/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ms extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "Azerbaijan";
        final String metaValue_BY = "Belarus";
        final String metaValue_BG = "Bulgaria";
        final String metaValue_DK = "Denmark";
        final String metaValue_DE = "Jerman";
        final String metaValue_ES = "Sepanyol";
        final String metaValue_EE = "Estonia";
        final String metaValue_FI = "Finland";
        final String metaValue_FJ = "Fiji";
        final String metaValue_FR = "Perancis";
        final String metaValue_IE = "Ireland";
        final String metaValue_HR = "Croatia";
        final String metaValue_HU = "Hungary";
        final String metaValue_AM = "Armenia";
        final String metaValue_ID = "Indonesia";
        final String metaValue_IS = "Iceland";
        final String metaValue_IT = "Itali";
        final String metaValue_JP = "Jepun";
        final String metaValue_GE = "Georgia";
        final String metaValue_KZ = "Kazakhstan";
        final String metaValue_LU = "Luxembourg";
        final String metaValue_LA = "Laos";
        final String metaValue_LT = "Lithuania";
        final String metaValue_LV = "Latvia";
        final String metaValue_MN = "Mongolia";
        final String metaValue_MT = "Malta";
        final String metaValue_NR = "Nauru";
        final String metaValue_NP = "Nepal";
        final String metaValue_NL = "Belanda";
        final String metaValue_NO = "Norway";
        final String metaValue_PL = "Poland";
        final String metaValue_RO = "Romania";
        final String metaValue_RU = "Rusia";
        final String metaValue_SI = "Slovenia";
        final String metaValue_WS = "Samoa";
        final String metaValue_AL = "Albania";
        final String metaValue_RS = "Serbia";
        final String metaValue_SE = "Sweden";
        final String metaValue_TO = "Tonga";
        final String metaValue_UA = "Ukraine";
        final String metaValue_UZ = "Uzbekistan";
        final String metaValue_VN = "Vietnam";
        final String metaValue_PH = "Filipina";
        final String metaValue_KI = "Kiribati";
        final String metaValue_TV = "Tuvalu";
        final String metaValue_ar = "Arab";
        final String metaValue_ae = "Avestan";
        final String metaValue_ban = "Bali";
        final String metaValue_bug = "Bugis";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Coptic";
        final String metaValue_ET = "Ethiopia";
        final String metaValue_el = "Greek";
        final String metaValue_gu = "Gujarat";
        final String metaValue_he = "Ibrani";
        final String metaValue_jv = "Jawa";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Korea";
        final String metaValue_la = "Latin";
        final String metaValue_mak = "Makasar";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_nqo = "N\u2019ko";
        final String metaValue_si = "Sinhala";
        final String metaValue_su = "Sunda";
        final String metaValue_SY = "Syria";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_th = "Thai";
        final String metaValue_bo = "Tibet";
        final String metaValue_vai = "Vai";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "Dunia" },
            { "002", "Afrika" },
            { "003", "Amerika Utara" },
            { "005", "Amerika Selatan" },
            { "009", "Oceania" },
            { "011", "Afrika Barat" },
            { "013", "Amerika Tengah" },
            { "014", "Afrika Timur" },
            { "015", "Afrika Utara" },
            { "017", "Afrika Tengah" },
            { "018", "Selatan Afrika" },
            { "019", "Amerika" },
            { "021", "Utara Amerika" },
            { "029", "Caribbean" },
            { "030", "Asia Timur" },
            { "034", "Asia Selatan" },
            { "035", "Asia Tenggara" },
            { "039", "Eropah Selatan" },
            { "053", "Australasia" },
            { "054", "Melanesia" },
            { "057", "Wilayah Mikronesia" },
            { "061", "Polinesia" },
            { "142", "Asia" },
            { "143", "Asia Tengah" },
            { "145", "Asia Barat" },
            { "150", "Eropah" },
            { "151", "Eropah Timur" },
            { "154", "Eropah Utara" },
            { "155", "Eropah Barat" },
            { "202", "Afrika Sub-Sahara" },
            { "419", "Amerika Latin" },
            { "AC", "Pulau Ascension" },
            { "AD", "Andorra" },
            { "AE", "Emiriah Arab Bersatu" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua dan Barbuda" },
            { "AI", "Anguilla" },
            { "AL", metaValue_AL },
            { "AM", metaValue_AM },
            { "AO", "Angola" },
            { "AQ", "Antartika" },
            { "AR", "Argentina" },
            { "AS", "Samoa Amerika" },
            { "AT", "Austria" },
            { "AU", "Australia" },
            { "AW", "Aruba" },
            { "AX", "Kepulauan Aland" },
            { "AZ", metaValue_AZ },
            { "BA", "Bosnia dan Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgium" },
            { "BF", "Burkina Faso" },
            { "BG", metaValue_BG },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barthelemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Belanda Caribbean" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Pulau Bouvet" },
            { "BW", "Botswana" },
            { "BY", metaValue_BY },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kepulauan Cocos (Keeling)" },
            { "CD", "Congo - Kinshasa" },
            { "CF", "Republik Afrika Tengah" },
            { "CG", "Congo - Brazzaville" },
            { "CH", "Switzerland" },
            { "CI", "Cote d\u2019Ivoire" },
            { "CK", "Kepulauan Cook" },
            { "CL", "Chile" },
            { "CM", "Cameroon" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Pulau Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Cape Verde" },
            { "CW", "Curacao" },
            { "CX", "Pulau Krismas" },
            { "CY", "Cyprus" },
            { "CZ", "Czechia" },
            { "DE", metaValue_DE },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", metaValue_DK },
            { "DM", "Dominica" },
            { "DO", "Republik Dominica" },
            { "DZ", "Algeria" },
            { "EA", "Ceuta dan Melilla" },
            { "EC", "Ecuador" },
            { "EE", metaValue_EE },
            { "EG", "Mesir" },
            { "EH", "Sahara Barat" },
            { "ER", "Eritrea" },
            { "ES", metaValue_ES },
            { "ET", metaValue_ET },
            { "EU", "Kesatuan Eropah" },
            { "EZ", "Zon Euro" },
            { "FI", metaValue_FI },
            { "FJ", metaValue_FJ },
            { "FK", "Kepulauan Falkland" },
            { "FM", "Micronesia" },
            { "FO", "Kepulauan Faroe" },
            { "FR", metaValue_FR },
            { "GA", "Gabon" },
            { "GB", "United Kingdom" },
            { "GD", "Grenada" },
            { "GE", metaValue_GE },
            { "GF", "Guiana Perancis" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Greenland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Guinea Khatulistiwa" },
            { "GR", "Greece" },
            { "GS", "Kepulauan Georgia Selatan & Sandwich Selatan" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hong Kong SAR China" },
            { "HM", "Kepulauan Heard & McDonald" },
            { "HN", "Honduras" },
            { "HR", metaValue_HR },
            { "HT", "Haiti" },
            { "HU", metaValue_HU },
            { "IC", "Kepulauan Canary" },
            { "ID", metaValue_ID },
            { "IE", metaValue_IE },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Wilayah Lautan Hindi British" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", metaValue_IS },
            { "IT", metaValue_IT },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordan" },
            { "JP", metaValue_JP },
            { "KE", "Kenya" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kemboja" },
            { "KI", metaValue_KI },
            { "KM", "Comoros" },
            { "KN", "Saint Kitts dan Nevis" },
            { "KP", "Korea Utara" },
            { "KR", "Korea Selatan" },
            { "KW", "Kuwait" },
            { "KY", "Kepulauan Cayman" },
            { "KZ", metaValue_KZ },
            { "LA", metaValue_LA },
            { "LB", "Lubnan" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", metaValue_LT },
            { "LU", metaValue_LU },
            { "LV", metaValue_LV },
            { "LY", "Libya" },
            { "MA", "Maghribi" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Kepulauan Marshall" },
            { "MK", "Macedonia Utara" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Burma)" },
            { "MN", metaValue_MN },
            { "MO", "Macau SAR China" },
            { "MP", "Kepulauan Mariana Utara" },
            { "MQ", "Martinique" },
            { "MR", "Mauritania" },
            { "MS", "Montserrat" },
            { "MT", metaValue_MT },
            { "MU", "Mauritius" },
            { "MV", "Maldives" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambique" },
            { "NA", "Namibia" },
            { "NC", "New Caledonia" },
            { "NE", "Niger" },
            { "NF", "Pulau Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", metaValue_NL },
            { "NO", metaValue_NO },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "Niue" },
            { "NZ", "New Zealand" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Polinesia Perancis" },
            { "PG", "Papua New Guinea" },
            { "PH", metaValue_PH },
            { "PK", "Pakistan" },
            { "PL", metaValue_PL },
            { "PM", "Saint Pierre dan Miquelon" },
            { "PN", "Kepulauan Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Wilayah Palestin" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "Oceania Terpencil" },
            { "RE", "Reunion" },
            { "RO", metaValue_RO },
            { "RS", metaValue_RS },
            { "RU", metaValue_RU },
            { "RW", "Rwanda" },
            { "SA", "Arab Saudi" },
            { "SB", "Kepulauan Solomon" },
            { "SC", "Seychelles" },
            { "SD", "Sudan" },
            { "SE", metaValue_SE },
            { "SG", "Singapura" },
            { "SH", "Saint Helena" },
            { "SI", metaValue_SI },
            { "SJ", "Svalbard dan Jan Mayen" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Surinam" },
            { "SS", "Sudan Selatan" },
            { "ST", "Sao Tome dan Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", metaValue_SY },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Kepulauan Turks dan Caicos" },
            { "TD", "Chad" },
            { "TF", "Wilayah Selatan Perancis" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tajikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunisia" },
            { "TO", metaValue_TO },
            { "TR", "Turkiye" },
            { "TT", "Trinidad dan Tobago" },
            { "TV", metaValue_TV },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", metaValue_UA },
            { "UG", "Uganda" },
            { "UM", "Kepulauan Terpencil A.S." },
            { "UN", "Bangsa-bangsa Bersatu" },
            { "US", "Amerika Syarikat" },
            { "UY", "Uruguay" },
            { "UZ", metaValue_UZ },
            { "VA", "Kota Vatican" },
            { "VC", "Saint Vincent dan Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Kepulauan Virgin British" },
            { "VI", "Kepulauan Virgin A.S." },
            { "VN", metaValue_VN },
            { "VU", "Vanuatu" },
            { "WF", "Wallis dan Futuna" },
            { "WS", metaValue_WS },
            { "XA", "Aksen Pseudo" },
            { "XB", "Bidi Pseudo" },
            { "XK", "Kosovo" },
            { "YE", "Yaman" },
            { "YT", "Mayotte" },
            { "ZA", "Afrika Selatan" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Wilayah Tidak Diketahui" },
            { "aa", "Afar" },
            { "ab", "Abkhazia" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharic" },
            { "an", "Aragon" },
            { "ar", metaValue_ar },
            { "as", "Assam" },
            { "av", "Avaric" },
            { "ay", "Aymara" },
            { "az", metaValue_AZ },
            { "ba", "Bashkir" },
            { "be", metaValue_BY },
            { "bg", metaValue_BG },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", "Benggali" },
            { "bo", metaValue_bo },
            { "br", "Breton" },
            { "bs", "Bosnia" },
            { "ca", "Catalonia" },
            { "ce", "Chechen" },
            { "ch", "Chamorro" },
            { "co", "Corsica" },
            { "cs", "Czech" },
            { "cu", "Slavik Gereja" },
            { "cv", "Chuvash" },
            { "cy", "Wales" },
            { "da", metaValue_DK },
            { "de", metaValue_DE },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Inggeris" },
            { "eo", "Esperanto" },
            { "es", metaValue_ES },
            { "et", metaValue_EE },
            { "eu", "Basque" },
            { "fa", "Parsi" },
            { "ff", "Fulah" },
            { "fi", metaValue_FI },
            { "fj", metaValue_FJ },
            { "fo", "Faroe" },
            { "fr", metaValue_FR },
            { "fy", "Frisian Barat" },
            { "ga", metaValue_IE },
            { "gd", "Scots Gaelic" },
            { "gl", "Galicia" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", metaValue_HR },
            { "ht", "Kreol Haiti" },
            { "hu", metaValue_HU },
            { "hy", metaValue_AM },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", metaValue_ID },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", "Sichuan Yi" },
            { "io", "Ido" },
            { "is", metaValue_IS },
            { "it", metaValue_IT },
            { "iu", "Inuktitut" },
            { "ja", metaValue_JP },
            { "jv", metaValue_jv },
            { "ka", metaValue_GE },
            { "kg", "Kongo" },
            { "ki", "Kikuya" },
            { "kj", "Kuanyama" },
            { "kk", metaValue_KZ },
            { "kl", "Kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kashmir" },
            { "ku", "Kurdish" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirghiz" },
            { "la", metaValue_la },
            { "lb", metaValue_LU },
            { "lg", "Ganda" },
            { "li", "Limburgish" },
            { "ln", "Lingala" },
            { "lo", metaValue_LA },
            { "lt", metaValue_LT },
            { "lu", "Luba-Katanga" },
            { "lv", metaValue_LV },
            { "mg", "Malagasy" },
            { "mh", "Marshall" },
            { "mi", "Maori" },
            { "mk", "Macedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_MN },
            { "mr", "Marathi" },
            { "ms", "Melayu" },
            { "mt", metaValue_MT },
            { "my", "Burma" },
            { "na", metaValue_NR },
            { "nb", "Bokmal Norway" },
            { "nd", "Ndebele Utara" },
            { "ne", metaValue_NP },
            { "ng", "Ndonga" },
            { "nl", metaValue_NL },
            { "nn", "Nynorsk Norway" },
            { "no", metaValue_NO },
            { "nr", "Ndebele Selatan" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitania" },
            { "om", "Oromo" },
            { "or", "Odia" },
            { "os", "Ossete" },
            { "pa", "Punjabi" },
            { "pl", metaValue_PL },
            { "ps", "Pashto" },
            { "pt", "Portugis" },
            { "qu", "Quechua" },
            { "rm", "Romansh" },
            { "rn", "Rundi" },
            { "ro", metaValue_RO },
            { "ru", metaValue_RU },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardinia" },
            { "sd", "Sindhi" },
            { "se", "Sami Utara" },
            { "sg", "Sango" },
            { "sh", "SerboCroatia" },
            { "si", metaValue_si },
            { "sk", "Slovak" },
            { "sl", metaValue_SI },
            { "sm", metaValue_WS },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", metaValue_AL },
            { "sr", metaValue_RS },
            { "ss", "Swati" },
            { "st", "Sotho Selatan" },
            { "su", metaValue_su },
            { "sv", metaValue_SE },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tajik" },
            { "th", metaValue_th },
            { "ti", "Tigrinya" },
            { "tk", "Turkmen" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", "Turki" },
            { "ts", "Tsonga" },
            { "tt", "Tatar" },
            { "tw", "Twi" },
            { "ty", "Tahiti" },
            { "ug", "Uyghur" },
            { "uk", metaValue_UA },
            { "ur", "Urdu" },
            { "uz", metaValue_UZ },
            { "ve", "Venda" },
            { "vi", metaValue_VN },
            { "vo", "Volap\u00fck" },
            { "wa", "Walloon" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Yiddish" },
            { "yo", "Yoruba" },
            { "zh", "Cina" },
            { "zu", "Zulu" },
            { "ace", "Aceh" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adyghe" },
            { "aeb", "Arab Tunisia" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "ale", "Aleut" },
            { "alt", "Altai Selatan" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arn", "Mapuche" },
            { "arp", "Arapaho" },
            { "arq", "Arab Algeria" },
            { "ars", "Arab Najdi" },
            { "ary", "Arab Maghribi" },
            { "arz", "Arab Mesir" },
            { "asa", "Asu" },
            { "ast", "Asturia" },
            { "atj", "Atikamekw" },
            { "awa", "Awadhi" },
            { "bal", "Baluchi" },
            { "ban", metaValue_ban },
            { "bas", "Basaa" },
            { "bax", "Bamun" },
            { "bbj", "Ghomala" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bgc", "Haryanvi" },
            { "bgn", "Balochi Barat" },
            { "bho", "Bhojpuri" },
            { "bin", "Bini" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "bpy", "Bishnupriya" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Buriat" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cay", "Cayuga" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chk", "Chukese" },
            { "chm", "Mari" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Kurdi Tengah" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "crg", "Michif" },
            { "crh", "Turki Krimea" },
            { "crj", "Cree Tenggara" },
            { "crk", "Plains Cree" },
            { "crl", "Timur Laut Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonquian" },
            { "crs", "Perancis Seselwa Creole" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "dgr", "Dogrib" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Sorbian Rendah" },
            { "dua", "Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "eka", "Ekajuk" },
            { "ewo", "Ewondo" },
            { "fil", metaValue_PH },
            { "fon", "Fon" },
            { "frc", "Perancis Cajun" },
            { "frr", "Frisian Utara" },
            { "fur", "Friulian" },
            { "gaa", "Ga" },
            { "gag", "Gagauz" },
            { "gan", "Cina Gan" },
            { "gba", "Gbaya" },
            { "gbz", "Zoroastrian Dari" },
            { "gez", "Geez" },
            { "gil", metaValue_KI },
            { "glk", "Gilaki" },
            { "gor", "Gorontalo" },
            { "grc", "Greek Purba" },
            { "gsw", "Jerman Switzerland" },
            { "guz", "Gusii" },
            { "gwi", "Gwich\u02bcin" },
            { "hai", "Haida" },
            { "hak", "Cina Hakka" },
            { "haw", "Hawaii" },
            { "hax", "Haida Selatan" },
            { "hil", "Hiligaynon" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbian Atas" },
            { "hsn", "Cina Xiang" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Inuktitut Kanada Barat" },
            { "ilo", "Iloko" },
            { "inh", "Ingush" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "kab", "Kabyle" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kbd", "Kabardia" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permyak" },
            { "kok", "Konkani" },
            { "kpe", "Kpelle" },
            { "krc", "Karachay-Balkar" },
            { "krl", "Karelian" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Colognian" },
            { "kum", "Kumyk" },
            { "kwk", "Kwak\u2019wala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lez", "Lezghian" },
            { "lil", "Lillooet" },
            { "lkt", "Lakota" },
            { "lou", "Kreol Louisiana" },
            { "loz", "Lozi" },
            { "lrc", "Luri Utara" },
            { "lsm", "Saamia" },
            { "lua", "Luba-Lulua" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "mad", "Madura" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", metaValue_mak },
            { "mas", "Masai" },
            { "mde", "Maba" },
            { "mdf", "Moksha" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mni", "Manipuri" },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mua", "Mundang" },
            { "mul", "Pelbagai Bahasa" },
            { "mus", "Creek" },
            { "mwl", "Mirandese" },
            { "mye", "Myene" },
            { "myv", "Erzya" },
            { "mzn", "Mazanderani" },
            { "nan", "Cina Min Nan" },
            { "nap", "Neapolitan" },
            { "naq", "Nama" },
            { "nds", "Jerman Rendah" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", "Niu" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "nqo", metaValue_nqo },
            { "nso", "Sotho Utara" },
            { "nus", "Nuer" },
            { "nyn", "Nyankole" },
            { "ojb", "Ojibwa Barat Laut" },
            { "ojc", "Ojibwa Tengah" },
            { "ojs", "Oji-Cree" },
            { "ojw", "Ojibwa Barat" },
            { "oka", "Okanagan" },
            { "pag", "Pangasinan" },
            { "pam", "Pampanga" },
            { "pap", "Papiamento" },
            { "pau", "Palauan" },
            { "pcm", "Nigerian Pidgin" },
            { "pis", "Pijin" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Prusia" },
            { "quc", "K\u02bciche\u02bc" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonga" },
            { "rhg", "Rohingya" },
            { "rof", "Rombo" },
            { "rup", "Aromanian" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Sakha" },
            { "saq", "Samburu" },
            { "sat", "Santali" },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sicili" },
            { "sco", "Scots" },
            { "sdh", "Kurdish Selatan" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "ses", "Koyraboro Senni" },
            { "shi", "Tachelhit" },
            { "shn", "Shan" },
            { "shu", "Arab Chadian" },
            { "slh", "Lushootseed Selatan" },
            { "sma", "Sami Selatan" },
            { "smj", "Lule Sami" },
            { "smn", "Inari Sami" },
            { "sms", "Skolt Sami" },
            { "snk", "Soninke" },
            { "srn", "Sranan Tongo" },
            { "ssy", metaValue_ssy },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "swb", "Comoria" },
            { "syr", "Syriac" },
            { "tce", "Tutchone Selatan" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysh" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "trv", "Taroko" },
            { "ttm", "Tutchone Utara" },
            { "tum", "Tumbuka" },
            { "tvl", metaValue_TV },
            { "twq", "Tasawaq" },
            { "tyv", "Tuvinian" },
            { "tzm", "Tamazight Atlas Tengah" },
            { "udm", "Udmurt" },
            { "umb", "Umbundu" },
            { "und", "Bahasa Tidak Diketahui" },
            { "vai", metaValue_vai },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "wbp", "Warlpiri" },
            { "wuu", "Cina Wu" },
            { "xal", "Kalmyk" },
            { "xog", "Soga" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonis" },
            { "zgh", "Tamazight Maghribi Standard" },
            { "zun", "Zuni" },
            { "zxx", "Tiada kandungan linguistik" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Aghb", "Kaukasia Albania" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armi", "Aramia Imperial" },
            { "Armn", metaValue_AM },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", "Benggala" },
            { "Bhks", "Bhaisuki" },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Suku Kata Orang Asli Kanada Bersatu" },
            { "Cari", "Carian" },
            { "Cham", "Cham" },
            { "Cher", metaValue_chr },
            { "Copt", metaValue_cop },
            { "Cprt", "Cypriot" },
            { "Cyrl", "Cyril" },
            { "Deva", "Devanagari" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Trengkas Duployan" },
            { "Egyp", "Hiroglif Mesir" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaic" },
            { "Ethi", metaValue_ET },
            { "Geor", metaValue_GE },
            { "Glag", "Glagolitik" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gonti" },
            { "Goth", "Gothic" },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han dengan Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "Ringkas" },
            { "Hant", "Tradisional" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Hiroglif Anatoli" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Ejaan sukuan Jepun" },
            { "Hung", "Hungary Lama" },
            { "Ital", "Italik Lama" },
            { "Jamo", "Jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_JP },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", "Lao" },
            { "Latn", metaValue_la },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Lyci", "Lycia" },
            { "Lydi", "Lydia" },
            { "Mahj", "Mahajani" },
            { "Maka", metaValue_mak },
            { "Mand", "Mandaean" },
            { "Mani", "Manichaean" },
            { "Marc", "Marchen" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Kursif Meroitic" },
            { "Mero", "Meroitic" },
            { "Mlym", metaValue_ml },
            { "Modi", "Modi" },
            { "Mong", metaValue_MN },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei Mayek" },
            { "Mult", "Multani" },
            { "Mymr", "Myammar" },
            { "Nand", "Nandinagari" },
            { "Narb", "Arab Utara Lama" },
            { "Nbat", "Nabataean" },
            { "Newa", "Newa" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nushu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", "Oriya" },
            { "Osge", "Osage" },
            { "Osma", "Osmanya" },
            { "Palm", "Palmyrene" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Permic Lama" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inskripsi Pahlavi" },
            { "Phlp", "Pslater Pahlavi" },
            { "Phnx", "Phoenicia" },
            { "Plrd", "Fonetik Pollard" },
            { "Prti", "Inskripsi Parthian" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi Rohingya" },
            { "Runr", "Runic" },
            { "Samr", "Samaritan" },
            { "Sarb", "Arab Selatan Lama" },
            { "Saur", "Saurashtra" },
            { "Sgnw", "Tulisan Isyarat" },
            { "Shaw", "Shavia" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sogd", "Sogdia" },
            { "Sogo", "Sogdia Lama" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_SY },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue Baharu" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Tfng", "Tifinagh" },
            { "Tglg", "Tagalog" },
            { "Thaa", "Thaana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Ugar", "Ugaritic" },
            { "Vaii", metaValue_vai },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Xpeo", "Parsi Lama" },
            { "Xsux", "Aksara Paku Sumero-Akkadia" },
            { "Yiii", "Yi" },
            { "Zanb", "Segi Empat Zanabazar" },
            { "Zinh", "Diwarisi" },
            { "Zmth", "Tatatanda matematik" },
            { "Zsye", "Emoji" },
            { "Zsym", "Simbol" },
            { "Zxxx", "Tidak ditulis" },
            { "Zyyy", "Lazim" },
            { "Zzzz", "Tulisan Tidak Diketahui" },
            { "de_AT", "Jerman Austria" },
            { "de_CH", "Jerman Halus Switzerland" },
            { "en_AU", "Inggeris Australia" },
            { "en_CA", "Inggeris Kanada" },
            { "en_GB", "Inggeris British" },
            { "en_US", "Inggeris AS" },
            { "es_ES", "Sepanyol Eropah" },
            { "es_MX", "Sepanyol Mexico" },
            { "fa_AF", "Dari" },
            { "fr_CA", "Perancis Kanada" },
            { "fr_CH", "Perancis Switzerland" },
            { "nl_BE", "Flemish" },
            { "pt_BR", "Portugis Brazil" },
            { "pt_PT", "Portugis Eropah" },
            { "ro_MD", "Moldavia" },
            { "sw_CD", "Congo Swahili" },
            { "%%1901", "Sistem ejaan Jerman Tradisional" },
            { "%%1994", "Sistem ejaan Resia standard" },
            { "%%1996", "Sistem ejaan Jerman 1996" },
            { "ar_001", "Arab Standard Moden" },
            { "es_419", "Sepanyol Amerika Latin" },
            { "key.ca", "Kalendar" },
            { "key.cf", "Format Mata Wang" },
            { "key.co", "Tertib Isihan" },
            { "key.cu", "Mata wang" },
            { "key.hc", "Kitaran Jam (12 berbanding 24)" },
            { "key.lb", "Gaya Pemisah Baris" },
            { "key.ms", "Sistem Ukuran" },
            { "key.nu", "Nombor" },
            { "key.tz", "Zon Waktu" },
            { "key.va", "Varian Tempat" },
            { "nds_NL", "Saxon Rendah" },
            { "%%ALUKU", "Dialek Aluku" },
            { "%%BARLA", "Kumpulan dialek Barlavento Kabuverdianu" },
            { "%%BISKE", "Dialek San Giorgio/Bila" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Sistem Ejaan Lazim" },
            { "%%KSCOR", "Sistem Ejaan Standard" },
            { "%%LIPAW", "Dialek Lipovaz Resia" },
            { "%%NEDIS", "Dialek Natisone" },
            { "%%NJIVA", "Dialek Gniva/Njiva" },
            { "%%NULIK", "Volapuk Moden" },
            { "%%OSOJS", "Dialek Oseacco/Osojane" },
            { "%%POSIX", "Komputer" },
            { "%%RIGIK", "Vopaluk Klasik" },
            { "%%ROZAJ", "Resia" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Dialek Stolvizza/Solbica" },
            { "%%SOTAV", "Kumpulan dialek Sotavento Kabuverdianu" },
            { "%%UCCOR", "Sistem Ejaan Bersatu" },
            { "zh_Hans", "Cina Ringkas" },
            { "zh_Hant", "Cina Tradisional" },
            { "%%AO1990", "Perjanjian Sistem Ejaan Bahasa Portugis 1990" },
            { "%%DAJNKO", "Abjad Dajnko" },
            { "%%EKAVSK", "Serbia dengan sebutan Ekavia" },
            { "%%FONIPA", "Fonetik IPA" },
            { "%%FONUPA", "Fonetik UPA" },
            { "%%NDYUKA", "Dialek Ndyuka" },
            { "%%PAMAKA", "Dialek Pamaka" },
            { "%%PINYIN", "Perumian Pinyin" },
            { "%%TARASK", "Sistem ejaan Taraskievica" },
            { "%%UCRCOR", "Sistem Ejaan Semakan Bersatu" },
            { "%%UNIFON", "Abjad fonetik Unifon" },
            { "%%ABL1943", "Perumusan sistem ejaan 1943" },
            { "%%ALALC97", "Perumian ALA-LC, edisi 1997" },
            { "%%BALANKA", "Dialek Balanka Anii" },
            { "%%BOHORIC", "Abjad Bohoric" },
            { "%%EMODENG", "Inggeris Moden Awal" },
            { "%%HEPBURN", "Perumian Hepburn" },
            { "%%METELKO", "Abjad Metelko" },
            { "%%MONOTON", "Ekanada" },
            { "%%POLYTON", "Banyak Nada" },
            { "%%REVISED", "Sistem Ejaan Semakan" },
            { "%%1606NICT", "Lewat Pertengahan Era Perancis hingga 1606" },
            { "%%1694ACAD", "Awal Pertengahan Era Perancis" },
            { "%%1959ACAD", "Akademik" },
            { "%%BAKU1926", "Abjad Latin Turki Disatukan" },
            { "%%COLB1945", "Konvensyen Sistem Ejaan Portugis-Brazil 1945" },
            { "%%IJEKAVSK", "Fon Serbia dengan sebutan Ijekavia" },
            { "%%OXENDICT", "Ejaan Kamus Inggeris Oxford" },
            { "%%SCOTLAND", "Inggeris Standard Scotland" },
            { "%%VALENCIA", "Valencia" },
            { "%%WADEGILE", "Perumian Wade-Giles" },
            { "type.ca.roc", "Kalendar Minguo" },
            { "type.co.eor", "Peraturan Isihan Eropah" },
            { "type.hc.h11", "Sistem 12 Jam (0\u201311)" },
            { "type.hc.h12", "Sistem 12 Jam (1\u201312)" },
            { "type.hc.h23", "Sistem 24 Jam (0\u201323)" },
            { "type.hc.h24", "Sistem 24 Jam (1\u201324)" },
            { "type.m0.bgn", "Transliterasi BGN AS" },
            { "type.nu.ahom", "Digit Ahom" },
            { "type.nu.arab", "Digit Indi-Arab" },
            { "type.nu.armn", "Angka Armenia" },
            { "type.nu.bali", "Digit Bali" },
            { "type.nu.beng", "Digit Benggali" },
            { "type.nu.brah", "Digit Brahmi" },
            { "type.nu.cakm", "Digit Chakma" },
            { "type.nu.cham", "Digit Cham" },
            { "type.nu.cyrl", "Digit Cyril" },
            { "type.nu.deva", "Digit Devanagari" },
            { "type.nu.ethi", "Angka Ethiopia" },
            { "type.nu.geor", "Angka Georgia" },
            { "type.nu.gong", "Digit Gunjala Gondi" },
            { "type.nu.gonm", "Digit Masaram Gondi" },
            { "type.nu.grek", "Angka Greek" },
            { "type.nu.gujr", "Digit Gujarat" },
            { "type.nu.guru", "Digit Gurmukhi" },
            { "type.nu.hans", "Angka Cina Ringkas" },
            { "type.nu.hant", "Angka Cina Tradisional" },
            { "type.nu.hebr", "Angka Ibrani" },
            { "type.nu.hmng", "Digit Pahawh Hmong" },
            { "type.nu.hmnp", "Digit Nyiakeng Puachue Hmong" },
            { "type.nu.java", "Digit Jawa" },
            { "type.nu.jpan", "Angka Jepun" },
            { "type.nu.kali", "Digit Kayah Li" },
            { "type.nu.khmr", "Digit Khmer" },
            { "type.nu.knda", "Digit Kannada" },
            { "type.nu.lana", "Digit Tai Tham Hora" },
            { "type.nu.laoo", "Digit Lao" },
            { "type.nu.latn", "Digit Barat" },
            { "type.nu.lepc", "Digit Lepcha" },
            { "type.nu.limb", "Digit Limbu" },
            { "type.nu.mlym", "Digit Malayalam" },
            { "type.nu.modi", "Digit Modi" },
            { "type.nu.mong", "Digit Mongolia" },
            { "type.nu.mroo", "Digit Mro" },
            { "type.nu.mtei", "Digit Meetei Mayek" },
            { "type.nu.mymr", "Digit Myammar" },
            { "type.nu.nkoo", "Digit N\u2019Ko" },
            { "type.nu.olck", "Digit Ol Chiki" },
            { "type.nu.orya", "Digit Oriya" },
            { "type.nu.osma", "Digit Osmanya" },
            { "type.nu.rohg", "Digit Hanifi Rohingya" },
            { "type.nu.saur", "Digit Saurashtra" },
            { "type.nu.shrd", "Digit Sharada" },
            { "type.nu.sind", "Digit Khudawadi" },
            { "type.nu.sinh", "Digit Sinhala Lith" },
            { "type.nu.sora", "Digit Sora Sompeng" },
            { "type.nu.sund", "Digit Sunda" },
            { "type.nu.takr", "Digit Takri" },
            { "type.nu.talu", "Digit Tai Lue Baru" },
            { "type.nu.taml", "Angka Tamil Tradisional" },
            { "type.nu.telu", "Digit Telugu" },
            { "type.nu.thai", "Digit Thai" },
            { "type.nu.tibt", "Digit Tibet" },
            { "type.nu.tirh", "Digit Tirhuta" },
            { "type.nu.vaii", "Digit Vai" },
            { "type.nu.wara", "Digit Warang Citi" },
            { "type.nu.wcho", "Digit Wancho" },
            { "type.ca.dangi", "Kalendar Dangi" },
            { "type.co.ducet", "Tertib Isih Unikod Lalai" },
            { "type.co.emoji", "Aturan Isih Emoji" },
            { "type.lb.loose", "Gaya Pemisah Baris Bebas" },
            { "type.nu.roman", "Angka Roman" },
            { "type.ca.coptic", "Kalendar Qibti" },
            { "type.ca.hebrew", "Kalendar Ibrani" },
            { "type.ca.indian", "Kalendar Kebangsaan India" },
            { "type.co.compat", "Tertib Isihan Sebelumnya" },
            { "type.co.pinyin", "Aturan Isih Pinyin" },
            { "type.co.search", "Carian Tujuan Umum" },
            { "type.co.stroke", "Aturan Isih Coretan" },
            { "type.co.unihan", "Aturan Isih Coretan Radikal" },
            { "type.co.zhuyin", "Aturan Isih Zhuyin" },
            { "type.d0.fwidth", "Ke Kelebaran Penuh" },
            { "type.d0.hwidth", "Ke Kelebaran Separa" },
            { "type.lb.normal", "Gaya Pemisah Baris Biasa" },
            { "type.lb.strict", "Gaya Pemisah Baris Ketat" },
            { "type.m0.ungegn", "Transliterasi UN GEGN" },
            { "type.ms.metric", "Sistem Metrik" },
            { "type.nu.native", "Digit Asal" },
            { "type.ca.chinese", "Kalendar Cina" },
            { "type.ca.islamic", "Kalendar Islam" },
            { "type.ca.iso8601", "Kalendar ISO-8601" },
            { "type.ca.persian", "Kalendar Parsi" },
            { "type.cf.account", "Format Mata Wang Perakaunan" },
            { "type.co.big5han", "Aturan Isih Cina Tradisional - Big5" },
            { "type.d0.npinyin", "Bernombor" },
            { "type.nu.arabext", "Digit Indi Arab Lanjutan" },
            { "type.nu.armnlow", "Angka Kecil Armenia" },
            { "type.nu.finance", "Angka Kewangan" },
            { "type.nu.greklow", "Angka Huruf Kecil Greek" },
            { "type.nu.hanidec", "Angka Perpuluhan Cina" },
            { "type.nu.hansfin", "Angka Kewangan Cina Ringkas" },
            { "type.nu.hantfin", "Angka Kewangan Cina Tradisional" },
            { "type.nu.jpanfin", "Angka Kewangan Jepun" },
            { "type.nu.mathdbl", "Digit Matematik Dwilejang" },
            { "type.nu.tamldec", "Digit Tamil" },
            { "type.ca.buddhist", "Kalendar Buddha" },
            { "type.ca.ethiopic", "Kalendar Ethiopia" },
            { "type.ca.japanese", "Kalendar Jepun" },
            { "type.cf.standard", "Format Mata Wang Standard" },
            { "type.co.phonetic", "Urutan Isih Fonetik" },
            { "type.co.searchjl", "Cari Mengikut Konsonan Awal Hangul" },
            { "type.co.standard", "Tertib Isih Standard" },
            { "type.ms.uksystem", "Sistem Ukuran Imperial" },
            { "type.ms.ussystem", "Sistem Ukuran AS" },
            { "type.nu.fullwide", "Digit Lebar Penuh" },
            { "type.nu.lanatham", "Digit Tai Tham Tham" },
            { "type.nu.mathbold", "Digit Matematik Tebal" },
            { "type.nu.mathmono", "Digit Matematik Monospace" },
            { "type.nu.mathsanb", "Digit Matematik San Serif Tebal" },
            { "type.nu.mathsans", "Digit Matematik San Serif" },
            { "type.nu.mymrshan", "Digit Myanmar Shan" },
            { "type.nu.mymrtlng", "Digit Myanmar Tai Laing" },
            { "type.nu.romanlow", "Angka Huruf Kecil Roman" },
            { "type.ca.gregorian", "Kalendar Gregory" },
            { "type.co.gb2312han", "Aturan Isih Bahasa Cina Ringkas - GB2312" },
            { "type.co.phonebook", "Aturan Isih Buku Telefon" },
            { "type.co.dictionary", "Aturan Isih Kamus" },
            { "type.co.traditional", "Aturan Isih Tradisional" },
            { "type.nu.traditional", "Angka Tradisional" },
            { "type.ca.islamic-tbla", "Kalendar Islam (jadual, zaman astronomi)" },
            { "type.ca.islamic-civil", "Kalendar Sivil Islam" },
            { "type.ca.islamic-umalqura", "Kalendar Islam (Umm Al-Quran)" },
            { "type.ca.ethiopic-amete-alem", "Kalendar Amete Alem Ethiopia" },
        };
        return data;
    }
}
