/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.indexstatemanagement.action;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.admin.indices.alias.Alias;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.unit.ByteSizeValue;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.indexstatemanagement.action.ShrinkAction;
import org.opensearch.indexmanagement.spi.indexstatemanagement.Action;
import org.opensearch.indexmanagement.spi.indexstatemanagement.ActionParser;
import org.opensearch.script.Script;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/opensearch/indexmanagement/indexstatemanagement/action/ShrinkActionParser;", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/ActionParser;", "()V", "fromStreamInput", "Lorg/opensearch/indexmanagement/spi/indexstatemanagement/Action;", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "fromXContent", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "index", "", "getActionType", "", "opensearch-index-management"})
public final class ShrinkActionParser
extends ActionParser {
    public ShrinkActionParser() {
        super(false, 1, null);
    }

    @NotNull
    public Action fromStreamInput(@NotNull StreamInput sin) {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        Integer numNewShards = sin.readOptionalInt();
        ByteSizeValue maxShardSize = (ByteSizeValue)sin.readOptionalWriteable(ByteSizeValue::new);
        Double percentageOfSourceShards = sin.readOptionalDouble();
        Script targetIndexTemplate = sin.readBoolean() ? new Script(sin) : null;
        List aliases = sin.readBoolean() ? sin.readList(Alias::new) : null;
        boolean switchAliases2 = sin.readBoolean();
        Boolean forceUnsafe = sin.readOptionalBoolean();
        int index2 = sin.readInt();
        return new ShrinkAction(numNewShards, maxShardSize, percentageOfSourceShards, targetIndexTemplate, aliases, switchAliases2, forceUnsafe, index2);
    }

    @NotNull
    public Action fromXContent(@NotNull XContentParser xcp, int index2) {
        Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
        Integer numNewShards = null;
        ByteSizeValue maxShardSize = null;
        Double percentageOfSourceShards = null;
        Script targetIndexTemplate = null;
        List aliases = null;
        boolean switchAliases2 = false;
        Boolean forceUnsafe = null;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
        block18: while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
            String fieldName;
            block27: {
                fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) break block27;
                int n = -1;
                switch (string.hashCode()) {
                    case -490479789: {
                        if (string.equals("target_index_name_template")) {
                            n = 1;
                        }
                        break;
                    }
                    case -1031846355: {
                        if (string.equals("num_new_shards")) {
                            n = 2;
                        }
                        break;
                    }
                    case -914534658: {
                        if (string.equals("aliases")) {
                            n = 3;
                        }
                        break;
                    }
                    case 709770618: {
                        if (string.equals("force_unsafe")) {
                            n = 4;
                        }
                        break;
                    }
                    case -12044045: {
                        if (string.equals("switch_aliases")) {
                            n = 5;
                        }
                        break;
                    }
                    case -84890243: {
                        if (string.equals("max_shard_size")) {
                            n = 6;
                        }
                        break;
                    }
                    case 1679298454: {
                        if (string.equals("percentage_of_source_shards")) {
                            n = 7;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 2: {
                        numNewShards = xcp.intValue();
                        continue block18;
                    }
                    case 6: {
                        maxShardSize = ByteSizeValue.parseBytesSizeValue((String)xcp.text(), (String)"max_shard_size");
                        continue block18;
                    }
                    case 7: {
                        percentageOfSourceShards = xcp.doubleValue();
                        continue block18;
                    }
                    case 1: {
                        targetIndexTemplate = Script.parse((XContentParser)xcp, (String)"mustache");
                        continue block18;
                    }
                    case 3: {
                        if (xcp.currentToken() == XContentParser.Token.VALUE_NULL) continue block18;
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        aliases = new ArrayList();
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                            Alias alias = Alias.fromXContent((XContentParser)xcp);
                            Intrinsics.checkNotNullExpressionValue((Object)alias, (String)"fromXContent(xcp)");
                            aliases.add(alias);
                            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
                        }
                        continue block18;
                    }
                    case 5: {
                        switchAliases2 = xcp.booleanValue();
                        continue block18;
                    }
                    case 4: {
                        forceUnsafe = xcp.booleanValue();
                        continue block18;
                    }
                }
            }
            throw new IllegalArgumentException("Invalid field: [" + fieldName + "] found in ShrinkAction.");
        }
        return new ShrinkAction(numNewShards, maxShardSize, percentageOfSourceShards, targetIndexTemplate, aliases, switchAliases2, forceUnsafe, index2);
    }

    @NotNull
    public String getActionType() {
        return "shrink";
    }
}

