/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import net.sourceforge.plantuml.log.Logme;
import net.sourceforge.plantuml.preproc.FileWithSuffix;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.ReadLineSimple;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.preproc2.ReadFilterMergeLines;
import net.sourceforge.plantuml.security.SURL;
import net.sourceforge.plantuml.text.StringLocated;
import net.sourceforge.plantuml.utils.Log;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public static StartDiagramExtractReader build(FileWithSuffix f2, StringLocated s2, Charset charset) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(f2, s2, charset), f2.getSuffix());
    }

    public static StartDiagramExtractReader build(SURL url, StringLocated s2, String uid, Charset charset) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(url, s2, charset), uid);
    }

    public static StartDiagramExtractReader build(InputStream is, StringLocated s2, String desc) {
        return new StartDiagramExtractReader(StartDiagramExtractReader.getReadLine(is, s2, desc), null);
    }

    private StartDiagramExtractReader(ReadLine raw, String suf) {
        int bloc = 0;
        String uid = null;
        if (suf != null && suf.matches("\\d+")) {
            bloc = Integer.parseInt(suf);
        } else {
            uid = suf;
        }
        if (bloc < 0) {
            bloc = 0;
        }
        this.raw = raw;
        StringLocated s2 = null;
        try {
            while ((s2 = raw.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s2.getString()) || !this.checkUid(uid, s2)) continue;
                if (bloc == 0) {
                    return;
                }
                --bloc;
            }
        }
        catch (IOException e) {
            Logme.error(e);
            Log.error("Error " + e);
        }
        this.finished = true;
    }

    private boolean checkUid(String uid, StringLocated s2) {
        if (uid == null) {
            return true;
        }
        return s2.toString().matches(".*id=" + uid + "\\W.*");
    }

    private static ReadLine getReadLine(FileWithSuffix f2, StringLocated s2, Charset charset) {
        try {
            Reader tmp1 = f2.getReader(charset);
            if (tmp1 == null) {
                return new ReadLineSimple(s2, "Cannot open " + f2.getDescription());
            }
            return StartDiagramExtractReader.uncommentAndMerge(ReadLineReader.create(tmp1, f2.getDescription()));
        }
        catch (IOException e) {
            return new ReadLineSimple(s2, e.toString());
        }
    }

    private static ReadLine getReadLine(InputStream is, StringLocated s2, String description) {
        return StartDiagramExtractReader.uncommentAndMerge(ReadLineReader.create(new InputStreamReader(is), description));
    }

    private static ReadLine getReadLine(SURL url, StringLocated s2, Charset charset) {
        InputStream tmp = url.openStream();
        if (tmp == null) {
            return new ReadLineSimple(s2, "Cannot connect");
        }
        return StartDiagramExtractReader.uncommentAndMerge(ReadLineReader.create(new InputStreamReader(tmp, charset), url.toString()));
    }

    private static ReadLine uncommentAndMerge(ReadLine reader) {
        return new UncommentReadLine(new ReadFilterMergeLines().applyFilter(reader));
    }

    public static boolean containsStartDiagram(FileWithSuffix f2, StringLocated s2, Charset charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(f2, s2, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(SURL url, StringLocated s2, Charset charset) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(url, s2, charset);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    public static boolean containsStartDiagram(InputStream is, StringLocated s2, String description) throws IOException {
        ReadLine r = StartDiagramExtractReader.getReadLine(is, s2, description);
        return StartDiagramExtractReader.containsStartDiagram(r);
    }

    private static boolean containsStartDiagram(ReadLine r) throws IOException {
        try {
            StringLocated s2 = null;
            while ((s2 = r.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(s2.getString())) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
        }
        return false;
    }

    @Override
    public StringLocated readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        StringLocated result = this.raw.readLine();
        if (result != null && StartUtils.isArobaseEndDiagram(result.getString())) {
            this.finished = true;
            return null;
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.raw.close();
    }
}

