/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.draw;

import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColorSet;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.klimt.sprite.SpriteContainerEmpty;
import net.sourceforge.plantuml.project.LabelStrategy;
import net.sourceforge.plantuml.project.core.Task;
import net.sourceforge.plantuml.project.core.TaskAttribute;
import net.sourceforge.plantuml.project.draw.FingerPrint;
import net.sourceforge.plantuml.project.draw.TaskDraw;
import net.sourceforge.plantuml.project.lang.CenterBorderColor;
import net.sourceforge.plantuml.project.time.Day;
import net.sourceforge.plantuml.project.timescale.TimeScale;
import net.sourceforge.plantuml.real.Real;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleBuilder;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.url.Url;
import net.sourceforge.plantuml.utils.Direction;

public class TaskDrawSeparator
implements TaskDraw {
    private final TimeScale timeScale;
    private Real y;
    private final Day min;
    private final Day max;
    private final String name;
    private final StyleBuilder styleBuilder;
    private final HColorSet colorSet;

    public TaskDrawSeparator(String name, TimeScale timeScale, Real y, Day min2, Day max, StyleBuilder styleBuilder, HColorSet colorSet) {
        this.styleBuilder = styleBuilder;
        this.colorSet = colorSet;
        this.name = name;
        this.y = y;
        this.timeScale = timeScale;
        this.min = min2;
        this.max = max;
    }

    @Override
    public void drawTitle(UGraphic ug, LabelStrategy labelStrategy, double colTitles, double colBars) {
        ClockwiseTopRightBottomLeft padding = this.getStyle().getPadding();
        ClockwiseTopRightBottomLeft margin = this.getStyle().getMargin();
        double dx = margin.getLeft() + padding.getLeft();
        double dy = margin.getTop() + padding.getTop();
        double x = labelStrategy.titleInFirstColumn() ? colTitles : 0.0;
        this.getTitle().drawU(ug.apply(new UTranslate(x + dx, dy)));
    }

    @Override
    public double getTitleWidth(StringBounder stringBounder) {
        return 0.0;
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.ganttDiagram, SName.separator);
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.styleBuilder);
    }

    private TextBlock getTitle() {
        if (this.name == null) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        return Display.getWithNewlines(this.name).create(this.getFontConfiguration(), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    private FontConfiguration getFontConfiguration() {
        return this.getStyle().getFontConfiguration(this.colorSet);
    }

    @Override
    public void drawU(UGraphic ug) {
        double height;
        StringBounder stringBounder = ug.getStringBounder();
        double widthTitle = this.getTitle().calculateDimension(stringBounder).getWidth();
        double start = this.timeScale.getStartingPosition(this.min);
        double end = this.timeScale.getEndingPosition(this.max);
        ClockwiseTopRightBottomLeft padding = this.getStyle().getPadding();
        ClockwiseTopRightBottomLeft margin = this.getStyle().getMargin();
        ug = ug.apply(new UTranslate(0.0, margin.getTop()));
        HColor backColor = this.getStyle().value(PName.BackGroundColor).asColor(this.colorSet);
        if (!backColor.isTransparent() && (height = padding.getTop() + this.getTextHeight(stringBounder) + padding.getBottom()) > 0.0) {
            URectangle rect = URectangle.build(end - start, height);
            ug.apply(backColor.bg()).draw(rect);
        }
        HColor lineColor = this.getStyle().value(PName.LineColor).asColor(this.colorSet);
        ug = ug.apply(lineColor);
        ug = ug.apply(UTranslate.dy(padding.getTop() + this.getTextHeight(stringBounder) / 2.0));
        if (widthTitle == 0.0) {
            ULine line = ULine.hline(end - start);
            ug.draw(line);
        } else {
            if (padding.getLeft() > 1.0) {
                ULine line1 = ULine.hline(padding.getLeft());
                ug.draw(line1);
            }
            double x1 = padding.getLeft() + margin.getLeft() + widthTitle + margin.getRight();
            double x2 = end - 1.0;
            ULine line2 = ULine.hline(x2 - x1);
            ug.apply(UTranslate.dx(x1)).draw(line2);
        }
    }

    @Override
    public FingerPrint getFingerPrint(StringBounder stringBounder) {
        double h2 = this.getFullHeightTask(stringBounder);
        double end = this.timeScale.getEndingPosition(this.max);
        return new FingerPrint(0.0, this.getY(stringBounder).getCurrentValue(), end, this.getY(stringBounder).getCurrentValue() + h2);
    }

    @Override
    public FingerPrint getFingerPrintNote(StringBounder stringBounder) {
        return null;
    }

    @Override
    public double getFullHeightTask(StringBounder stringBounder) {
        ClockwiseTopRightBottomLeft padding = this.getStyle().getPadding();
        ClockwiseTopRightBottomLeft margin = this.getStyle().getMargin();
        return margin.getTop() + padding.getTop() + this.getTextHeight(stringBounder) + padding.getBottom() + margin.getBottom();
    }

    private double getTextHeight(StringBounder stringBounder) {
        return this.getTitle().calculateDimension(stringBounder).getHeight();
    }

    @Override
    public Real getY(StringBounder stringBounder) {
        return this.y;
    }

    @Override
    public TaskDraw getTrueRow() {
        return null;
    }

    @Override
    public void setColorsAndCompletion(CenterBorderColor colors, int completion, Url url, Display note, Stereotype noteStereotype) {
    }

    @Override
    public Task getTask() {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getY(StringBounder stringBounder, Direction direction) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getHeightMax(StringBounder stringBounder) {
        return this.getFullHeightTask(stringBounder);
    }

    @Override
    public double getX1(TaskAttribute taskAttribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getX2(TaskAttribute taskAttribute) {
        throw new UnsupportedOperationException();
    }
}

