/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.text.Guillemet;

public class EntityImageArcCircle
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;

    public EntityImageArcCircle(Entity entity) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        this.name = entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.COMPONENT, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null ? null : Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.COMPONENT_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimName = this.name.calculateDimension(stringBounder);
        XDimension2D dimStereo = this.getStereoDimension(stringBounder);
        return dimStereo.mergeTB(dimName);
    }

    private XDimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new XDimension2D(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimStereo = this.getStereoDimension(stringBounder);
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimName = this.name.calculateDimension(stringBounder);
        double nameX = (dimTotal.getWidth() - dimName.getWidth()) / 2.0;
        double nameY = dimStereo.getHeight();
        this.name.drawU(ug.apply(new UTranslate(nameX, nameY)));
        if (this.stereo != null) {
            double stereoX = (dimTotal.getWidth() - dimStereo.getWidth()) / 2.0;
            this.stereo.drawU(ug.apply(UTranslate.dx(stereoX)));
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

