/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import javax.media.ConfigureCompleteEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.DataSink;
import javax.media.EndOfMediaEvent;
import javax.media.Format;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.NoDataSinkException;
import javax.media.NoProcessorException;
import javax.media.PrefetchCompleteEvent;
import javax.media.Processor;
import javax.media.RealizeCompleteEvent;
import javax.media.ResourceUnavailableEvent;
import javax.media.control.TrackControl;
import javax.media.datasink.DataSinkErrorEvent;
import javax.media.datasink.DataSinkEvent;
import javax.media.datasink.DataSinkListener;
import javax.media.datasink.EndOfStreamEvent;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.DataSource;

public class JPEGImagesToVideo {
    private Object waitSync;
    private boolean stateTransitionOK;
    private Object waitFileSync;
    private boolean fileDone;
    private String fileError;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createVideoFile(int n, int n2, int n3, DataSource dataSource, File file) throws IOException {
        this.waitSync = new Object();
        this.stateTransitionOK = true;
        this.waitFileSync = new Object();
        this.fileDone = false;
        this.fileError = null;
        ControllerListener controllerListener = new ControllerListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void controllerUpdate(ControllerEvent controllerEvent) {
                if (controllerEvent instanceof ConfigureCompleteEvent || controllerEvent instanceof RealizeCompleteEvent || controllerEvent instanceof PrefetchCompleteEvent) {
                    Object object = JPEGImagesToVideo.this.waitSync;
                    synchronized (object) {
                        JPEGImagesToVideo.this.stateTransitionOK = true;
                        JPEGImagesToVideo.this.waitSync.notifyAll();
                    }
                } else if (controllerEvent instanceof ResourceUnavailableEvent) {
                    Object object = JPEGImagesToVideo.this.waitSync;
                    synchronized (object) {
                        JPEGImagesToVideo.this.stateTransitionOK = false;
                        JPEGImagesToVideo.this.waitSync.notifyAll();
                    }
                } else if (controllerEvent instanceof EndOfMediaEvent) {
                    controllerEvent.getSourceController().stop();
                    controllerEvent.getSourceController().close();
                }
            }
        };
        DataSinkListener dataSinkListener = new DataSinkListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataSinkUpdate(DataSinkEvent dataSinkEvent) {
                if (dataSinkEvent instanceof EndOfStreamEvent) {
                    Object object = JPEGImagesToVideo.this.waitFileSync;
                    synchronized (object) {
                        JPEGImagesToVideo.this.fileDone = true;
                        JPEGImagesToVideo.this.waitFileSync.notifyAll();
                    }
                }
                if (dataSinkEvent instanceof DataSinkErrorEvent) {
                    Object object = JPEGImagesToVideo.this.waitFileSync;
                    synchronized (object) {
                        JPEGImagesToVideo.this.fileDone = true;
                        JPEGImagesToVideo.this.fileError = "Data sink error";
                        JPEGImagesToVideo.this.waitFileSync.notifyAll();
                    }
                }
            }
        };
        Processor processor = null;
        DataSink dataSink = null;
        try {
            processor = Manager.createProcessor((DataSource)dataSource);
            processor.addControllerListener(controllerListener);
            processor.configure();
            if (!this.waitForState(processor, 180)) {
                throw new IOException("Failed to configure the processor.");
            }
            processor.setContentDescriptor(new ContentDescriptor("video.quicktime"));
            TrackControl[] trackControlArray = processor.getTrackControls();
            Format[] formatArray = trackControlArray[0].getSupportedFormats();
            if (formatArray == null || formatArray.length <= 0) {
                throw new IOException("The mux does not support the input format: " + trackControlArray[0].getFormat());
            }
            trackControlArray[0].setFormat(formatArray[0]);
            processor.realize();
            if (!this.waitForState(processor, 300)) {
                throw new IOException("Failed to realize the processor.");
            }
            dataSink = Manager.createDataSink((DataSource)processor.getDataOutput(), (MediaLocator)new MediaLocator(file.toURL()));
            dataSink.open();
            dataSink.addDataSinkListener(dataSinkListener);
            this.fileDone = false;
            processor.start();
            dataSink.start();
            Object object = this.waitFileSync;
            synchronized (object) {
                while (!this.fileDone) {
                    this.waitFileSync.wait();
                }
            }
            if (this.fileError != null) {
                throw new IOException(this.fileError);
            }
        }
        catch (NoProcessorException noProcessorException) {
            IOException iOException = new IOException(noProcessorException.getMessage());
            iOException.initCause(noProcessorException);
            throw iOException;
        }
        catch (NoDataSinkException noDataSinkException) {
            IOException iOException = new IOException("Failed to create a DataSink for the given output MediaLocator");
            iOException.initCause(noDataSinkException);
            throw iOException;
        }
        catch (InterruptedException interruptedException) {
            if (dataSink != null) {
                dataSink.stop();
            }
            throw new InterruptedIOException("Video creation interrupted");
        }
        finally {
            if (dataSink != null) {
                dataSink.close();
                dataSink.removeDataSinkListener(dataSinkListener);
            }
            if (processor != null) {
                processor.close();
                processor.removeControllerListener(controllerListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForState(Processor processor, int n) throws InterruptedException {
        Object object = this.waitSync;
        synchronized (object) {
            while (processor.getState() < n && this.stateTransitionOK) {
                this.waitSync.wait();
            }
        }
        return this.stateTransitionOK;
    }
}

