/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.rca.framework.api.aggregators;

import java.io.IOException;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.BucketizedSlidingWindowConfig;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.PersistableSlidingWindow;
import org.opensearch.performanceanalyzer.rca.framework.api.aggregators.SlidingWindowData;

public class BucketizedSlidingWindow
extends PersistableSlidingWindow {
    private static final Logger LOG = LogManager.getLogger(BucketizedSlidingWindow.class);
    private final long BUCKET_WINDOW_SIZE;

    public BucketizedSlidingWindow(int SLIDING_WINDOW_SIZE, int BUCKET_WINDOW_SIZE, TimeUnit timeUnit) {
        this(SLIDING_WINDOW_SIZE, BUCKET_WINDOW_SIZE, timeUnit, null);
    }

    public BucketizedSlidingWindow(int SLIDING_WINDOW_SIZE, int BUCKET_WINDOW_SIZE, TimeUnit timeUnit, Path persistFilePath) {
        super(SLIDING_WINDOW_SIZE, timeUnit, persistFilePath);
        if (BUCKET_WINDOW_SIZE >= SLIDING_WINDOW_SIZE) {
            throw new IllegalArgumentException("BucketWindow size should be less than SlidingWindow size");
        }
        this.BUCKET_WINDOW_SIZE = timeUnit.toMillis(BUCKET_WINDOW_SIZE);
    }

    public BucketizedSlidingWindow(BucketizedSlidingWindowConfig config) {
        this(config.getSlidingWindowSizeMinutes(), config.getBucketSizeMinutes(), config.getTimeUnit(), config.getPersistencePath());
    }

    @Override
    public void next(SlidingWindowData e) {
        if (!this.windowDeque.isEmpty()) {
            SlidingWindowData firstElement = (SlidingWindowData)this.windowDeque.getFirst();
            if (e.getTimeStamp() - firstElement.getTimeStamp() < this.BUCKET_WINDOW_SIZE) {
                firstElement.value += e.getValue();
                this.add(e);
                this.pruneExpiredEntries(e.getTimeStamp());
                try {
                    this.write();
                }
                catch (IOException ex) {
                    LOG.error("Failed to persist {} data", (Object)this.getClass().getSimpleName(), (Object)ex);
                }
                return;
            }
        }
        super.next(e);
    }

    @Override
    public int size() {
        this.pruneExpiredEntries(System.currentTimeMillis());
        return this.windowDeque.size();
    }

    @Override
    public double readAvg() {
        this.pruneExpiredEntries(System.currentTimeMillis());
        return super.readAvg();
    }

    @Override
    public double readAvg(TimeUnit timeUnit) {
        this.pruneExpiredEntries(System.currentTimeMillis());
        return super.readAvg(timeUnit);
    }

    @Override
    public double readSum() {
        this.pruneExpiredEntries(System.currentTimeMillis());
        return super.readSum();
    }
}

