/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.BytesRef;
import org.opensearch.index.fielddata.IndexFieldData;
import org.opensearch.index.mapper.MappedFieldType;
import org.opensearch.index.mapper.TextSearchInfo;
import org.opensearch.index.mapper.ValueFetcher;
import org.opensearch.index.query.QueryShardContext;
import org.opensearch.index.query.QueryShardException;
import org.opensearch.knn.index.KNNVectorIndexFieldData;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.search.aggregations.support.CoreValuesSourceType;
import org.opensearch.search.aggregations.support.ValuesSourceType;
import org.opensearch.search.lookup.SearchLookup;

public class KNNVectorFieldType
extends MappedFieldType {
    KNNMappingConfig knnMappingConfig;
    VectorDataType vectorDataType;

    public KNNVectorFieldType(String name, Map<String, String> metadata, VectorDataType vectorDataType, KNNMappingConfig annConfig) {
        super(name, false, false, true, TextSearchInfo.NONE, metadata);
        this.vectorDataType = vectorDataType;
        this.knnMappingConfig = annConfig;
    }

    public ValueFetcher valueFetcher(QueryShardContext context, SearchLookup searchLookup, String format) {
        throw new UnsupportedOperationException("KNN Vector do not support fields search");
    }

    public String typeName() {
        return "knn_vector";
    }

    public Query existsQuery(QueryShardContext context) {
        return new DocValuesFieldExistsQuery(this.name());
    }

    public Query termQuery(Object value, QueryShardContext context) {
        throw new QueryShardException(context, String.format(Locale.ROOT, "KNN vector do not support exact searching, use KNN queries instead: [%s]", this.name()), new Object[0]);
    }

    public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        this.failIfNoDocValues();
        return new KNNVectorIndexFieldData.Builder(this.name(), (ValuesSourceType)CoreValuesSourceType.BYTES, this.vectorDataType);
    }

    public Object valueForDisplay(Object value) {
        return KNNVectorFieldMapperUtil.deserializeStoredVector((BytesRef)value, this.vectorDataType);
    }

    public RescoreContext resolveRescoreContext(RescoreContext userProvidedContext) {
        if (userProvidedContext != null) {
            return userProvidedContext;
        }
        return this.getKnnMappingConfig().getCompressionLevel().getDefaultRescoreContext(this.getKnnMappingConfig().getMode());
    }

    @Generated
    public KNNMappingConfig getKnnMappingConfig() {
        return this.knnMappingConfig;
    }

    @Generated
    public VectorDataType getVectorDataType() {
        return this.vectorDataType;
    }
}

