/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.quantization.models.quantizationState;

import java.io.IOException;
import lombok.Generated;
import org.apache.lucene.util.RamUsageEstimator;
import org.opensearch.Version;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.knn.quantization.models.quantizationParams.ScalarQuantizationParams;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationState;
import org.opensearch.knn.quantization.models.quantizationState.QuantizationStateSerializer;

public final class OneBitScalarQuantizationState
implements QuantizationState {
    private ScalarQuantizationParams quantizationParams;
    private float[] meanThresholds;

    @Override
    public ScalarQuantizationParams getQuantizationParams() {
        return this.quantizationParams;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(Version.CURRENT.id);
        this.quantizationParams.writeTo(out);
        out.writeFloatArray(this.meanThresholds);
    }

    public OneBitScalarQuantizationState(StreamInput in) throws IOException {
        int version = in.readVInt();
        this.quantizationParams = new ScalarQuantizationParams(in, version);
        this.meanThresholds = in.readFloatArray();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        return QuantizationStateSerializer.serialize(this);
    }

    public static OneBitScalarQuantizationState fromByteArray(byte[] bytes) throws IOException {
        return (OneBitScalarQuantizationState)QuantizationStateSerializer.deserialize(bytes, OneBitScalarQuantizationState::new);
    }

    @Override
    public int getBytesPerVector() {
        return this.meanThresholds.length;
    }

    @Override
    public int getDimensions() {
        return this.meanThresholds.length + 7 & 0xFFFFFFF8;
    }

    @Override
    public long ramBytesUsed() {
        long size = RamUsageEstimator.shallowSizeOfInstance(OneBitScalarQuantizationState.class);
        size += RamUsageEstimator.shallowSizeOf((Object)this.quantizationParams);
        return size += RamUsageEstimator.sizeOf((float[])this.meanThresholds);
    }

    @Generated
    public float[] getMeanThresholds() {
        return this.meanThresholds;
    }

    @Generated
    public OneBitScalarQuantizationState() {
    }

    @Generated
    public OneBitScalarQuantizationState(ScalarQuantizationParams quantizationParams, float[] meanThresholds) {
        this.quantizationParams = quantizationParams;
        this.meanThresholds = meanThresholds;
    }
}

