/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.reader;

import com.google.common.annotations.VisibleForTesting;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jooq.BatchBindStep;
import org.jooq.DSLContext;
import org.jooq.Field;
import org.jooq.Name;
import org.jooq.Query;
import org.jooq.Record;
import org.jooq.Result;
import org.jooq.SQLDialect;
import org.jooq.SelectField;
import org.jooq.SelectFieldOrAsterisk;
import org.jooq.TableLike;
import org.jooq.impl.DSL;
import org.opensearch.performanceanalyzer.DBUtils;
import org.opensearch.performanceanalyzer.commons.metrics.AllMetrics;
import org.opensearch.performanceanalyzer.reader.Removable;

public class ClusterManagerThrottlingMetricsSnapshot
implements Removable {
    private final DSLContext create;
    private final Long windowStartTime;
    private final String tableName;
    private List<Field<?>> columns;

    public ClusterManagerThrottlingMetricsSnapshot(Connection conn, Long windowStartTime) {
        this.create = DSL.using((Connection)conn, (SQLDialect)SQLDialect.SQLITE);
        this.windowStartTime = windowStartTime;
        this.tableName = "cluster_manager_throttling_" + windowStartTime;
        this.columns = new ArrayList<Field<?>>(){
            {
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Long.class));
                this.add(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Long.class));
            }
        };
        this.create.createTable(this.tableName).columns(this.columns).execute();
    }

    @Override
    public void remove() throws Exception {
        this.create.dropTable(DSL.table((String)this.tableName)).execute();
    }

    public Result<Record> fetchAll() {
        return this.create.select(new SelectFieldOrAsterisk[0]).from((TableLike)DSL.table((String)this.tableName)).fetch();
    }

    public BatchBindStep startBatchPut() {
        ArrayList<Object> dummyValues = new ArrayList<Object>();
        for (int i = 0; i < this.columns.size(); ++i) {
            dummyValues.add(null);
        }
        return this.create.batch((Query)this.create.insertInto(DSL.table((String)this.tableName)).values(dummyValues));
    }

    public Result<Record> fetchAggregatedMetrics() {
        ArrayList fields = new ArrayList<SelectField<?>>(){
            {
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString(), "max")));
                this.add(DSL.sum((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "sum")));
                this.add(DSL.avg((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Double.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "avg")));
                this.add(DSL.min((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "min")));
                this.add(DSL.max((Field)DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Long.class)).as(DBUtils.getAggFieldName(AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString(), "max")));
            }
        };
        ArrayList groupByFields = new ArrayList();
        return this.create.select((Collection)fields).from((TableLike)DSL.table((String)this.tableName)).groupBy(groupByFields).fetch();
    }

    @VisibleForTesting
    public void putMetrics(long retrying_task, Map<String, String> dimensions) {
        HashMap<Field, String> dimensionMap = new HashMap<Field, String>();
        for (Map.Entry<String, String> dimension : dimensions.entrySet()) {
            dimensionMap.put(DSL.field((Name)DSL.name((String)dimension.getKey()), String.class), dimension.getValue());
        }
        this.create.insertInto(DSL.table((String)this.tableName)).set(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.DATA_RETRYING_TASK_COUNT.toString()), Long.class), (Object)retrying_task).set(DSL.field((Name)DSL.name((String)AllMetrics.ClusterManagerThrottlingValue.CLUSTER_MANAGER_THROTTLED_PENDING_TASK_COUNT.toString()), Long.class), (Object)0L).set(dimensionMap).execute();
    }
}

