searchData={"items":[{"type":"module","title":"megaco","doc":"Main API of the Megaco application\n\nInterface module for the Megaco application","ref":"megaco.html"},{"type":"function","title":"megaco.call/3","doc":"Sends one or more transaction request(s) and waits for the reply.\n\nWhen sending one transaction in a message, `ActionRequests` should be\n`t:action_reqs/0` (the reply will then be `UserReply`). When sending several\ntransactions in a message, `ActionRequests` should be `[action_reqs()]` (the\nreply will then be `[UserReply]`). Each element of the list is part of one\ntransaction.\n\nFor some of _our_ codecs (not binary), it is also possible to pre-encode the\nactions, in which case `ActionRequests` will be either a `t:binary/0` or\n`[binary()]`.\n\nThe function returns when the reply arrives, when the request timer eventually\ntimes out or when the outstanding requests are explicitly cancelled.\n\nThe default values of the send options are obtained by\n`megaco:conn_info(ConnHandle, Item)`. But the send options above, may explicitly\nbe overridden.\n\nThe `ProtocolVersion` version is the version actually encoded in the reply\nmessage.\n\nAt `Success`, the `UserReply` contains a list of 'ActionReply' records possibly\ncontaining error indications.\n\nA `Failure`, indicates that the remote user has replied with an explicit\ntransactionError.\n\nA `UserCancelReason`, indicates that the request has been canceled by the user.\n`ReasonForUserCancel` is the reason given in the call to the\n[cancel](`m:megaco#cancel`) function.\n\nA send error (`SendReason`), indicates that the send function of the megaco\ntransport callback module failed to send the request. There are two separate\ncases: `SendCancelledReason` and `SendFailedReason`. The first is the result of\nthe send function returning `{cancel, Reason}` and the second is some other kind\nof erroneous return value. See the\n[send_message](`c:megaco_transport:send_message/3`) function for more info.\n\nAn `OtherReason`, indicates some other error such as timeout.\n\nFor more info about the 'extra' part of the result (`SuccessExtra` and\n`ErrorExtra`), see the [note](`m:megaco_user#extra_argument`) in the user\ncallback module documentation.\n\n[](){: #cast }","ref":"megaco.html#call/3"},{"type":"function","title":"megaco.cancel/2","doc":"Cancel all outstanding messages for this connection\n\nThis causes outstanding megaco:call/3 requests to return. The callback functions\nUserMod:handle_reply/4 and UserMod:handle_trans_ack/4 are also invoked where it\napplies. See the megaco_user module for more info about the callback arguments.\n\n[](){: #process_received_message }","ref":"megaco.html#cancel/2"},{"type":"function","title":"megaco.cast/3","doc":"Sends one or more transaction request(s) but does NOT wait for a reply\n\nWhen sending one transaction in a message, `ActionRequests` should be\n`t:action_reqs/0`. When sending several transactions in a message,\n`ActionRequests` should be `[action_reqs()]`. Each element of the list is part\nof one transaction.\n\nFor some of _our_ codecs (not binary), it is also possible to pre-encode the\nactions, in which case `Actions` will be either a `t:binary/0` or `[binary()]`.\n\nThe default values of the send options are obtained by\nmegaco:conn_info(ConnHandle, Item). But the send options above, may explicitly\nbe overridden.\n\nThe ProtocolVersion version is the version actually encoded in the reply\nmessage.\n\nThe callback function UserMod:handle_trans_reply/4 is invoked when the reply\narrives, when the request timer eventually times out or when the outstanding\nrequests are explicitly cancelled. See the megaco_user module for more info\nabout the callback arguments.\n\nGiven as `ReplyData` argument to UserMod:handle_trans_reply/4.\n\n[](){: #encode_actions }","ref":"megaco.html#cast/3"},{"type":"function","title":"megaco.conn_info/1","doc":"","ref":"megaco.html#conn_info/1"},{"type":"function","title":"megaco.conn_info/2","doc":"Lookup information about an active connection\n\nRequires that the connection is active.\n\nFailure: `exit` if, for instance, `ConnHandle` refers to a connection that no\nlonger exists.\n\n[](){: #conn_info_21 }\n\nLookup all connection information about an _active_ connection\n\nSee [conn_info](`m:megaco#conn_info_24`) for more info.\n\nFailure: `exit` if, for instance, `ConnHandle` refers to a connection that no\nlonger exists.\n\n[](){: #conn_info_22 }\n\nLookup information about currently active requests for an _active_ connection\n\nFailure: `exit` if, for instance, `ConnHandle` refers to a connection that no\nlonger exists.\n\n[](){: #conn_info_23 }\n\nLookup information about currently active replies for an _active_ connection\n\nFailure: `exit` if, for instance, `ConnHandle` refers to a connection that no\nlonger exists.\n\n[](){: #update_conn_info }","ref":"megaco.html#conn_info/2"},{"type":"function","title":"megaco.connect/4","doc":"","ref":"megaco.html#connect/4"},{"type":"function","title":"megaco.connect/5","doc":"Establish a \"virtual\" connection\n\nActivates a connection to a remote user. When this is done the connection can be\nused to send messages (with `SendMod:send_message/2`). The `ControlPid` is the\nidentifier of a process that controls the connection. That process will be\nsupervised and if it dies, this will be detected and the\n`UserMod:handle_disconnect/2` callback function will be invoked. See the\nmegaco_user module for more info about the callback arguments. The connection\nmay also explicitly be deactivated by invoking `megaco:disconnect/2`.\n\nThe `ControlPid` may be the identity of a process residing on another Erlang\nnode. This is useful when you want to distribute a user over several Erlang\nnodes. In such a case one of the nodes has the physical connection. When a user\nresiding on one of the other nodes needs to send a request (with `megaco:call/3`\nor `megaco:cast/3`), the message will encoded on the originating Erlang node,\nand then be forwarded to the node with the physical connection. When the reply\narrives, it will be forwarded back to the originator. The distributed connection\nmay explicitly be deactivated by a local call to `megaco:disconnect/2` or\nimplicitly when the physical connection is deactivated (with\n`megaco:disconnect/2`, killing the controlling process, halting the other node,\n...).\n\nThe call of this function will trigger the callback function\n`UserMod:handle_connect/2` to be invoked. See the megaco_user module for more\ninfo about the callback arguments.\n\nA connection may be established in several ways:\n\n- **`provisioned MID`** - The MG may explicitly invoke megaco:connect/4 and use\n  a provisioned MID of the MGC as the RemoteMid.\n\n- **`upgrade preliminary MID`** - The MG may explicitly invoke megaco:connect/4\n  with the atom 'preliminary_mid' as a temporary MID of the MGC, send an intial\n  message, the Service Change Request, to the MGC and then wait for an initial\n  message, the Service Change Reply. When the reply arrives, the Megaco\n  application will pick the MID of the MGC from the message header and\n  automatically upgrade the connection to be a \"normal\" connection. By using\n  this method of establishing the connection, the callback function\n  `UserMod:handle_connect/2` to be invoked twice. First with a `ConnHandle` with\n  the remote_mid-field set to preliminary_mid, and then when the connection\n  upgrade is done with the remote_mid-field set to the actual MID of the MGC.\n\n- **`automatic`** - When the MGC receives its first message, the Service Change\n  Request, the Megaco application will automatically establish the connection by\n  using the MG MID found in the message header as remote mid.\n\n- **`distributed`** - When a user (MG/MGC) is distributed over several nodes, it\n  is required that the node hosting the connection already has activated the\n  connection and that it is in the \"normal\" state. The `RemoteMid` must be a\n  real Megaco MID and not a `preliminary_mid`.\n\nAn initial megaco_receive_handle record may be obtained with\n`megaco:user_info(UserMid, receive_handle)`\n\nThe send handle is provided by the preferred transport module, e.g. megaco_tcp,\nmegaco_udp. Read the documentation about each transport module about the\ndetails.\n\nThe connect is done in two steps: first an internal `connection setup` and then\nby calling the user [handle_connect](`m:megaco_user#connect`) callback function.\nThe first step could result in an error with `Reason = ConnectReason` and the\nsecond an error with `Reason = HandleConnectReason`:\n\n- **`ConnectReason`** - An error with this reason is generated by the megaco\n  application itself.\n\n- **`HandleConnectReason`** - An error with this reason is caused by the user\n  [handle_connect](`m:megaco_user#connect`) callback function either returning\n  an error or an invalid value.\n\n`Extra` can be any `t:term/0` except the atom `ignore_extra`. It is passed\n(back) to the user via the callback function\n[handle_connect/3](`m:megaco_user#connect`).\n\n[](){: #disconnect }","ref":"megaco.html#connect/5"},{"type":"function","title":"megaco.decode_sdp/1","doc":"Decode (parse) a property parameter construct.\n\nWhen decoding `t:property_group/0` or `t:property_groups/0`, those property\nparameter constructs that cannot be decoded (either because of decode error or\nbecause they are unknown), will be returned as a two-tuple. The first element of\nwhich will be the (undecoded) property parameter and the other the actual\nreason. This means that the caller of this function has to expect not only\nsdp-records, but also this two-tuple construct.\n\nThis function performs the following transformation:\n\n- property_parm() -> sdp()\n- property_group() -> sdp_property_group()\n- property_groups() -> sdp_property_groups()\n\n[](){: #versions } [](){: #versions1 } [](){: #versions2 }","ref":"megaco.html#decode_sdp/1"},{"type":"function","title":"megaco.disable_trace/0","doc":"This function is used to stop megaco tracing.\n\n[](){: #set_trace }","ref":"megaco.html#disable_trace/0"},{"type":"function","title":"megaco.disconnect/2","doc":"Tear down a \"virtual\" connection\n\nCauses the `UserMod:handle_disconnect/2` callback function to be invoked. See\nthe megaco_user module for more info about the callback arguments.\n\n[](){: #call }","ref":"megaco.html#disconnect/2"},{"type":"function","title":"megaco.enable_trace/2","doc":"This function is used to start megaco tracing at a given `Level` and direct\nresult to the given `Destination`.\n\nIt starts a tracer server and then sets the proper match spec (according to\n`Level`).\n\nIn the case when `Destination` is `File`, the printable megaco trace events will\nbe printed to the file `File` using plain `io:format/2`.\n\nIn the case when `Destination` is `io`, the printable megaco trace events will\nbe printed on stdout using plain `io:format/2`.\n\nSee `dbg` for further information.\n\n[](){: #disable_trace }","ref":"megaco.html#enable_trace/2"},{"type":"function","title":"megaco.encode_actions/3","doc":"Encodes lists of action requests for one or more transaction request(s).\n\nWhen encoding action requests for one transaction, `Actions` should be\n`t:action_reqs/0`. When encoding action requests for several transactions,\n`Actions` should be `[action_reqs()]`. Each element of the list is part of one\ntransaction.\n\n[](){: #token_tag2string }","ref":"megaco.html#encode_actions/3"},{"type":"function","title":"megaco.encode_sdp/1","doc":"Encode (generate) an SDP construct.\n\nIf a `t:property_parm/0` is found as part of the input (`SDP`) then it is left\nunchanged.\n\nThis function performs the following transformation:\n\n- sdp() -> property_parm()\n- sdp_property_group() -> property_group()\n- sdp_property_groups() -> property_groups()\n\n[](){: #decode_sdp }","ref":"megaco.html#encode_sdp/1"},{"type":"function","title":"megaco.eval_digit_map/1","doc":"","ref":"megaco.html#eval_digit_map/1"},{"type":"function","title":"megaco.eval_digit_map/2","doc":"Collect digit map letters according to the digit map.\n\nWhen evaluating a digit map, a state machine waits for timeouts and letters\nreported by megaco:report_digit_event/2. The length of the various timeouts are\ndefined in the digit_map_value() record.\n\nWhen a complete sequence of valid events has been received, the result is\nreturned as a list of letters.\n\nThere are two options for handling syntax errors (that is when an unexpected\nevent is received when the digit map evaluator is expecting some other event).\nThe unexpected events may either be ignored or rejected. The latter means that\nthe evaluation is aborted and an error is returned.\n\n[](){: #report_digit_event }","ref":"megaco.html#eval_digit_map/2"},{"type":"function","title":"megaco.get_stats/0","doc":"Retreive all (SNMP) statistic counters maintained by the megaco application.\n\nThe global counters handle events that cannot be attributed to a single\nconnection (e.g. protocol errors that occur before the connection has been\nproperly setup).\n\n[](){: #get_stats_1_1 }","ref":"megaco.html#get_stats/0"},{"type":"function","title":"megaco.get_stats/1","doc":"Retreive a (SNMP) (global) statistic counter maintained by the megaco\napplication.\n\nThe global counters handle events that cannot be attributed to a single\nconnection (e.g. protocol errors that occur before the connection has been\nproperly setup).\n\n[](){: #get_stats_1_2 }\n\nRetreive all (SNMP) statistic counters maintained by the megaco application, for\na specific connection.\n\n[](){: #get_stats_2 }","ref":"megaco.html#get_stats/1"},{"type":"function","title":"megaco.get_stats/2","doc":"Retreive a (SNMP) statistic counter maintained by the megaco application.\n\n[](){: #reset_stats } [](){: #reset_stats_0 }","ref":"megaco.html#get_stats/2"},{"type":"function","title":"megaco.info/0","doc":"This function produces a list of information about the megaco application. Such\nas users and their config, connections and their config, statistics and so on.\n\nThis information can be produced by the functions\n[user_info](`m:megaco#user_info`), [conn_info](`m:megaco#conn_info`),\n[system_info](`m:megaco#system_info`) and [get_stats](`m:megaco#get_stats`) but\nthis is a simple way to get it all at once.\n\n[](){: #connect }","ref":"megaco.html#info/0"},{"type":"function","title":"megaco.parse_digit_map/1","doc":"Parses a digit map body\n\nParses a digit map body, represented as a list of characters, into a list of\nstate transitions suited to be evaluated by megaco:eval_digit_map/1,2.\n\n[](){: #eval_digit_map }","ref":"megaco.html#parse_digit_map/1"},{"type":"function","title":"megaco.print_version_info/0","doc":"","ref":"megaco.html#print_version_info/0"},{"type":"function","title":"megaco.print_version_info/1","doc":"Utility function to produce a formated printout of the versions info generated\nby the `versions1` and `versions2` functions.\n\nThe function print_version_info/0 uses the result of function version1/0 as\n`VersionInfo`.\n\nExample:\n\n```erlang\n           {ok, V} = megaco:versions1(), megaco:format_versions(V).\n```\n\n[](){: #enable_trace }","ref":"megaco.html#print_version_info/1"},{"type":"function","title":"megaco.process_received_message/4","doc":"","ref":"megaco.html#process_received_message/4"},{"type":"function","title":"megaco.process_received_message/5","doc":"Process a received message\n\nThis function is intended to be invoked by some transport modules when get an\nincoming message. Which transport that actually is used is up to the user to\nchoose.\n\nThe message is delivered as an Erlang binary and is decoded by the encoding\nmodule stated in the receive handle together with its encoding config (also in\nthe receive handle). Depending of the outcome of the decoding various callback\nfunctions will be invoked. See megaco_user for more info about the callback\narguments.\n\nThe argument `Extra` is just an opaque data structure passed to the user via the\ncallback functions in the [user callback module](`m:megaco_user`). Note however\nthat if `Extra` has the value `extra_undefined` the argument will be ignored\n(same as if [`process_received_message/4`](`process_received_message/4`) had\nbeen called). See the documentation for the behaviour of the callback module,\n`m:megaco_user`, for more info.\n\nNote that all processing is done in the context of the calling process. A\ntransport module could call this function via one of the `spawn` functions (e.g.\n`spawn_opt`). See also `receive_message/4,5`.\n\nIf the message cannot be decoded the following callback function will be\ninvoked:\n\n- UserMod:handle_syntax_error/3\n\nIf the decoded message instead of transactions contains a message error, the\nfollowing callback function will be invoked:\n\n- UserMod:handle_message_error/3\n\nIf the decoded message happens to be received before the connection is\nestablished, a new \"virtual\" connection is established. This is typically the\ncase for the Media Gateway Controller (MGC) upon the first Service Change. When\nthis occurs the following callback function will be invoked:\n\n- UserMod:handle_connect/2\n\nFor each transaction request in the decoded message the following callback\nfunction will be invoked:\n\n- UserMod:handle_trans_request/3\n\nFor each transaction reply in the decoded message the reply is returned to the\nuser. Either the originating function megaco:call/3 will return. Or in case the\noriginating function was megaco:case/3 the following callback function will be\ninvoked:\n\n- UserMod:handle_trans_reply/4\n\nWhen a transaction acknowledgement is received it is possible that user has\ndecided not to bother about the acknowledgement. But in case the return value\nfrom UserMod:handle_trans_request/3 indicates that the acknowledgement is\nimportant the following callback function will be invoked:\n\n- UserMod:handle_trans_ack/4\n\nSee the megaco_user module for more info about the callback arguments.\n\n[](){: #receive_message }","ref":"megaco.html#process_received_message/5"},{"type":"function","title":"megaco.receive_message/4","doc":"","ref":"megaco.html#receive_message/4"},{"type":"function","title":"megaco.receive_message/5","doc":"Process a received message\n\nThis is a callback function intended to be invoked by some transport modules\nwhen get an incoming message. Which transport that actually is used is up to the\nuser to choose.\n\nIn principle, this function calls the `process_received_message/4,5` function\nvia a `spawn` to perform the actual processing.\n\nFor further information see the\n[process_received_message/4,5](`m:megaco#process_received_message`) function.\n\n[](){: #parse_digit_map }","ref":"megaco.html#receive_message/5"},{"type":"function","title":"megaco.report_digit_event/2","doc":"Send one or more events to the event collector process.\n\nSend one or more events to a process that is evaluating a digit map, that is a\nprocess that is executing megaco:eval_digit_map/1,2.\n\nNote that the events `$s | $S`, `l | $L` and `$z | $Z` has nothing to do with\nthe timers using the same characters.\n\n[](){: #test_digit_event }","ref":"megaco.html#report_digit_event/2"},{"type":"function","title":"megaco.reset_stats/0","doc":"Reset all (SNMP) statistics counters.\n\n[](){: #reset_stats_1_1 }","ref":"megaco.html#reset_stats/0"},{"type":"function","title":"megaco.reset_stats/1","doc":"Reset the specified (SNMP) statistics counter.\n\n[](){: #reset_stats_1_2 }\n\nReset all (SNMP) statistics counters for a connection.\n\n[](){: #test_request }","ref":"megaco.html#reset_stats/1"},{"type":"function","title":"megaco.set_trace/1","doc":"This function is used to change the megaco trace level.\n\nIt is assumed that tracing has already been enabled (see `enable_trace` above).\n\n[](){: #stats } [](){: #get_stats } [](){: #get_stats_0 }","ref":"megaco.html#set_trace/1"},{"type":"function","title":"megaco.start/0","doc":"Starts the Megaco application\n\nUsers may either explicitly be registered with megaco:start_user/2 and/or be\nstatically configured by setting the application environment variable 'users' to\na list of \\{UserMid, Config\\} tuples. See the function megaco:start_user/2 for\ndetails.\n\n[](){: #stop }","ref":"megaco.html#start/0"},{"type":"function","title":"megaco.start_user/2","doc":"Initial configuration of a user\n\nRequires the megaco application to be started. A user is either a Media Gateway\n(MG) or a Media Gateway Controller (MGC). One Erlang node may host many users.\n\nA user is identified by its UserMid, which must be a legal Megaco MID.\n\nConfig is a list of \\{Item, Value\\} tuples. See megaco:user_info/2 about which\nitems and values that are valid.\n\n[](){: #stop_user }","ref":"megaco.html#start_user/2"},{"type":"function","title":"megaco.stop/0","doc":"Stops the Megaco application\n\n[](){: #start_user }","ref":"megaco.html#stop/0"},{"type":"function","title":"megaco.stop_user/1","doc":"Delete the configuration of a user\n\nRequires that the user does not have any active connection.\n\n[](){: #user_info } [](){: #user_info_11 } [](){: #user_info_23 }","ref":"megaco.html#stop_user/1"},{"type":"function","title":"megaco.system_info/0","doc":"","ref":"megaco.html#system_info/0"},{"type":"function","title":"megaco.system_info/1","doc":"Lookup system information.\n\n[](){: #info }","ref":"megaco.html#system_info/1"},{"type":"function","title":"megaco.test_digit_event/2","doc":"Feed digit map collector with events and return the result\n\nThis function starts the evaluation of a digit map with megaco:eval_digit_map/1\nand sends a sequence of events to it with megaco:report_digit_event/2 in order\nto simplify testing of digit maps.\n\n[](){: #encode_sdp }","ref":"megaco.html#test_digit_event/2"},{"type":"function","title":"megaco.test_reply/5","doc":"Tests if the Reply argument is correctly composed.\n\nThis function is only intended for testing purposes. It's supposed to test the\n`actual_reply()` return value of the callback functions\n[handle_trans_request](`m:megaco_user#trans_request`) and\n[handle_trans_long_request](`m:megaco_user#trans_long_request`) functions (with\nthe additions of the `EncodingMod` and `EncodingConfig` arguments). It composes\na complete megaco message end attempts to encode it. The return value, will be a\ntuple of the composed megaco message and the encode result.","ref":"megaco.html#test_reply/5"},{"type":"function","title":"megaco.test_request/5","doc":"Tests if the Actions argument is correctly composed.\n\nThis function is only intended for testing purposes. It's supposed to have a\nsame kind of interface as the [call](`m:megaco#call`) or [cast](`m:megaco#cast`)\nfunctions (with the additions of the `EncodingMod` and `EncodingConfig`\narguments). It composes a complete megaco message end attempts to encode it. The\nreturn value, will be a tuple of the composed megaco message and the encode\nresult.\n\n[](){: #test_reply }","ref":"megaco.html#test_request/5"},{"type":"function","title":"megaco.token_tag2string/1","doc":"","ref":"megaco.html#token_tag2string/1"},{"type":"function","title":"megaco.token_tag2string/2","doc":"","ref":"megaco.html#token_tag2string/2"},{"type":"function","title":"megaco.token_tag2string/3","doc":"Convert a token tag to a string\n\nIf no encoder module is given, the default is used (which is pretty).\n\nIf no or an unknown version is given, the _best_ version is used (which is v3).\n\nIf no match is found for `Tag`, `Result` will be the empty string (`[]`).\n\n[](){: #cancel }","ref":"megaco.html#token_tag2string/3"},{"type":"function","title":"megaco.update_conn_info/3","doc":"Update information about an active connection\n\nRequires that the connection is activated. See `t:conn_info_item/0` about which\nitems and values that are valid.\n\n[](){: #system_info }","ref":"megaco.html#update_conn_info/3"},{"type":"function","title":"megaco.update_user_info/3","doc":"Update information about a user\n\nRequires that the user is started.\n\n[](){: #conn_info } [](){: #conn_info_11 } [](){: #conn_info_24 }","ref":"megaco.html#update_user_info/3"},{"type":"function","title":"megaco.user_info/1","doc":"","ref":"megaco.html#user_info/1"},{"type":"function","title":"megaco.user_info/2","doc":"Lookup user information\n\n[](){: #user_info_21 }\n\nLookup user information about currently active requests.\n\n[](){: #user_info_22 }\n\nLookup user information about currently active replies.\n\n[](){: #update_user_info }","ref":"megaco.html#user_info/2"},{"type":"function","title":"megaco.versions1/0","doc":"","ref":"megaco.html#versions1/0"},{"type":"function","title":"megaco.versions2/0","doc":"Utility functions used to retrieve some system and application info.\n\nThe difference between the two functions is in how they get the modules to\ncheck. `versions1` uses the app-file and `versions2` uses the function\n`application:get_key`.\n\n[](){: #print_version_info }","ref":"megaco.html#versions2/0"},{"type":"type","title":"megaco.action_reply/0","doc":"","ref":"megaco.html#t:action_reply/0"},{"type":"type","title":"megaco.action_reps/0","doc":"","ref":"megaco.html#t:action_reps/0"},{"type":"type","title":"megaco.action_reqs/0","doc":"","ref":"megaco.html#t:action_reqs/0"},{"type":"type","title":"megaco.action_request/0","doc":"","ref":"megaco.html#t:action_request/0"},{"type":"type","title":"megaco.conn_handle/0","doc":"","ref":"megaco.html#t:conn_handle/0"},{"type":"type","title":"megaco.conn_info_item/0","doc":"This type is a basic (atom) lookup key (for info on an active connection). The\ncorresponding value can be of any type.[](){: #ci_control_pid }\n\n- **`control_pid`** - The process identifier of the controlling process for a\n  connection.\n\n  Value type: [pid()](`t:erlang:pid/0`)\n\n  [](){: #ci_send_handle }\n\n- **`send_handle`** - Opaque send handle whose contents is internal for the send\n  module.\n\n  Value type: `t:send_handle/0`\n\n  [](){: #ci_local_mid }\n\n- **`local_mid`** - The local mid (of the connection, i.e. the own mid).\n\n  Value type: `t:mid/0`\n\n  [](){: #ci_remote_mid }\n\n- **`remote_mid`** - The remote mid (of the connection).\n\n  Value type: `t:mid/0`\n\n  [](){: #ci_receive_handle }\n\n- **`receive_handle`** - Construct a megaco_receive_handle record.\n\n  Value type: `t:receive_handle/0`\n\n  [](){: #ci_trans_id }\n\n- **`trans_id`** - Next transaction id.\n\n  Note that transaction id's are (currently) maintained on a per user basis so\n  there is no way to be sure that the value returned will actually be used for a\n  transaction sent on this connection (in case a user has several connections,\n  which is not at all unlikely).\n\n  Value type: `t:transaction_id/0` | `undefined_serial`\n\n  [](){: #ci_max_trans_id }\n\n- **`max_trans_id`** - Last transaction id.\n\n  Value type: `t:transaction_id/0` | `infinity`\n\n  [](){: #ci_request_timer }\n\n- **`request_timer`** - Wait for reply.\n\n  The timer is cancelled when a reply is received.\n\n  When a pending message is received, the timer is cancelled and the\n  `long_request_timer` is started instead (see below). No resends will be\n  performed from this point (since we now know that the other side has received\n  the request).\n\n  When the timer reaches an intermediate expire, the request is resent and the\n  timer is restarted.\n\n  When the timer reaches the final expire, either the function `megaco:call`\n  will return with `{error, timeout}` or the callback function\n  `handle_trans_reply` will be called with `UserReply = {error, timeout}` (if\n  `megaco:cast` was used).\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `#megaco_incr_timer{}`.\n\n  [](){: #ci_long_request_timer }\n\n- **`long_request_timer`** - Wait for reply after having received a pending\n  message.\n\n  When the timer reaches an intermediate expire, the timer restarted.\n\n  When a pending message is received, and the `long_request_timer` is _not_ \"on\n  its final leg\", the timer will be restarted, and, if\n  `long_request_resend = true`, the request will be re-sent.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `60 seconds`.\n\n  [](){: #ci_request_keep_alive_timeout }\n\n- **`request_keep_alive_timeout`** - Specifies the timeout time for the\n  request-keep-alive timer.\n\n  This timer is started when the _first_ reply to an asynchronous request\n  (issued using the [megaco:cast/3](`m:megaco#cast`) function) arrives. As long\n  as this timer is running, replies will be delivered via the\n  [handle_trans_reply/4,5](`m:megaco_user#trans_reply`) callback function, with\n  their \"arrival number\" (see `UserReply` of the\n  [handle_trans_reply/4,5](`m:megaco_user#trans_reply`) callback function).\n\n  Replies arriving after the timer has expired, will be delivered using the\n  [handle_unexpected_trans/3,4](`m:megaco_user#unexpected_trans`) callback\n  function.\n\n  Value type: `plain` | [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `plain`.\n\n  [](){: #ci_long_request_resend }\n\n- **`long_request_resend`** - This option indicates weather the request should\n  be resent until the reply is received, _even_ though a pending message has\n  been received.\n\n  Normally, after a pending message has been received, the request is not resent\n  (since a pending message is an indication that the request has been received).\n  But since the reply (to the request) can be lost, this behaviour has its\n  values.\n\n  It is of course pointless to set this value to _true_ unless the\n  `long_request_timer` (see above) is also set to an incremental timer\n  (`#megaco_incr_timer{}`).\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_reply_timer }\n\n- **`reply_timer`** - Wait for an ack.\n\n  When a request is received, some info related to the reply is store internally\n  (e.g. the binary of the reply). This info will live until either an ack is\n  received or this timer expires. For instance, if the same request is received\n  again (e.g. a request with the same transaction id), the (stored) reply will\n  be (re-) sent automatically by megaco.\n\n  If the timer is of type `#megaco_incr_timer{}`, then for each intermediate\n  timout, the reply will be resent (this is valid until the ack is received or\n  the timer expires).\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `30000`.\n\n  [](){: #ci_call_proxy_gc_timeout }\n\n- **`call_proxy_gc_timeout`** - Timeout time for the call proxy.\n\n  When a request is sent using the [call/3](`m:megaco#call`) function, a proxy\n  process is started to handle all replies. When the reply has been received and\n  delivered to the user, the proxy process continue to exist for as long as this\n  option specifies. Any received messages, is passed on to the user via the\n  [handle_unexpected_trans](`m:megaco_user#handle_unexpected_trans`) callback\n  function.\n\n  The timeout time is in milliseconds. A value of 0 (zero) means that the proxy\n  process will exit directly after the reply has been delivered.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `5000` (= 5 seconds).\n\n- **`auto_ack`** - Automatic send transaction ack when the transaction reply has\n  been received (see `trans_ack` below).\n\n  This is used for _three-way-handshake_.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_trans_ack }\n\n- **`trans_ack`** - Shall ack's be accumulated or not.\n\n  This property is only valid if `auto_ack` is true.\n\n  If `auto_ack` is true, then if `trans_ack` is `false`, ack's will be sent\n  immediately. If `trans_ack` is `true`, then ack's will instead be sent to the\n  transaction sender process for accumulation and later sending (see\n  `trans_ack_maxcount`, `trans_req_maxcount`, `trans_req_maxsize`,\n  `trans_ack_maxcount` and `trans_timer`).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_trans_ack_maxcount }\n\n- **`trans_ack_maxcount`** - Maximum number of accumulated ack's. At most this\n  many ack's will be accumulated by the transaction sender (if started and\n  configured to accumulate ack's).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `10`.\n\n  [](){: #ci_trans_req }\n\n- **`trans_req`** - Shall requests be accumulated or not.\n\n  If `trans_req` is `false`, then request(s) will be sent immediately (in its\n  own message).\n\n  If `trans_req` is true, then request(s) will instead be sent to the\n  transaction sender process for accumulation and later sending (see\n  `trans_ack_maxcount`, `trans_req_maxcount`, `trans_req_maxsize`,\n  `trans_ack_maxcount` and `trans_timer`).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_trans_req_maxcount }\n\n- **`trans_req_maxcount`** - Maximum number of accumulated requests. At most\n  this many requests will be accumulated by the transaction sender (if started\n  and configured to accumulate requests).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `10`.\n\n  [](){: #ci_trans_req_maxsize }\n\n- **`trans_req_maxsize`** - Maximum size of the accumulated requests. At most\n  this much requests will be accumulated by the transaction sender (if started\n  and configured to accumulate requests).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `2048`.\n\n  [](){: #ci_trans_timer }\n\n- **`trans_timer`** - Transaction sender timeout time. Has two functions. First,\n  if the value is 0, then transactions will not be accumulated (e.g. the\n  transaction sender process will not be started). Second, if the value is\n  greater then 0 and `auto_ack` and `trans_ack` is true or if `trans_req` is\n  true, then transaction sender will be started and transactions (which is\n  depending on the values of `auto_ack`, `trans_ack` and `trans_req`) will be\n  accumulated, for later sending.\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `0`.\n\n  [](){: #ci_pending_timer }\n\n- **`pending_timer`** - Automatic send transaction pending if the timer expires\n  before a transaction reply has been sent. This timer is also called\n  provisional response timer.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `30000` (= 30 seconds).\n\n  [](){: #ci_sent_pending_limit }\n\n- **`sent_pending_limit`** - Sent pending limit (see the\n  MGOriginatedPendingLimit and the MGCOriginatedPendingLimit of the megaco root\n  package). This parameter specifies how many pending messages that can be sent\n  (for a given received transaction request). When the limit is exceeded, the\n  transaction is aborted (see\n  [handle_trans_request_abort](`m:megaco_user#request_abort`)) and an error\n  message is sent to the other side.\n\n  Note that this has no effect on the actual sending of pending transactions.\n  This is either implicit (e.g. when receiving a re-sent transaction request for\n  a request which is being processed) or controlled by the pending_timer, see\n  above.\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`) | `infinity`\n\n  Defaults to `infinity`.\n\n  [](){: #ci_recv_pending_limit }\n\n- **`recv_pending_limit`** - Receive pending limit (see the\n  MGOriginatedPendingLimit and the MGCOriginatedPendingLimit of the megaco root\n  package). This parameter specifies how many pending messages that can be\n  received (for a sent transaction request). When the limit is exceeded, the\n  transaction is considered lost, and an error returned to the user (through the\n  call-back function _handle_trans_reply_).\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`) | `infinity`\n\n  Defaults to `infinity`.\n\n  [](){: #ci_send_mod }\n\n- **`send_mod`** - Send callback module which exports send_message/2. The\n  function SendMod:send_message(SendHandle, Binary) is invoked when the bytes\n  needs to be transmitted to the remote user.\n\n  Value type: [module()](`t:erlang:module/0`).\n\n  Defaults to `megaco_tcp`.\n\n  [](){: #ci_encoding_mod }\n\n- **`encoding_mod`** - Encoding callback module which exports encode_message/2\n  and decode_message/2. The function EncodingMod:encode_message(EncodingConfig,\n  MegacoMessage) is invoked whenever a 'MegacoMessage' record needs to be\n  translated into an Erlang binary. The function\n  EncodingMod:decode_message(EncodingConfig, Binary) is invoked whenever an\n  Erlang binary needs to be translated into a 'MegacoMessage' record.\n\n  Value type: [module()](`t:erlang:module/0`).\n\n  Defaults to `megaco_pretty_text_encoder`.\n\n  [](){: #ci_encoding_config }\n\n- **`encoding_config`** - Encoding module config.\n\n  Value type: [loist()](`t:erlang:list/0`).\n\n  Defaults to `[]`.\n\n  [](){: #ci_protocol_version }\n\n- **`protocol_version`** - Actual protocol version.\n\n  Value type: `t:protocol_version/0`\n\n  Defaults to `1`.\n\n  [](){: #ci_strict_version }\n\n- **`strict_version`** - Strict version control, i.e. when a message is\n  received, verify that the version is that which was negotiated.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `true`.\n\n  [](){: #ci_reply_data }\n\n- **`reply_data`** - Default reply data.\n\n  Value type: [term()](`t:erlang:term/0`)\n\n  Defaults to `undefined`.\n\n  [](){: #ci_threaded }\n\n- **`threaded`** - If a received message contains several transaction requests,\n  this option indicates whether the requests should be handled sequentially in\n  the same process (`false`), or if each request should be handled by its own\n  process (`true` i.e. a separate process is spawned for each request).\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_resend_indication }\n\n- **`resend_indication`** - This option indicates weather the transport module\n  should be told if a message send is a resend or not.\n\n  If _false_, megaco messages are sent using the\n  [send_message/2](`c:megaco_transport:send_message/2`) function.\n\n  If _true_, megaco message _re-sends_ are made using the\n  [resend_message](`c:megaco_transport:resend_message/2`) function. The initial\n  message send is still done using the\n  [send_message](`c:megaco_transport:send_message/2`) function.\n\n  The special value _flag_ instead indicates that the function\n  [send_message/3](`c:megaco_transport:send_message/3`) shall be used.\n\n  Value type: `flag` | [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_segment_reply_ind }\n\n- **`segment_reply_ind`** - This option specifies if the user shall be notified\n  of received segment replies or not.\n\n  See [handle_segment_reply](`m:megaco_user#segment_reply`) callback function\n  for more information.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ci_segment_recv_timer }\n\n- **`segment_recv_timer`** - This timer is started when the segment indicated by\n  the `segmentation complete token` (e.g. the last of the segment which makes up\n  the reply) is received, but all segments has not yet been received.\n\n  When the timer finally expires, a \"megaco segments not received\" (459) error\n  message is sent to the other side and the user is notified with a\n  `segment timeout` `UserReply` in either the\n  [handle_trans_reply](`m:megaco_user#trans_reply`) callback function or the\n  return value of the [call](`m:megaco#call`) function.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `10000` (= 10 seconds).\n\n  [](){: #ci_segment_send }\n\n- **`segment_send`** - Shall outgoing messages be segmented or not.\n\n  Value type: `none` | [pos_integer()](`t:erlang:pos_integer/0`) | `infinity`\n\n  - **`none`** - Do not segment outgoing reply messages. This is useful when\n    either it is known that messages are never to large or that the transport\n    protocol can handle such things on its own (e.g. TCP or SCTP).\n\n  - **`t:pos_integer/0`** - Outgoing reply messages will be segmented as needed\n    (see `max_pdu_size` below). This value, K, indicate the outstanding window,\n    i.e. how many segments can be outstanding (not acknowledged) at any given\n    time.\n\n  - **`infinity`** - Outgoing reply messages will be segmented as needed (see\n    `max_pdu_size` below). Segment messages are sent all at once (i.e. no\n    acknowledgement awaited before sending the next segment).\n\n  Defaults to `none`.\n\n  [](){: #ci_max_pdu_size }\n\n- **`max_pdu_size`** - Max message size. If the encoded message (PDU) exceeds\n  this size, the message should be segmented, and then encoded.\n\n  Value type: `infinity` | [pos_integer()](`t:erlang:pos_integer/0`)\n\n  Defaults to `infinity`.","ref":"megaco.html#t:conn_info_item/0"},{"type":"type","title":"megaco.counter/0","doc":"","ref":"megaco.html#t:counter/0"},{"type":"type","title":"megaco.counter_value/0","doc":"","ref":"megaco.html#t:counter_value/0"},{"type":"type","title":"megaco.digit_map_event/0","doc":"","ref":"megaco.html#t:digit_map_event/0"},{"type":"type","title":"megaco.digit_map_kind/0","doc":"","ref":"megaco.html#t:digit_map_kind/0"},{"type":"type","title":"megaco.digit_map_letter/0","doc":"","ref":"megaco.html#t:digit_map_letter/0"},{"type":"type","title":"megaco.digit_map_value/0","doc":"","ref":"megaco.html#t:digit_map_value/0"},{"type":"type","title":"megaco.error_desc/0","doc":"","ref":"megaco.html#t:error_desc/0"},{"type":"type","title":"megaco.global_counter/0","doc":"","ref":"megaco.html#t:global_counter/0"},{"type":"type","title":"megaco.megaco_message/0","doc":"","ref":"megaco.html#t:megaco_message/0"},{"type":"type","title":"megaco.megaco_timer/0","doc":"","ref":"megaco.html#t:megaco_timer/0"},{"type":"type","title":"megaco.mid/0","doc":"The Megaco Identifier.","ref":"megaco.html#t:mid/0"},{"type":"type","title":"megaco.property_group/0","doc":"","ref":"megaco.html#t:property_group/0"},{"type":"type","title":"megaco.property_groups/0","doc":"","ref":"megaco.html#t:property_groups/0"},{"type":"type","title":"megaco.property_parm/0","doc":"","ref":"megaco.html#t:property_parm/0"},{"type":"type","title":"megaco.protocol_version/0","doc":"","ref":"megaco.html#t:protocol_version/0"},{"type":"type","title":"megaco.receive_handle/0","doc":"","ref":"megaco.html#t:receive_handle/0"},{"type":"type","title":"megaco.sdp/0","doc":"","ref":"megaco.html#t:sdp/0"},{"type":"type","title":"megaco.sdp_property_group/0","doc":"","ref":"megaco.html#t:sdp_property_group/0"},{"type":"type","title":"megaco.sdp_property_groups/0","doc":"","ref":"megaco.html#t:sdp_property_groups/0"},{"type":"type","title":"megaco.sdp_property_parm/0","doc":"","ref":"megaco.html#t:sdp_property_parm/0"},{"type":"type","title":"megaco.segment_no/0","doc":"","ref":"megaco.html#t:segment_no/0"},{"type":"type","title":"megaco.send_handle/0","doc":"Opaque send handle whose contents is internal for the send module. May be any\nterm.","ref":"megaco.html#t:send_handle/0"},{"type":"type","title":"megaco.system_info_item/0","doc":"[](){: #si_text_config }\n\n- **`text_config`** - The text encoding config.\n\n  Value type: [term()](`t:erlang:term/0`)\n\n  [](){: #si_connections }\n\n- **`connections`** - Lists all active connections. Returns a list of\n  megaco_conn_handle records.\n\n  Value type: [`t:conn_handle/0`]\n\n  [](){: #si_users }\n\n- **`users`** - Lists all active users.\n\n  Value type: [`t:mid/0`]\n\n  [](){: #si_active_requests }\n\n- **`n_active_requests`** - Returns number of requests that has originated from\n  this Erlang node and still are active (and therefore consumes system\n  resources).\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  [](){: #si_active_replies }\n\n- **`n_active_replies`** - Returns the number of replies that has originated\n  from this Erlang node and still are active (and therefore consumes system\n  resources).\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  [](){: #si_active_connections }\n\n- **`n_active_connections`** - Returns the number of active connections.\n\n  Value type: [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  [](){: #si_reply_counters }\n\n- **`reply_counters`** - Returns a list of the reply counters.\n\n  Value type: [\\{`t:conn_handle/0`, `t:transaction_id/0`,\n  [non_neg_integer()](`t:erlang:non_neg_integer/0`)\\}]\n\n  [](){: #si_pending_counters }\n\n- **`pending_counters`** - Returns a list of the receive and sent pending\n  counters.\n\n  Value type: [\\{recv | sent, [\\{`t:transaction_id/0`,\n  [non_neg_integer()](`t:erlang:non_neg_integer/0`)\\}]\\}]\n\n[](){: #start }","ref":"megaco.html#t:system_info_item/0"},{"type":"type","title":"megaco.trace_data/0","doc":"The trace data passed to the trace handler fun (in the second argument) and\nreturned by same. For instance this could be a file descriptor, that the trace\nhandler fun can use to print the event to a file.","ref":"megaco.html#t:trace_data/0"},{"type":"type","title":"megaco.trace_event/0","doc":"The trace event generated by dbg.","ref":"megaco.html#t:trace_event/0"},{"type":"type","title":"megaco.trace_handler/0","doc":"The trace handler fun is used to \"process\" each trace event (for instance print\nto file or to stdout after formating).","ref":"megaco.html#t:trace_handler/0"},{"type":"type","title":"megaco.trace_level/0","doc":"How much trace events should be produced. `min` (=`0`) means no trace events are\nproduced, which is the default.","ref":"megaco.html#t:trace_level/0"},{"type":"type","title":"megaco.transaction_id/0","doc":"","ref":"megaco.html#t:transaction_id/0"},{"type":"type","title":"megaco.transaction_reply/0","doc":"","ref":"megaco.html#t:transaction_reply/0"},{"type":"type","title":"megaco.user_info_item/0","doc":"- **`connections`** - Lists all active connections for this user. Returns a list\n  of megaco_conn_handle records.\n\n  Value type: [`t:conn_handle/0`]\n\n  [](){: #ui_receive_handle }\n\n- **`receive_handle`** - Construct a receive_handle from user config.\n\n  Value type: `t:receive_handle/0`\n\n  [](){: #ui_trans_id }\n\n- **`trans_id`** - Current transaction id.\n\n  Value type: `t:transaction_id/0` | `undefined_serial`\n\n  [](){: #ui_min_trans_id }\n\n- **`min_trans_id`** - First transaction id.\n\n  Value type: `t:transaction_id/0`\n\n  Defaults to `1`.\n\n  [](){: #ui_max_trans_id }\n\n- **`max_trans_id`** - Last transaction id.\n\n  Value type: `t:transaction_id/0` | `infinity`\n\n  Defaults to `infinity`.\n\n  [](){: #ui_request_timer }\n\n- **`request_timer`** - Wait for reply.\n\n  The timer is cancelled when a reply is received.\n\n  When a pending message is received, the timer is cancelled and the\n  `long_request_timer` is started instead (see below). No resends will be\n  performed from this point (since we now know that the other side has received\n  the request).\n\n  When the timer reaches an intermediate expire, the request is resent and the\n  timer is restarted.\n\n  When the timer reaches the final expire, either the function `megaco:call`\n  will return with `{error, timeout}` or the callback function\n  `handle_trans_reply` will be called with `UserReply = {error, timeout}` (if\n  `megaco:cast` was used).\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `#megaco_incr_timer{}`.\n\n  [](){: #ui_long_request_timer }\n\n- **`long_request_timer`** - Wait for reply after having received a pending\n  message.\n\n  When the timer reaches an intermediate expire, the timer is restarted.\n\n  When a pending message is received, and the `long_request_timer` is _not_ \"on\n  its final leg\", the timer will be restarted, and, if\n  `long_request_resend = true`, the request will be re-sent.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `60000` (= 60 seconds).\n\n  [](){: #ui_long_request_resend }\n\n- **`long_request_resend`** - This option indicates weather the request should\n  be resent until the reply is received, _even_ though a pending message has\n  been received.\n\n  Normally, after a pending message has been received, the request is not resent\n  (since a pending message is an indication that the request has been received).\n  But since the reply (to the request) can be lost, this behaviour has its\n  values.\n\n  It is of course pointless to set this value to _true_ unless the\n  `long_request_timer` (see above) is also set to an incremental timer\n  (`#megaco_incr_timer{}`).\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_reply_timer }\n\n- **`reply_timer`** - Wait for an ack.\n\n  When a request is received, some info related to the reply is store internally\n  (e.g. the binary of the reply). This info will live until either an ack is\n  received or this timer expires. For instance, if the same request is received\n  again (e.g. a request with the same transaction id), the (stored) reply will\n  be (re-) sent automatically by megaco.\n\n  If the timer is of type `#megaco_incr_timer{}`, then for each intermediate\n  timout, the reply will be resent (this is valid until the ack is received or\n  the timer expires).\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `30 seconds`.\n\n  [](){: #ui_request_keep_alive_timeout }\n\n- **`request_keep_alive_timeout`** - Specifies the timeout time for the\n  request-keep-alive timer.\n\n  This timer is started when the _first_ reply to an asynchronous request\n  (issued using the [megaco:cast/3](`m:megaco#cast`) function) arrives. As long\n  as this timer is running, replies will be delivered via the\n  [handle_trans_reply/4,5](`m:megaco_user#trans_reply`) callback function, with\n  their \"arrival number\" (see `UserReply` of the\n  [handle_trans_reply/4,5](`m:megaco_user#trans_reply`) callback function).\n\n  Replies arriving after the timer has expired, will be delivered using the\n  [handle_unexpected_trans/3,4](`m:megaco_user#unexpected_trans`) callback\n  function.\n\n  Value type: `plain` | [non_neg_integer()](`t:erlang:non_neg_integer/0`)\n\n  Defaults to `plain`.\n\n  [](){: #ui_call_proxy_gc_timeout }\n\n- **`call_proxy_gc_timeout`** - Timeout time for the call proxy.\n\n  When a request is sent using the [call/3](`m:megaco#call`) function, a proxy\n  process is started to handle all replies. When the reply has been received and\n  delivered to the user, the proxy process continue to exist for as long as this\n  option specifies. Any received messages, is passed on to the user via the\n  [handle_unexpected_trans](`m:megaco_user#handle_unexpected_trans`) callback\n  function.\n\n  The timeout time is in milliseconds. A value of 0 (zero) means that the proxy\n  process will exit directly after the reply has been delivered.\n\n  Value type: [pos_integer()](`t:erlang:pos_integer/0`)\n\n  Defaults to `5000` (= 5 seconds).\n\n  [](){: #ui_auto_ack }\n\n- **`auto_ack`** - Automatic send transaction ack when the transaction reply has\n  been received (see `trans_ack` below).\n\n  This is used for _three-way-handshake_.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_trans_ack }\n\n- **`trans_ack`** - Shall ack's be accumulated or not.\n\n  This property is only valid if `auto_ack` is true.\n\n  If `auto_ack` is true, then if `trans_ack` is `false`, ack's will be sent\n  immediately. If `trans_ack` is `true`, then ack's will instead be sent to the\n  transaction sender process for accumulation and later sending (see\n  `trans_ack_maxcount`, `trans_req_maxcount`, `trans_req_maxsize`,\n  `trans_ack_maxcount` and `trans_timer`).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_trans_ack_maxcount }\n\n- **`trans_ack_maxcount`** - Maximum number of accumulated ack's. At most this\n  many ack's will be accumulated by the transaction sender (if started and\n  configured to accumulate ack's).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [integer()](`t:erlang:integer/0`)\n\n  Defaults to `10`.\n\n  [](){: #ui_trans_req }\n\n- **`trans_req`** - Shall requests be accumulated or not.\n\n  If `trans_req` is `false`, then request(s) will be sent immediately (in its\n  own message).\n\n  If `trans_req` is true, then request(s) will instead be sent to the\n  transaction sender process for accumulation and later sending (see\n  `trans_ack_maxcount`, `trans_req_maxcount`, `trans_req_maxsize`,\n  `trans_ack_maxcount` and `trans_timer`).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_trans_req_maxcount }\n\n- **`trans_req_maxcount`** - Maximum number of accumulated requests. At most\n  this many requests will be accumulated by the transaction sender (if started\n  and configured to accumulate requests).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [integer()](`t:erlang:integer/0`)\n\n  Defaults to `10`.\n\n  [](){: #ui_trans_req_maxsize }\n\n- **`trans_req_maxsize`** - Maximum size of the accumulated requests. At most\n  this much requests will be accumulated by the transaction sender (if started\n  and configured to accumulate requests).\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [integer()](`t:erlang:integer/0`)\n\n  Defaults to `2048`.\n\n  [](){: #ui_trans_timer }\n\n- **`trans_timer`** - Transaction sender timeout time. Has two functions. First,\n  if the value is 0, then transactions will not be accumulated (e.g. the\n  transaction sender process will not be started). Second, if the value is\n  greater then 0 and `auto_ack` and `trans_ack` are both true or if `trans_req`\n  is true, then transaction sender will be started and transactions (which is\n  depending on the values of `auto_ack`, `trans_ack` and `trans_req`) will be\n  accumulated, for later sending.\n\n  See also [transaction sender](megaco_run.md#transaction_sender) for more info.\n\n  Value type: [integer()](`t:erlang:integer/0`)\n\n  Defaults to `0`.\n\n  [](){: #ui_pending_timer }\n\n- **`pending_timer`** - Automatically send pending if the timer expires before a\n  transaction reply has been sent. This timer is also called provisional\n  response timer.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `30000`.\n\n  [](){: #ui_sent_pending_limit }\n\n- **`sent_pending_limit`** - Sent pending limit (see the\n  MGOriginatedPendingLimit and the MGCOriginatedPendingLimit of the megaco root\n  package). This parameter specifies how many pending messages that can be sent\n  (for a given received transaction request). When the limit is exceeded, the\n  transaction is aborted (see\n  [handle_trans_request_abort](`m:megaco_user#request_abort`)) and an error\n  message is sent to the other side.\n\n  Note that this has no effect on the actual sending of pending transactions.\n  This is either implicit (e.g. when receiving a re-sent transaction request for\n  a request which is being processed) or controlled by the pending_timer, see\n  above.\n\n  Value type: `infinity` | [pos_integer()](`t:erlang:pos_integer/0`)\n\n  Defaults to `infinity`.\n\n  [](){: #ui_recv_pending_limit }\n\n- **`recv_pending_limit`** - Receive pending limit (see the\n  MGOriginatedPendingLimit and the MGCOriginatedPendingLimit of the megaco root\n  package). This parameter specifies how many pending messages that can be\n  received (for a sent transaction request). When the limit is exceeded, the\n  transaction is considered lost, and an error returned to the user (through the\n  call-back function _handle_trans_reply_).\n\n  Value type: `infinity` | [pos_integer()](`t:erlang:pos_integer/0`)\n\n  Defaults to `infinity`.\n\n  [](){: #ui_send_mod }\n\n- **`send_mod`** - Send callback module which exports send_message/2. The\n  function SendMod:send_message(SendHandle, Binary) is invoked when the bytes\n  needs to be transmitted to the remote user.\n\n  Value type: [module()](`t:erlang:module/0`)\n\n  Defaults to `megaco_tcp`.\n\n  [](){: #ui_encoding_mod }\n\n- **`encoding_mod`** - Encoding callback module which exports encode_message/2\n  and decode_message/2. The function EncodingMod:encode_message(EncodingConfig,\n  MegacoMessage) is invoked whenever a 'MegacoMessage' record needs to be\n  translated into an Erlang binary. The function\n  EncodingMod:decode_message(EncodingConfig, Binary) is invoked whenever an\n  Erlang binary needs to be translated into a 'MegacoMessage' record.\n\n  Value type: [module()](`t:erlang:module/0`)\n\n  Defaults to `megaco_pretty_text_encoder`.\n\n  [](){: #ui_encoding_config }\n\n- **`encoding_config`** - Encoding module config.\n\n  Value type: [list()](`t:erlang:list/0`)\n\n  Defaults to `[]`.\n\n  [](){: #ui_protocol_version }\n\n- **`protocol_version`** - Actual protocol version.\n\n  Value type: `t:protocol_version/0`\n\n  Defaults to `1`.\n\n  [](){: #ui_strict_version }\n\n- **`strict_version`** - Strict version control, i.e. when a message is\n  received, verify that the version is that which was negotiated.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `true`.\n\n  [](){: #ui_reply_data }\n\n- **`reply_data`** - Default reply data.\n\n  Value type: [term()](`t:erlang:term/0`)\n\n  Defaults to `undefined`.\n\n  [](){: #ui_user_mod }\n\n- **`user_mod`** - Name of the user callback module. See the the reference\n  manual for megaco_user for more info.\n\n  Value type: [module()](`t:erlang:module/0`)\n\n  Has no default value since its an mandatory config option.\n\n  [](){: #ui_user_args }\n\n- **`user_args`** - List of extra arguments to the user callback functions. See\n  the the reference manual for megaco_user for more info.\n\n  Value type: [list()](`t:erlang:list/0`)\n\n  [](){: #ui_threaded }\n\n- **`threaded`** - If a received message contains several transaction requests,\n  this option indicates whether the requests should be handled sequentially in\n  the same process (`false`), or if each request should be handled by its own\n  process (`true` i.e. a separate process is spawned for each request).\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_resend_indication }\n\n- **`resend_indication`** - This option indicates weather the transport module\n  should be told if a message send is a resend or not.\n\n  If _false_, megaco messages are sent using the\n  [send_message](`c:megaco_transport:send_message/2`) function.\n\n  If _true_, megaco message _re-sends_ are made using the\n  [resend_message](`c:megaco_transport:resend_message/2`) function. The initial\n  message send is still done using the\n  [send_message](`c:megaco_transport:send_message/2`) function.\n\n  The special value _flag_ instead indicates that the function\n  [send_message/3](`c:megaco_transport:send_message/3`) shall be used.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_segment_reply_ind }\n\n- **`segment_reply_ind`** - This option specifies if the user shall be notified\n  of received segment replies or not.\n\n  See [handle_segment_reply](`m:megaco_user#segment_reply`) callback function\n  for more information.\n\n  Value type: [boolean()](`t:erlang:boolean/0`)\n\n  Defaults to `false`.\n\n  [](){: #ui_segment_recv_timer }\n\n- **`segment_recv_timer`** - This timer is started when the segment indicated by\n  the `segmentation complete token` is received, but all segments has not yet\n  been received.\n\n  When the timer finally expires, a \"megaco segments not received\" (459) error\n  message is sent to the other side and the user is notified with a\n  `segment timeout` `UserReply` in either the\n  [handle_trans_reply](`m:megaco_user#trans_reply`) callback function or the\n  return value of the [call](`m:megaco#call`) function.\n\n  Value type: `t:megaco_timer/0`\n\n  Defaults to `10000`.\n\n  [](){: #ui_segment_send }\n\n- **`segment_send`** - Shall outgoing messages be segmented or not.\n\n  Value type: `none` | [pos_integer()](`t:erlang:pos_integer/0`) | `infinity`\n\n  - **`none`** - Do not segment outgoing reply messages. This is useful when\n    either it is known that messages are never to large or that the transport\n    protocol can handle such things on its own (e.g. TCP or SCTP).\n\n  - **`t:pos_integer/0`** - Outgoing reply messages will be segmented as needed\n    (see `max_pdu_size` below). This value, K, indicate the outstanding window,\n    i.e. how many segments can be outstanding (not acknowledged) at any given\n    time.\n\n  - **`infinity`** - Outgoing reply messages will be segmented as needed (see\n    `max_pdu_size` below). Segment messages are sent all at once (i.e. no\n    acknowledgement awaited before sending the next segment).\n\n  Defaults to `none`.\n\n  [](){: #ui_max_pdu_size }\n\n- **`max_pdu_size`** - Max message size. If the encoded message (PDU) exceeds\n  this size, the message should be segmented, and then encoded.\n\n  Value type: `infinity` | [pos_integer()](`t:erlang:pos_integer/0`)\n\n  Defaults to `infinity`.","ref":"megaco.html#t:user_info_item/0"},{"type":"type","title":"megaco.void/0","doc":"The type is used when a functions return is to be ignored.","ref":"megaco.html#t:void/0"},{"type":"module","title":"megaco_codec_meas","doc":"This module implements a simple megaco codec measurement tool.\n\nResults are written to file (excel compatible text files) and on stdout.\n\n_Note_ that this module is _not_ included in the runtime part of the\napplication.","ref":"megaco_codec_meas.html"},{"type":"function","title":"megaco_codec_meas.start/0","doc":"","ref":"megaco_codec_meas.html#start/0"},{"type":"function","title":"megaco_codec_meas.start/1","doc":"start(MessagePackage) -> void()\n\nThis function runs the measurement on all the _official_ codecs; pretty,\ncompact, ber, per and erlang.","ref":"megaco_codec_meas.html#start/1"},{"type":"module","title":"megaco_codec_mstone1","doc":"This module implements a simple megaco codec-based performance tool.\n\nThis module implements the _mstone1_ tool, a simple megaco codec-based\nperformance tool.\n\nThe results, the mstone value(s), are written to stdout.\n\n_Note_ that this module is _not_ included in the runtime part of the\napplication.","ref":"megaco_codec_mstone1.html"},{"type":"function","title":"megaco_codec_mstone1.start/0","doc":"","ref":"megaco_codec_mstone1.html#start/0"},{"type":"function","title":"megaco_codec_mstone1.start/1","doc":"","ref":"megaco_codec_mstone1.html#start/1"},{"type":"function","title":"megaco_codec_mstone1.start/2","doc":"start(MessagePackage, Factor) -> void()\n\nThis function starts the _mstone1_ performance test with all codec configs.\n`Factor` (defaults to `1`) processes are started for every supported codec\nconfig.\n\nEach process encodes and decodes their messages. The number of messages\nprocessed in total (for all processes) is the mstone value.","ref":"megaco_codec_mstone1.html#start/2"},{"type":"function","title":"megaco_codec_mstone1.start_flex/0","doc":"","ref":"megaco_codec_mstone1.html#start_flex/0"},{"type":"function","title":"megaco_codec_mstone1.start_flex/1","doc":"","ref":"megaco_codec_mstone1.html#start_flex/1"},{"type":"function","title":"megaco_codec_mstone1.start_flex/2","doc":"start_flex(MessagePackage, Factor) -> void()\n\nThis function starts the _mstone1_ performance test with only the flex codec\nconfigs (i.e. `pretty` and `compact` with `flex`). The same number of processes\nare started as when running the standard test (using the `start/0,1` function).\nEach process encodes and decodes their messages. The number of messages\nprocessed in total (for all processes) is the mstone value.","ref":"megaco_codec_mstone1.html#start_flex/2"},{"type":"function","title":"megaco_codec_mstone1.start_no_drv/0","doc":"","ref":"megaco_codec_mstone1.html#start_no_drv/0"},{"type":"function","title":"megaco_codec_mstone1.start_no_drv/1","doc":"","ref":"megaco_codec_mstone1.html#start_no_drv/1"},{"type":"function","title":"megaco_codec_mstone1.start_no_drv/2","doc":"start_no_drv(MessagePackage, Factor) -> void()\n\nThis function starts the _mstone1_ performance test with codec configs not using\nany drivers (i.e. `pretty` and `compact` without `flex`, `ber` and `per` without\n`driver` and `erlang` without `compressed`). The same number of processes are\nstarted as when running the standard test (using the `start/0,1` function). Each\nprocess encodes and decodes their messages. The number of messages processed in\ntotal (for all processes) is the mstone value.","ref":"megaco_codec_mstone1.html#start_no_drv/2"},{"type":"function","title":"megaco_codec_mstone1.start_only_drv/0","doc":"","ref":"megaco_codec_mstone1.html#start_only_drv/0"},{"type":"function","title":"megaco_codec_mstone1.start_only_drv/1","doc":"","ref":"megaco_codec_mstone1.html#start_only_drv/1"},{"type":"function","title":"megaco_codec_mstone1.start_only_drv/2","doc":"start_only_drv(MessagePackage, Factor) -> void()\n\nThis function starts the _mstone1_ performance test with only the driver using\ncodec configs (i.e. `pretty` and `compact` with `flex`, and `ber` and `per` with\n`driver` and `erlang` with `compressed`). The same number of processes are\nstarted as when running the standard test (using the `start/0,1` function). Each\nprocess encodes and decodes their messages. The number of messages processed in\ntotal (for all processes) is the mstone value.","ref":"megaco_codec_mstone1.html#start_only_drv/2"},{"type":"module","title":"megaco_codec_mstone2","doc":"This module implements a simple megaco codec-based performance tool.\n\nThis module implements the _mstone2_ tool, a simple megaco codec-based\nperformance tool.\n\nThe results, the mstone value(s), are written to stdout.\n\n_Note_ that this module is _not_ included in the runtime part of the\napplication.","ref":"megaco_codec_mstone2.html"},{"type":"function","title":"megaco_codec_mstone2.start/0","doc":"","ref":"megaco_codec_mstone2.html#start/0"},{"type":"function","title":"megaco_codec_mstone2.start/1","doc":"start(MessagePackage) -> void()\n\nThis function starts the _mstone2_ performance test with all codec configs.\nProcesses are created dynamically. Each process make _one_ run through their\nmessages (decoding and encoding messages) and then exits. When one process\nexits, a new is created with the same codec config and set of messages.\n\nThe number of messages processed in total (for all processes) is the mstone\nvalue.","ref":"megaco_codec_mstone2.html#start/1"},{"type":"module","title":"megaco_codec_transform","doc":"Megaco message transformation utility.\n\nThis module implements a simple megaco message transformation utility.\n\n_Note_ that this module is _not_ included in the runtime part of the\napplication.\n\n[](){: #export_messages }","ref":"megaco_codec_transform.html"},{"type":"function","title":"megaco_codec_transform.export_messages/0","doc":"","ref":"megaco_codec_transform.html#export_messages/0"},{"type":"function","title":"megaco_codec_transform.export_messages/1","doc":"export_messages(MessagePackage) -> void()\n\nExport the messages in the `MessagePackage` (default is `time_test`).\n\nThe output produced by this function is a directory structure with the following\nstructure:\n\n```text\n /pretty/ \n                  compact/ \n                  per/ \n                  ber/ \n                  erlang/ \n```","ref":"megaco_codec_transform.html#export_messages/1"},{"type":"module","title":"megaco_digit_map","doc":"Digit Map utility module.\n\nThis is a Digit Map utility module (types).","ref":"megaco_digit_map.html"},{"type":"module","title":"Version note - megaco_digit_map","doc":"This module has existed in the megaco app for long time,\nbut as of 27.0, its also documented.","ref":"megaco_digit_map.html#module-version-note"},{"type":"type","title":"megaco_digit_map.cancel/0","doc":"`$z | $Z | cancel`","ref":"megaco_digit_map.html#t:cancel/0"},{"type":"type","title":"megaco_digit_map.event/0","doc":"","ref":"megaco_digit_map.html#t:event/0"},{"type":"type","title":"megaco_digit_map.kind/0","doc":"","ref":"megaco_digit_map.html#t:kind/0"},{"type":"type","title":"megaco_digit_map.letter/0","doc":"`$0..$9 | $a..$k | $A..$K`","ref":"megaco_digit_map.html#t:letter/0"},{"type":"type","title":"megaco_digit_map.one_second/0","doc":"`$s | $S`","ref":"megaco_digit_map.html#t:one_second/0"},{"type":"type","title":"megaco_digit_map.pause/0","doc":"","ref":"megaco_digit_map.html#t:pause/0"},{"type":"type","title":"megaco_digit_map.ten_seconds/0","doc":"`$l | $L`","ref":"megaco_digit_map.html#t:ten_seconds/0"},{"type":"type","title":"megaco_digit_map.value/0","doc":"","ref":"megaco_digit_map.html#t:value/0"},{"type":"behaviour","title":"megaco_edist_compress","doc":"Megaco erlang dist compress behaviour.\n\nThe following functions should be exported from a `megaco_edist_compress`\ncallback module:","ref":"megaco_edist_compress.html"},{"type":"callback","title":"megaco_edist_compress.decode/2","doc":"Decompress a megaco component.","ref":"megaco_edist_compress.html#c:decode/2"},{"type":"callback","title":"megaco_edist_compress.encode/2","doc":"Compress a megaco component. The erlang dist encoder makes no assumption on the\nhow or even if the component is compressed.","ref":"megaco_edist_compress.html#c:encode/2"},{"type":"behaviour","title":"megaco_encoder","doc":"Megaco encoder behaviour.\n\nThe following functions should be exported from a `megaco_encoder` callback\nmodule:","ref":"megaco_encoder.html"},{"type":"behaviour","title":"DATA TYPES - megaco_encoder","doc":"> #### Note {: .info }\n>\n> Note that the actual definition of (some of) these records depend on the\n> megaco protocol version used. For instance, the `'TransactionReply'` record\n> has two more fields in version 3, so a simple erlang type definition cannot be\n> made here.\n\n```text\nprotocol_version() = integer()\nsegment_no()       = integer()\nmegaco_message() = #'MegacoMessage{}'\ntransaction() = {transactionRequest,     transaction_request()}      |\n                {transactionPending,     transaction_reply()}        |\n                {transactionReply,       transaction_pending()}      |\n                {transactionResponseAck, transaction_response_ack()} |\n                {segmentReply,           segment_reply()}\ntransaction_request() = #'TransactionRequest'{}\ntransaction_pending() = #'TransactionPending'{}\ntransaction_reply() = #'TransactionReply'{}\ntransaction_response_ack() = [transaction_ack()]\ntransaction_ack() = #'TransactionAck'{}\nsegment_reply() = #'SegmentReply'{}\naction_request() = #'ActionRequest'{}\naction_reply() = #'ActionReply'{}\ncommand_request() = #'CommandRequest'{}\nerror_desc()   = #'ErrorDescriptor'{}\n```\n\n[](){: #encode_message }","ref":"megaco_encoder.html#module-data-types"},{"type":"callback","title":"megaco_encoder.decode_message/3","doc":"Decode a megaco message.\n\nNote that if the Version argument is `dynamic`, the decoder should try to figure\nout the actual version from the message itself and then use the proper decoder,\ne.g. version 1.  \nIf on the other hand the Version argument is an integer, it means that this is\nthe expected version of the message and the decoder for that version should be\nused.\n\n[](){: #decode_mini_message }","ref":"megaco_encoder.html#c:decode_message/3"},{"type":"callback","title":"megaco_encoder.decode_mini_message/3","doc":"Perform a minimal decode of a megaco message.\n\nThe purpose of this function is to do a minimal decode of Megaco message. A\nsuccessfull result is a `'MegacoMessage'` in which only version and mid has been\ninitiated. This function is used by the megaco_messenger module when the\n[`decode_message/3`](`c:decode_message/3`) function fails to figure out the mid\n(the actual sender) of the message.\n\nNote again that a successfull decode only returns a partially initiated message.\n\n[](){: #encode_transaction }","ref":"megaco_encoder.html#c:decode_mini_message/3"},{"type":"callback","title":"megaco_encoder.encode_action_reply/3","doc":"Encode a megaco action reply. If this, for whatever reason, is not supported,\nthe function should return the error reason `not_implemented`.\n\nThis function is used when segmentation has been configured. So, for this to\nwork, this function _must_ be fully supported\\!","ref":"megaco_encoder.html#c:encode_action_reply/3"},{"type":"callback","title":"megaco_encoder.encode_action_requests/3","doc":"Encode megaco action requests. This function is called when the user calls the\nfunction [encode_actions/3](`m:megaco#encode_actions`). If that function is\nnever used or if the codec cannot support this (the encoding of individual\nactions), then return with error reason `not_implemented`.\n\n[](){: #encode_action_reply }","ref":"megaco_encoder.html#c:encode_action_requests/3"},{"type":"callback","title":"megaco_encoder.encode_message/3","doc":"Encode a megaco message.\n\n[](){: #decode_message }","ref":"megaco_encoder.html#c:encode_message/3"},{"type":"callback","title":"megaco_encoder.encode_transaction/3","doc":"Encode a megaco transaction. If this, for whatever reason, is not supported, the\nfunction should return the error reason `not_implemented`.\n\nThis functionality is used both when the transaction sender is used and for\nsegmentation. So, for either of those to work, this function _must_ be fully\nsupported\\!\n\n[](){: #encode_action_requests }","ref":"megaco_encoder.html#c:encode_transaction/3"},{"type":"type","title":"megaco_encoder.action_reply/0","doc":"","ref":"megaco_encoder.html#t:action_reply/0"},{"type":"type","title":"megaco_encoder.action_request/0","doc":"","ref":"megaco_encoder.html#t:action_request/0"},{"type":"type","title":"megaco_encoder.alpha/0","doc":"Alpha Numeric characters: `A..Z | a..z`","ref":"megaco_encoder.html#t:alpha/0"},{"type":"type","title":"megaco_encoder.command_request/0","doc":"","ref":"megaco_encoder.html#t:command_request/0"},{"type":"type","title":"megaco_encoder.deviceName/0","doc":"","ref":"megaco_encoder.html#t:deviceName/0"},{"type":"type","title":"megaco_encoder.digit/0","doc":"Decimal digits: `0..9`","ref":"megaco_encoder.html#t:digit/0"},{"type":"type","title":"megaco_encoder.domainName/0","doc":"","ref":"megaco_encoder.html#t:domainName/0"},{"type":"type","title":"megaco_encoder.error_desc/0","doc":"","ref":"megaco_encoder.html#t:error_desc/0"},{"type":"type","title":"megaco_encoder.ip4Address/0","doc":"","ref":"megaco_encoder.html#t:ip4Address/0"},{"type":"type","title":"megaco_encoder.ip6Address/0","doc":"","ref":"megaco_encoder.html#t:ip6Address/0"},{"type":"type","title":"megaco_encoder.megaco_message/0","doc":"","ref":"megaco_encoder.html#t:megaco_message/0"},{"type":"type","title":"megaco_encoder.mtpAddress/0","doc":"There is no way to properly express this type in the Erlang type system, so this\nis the best we can do.\n\nA proper definition would be: `-type mtpAddress() :: octet_string(2..4).`","ref":"megaco_encoder.html#t:mtpAddress/0"},{"type":"type","title":"megaco_encoder.octet/0","doc":"","ref":"megaco_encoder.html#t:octet/0"},{"type":"type","title":"megaco_encoder.octet_string/0","doc":"","ref":"megaco_encoder.html#t:octet_string/0"},{"type":"type","title":"megaco_encoder.pathName/0","doc":"There is no way to properly express this type in the Erlang type system, so this\nis the best we can do. The minimum length is 1 and the maximum length is 64.\n\nHere is the ABNF (copied from the megaco standard) to fill in the blanks:\n\n`# Total length of pathNAME must not exceed 64 chars.`\n\n`pathNAME = [\"*\"] NAME *(\"/\" / \"*\"/ ALPHA / DIGIT /\"_\" / \"$\" ) [\"@\" pathDomainName ]`\n\n`# ABNF allows two or more consecutive \".\" although it is meaningless in a path domain name.`\n\n`pathDomainName = (ALPHA / DIGIT / \"*\" ) *63(ALPHA / DIGIT / \"-\" / \"*\" / \".\")`\n\n`NAME = ALPHA *63(ALPHA / DIGIT / \"_\" )`","ref":"megaco_encoder.html#t:pathName/0"},{"type":"type","title":"megaco_encoder.protocol_version/0","doc":"","ref":"megaco_encoder.html#t:protocol_version/0"},{"type":"type","title":"megaco_encoder.segment_no/0","doc":"","ref":"megaco_encoder.html#t:segment_no/0"},{"type":"type","title":"megaco_encoder.segment_reply/0","doc":"","ref":"megaco_encoder.html#t:segment_reply/0"},{"type":"type","title":"megaco_encoder.transaction/0","doc":"","ref":"megaco_encoder.html#t:transaction/0"},{"type":"type","title":"megaco_encoder.transaction_ack/0","doc":"","ref":"megaco_encoder.html#t:transaction_ack/0"},{"type":"type","title":"megaco_encoder.transaction_pending/0","doc":"","ref":"megaco_encoder.html#t:transaction_pending/0"},{"type":"type","title":"megaco_encoder.transaction_reply/0","doc":"The problem with TransactionReply is that its definition depend on which version\nof the protocol we are using. As of version 3, it has two more fields.","ref":"megaco_encoder.html#t:transaction_reply/0"},{"type":"type","title":"megaco_encoder.transaction_request/0","doc":"","ref":"megaco_encoder.html#t:transaction_request/0"},{"type":"type","title":"megaco_encoder.transaction_response_ack/0","doc":"","ref":"megaco_encoder.html#t:transaction_response_ack/0"},{"type":"module","title":"megaco_flex_scanner","doc":"Interface module to the flex scanner linked in driver.\n\nThis module contains the public interface to the flex scanner linked in driver.\nThe flex scanner performs the scanning phase of text message decoding.\n\nThe flex scanner is written using a tool called _flex_. In order to be able to\ncompile the flex scanner driver, this tool has to be available.\n\nBy default the flex scanner reports line-number of an error. But it can be built\nwithout line-number reporting. Instead token number is used. This will speed up\nthe scanning some 5-10%. Use `--disable-megaco-flex-scanner-lineno` when\nconfiguring the application.\n\nThe scanner will, by default, be built as a reentrant scanner _if_ the flex\nutility supports this (it depends on the version of flex). It is possible to\nexplicitly disable this even when flex support this. Use\n`--disable-megaco-reentrant-flex-scanner` when configuring the application.","ref":"megaco_flex_scanner.html"},{"type":"function","title":"megaco_flex_scanner.is_reentrant_enabled/0","doc":"is_reentrant_enabled() -> Boolean\n\nIs the flex scanner reentrant or not.\n\n[](){: #is_scanner_port }","ref":"megaco_flex_scanner.html#is_reentrant_enabled/0"},{"type":"function","title":"megaco_flex_scanner.is_scanner_port/2","doc":"Checks if a port is a flex scanner port or not (useful when if a port exits).\n\n[](){: #scan }","ref":"megaco_flex_scanner.html#is_scanner_port/2"},{"type":"function","title":"megaco_flex_scanner.scan/2","doc":"Scans a megaco message and generates a token list to be passed on the parser.","ref":"megaco_flex_scanner.html#scan/2"},{"type":"function","title":"megaco_flex_scanner.start/0","doc":"This function is used to start the flex scanner. It locates the library and\nloads the linked in driver.\n\nOn a single core system or if it's a non-reentrant scanner, a single port is\ncreated. On a multi-core system with a reentrant scanner, several ports will be\ncreated (one for each scheduler).\n\nNote that the process that calls this function _must_ be permanent. If it dies,\nthe port(s) will exit and the driver unload.\n\n[](){: #stop }","ref":"megaco_flex_scanner.html#start/0"},{"type":"function","title":"megaco_flex_scanner.stop/1","doc":"This function is used to stop the flex scanner. It also unloads the driver.\n\n[](){: #is_reentrant_enabled }","ref":"megaco_flex_scanner.html#stop/1"},{"type":"type","title":"megaco_flex_scanner.megaco_ports/0","doc":"Return value of a successful (flex) scanner start.\n\n[](){: #start }","ref":"megaco_flex_scanner.html#t:megaco_ports/0"},{"type":"module","title":"megaco_sdp","doc":"SDP utility module.\n\nThis module contains various things related to SDP.","ref":"megaco_sdp.html"},{"type":"module","title":"Version note - megaco_sdp","doc":"This module has existed in the megaco app for long time,\nbut as of 27.0 its also documented.","ref":"megaco_sdp.html#module-version-note"},{"type":"type","title":"megaco_sdp.property_group/0","doc":"","ref":"megaco_sdp.html#t:property_group/0"},{"type":"type","title":"megaco_sdp.property_groups/0","doc":"","ref":"megaco_sdp.html#t:property_groups/0"},{"type":"type","title":"megaco_sdp.property_parm/0","doc":"","ref":"megaco_sdp.html#t:property_parm/0"},{"type":"type","title":"megaco_sdp.sdp/0","doc":"","ref":"megaco_sdp.html#t:sdp/0"},{"type":"type","title":"megaco_sdp.sdp_a/0","doc":"Session attribute.","ref":"megaco_sdp.html#t:sdp_a/0"},{"type":"type","title":"megaco_sdp.sdp_a_fmtp/0","doc":"","ref":"megaco_sdp.html#t:sdp_a_fmtp/0"},{"type":"type","title":"megaco_sdp.sdp_a_ptime/0","doc":"","ref":"megaco_sdp.html#t:sdp_a_ptime/0"},{"type":"type","title":"megaco_sdp.sdp_a_quality/0","doc":"","ref":"megaco_sdp.html#t:sdp_a_quality/0"},{"type":"type","title":"megaco_sdp.sdp_a_rtpmap/0","doc":"","ref":"megaco_sdp.html#t:sdp_a_rtpmap/0"},{"type":"type","title":"megaco_sdp.sdp_b/0","doc":"Bandwidth information.","ref":"megaco_sdp.html#t:sdp_b/0"},{"type":"type","title":"megaco_sdp.sdp_c/0","doc":"Connection information.","ref":"megaco_sdp.html#t:sdp_c/0"},{"type":"type","title":"megaco_sdp.sdp_e/0","doc":"Email address.","ref":"megaco_sdp.html#t:sdp_e/0"},{"type":"type","title":"megaco_sdp.sdp_i/0","doc":"Session information.","ref":"megaco_sdp.html#t:sdp_i/0"},{"type":"type","title":"megaco_sdp.sdp_k/0","doc":"Encryption key.","ref":"megaco_sdp.html#t:sdp_k/0"},{"type":"type","title":"megaco_sdp.sdp_m/0","doc":"Media name and transport address.","ref":"megaco_sdp.html#t:sdp_m/0"},{"type":"type","title":"megaco_sdp.sdp_o/0","doc":"Owner/creator and session identifier.","ref":"megaco_sdp.html#t:sdp_o/0"},{"type":"type","title":"megaco_sdp.sdp_p/0","doc":"Phone number.","ref":"megaco_sdp.html#t:sdp_p/0"},{"type":"type","title":"megaco_sdp.sdp_property_group/0","doc":"","ref":"megaco_sdp.html#t:sdp_property_group/0"},{"type":"type","title":"megaco_sdp.sdp_property_groups/0","doc":"","ref":"megaco_sdp.html#t:sdp_property_groups/0"},{"type":"type","title":"megaco_sdp.sdp_property_parm/0","doc":"","ref":"megaco_sdp.html#t:sdp_property_parm/0"},{"type":"type","title":"megaco_sdp.sdp_r/0","doc":"Repeat times.","ref":"megaco_sdp.html#t:sdp_r/0"},{"type":"type","title":"megaco_sdp.sdp_s/0","doc":"Session name.","ref":"megaco_sdp.html#t:sdp_s/0"},{"type":"type","title":"megaco_sdp.sdp_t/0","doc":"","ref":"megaco_sdp.html#t:sdp_t/0"},{"type":"type","title":"megaco_sdp.sdp_u/0","doc":"URI of description.","ref":"megaco_sdp.html#t:sdp_u/0"},{"type":"type","title":"megaco_sdp.sdp_v/0","doc":"Protocol version.","ref":"megaco_sdp.html#t:sdp_v/0"},{"type":"type","title":"megaco_sdp.sdp_z/0","doc":"Time zone adjustment.","ref":"megaco_sdp.html#t:sdp_z/0"},{"type":"module","title":"megaco_tcp","doc":"Interface module to TPKT transport protocol for Megaco/H.248.\n\nThis module contains the public interface to the TPKT (TCP/IP) version transport\nprotocol for Megaco/H.248.","ref":"megaco_tcp.html"},{"type":"function","title":"megaco_tcp.block/1","doc":"Stop receiving incoming messages on the socket.","ref":"megaco_tcp.html#block/1"},{"type":"function","title":"megaco_tcp.close/1","doc":"This function is used for closing an active TPKT connection.","ref":"megaco_tcp.html#close/1"},{"type":"function","title":"megaco_tcp.connect/2","doc":"This function is used to open a TPKT connection.\n\n- **`module`** - This option makes it possible for the user to provide their own\n  callback module. The `receive_message/4` or `process_received_message/4`\n  functions of this module is called when a new message is received. Which one\n  is called depends on the size of the message;\n\n  - **`small`** - receive_message\n\n  - **`large`** - process_received_message\n\n  Default value is _megaco_.\n\n- **`inet_backend`** - Choose the inet-backend.\n\n  This option make it possible to use a different inet-backend ('default',\n  'inet' or 'socket').\n\n  Default is `default` (system default).","ref":"megaco_tcp.html#connect/2"},{"type":"function","title":"megaco_tcp.get_stats/0","doc":"Get all counter values for all known connections.","ref":"megaco_tcp.html#get_stats/0"},{"type":"function","title":"megaco_tcp.get_stats/1","doc":"Get all counter values for a given (connection) handle.","ref":"megaco_tcp.html#get_stats/1"},{"type":"function","title":"megaco_tcp.get_stats/2","doc":"Get the value of a specific counter.","ref":"megaco_tcp.html#get_stats/2"},{"type":"function","title":"megaco_tcp.listen/2","doc":"This function is used for starting new TPKT listening socket for TCP/IP. The\noption list contains the socket definitions.\n\n- **`inet_backend`** - Choose the inet-backend.\n\n  This option make it possible to use a different inet-backend ('default',\n  'inet' or 'socket').\n\n  Default is `default` (system default).","ref":"megaco_tcp.html#listen/2"},{"type":"function","title":"megaco_tcp.reset_stats/0","doc":"Reset all counters for all connections.","ref":"megaco_tcp.html#reset_stats/0"},{"type":"function","title":"megaco_tcp.reset_stats/1","doc":"Reset all counters for the given connection.","ref":"megaco_tcp.html#reset_stats/1"},{"type":"function","title":"megaco_tcp.send_message/2","doc":"Sends a message on a TPKT connection.","ref":"megaco_tcp.html#send_message/2"},{"type":"function","title":"megaco_tcp.socket/1","doc":"socket(Handle) -> Socket\n\nThis function is used to convert a socket `handle()` to a inet `socket()`.","ref":"megaco_tcp.html#socket/1"},{"type":"function","title":"megaco_tcp.start_transport/0","doc":"This function is used for starting the TCP/IP transport service. Use\nexit(TransportRef, Reason) to stop the transport service.","ref":"megaco_tcp.html#start_transport/0"},{"type":"function","title":"megaco_tcp.unblock/1","doc":"Starting to receive incoming messages from the socket again.","ref":"megaco_tcp.html#unblock/1"},{"type":"function","title":"megaco_tcp.upgrade_receive_handle/2","doc":"Upgrade the receive handle of the control process (e.g. after having changed\nprotocol version).","ref":"megaco_tcp.html#upgrade_receive_handle/2"},{"type":"type","title":"megaco_tcp.counter/0","doc":"Defines the different counters handled by this transport.","ref":"megaco_tcp.html#t:counter/0"},{"type":"opaque","title":"megaco_tcp.handle/0","doc":"An opaque data type representing a TPKT connection.","ref":"megaco_tcp.html#t:handle/0"},{"type":"behaviour","title":"megaco_transport","doc":"Megaco transport behaviour.\n\nThe following functions should be exported from a `megaco_transport` callback\nmodule:\n\n- [send_message/2](`m:megaco_transport#send_message`) [`mandatory`]\n- [send_message/3](`m:megaco_transport#send_message`) [`optional`]\n- [resend_message/2](`m:megaco_transport#resend_message`) [`optional`]\n-\n\n[](){: #send_message }","ref":"megaco_transport.html"},{"type":"callback","title":"megaco_transport.resend_message/2","doc":"Re-send a megaco message.\n\nNote that this function will only be called if the user has set the\n[resend_indication](`m:megaco#ui_resend_indication`) config option to\n`true`_and_ it is in fact a message resend. If not _both_ of these condition's\nare meet, `send_message` will be called.\n\nIf the function returns `{cancel, Reason}`, this means the transport module\ndecided not to send the message. This is _not_ an error. No error messages will\nbe issued and no error counters incremented. What actions this will result in\ndepends on what kind of message was sent.\n\nIn the case of requests, megaco will cancel the message in much the same way as\nif `megaco:cancel` had been called (after a successfull send). The information\nwill be propagated back to the user differently depending on how the request(s)\nwhere issued: For requests issued using [megaco:call](`m:megaco#call`), the info\nwill be delivered in the return value. For requests issued using `megaco:cast`\nthe info will be delivered via a call to the callback function\n[handle_trans_reply](`m:megaco_user#trans_reply`).\n\nIn the case of reply, megaco will cancel the reply and information of this will\nbe returned to the user via a call to the callback function\n[handle_trans_ack](`m:megaco_user#trans_ack`).","ref":"megaco_transport.html#c:resend_message/2"},{"type":"callback","title":"megaco_transport.send_message/2","doc":"","ref":"megaco_transport.html#c:send_message/2"},{"type":"callback","title":"megaco_transport.send_message/3","doc":"Send a megaco message.\n\nIf the function returns `{cancel, Reason}`, this means the transport module\ndecided not to send the message. This is _not_ an error. No error messages will\nbe issued and no error counters incremented. What actions this will result in\ndepends on what kind of message was sent.\n\nIn the case of requests, megaco will cancel the message in much the same way as\nif `megaco:cancel` had been called (after a successfull send). The information\nwill be propagated back to the user differently depending on how the request(s)\nwhere issued: For requests issued using [megaco:call](`m:megaco#call`), the info\nwill be delivered in the return value. For requests issued using `megaco:cast`\nthe info will be delivered via a call to the callback function\n[handle_trans_reply](`m:megaco_user#trans_reply`).\n\nIn the case of reply, megaco will cancel the reply and information of this will\nbe returned to the user via a call to the callback function\n[handle_trans_ack](`m:megaco_user#trans_ack`).\n\nThe function [`send_message/3`](`c:send_message/3`) will only be called if the\n[resend_indication](`m:megaco#ui_resend_indication`) config option has been set\nto the value `flag`. The third argument, `Resend` then indicates if the message\nsend is a resend or not.\n\n[](){: #resend_message }","ref":"megaco_transport.html#c:send_message/3"},{"type":"module","title":"megaco_udp","doc":"Interface module to UDP transport protocol for Megaco/H.248.\n\nThis module contains the public interface to the UDP/IP version\ntransport protocol for Megaco/H.248.","ref":"megaco_udp.html"},{"type":"function","title":"megaco_udp.block/1","doc":"Stop receiving incoming messages on the socket.","ref":"megaco_udp.html#block/1"},{"type":"function","title":"megaco_udp.close/1","doc":"This function is used for closing an active UDP socket.","ref":"megaco_udp.html#close/1"},{"type":"function","title":"megaco_udp.create_send_handle/3","doc":"Creates a send handle from a transport handle. The send handle is intended to be\nused by megaco_udp:send_message/2.","ref":"megaco_udp.html#create_send_handle/3"},{"type":"function","title":"megaco_udp.get_stats/0","doc":"Get all counter values for all known connections.","ref":"megaco_udp.html#get_stats/0"},{"type":"function","title":"megaco_udp.get_stats/1","doc":"Get all counter values for a given handle.","ref":"megaco_udp.html#get_stats/1"},{"type":"function","title":"megaco_udp.get_stats/2","doc":"Get the value of a specific counter.","ref":"megaco_udp.html#get_stats/2"},{"type":"function","title":"megaco_udp.open/2","doc":"This function is used to open an UDP/IP socket.\n\n- **`module`** - The option makes it possible for the user to provide their own\n  callback module. The functions `receive_message/4` or\n  `process_received_message/4` of this module is called when a new message is\n  received. Which one depends on the size of the message:\n\n  - **`small`** - receive_message\n\n  - **`large`** - process_received_message\n\n  Default value is _megaco_.\n\n- **`inet_backend`** - Choose the inet-backend.\n\n  This option make it possible to use a different inet-backend ('default',\n  'inet' or 'socket').\n\n  Default is `default` (system default).","ref":"megaco_udp.html#open/2"},{"type":"function","title":"megaco_udp.reset_stats/0","doc":"Reset all counters for all UDP handles.","ref":"megaco_udp.html#reset_stats/0"},{"type":"function","title":"megaco_udp.reset_stats/1","doc":"Reset all counters for the given UDP handle.","ref":"megaco_udp.html#reset_stats/1"},{"type":"function","title":"megaco_udp.send_message/2","doc":"Sends a message on a socket. The send handle is obtained by\nmegaco_udp:create_send_handle/3. Increments the NumOutMessages and NumOutOctets\ncounters if message successfully sent. In case of a failure to send, the\nNumErrors counter is _not_ incremented. This is done elsewhere in the megaco\napp.","ref":"megaco_udp.html#send_message/2"},{"type":"function","title":"megaco_udp.socket/1","doc":"This function is used to convert a socket `handle()` to a inet `socket()`.","ref":"megaco_udp.html#socket/1"},{"type":"function","title":"megaco_udp.start_transport/0","doc":"This function is used for starting the UDP/IP transport service. Use\nexit(TransportRef, Reason) to stop the transport service.","ref":"megaco_udp.html#start_transport/0"},{"type":"function","title":"megaco_udp.unblock/1","doc":"Starting to receive incoming messages from the socket again.","ref":"megaco_udp.html#unblock/1"},{"type":"function","title":"megaco_udp.upgrade_receive_handle/2","doc":"Update the receive handle of the control process (e.g. after having changed\nprotocol version).","ref":"megaco_udp.html#upgrade_receive_handle/2"},{"type":"type","title":"megaco_udp.counter/0","doc":"Defines the different counters handled by this transport.","ref":"megaco_udp.html#t:counter/0"},{"type":"opaque","title":"megaco_udp.handle/0","doc":"An opaque data type representing an UDP socket.","ref":"megaco_udp.html#t:handle/0"},{"type":"opaque","title":"megaco_udp.send_handle/0","doc":"An opaque data type representing an UDP socket, used when sending.","ref":"megaco_udp.html#t:send_handle/0"},{"type":"behaviour","title":"megaco_user","doc":"Callback module for users of the Megaco application\n\nThis module defines the callback behaviour of Megaco users. A megaco_user\ncompliant callback module must export the following functions:\n\n- [handle_connect/2,3](`m:megaco_user#connect`)\n- [handle_disconnect/3](`m:megaco_user#disconnect`)\n- [handle_syntax_error/3,4](`m:megaco_user#syntax_error`)\n- [handle_message_error/3,4](`m:megaco_user#message_error`)\n- [handle_trans_request/3,4](`m:megaco_user#trans_request`)\n- [handle_trans_long_request/3,4](`m:megaco_user#trans_long_request`)\n- [handle_trans_reply/4,5](`m:megaco_user#trans_reply`)\n- [handle_trans_ack/4,5](`m:megaco_user#trans_ack`)\n- [handle_unexpected_trans/3,4](`m:megaco_user#unexpected_trans`)\n- [handle_trans_request_abort/4,5](`m:megaco_user#request_abort`)\n- [handle_segment_reply/5,6](`m:megaco_user#segment_reply`)\n\nThe semantics of them and their exact signatures are explained below.\n\nThe `user_args` configuration parameter which may be used to extend the argument\nlist of the callback functions. For example, the handle_connect function takes\nby default two arguments:\n\n```text\n        handle_connect(Handle, Version)\n```\n\nbut if the `user_args` parameter is set to a longer list, such as\n`[SomePid,SomeTableRef]`, the callback function is expected to have these (in\nthis case two) extra arguments last in the argument list:\n\n```erlang\n        handle_connect(Handle, Version, SomePid, SomeTableRef)\n```\n\n[](){: #extra_argument }\n\n> #### Note {: .info }\n>\n> Must of the functions below has an optional `Extra` argument (e.g.\n> [handle_unexpected_trans/4](`m:megaco_user#unexpected_trans`)). The functions\n> which takes this argument will be called if and only if one of the functions\n> [receive_message/5](`m:megaco#receive_message`) or\n> [process_received_message/5](`m:megaco#process_received_message`) was called\n> with the `Extra` argument different than `ignore_extra`.","ref":"megaco_user.html"},{"type":"behaviour","title":"DATA TYPES - megaco_user","doc":"```erlang\naction_request() = #'ActionRequest'{}\naction_reply() = #'ActionReply'{}\nerror_desc() = #'ErrorDescriptor'{}\nsegment_no() = integer()\n```\n\n```erlang\nconn_handle() = #megaco_conn_handle{}\n```\n\nThe record initially returned by `megaco:connect/4,5`. It identifies a \"virtual\"\nconnection and may be reused after a reconnect (disconnect + connect).\n\n```text\nprotocol_version() = integer()\n```\n\nIs the actual protocol version. In most cases the protocol version is retrieved\nfrom the processed message, but there are exceptions:\n\n- When `handle_connect/2,3` is triggered by an explicit call to\n  `megaco:connect/4,5`.\n- [`handle_disconnect/3`](`c:handle_disconnect/3`)\n- [`handle_syntax_error/3`](`c:handle_syntax_error/3`)\n\nIn these cases, the ProtocolVersion default version is obtained from the static\nconnection configuration:\n\n- `megaco:conn_info(ConnHandle, protocol_version)`.\n\n[](){: #connect }","ref":"megaco_user.html#module-data-types"},{"type":"callback","title":"megaco_user.handle_connect/2","doc":"","ref":"megaco_user.html#c:handle_connect/2"},{"type":"callback","title":"megaco_user.handle_connect/3","doc":"Invoked when a new connection is established\n\nConnections may either be established by an explicit call to megaco:connect/4 or\nimplicitly at the first invocation of megaco:receive_message/3.\n\nNormally a Media Gateway (MG) connects explicitly while a Media Gateway\nController (MGC) connects implicitly.\n\nAt the Media Gateway Controller (MGC) side it is possible to reject a connection\nrequest (and send a message error reply to the gateway) by returning\n`{error, ErrorDescr}` or simply `error` which generates an error descriptor with\ncode 402 (unauthorized) and reason \"Connection refused by user\" (this is also\nthe case for all unknown results, such as exit signals or throw).\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_message_error/4`](`c:handle_message_error/4`).\n\n[`handle_connect/3`](`c:handle_connect/3`) (with `Extra`) can also be called as\na result of a call to the [megaco:connect/5](`m:megaco#connect`) function (if\nthat function is called with the `Extra` argument different than `ignore_extra`.\n\n[](){: #disconnect }","ref":"megaco_user.html#c:handle_connect/3"},{"type":"callback","title":"megaco_user.handle_disconnect/3","doc":"Invoked when a connection is teared down\n\nThe disconnect may either be made explicitly by a call to megaco:disconnect/2 or\nimplicitly when the control process of the connection dies.\n\n[](){: #syntax_error }","ref":"megaco_user.html#c:handle_disconnect/3"},{"type":"callback","title":"megaco_user.handle_message_error/3","doc":"","ref":"megaco_user.html#c:handle_message_error/3"},{"type":"callback","title":"megaco_user.handle_message_error/4","doc":"Invoked when a received message just contains an error instead of a list of\ntransactions.\n\nIncoming messages is delivered by megaco:receive_message/4 and successfully\ndecoded. Normally a message contains a list of transactions, but it may instead\ncontain an ErrorDescriptor on top level of the message.\n\nMessage errors are detected remotely on the other side of the protocol. And you\nprobably don't want to reply to it, but it may indicate that you have\noutstanding transactions that not will get any response (request -> reply; reply\n-> ack).\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_message_error/4`](`c:handle_message_error/4`).\n\n[](){: #trans_request }","ref":"megaco_user.html#c:handle_message_error/4"},{"type":"callback","title":"megaco_user.handle_segment_reply/5","doc":"","ref":"megaco_user.html#c:handle_segment_reply/5"},{"type":"callback","title":"megaco_user.handle_segment_reply/6","doc":"This function is called when a segment reply has been received if the\n[segment_reply_ind](`m:megaco#conn_info`) config option has been set to true.\n\nThis is in effect a progress report.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_segment_reply/6`](`c:handle_segment_reply/6`).","ref":"megaco_user.html#c:handle_segment_reply/6"},{"type":"callback","title":"megaco_user.handle_syntax_error/3","doc":"","ref":"megaco_user.html#c:handle_syntax_error/3"},{"type":"callback","title":"megaco_user.handle_syntax_error/4","doc":"Invoked when a received message had syntax errors\n\nIncoming messages is delivered by megaco:receive_message/4 and normally decoded\nsuccessfully. But if the decoding failed this function is called in order to\ndecide if the originator should get a reply message (reply) or if the reply\nsilently should be discarded (no_reply).\n\nSyntax errors are detected locally on this side of the protocol and may have\nmany causes, e.g. a malfunctioning transport layer, wrong encoder/decoder\nselected, bad configuration of the selected encoder/decoder etc.\n\nThe error descriptor defaults to `DefaultED`, but can be overridden with an\nalternate one by returning `{reply,ED}` or `{no_reply,ED}` instead of `reply`\nand `no_reply` respectively.\n\nAny other return values (including exit signals or throw) and the `DefaultED`\nwill be used.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_syntax_error/4`](`c:handle_syntax_error/4`).\n\n[](){: #message_error }","ref":"megaco_user.html#c:handle_syntax_error/4"},{"type":"callback","title":"megaco_user.handle_trans_ack/4","doc":"","ref":"megaco_user.html#c:handle_trans_ack/4"},{"type":"callback","title":"megaco_user.handle_trans_ack/5","doc":"Optionally invoked for a transaction acknowledgement\n\nIf this function gets invoked or not, is controlled by the reply from the\npreceding call to handle_trans_request/3. The handle_trans_request/3 function\nmay decide to return \\{handle_ack, ack_data()\\} or \\{handle_sloppy_ack,\nack_data()\\} meaning that you need an immediate acknowledgement of the reply and\nthat this function should be invoked to handle the acknowledgement.\n\nThe ack_data() argument to this function is the Erlang term returned by\nhandle_trans_request/3.\n\nIf the AckStatus is ok, it is indicating that this is a true acknowledgement of\nthe transaction reply.\n\nIf the AckStatus is \\{error, Reason\\}, it is an indication that the\nacknowledgement or even the reply (for which this is an acknowledgement) was not\ndelivered, but there is no point in waiting any longer for it to arrive. This\nhappens when:\n\n- **`reply_timer`** - The `reply_timer` eventually times out.\n\n- **reply send failure** - When megaco fails to send the reply (see\n  [handle_trans_reply](`m:megaco_user#trans_reply`)), for whatever reason.\n\n- **cancel** - The user has explicitly cancelled the wait (megaco:cancel/2).\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_trans_ack/5`](`c:handle_trans_ack/5`).\n\n[](){: #unexpected_trans } [](){: #handle_unexpected_trans }","ref":"megaco_user.html#c:handle_trans_ack/5"},{"type":"callback","title":"megaco_user.handle_trans_long_request/3","doc":"","ref":"megaco_user.html#c:handle_trans_long_request/3"},{"type":"callback","title":"megaco_user.handle_trans_long_request/4","doc":"Optionally invoked for a time consuming transaction request\n\nIf this function gets invoked or not is controlled by the reply from the\npreceding call to handle_trans_request/3. The handle_trans_request/3 function\nmay decide to process the action requests itself or to delegate the processing\nto this function.\n\nThe req_data() argument to this function is the Erlang term returned by\nhandle_trans_request/3.\n\nAny other return values (including exit signals or throw) will result in an\nerror descriptor with code 500 (internal gateway error) and the module name (of\nthe callback module) as reason.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_trans_long_request/4`](`c:handle_trans_long_request/4`).\n\n[](){: #trans_reply }","ref":"megaco_user.html#c:handle_trans_long_request/4"},{"type":"callback","title":"megaco_user.handle_trans_reply/4","doc":"","ref":"megaco_user.html#c:handle_trans_reply/4"},{"type":"callback","title":"megaco_user.handle_trans_reply/5","doc":"Optionally invoked for a transaction reply\n\nThe sender of a transaction request has the option of deciding, whether the\noriginating Erlang process should synchronously wait (`megaco:call/3`) for a\nreply or if the message should be sent asynchronously (`megaco:cast/3`) and the\nprocessing of the reply should be delegated this callback function.\n\nNote that if the reply is segmented (split into several smaller messages;\nsegments), then some extra info, segment number and an indication if all\nsegments of a reply has been received or not, is also included in the\n`UserReply`.\n\nThe `ReplyData` defaults to `megaco:lookup(ConnHandle, reply_data)`, but may be\nexplicitly overridden by a `megaco:cast/3` option in order to forward info about\nthe calling context of the originating process.\n\nAt `success()`, the `UserReply` either contains:\n\n- A list of 'ActionReply' records possibly containing error indications.\n- A tuple of size three containing: the segment number, the\n  `last segment indicator` and finally a list of 'ActionReply' records possibly\n  containing error indications. This is of course only possible if the reply was\n  segmented.\n\n`failure()` indicates an local or external error and can be one of the\nfollowing:\n\n- A `transaction_reason()`, indicates that the remote user has replied with an\n  explicit transactionError.\n- A `segment_reason()`, indicates that the remote user has replied with an\n  explicit transactionError for this segment. This is of course only possible if\n  the reply was segmented.\n- A `user_cancel_reason()`, indicates that the request has been canceled by the\n  user. `reason_for_user_cancel()` is the reason given in the call to the\n  [cancel](`m:megaco#cancel`) function.\n- A `send_reason()`, indicates that the transport module\n  [send_message](`c:megaco_transport:send_message/3`) function did not send the\n  message. The reason for this can be:\n\n  - `send_cancelled_reason()` \\- the message sending was deliberately cancelled.\n    `reason_for_send_cancel()` is the reason given in the `cancel` return from\n    the [send_message](`c:megaco_transport:send_message/3`) function.\n  - `send_failed_reason()` \\- an error occurred while attempting to send the\n    message.\n\n- An `other_reason()`, indicates some other error such as:\n\n  - `timeout` \\- the reply failed to arrive before the request timer expired.\n  - `{segment_timeout, missing_segments()}` \\- one or more segments was not\n    delivered before the expire of the segment timer.\n  - `exceeded_recv_pending_limit` \\- the pending limit was exceeded for this\n    request.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_trans_reply/5`](`c:handle_trans_reply/5`).\n\n[](){: #trans_ack }","ref":"megaco_user.html#c:handle_trans_reply/5"},{"type":"callback","title":"megaco_user.handle_trans_request/3","doc":"","ref":"megaco_user.html#c:handle_trans_request/3"},{"type":"callback","title":"megaco_user.handle_trans_request/4","doc":"Invoked for each transaction request\n\nIncoming messages is delivered by megaco:receive_message/4 and successfully\ndecoded. Normally a message contains a list of transactions and this function is\ninvoked for each TransactionRequest in the message.\n\nThis function takes a list of 'ActionRequest' records and has three main\noptions:\n\n- **`Return ignore_trans_request`** - Decide that these action requests shall be\n  ignored completely.\n\n- **`Return pending()`** - Decide that the processing of these action requests\n  will take a long time and that the originator should get an immediate\n  'TransactionPending' reply as interim response. The actual processing of these\n  action requests instead should be delegated to the the\n  handle_trans_long_request/3 callback function with the req_data() as one of\n  its arguments.\n\n- **`Return reply()`** - Process the action requests and either return an\n  error_descr() indicating some fatal error or a list of action replies\n  (wildcarded or not).\n\n  If for some reason megaco is unable to deliver the reply, the reason for this\n  will be passed to the user via a call to the callback function\n  [handle_trans_ack](`m:megaco_user#trans_ack`), unless\n  `ack_action() = discard_ack`.\n\n  The ack_action() is either:\n\n  - **`discard_ack`** - Meaning that you don't care if the reply is acknowledged\n    or not.\n\n  - **`{handle_ack, ack_data()} | {handle_ack, ack_data(), send_options()}`** -\n    Meaning that you want an immediate acknowledgement when the other part\n    receives this transaction reply. When the acknowledgement eventually is\n    received, the handle_trans_ack/4 callback function will be invoked with the\n    ack_data() as one of its arguments. ack_data() may be any Erlang term.\n\n  - **`{handle_pending_ack, ack_data()} | {handle_pending_ack, ack_data(), send_options()}`** -\n    This has the same effect as the above, _if and only if_ megaco has sent at\n    least one pending message for this request (during the processing of the\n    request). If no pending message has been sent, then immediate\n    acknowledgement will _not_ be requested.\n\n    Note that this only works as specified if the `sent_pending_limit` config\n    option has been set to an integer value.\n\n  - **`{handle_sloppy_ack, ack_data()}| {handle_sloppy_ack, ack_data(), send_options()}`** -\n    Meaning that you want an acknowledgement _sometime_. When the\n    acknowledgement eventually is received, the handle_trans_ack/4 callback\n    function will be invoked with the ack_data() as one of its arguments.\n    ack_data() may be any Erlang term.\n\nAny other return values (including exit signals or throw) will result in an\nerror descriptor with code 500 (internal gateway error) and the module name (of\nthe callback module) as reason.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_trans_request/4`](`c:handle_trans_request/4`).\n\n[](){: #trans_long_request }","ref":"megaco_user.html#c:handle_trans_request/4"},{"type":"callback","title":"megaco_user.handle_trans_request_abort/4","doc":"","ref":"megaco_user.html#c:handle_trans_request_abort/4"},{"type":"callback","title":"megaco_user.handle_trans_request_abort/5","doc":"Invoked when a transaction request has been aborted\n\nThis function is invoked if the originating pending limit has been exceeded.\nThis usually means that a request has taken abnormally long time to complete.\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_trans_request_abort/5`](`c:handle_trans_request_abort/5`).\n\n[](){: #segment_reply }","ref":"megaco_user.html#c:handle_trans_request_abort/5"},{"type":"callback","title":"megaco_user.handle_unexpected_trans/3","doc":"","ref":"megaco_user.html#c:handle_unexpected_trans/3"},{"type":"callback","title":"megaco_user.handle_unexpected_trans/4","doc":"Invoked when a unexpected message is received\n\nIf a reply to a request is not received in time, the megaco stack removes all\ninfo about the request from its tables. If a reply should arrive after this has\nbeen done the app has no way of knowing where to send this message. The message\nis delivered to the \"user\" by calling this function on the local node (the node\nwhich has the link).\n\nSee [note](`m:megaco_user#extra_argument`) above about the `Extra` argument in\n[`handle_unexpected_trans/4`](`c:handle_unexpected_trans/4`).\n\n[](){: #request_abort }","ref":"megaco_user.html#c:handle_unexpected_trans/4"},{"type":"type","title":"megaco_user.conn_handle/0","doc":"","ref":"megaco_user.html#t:conn_handle/0"},{"type":"type","title":"megaco_user.megaco_timer/0","doc":"","ref":"megaco_user.html#t:megaco_timer/0"},{"type":"type","title":"megaco_user.receive_handle/0","doc":"","ref":"megaco_user.html#t:receive_handle/0"},{"type":"extras","title":"Megaco Release Notes","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Megaco Release Notes\n\nThis document describes the changes made to the Megaco system from version to\nversion. The intention of this document is to list all incompatibilities as well\nas all enhancements and bugfixes for every release of Megaco. Each release of\nMegaco thus constitutes one section in this document. The title of each section\nis the version number of Megaco.","ref":"notes.html"},{"type":"extras","title":"Megaco 4.6 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-6"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- `-callback` attributes have been added to `m:megaco_transport`.\n\n  Own Id: OTP-18806 Aux Id: [PR-7740]\n\n- Updated types and specs for all API modules.\n\n  Own Id: OTP-18920 Aux Id: BL-322\n\n- The documentation has been migrated to use Markdown and ExDoc.\n\n  Own Id: OTP-18955 Aux Id: [PR-8026]\n\n[PR-7740]: https://github.com/erlang/otp/pull/7740\n[PR-8026]: https://github.com/erlang/otp/pull/8026","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.5 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-5"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Make megaco transports handle gen_tcp | gen_udp with socket backend on Windows\n  (completion).\n\n  Own Id: OTP-18599 Aux Id: OTP-18029","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.4.4 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-4-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Removed configure option `--enable-sanitizers`. It was untested and broken.\n  Address sanitizer for the emulator has better support by the `asan` build\n  target.\n\n  Own Id: OTP-18538 Aux Id: GH-7031, PR-7078","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 4.4.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-4-3"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Replace size/1 with either tuple_size/1 or byte_size/1\n\n  The [`size/1`](`size/1`) BIF is not optimized by the JIT, and its use can\n  result in worse types for Dialyzer.\n\n  When one knows that the value being tested must be a tuple,\n  [`tuple_size/1`](`tuple_size/1`) should always be preferred.\n\n  When one knows that the value being tested must be a binary,\n  [`byte_size/1`](`byte_size/1`) should be preferred. However,\n  [`byte_size/1`](`byte_size/1`) also accepts a bitstring (rounding up size to a\n  whole number of bytes), so one must make sure that the call to `byte_size/` is\n  preceded by a call to [`is_binary/1`](`is_binary/1`) to ensure that bitstrings\n  are rejected. Note that the compiler removes redundant calls to\n  [`is_binary/1`](`is_binary/1`), so if one is not sure whether previous code\n  had made sure that the argument is a binary, it does not harm to add an\n  [`is_binary/1`](`is_binary/1`) test immediately before the call to\n  [`byte_size/1`](`byte_size/1`).\n\n  Own Id: OTP-18432 Aux Id:\n  GH-6672,PR-6793,PR-6784,PR-6787,PR-6785,PR-6682,PR-6800,PR-6797,PR-6798,PR-6799,PR-6796,PR-6813,PR-6671,PR-6673,PR-6684,PR-6694,GH-6677,PR-6696,PR-6670,PR-6674","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.4.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-4-2"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- A very minor improvement to the measurement tool.\n\n  Own Id: OTP-18298","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.4.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-4-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Fixed various dialyzer related issues in the examples and the application\n  proper.\n\n  Own Id: OTP-18179 Aux Id: ERIERL-836","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- There is a new configure option, `--enable-deterministic-build`, which will\n  apply the `deterministic` compiler option when building Erlang/OTP. The\n  `deterministic` option has been improved to eliminate more sources of\n  non-determinism in several applications.\n\n  Own Id: OTP-18165 Aux Id: PR-5965","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.4 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-4"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Input for `configure` scripts adapted to `autoconf` 2\\.71.\n\n  Own Id: OTP-17414 Aux Id: PR-4967\n\n- Megaco test suite(s) use the new peer module for node starts.\n\n  Own Id: OTP-17910","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The compilation time is no longer recorded in BEAM files. There remained\n  several undocumented functions that attempted to retrieve compilation times.\n  Those have now been removed.\n\n  Own Id: OTP-17962","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Update the performance and debug chapters of the megaco user's guide. Also\n  some updates to the meas tools.\n\n  Own Id: OTP-17839","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-2"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- \\[megaco_tcp] When connect fails, include more info in the error reason.\n\n  Own Id: OTP-17817","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-1"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- It is now possible to configure the built-in transports (megaco_tcp and megaco\n  udp) to use the new (gen_udp- and gen_tcp-) option 'inet_backend'.\n\n  Own Id: OTP-17533","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 4.0.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-0-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 4.0 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-4-0"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- All the pre-v3 codec(s) (prev3a, prev3b and prev3c) was deprecated in\n  OTP-23.0. They have now been removed.\n\n  \\*** POTENTIAL INCOMPATIBILITY \\***\n\n  Own Id: OTP-16560\n\n- Removed deprecated functions marked for removal.\n\n  Own Id: OTP-17049","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.19.5.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-5-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19.5 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-5"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Fixed usage of `AC_CONFIG_AUX_DIRS()` macros in configure script sources.\n\n  Own Id: OTP-17093 Aux Id: ERL-1447, PR-2948","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19.4 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Empty statistics descriptor (now) allowed in both encode and decode for\n  version 3.\n\n  Own Id: OTP-17012 Aux Id: ERL-1405","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The expected number of warnings when (yecc) generating v2 and v3 (text)\n  parser's was incorrect.\n\n  Own Id: OTP-16836","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The v2 and v3 parsers could not properly decode some IPv6 addresses.\n\n  Own Id: OTP-16818 Aux Id: ERIERL-526","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The mini parser could not properly decode some IPv6 addresses.\n\n  Own Id: OTP-16631 Aux Id: ERIERL-491","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.19 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-19"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Refactored the internal handling of deprecated and removed functions.\n\n  Own Id: OTP-16469\n\n- The preliminary version 3 codec(s) prev3a, prev3b and prev3c has been\n  deprecated and will be _removed_ in OTP 24. The encoding config option\n  'version3' will continue to work until OTP 24.\n\n  Own Id: OTP-16531","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.18.8.4 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-8-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Commit of generated `configure` script.\n\n  Own Id: OTP-17420 Aux Id: OTP-17398, GH-4821","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.8.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-8-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Empty statistics descriptor (now) allowed in both encode and decode for\n  version 3.\n\n  Own Id: OTP-17012 Aux Id: ERL-1405","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.8.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-8-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The v2 and v3 parsers could not properly decode some IPv6 addresses.\n\n  Own Id: OTP-16818 Aux Id: ERIERL-526","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.8.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-8-1"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The mini parser could not properly decode some IPv6 addresses.\n\n  Own Id: OTP-16631 Aux Id: ERIERL-491","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.8 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-8"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The documented function megaco:get_sdp_record_from_PropertGroup/2 was a\n  wrapper for megaco_sdp:get_sdp_record_from_PropertGroup/2 but did not actually\n  exist. This has now been fixed.\n\n  Own Id: OTP-16449","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Test suite completely reworked. Add (timestamp) utility functions for\n  debugging and testing.\n\n  Own Id: OTP-16158","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.18.7 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-7"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- The meas example had not been updated for a long time, which caused it to not\n  work. Also, it made use of deprecated functions (now()). This has now been\n  fixed.\n\n  Own Id: OTP-16061","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.6 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-6"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Fix various minor issues related to Dialyzer. Mostly these are dialyzer\n  warnings, but there was also some minor bugs detected by Dialyzer.\n\n  Own Id: OTP-15882","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.5 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-5"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Minor updates to build system necessary due to move of configuration of\n  `crypto` application.\n\n  Own Id: OTP-15262 Aux Id: OTP-15129\n\n- Minor adjustments made to build system for parallel configure.\n\n  Own Id: OTP-15340 Aux Id: OTP-14625","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.18.4 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-4"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Improved documentation.\n\n  Own Id: OTP-15190","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-3"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Removed all old unused files in the documentation.\n\n  Own Id: OTP-14475 Aux Id: ERL-409, PR-1493","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.18.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-2"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Typos have been fixed.\n\n  Own Id: OTP-14387","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.18.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18-1"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Internal changes\n\n  Own Id: OTP-13551","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.18 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-18"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- The runtime dependencies in the application resource file have been updated.\n\n  Own Id: OTP-12762","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-3"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Distribute `autoconf` helpers to applications at build time instead of having\n  multiple identical copies committed in the repository.\n\n  Own Id: OTP-12348","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-2"},{"type":"extras","title":"Fixed Bugs and Malfunctions - Megaco Release Notes","doc":"- Implement --enable-sanitizers\\[=sanitizers]. Similar to debugging with\n  Valgrind, it's very useful to enable -fsanitize= switches to catch bugs at\n  runtime.\n\n  Own Id: OTP-12153","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.17.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-1"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- The default encoding of Erlang files has been changed from ISO-8859-1 to\n  UTF-8.\n\n  The encoding of XML files has also been changed to UTF-8.\n\n  Own Id: OTP-10907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17.0.3 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-0-3"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Updated doc files to utf8.\n\n  Own Id: OTP-10907","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17.0.2 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-0-2"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Introduced functionality for inspection of system and build configuration.\n\n  Own Id: OTP-11196","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17.0.1 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-17-0-1"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Postscript files no longer needed for the generation of PDF files have been\n  removed.\n\n  Own Id: OTP-11016","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Megaco 3.17 - Megaco Release Notes","doc":"Version 3.17 supports code replacement in runtime from/to version 3.16.0.3 and\nand 3.16.0.2.","ref":"notes.html#megaco-3-17"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"- Buffer overrun error while flex scanner processing property parm groups.\n\n  This error occured only for large messages if a buffer realloc was needed\n  while processing the property parm groups.\n\n  Own Id: OTP-10998\n\n  Aux Id: Seq 12263","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Megaco 3.16.0.3 - Megaco Release Notes","doc":"Version 3.16.0.2 supports code replacement in runtime from/to version 3.16.0.1,\n3.16, 3.15.1.1, 3.15.1 and 3.15.","ref":"notes.html#megaco-3-16-0-3"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Where necessary, a comment stating encoding has been added to Erlang files.\n  The comment is meant to be removed in Erlang/OTP R17B when UTF-8 becomes the\n  default encoding.\n\n  Own Id: OTP-10630","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"- A number of binary encoding alternatives has been removed. The binary encoding\n  option `driver` has been removed since this (the use of the asn1 linked in\n  driver) is now default and there is now way to _not_ use it. See\n  [configuration of binary encoding](megaco_encode.md#binary_config) for more\n  info.","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Megaco 3.16.0.2 - Megaco Release Notes","doc":"Version 3.16.0.2 supports code replacement in runtime from/to version 3.16.0.1,\n3.16, 3.15.1.1, 3.15.1 and 3.15.","ref":"notes.html#megaco-3-16-0-2"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Allow whitespaces in installation path.\n\n  It is now possible to give configure and make an installation/release path\n  with whitespaces in it.\n\n  Own Id: OTP-10107\n\n- Fix parallel make for behaviours.\n- Removed use of deprecated system flag, `global_haeps_size`, in the measurement\n  tool `mstone1`.","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Megaco 3.16.0.1 - Megaco Release Notes","doc":"Version 3.16.0.1 supports code replacement in runtime from/to version 3.16,\n3.15.1.1, 3.15.1 and 3.15.","ref":"notes.html#megaco-3-16-0-1"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Fixed some faulty test cases.\n- Removed use of deprecated system flag, `scheduler_bind_type`, in the\n  measurement tool `mstone1`.\n\n  Own Id: OTP-9949","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Megaco 3.16 - Megaco Release Notes","doc":"Version 3.16 supports code replacement in runtime from/to version 3.15.1.1,\n3.15.1 and 3.15.","ref":"notes.html#megaco-3-16"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Minor improvements to the measurement tool `mstone1`.\n\n  Own Id: OTP-9604\n\n- ASN.1 no longer makes use of a driver to accelerate encode/decode, instead it\n  uses NIFs. The encoding config option is _still_ the same, i.e. `driver`.\n\n  Own Id: OTP-9672\n\n- The profiling test tool has been rewritten.\n\n  Håkan Mattsson\n\n  Own Id: OTP-9679\n\n- The flex driver has been updated to support the new driver format (changed to\n  enable 64-bit aware drivers).\n\n  Own Id: OTP-9795","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Megaco 3.15.1.1 - Megaco Release Notes","doc":"Version 3.15.1.1 supports code replacement in runtime from/to version 3.15.1 and\n3.15.","ref":"notes.html#megaco-3-15-1-1"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Correct various XML errors.\n\n  Own Id: OTP-9550","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.15.1 - Megaco Release Notes","doc":"Version 3.15.1 supports code replacement in runtime from/to version 3.15,\n3.14.1.1, 3.14.1 and 3.14.","ref":"notes.html#megaco-3-15-1"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"-","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"- Fixing miscellaneous things detected by dialyzer.\n\n  Own Id: OTP-9075","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.15 - Megaco Release Notes","doc":"","ref":"notes.html#megaco-3-15"},{"type":"extras","title":"Improvements and New Features - Megaco Release Notes","doc":"- Fixing auto-import issues.\n\n  Own Id: OTP-8842","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.14.1.1 - Megaco Release Notes","doc":"Version 3.14.1.1 supports code replacement in runtime from/to version 3.14.1,\n3.14, 3.13, 3.12 and 3.11.3.","ref":"notes.html#megaco-3-14-1-1"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Updated the [performance](megaco_performance.md) chapter.\n\n  Own Id: OTP-8696","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.14.1 - Megaco Release Notes","doc":"Version 3.14.1 supports code replacement in runtime from/to version 3.14, 3.13,\n3.12 and 3.11.3.","ref":"notes.html#megaco-3-14-1"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- A minor compiler related performance improvement.\n\n  Own Id: OTP-8561","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"- A race condition when, during high load, processing both the original and a\n  resent message and delivering this as two separate messages to the user.\n\n  Note that this solution only protects against multiple reply deliveries\\!\n\n  Own Id: OTP-8529\n\n  Aux Id: Seq 10915\n\n- Fix shared libraries installation.\n\n  The flex shared lib(s) were incorrectly installed as data files.\n\n  Peter Lemenkov\n\n  Own Id: OTP-8627\n\n- Eliminated a possible race condition while creating pending counters.\n\n  Own Id: OTP-8634\n\n  Aux Id: Seq 11579","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.14 - Megaco Release Notes","doc":"Version 3.14 supports code replacement in runtime from/to version 3.13, 3.12 and\n3.11.3.","ref":"notes.html#megaco-3-14"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- Various changes to configure and makefile(s) to facilitate cross compilation\n  (and other build system improvements).\n\n  Own Id: OTP-8323\n\n- Added a help target in the test Makefile to explain the most useful make\n  targets, used when testing the application using the test-server provided with\n  megaco.\n\n  Own Id: OTP-8362\n\n- Adapted megaco_filter to the new internal format.\n\n  Own Id: OTP-8403","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"- Callbacks, when the callback module is unknown (undefined), results in warning\n  messages.\n\n  A race condition scenario. As part of a cancelation operation, replies with\n  waiting acknowledgements is cancelled. This includes informing the user (via a\n  call to the handle_trans_ack callback function). It is possible that at this\n  point the connection data has been removed, which makes it impossible for\n  megaco to perform this operation, resulting in the warning message. The\n  solution is to also store the callback module with the other reply\n  information, to be used when cleaning up after a cancelation.\n\n  Own Id: OTP-8328\n\n  Aux Id: Seq 11384","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Megaco 3.13 - Megaco Release Notes","doc":"Version 3.13 supports code replacement in runtime from/to version 3.12 and\n3.11.3.","ref":"notes.html#megaco-3-13"},{"type":"extras","title":"Improvements and new features - Megaco Release Notes","doc":"- A minor optimization by using ets:update_element instead of ets:insert for\n  some table updates.\n\n  Own Id: OTP-8239\n\n- The documentation is now built with open source tools (_xsltproc_ and _fop_)\n  that exists on most platforms. One visible change is that the frames are\n  removed.\n\n  Own Id: OTP-8249","ref":"notes.html#improvements-and-new-features"},{"type":"extras","title":"Fixed bugs and malfunctions - Megaco Release Notes","doc":"-","ref":"notes.html#fixed-bugs-and-malfunctions"},{"type":"extras","title":"Incompatibilities - Megaco Release Notes","doc":"-","ref":"notes.html#incompatibilities"},{"type":"extras","title":"Introduction","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Introduction\n\nMegaco/H.248 is a protocol for control of elements in a physically decomposed\nmultimedia gateway, enabling separation of call control from media conversion. A\nMedia Gateway Controller (MGC) controls one or more Media Gateways (MG).\n\nThis version of the stack supports version 1, 2 and 3 as defined by:\n\n- version 1 - RFC 3525 and H.248-IG (v10-v13)\n- version 2 - draft-ietf-megaco-h248v2-04 & H.248.1 v2 Corrigendum 1 (03/2004)\n- version 3 - Full version 3 as defined by ITU H.248.1 (09/2005) (including\n  segments)\n\nThe semantics of the protocol has jointly been defined by two standardization\nbodies:\n\n- IETF - which calls the protocol Megaco\n- ITU - which calls the protocol H.248","ref":"megaco_intro.html"},{"type":"extras","title":"Scope and Purpose - Introduction","doc":"This manual describes the Megaco application, as a component of the Erlang/Open\nTelecom Platform development environment. It is assumed that the reader is\nfamiliar with the Erlang Development Environment, which is described in a\nseparate User's Guide.","ref":"megaco_intro.html#scope-and-purpose"},{"type":"extras","title":"Prerequisites - Introduction","doc":"The following prerequisites are required for understanding the material in the\nMegaco User's Guide:\n\n- the basics of the Megaco/H.248 protocol\n- the basics of the Abstract Syntax Notation One (ASN.1)\n- familiarity with the Erlang system and Erlang programming\n\nThe application requires Erlang/OTP release R10B or later.","ref":"megaco_intro.html#prerequisites"},{"type":"extras","title":"About This Manual - Introduction","doc":"In addition to this introductory chapter, the Megaco User's Guide contains the\nfollowing chapters:\n\n- Chapter 2: \"Architecture\" describes the architecture and typical usage of the\n  application.\n- Chapter 3: \"Internal form and its encodings\" describes the internal form of\n  Megaco/H.248 messages and its various encodings.\n- Chapter 4: \"Transport mechanisms\" describes how different mechanisms can be\n  used to transport the Megaco/H.248 messages.\n- Chapter 5: \"Debugging\" describes tracing and debugging.","ref":"megaco_intro.html#about-this-manual"},{"type":"extras","title":"Where to Find More Information - Introduction","doc":"Refer to the following documentation for more information about Megaco/H.248 and\nabout the Erlang/OTP development system:\n\n- [version 1, RFC 3525](https://www.erlang.org/doc/standard/rfc3525.txt)\n- [old version 1, RFC 3015](http://www.ietf.org/rfc/rfc3015.txt)\n- [Version 2 Corrigendum 1](https://web.archive.org/web/20100704020645/http://www.erlang.org/project/megaco/standard/H.248.1-Corr1-200403.doc)\n- [version 2, draft-ietf-megaco-h248v2-04](https://web.archive.org/web/20100620185420/http://erlang.org/project/megaco/standard/draft-ietf-megaco-h248v2-04.txt)\n- [H.248.1 version 3](http://www.itu.int/)\n- the ASN.1 application User's Guide\n- the Megaco application Reference Manual\n- Concurrent Programming in Erlang, 2nd Edition (1996), Prentice-Hall, ISBN\n  0-13-508301-X.","ref":"megaco_intro.html#where-to-find-more-information"},{"type":"extras","title":"Architecture","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Architecture","ref":"megaco_architecture.html"},{"type":"extras","title":"Network view - Architecture","doc":"Megaco is a (master/slave) protocol for control of gateway functions at the edge\nof the packet network. Examples of this is IP-PSTN trunking gateways and analog\nline gateways. The main function of Megaco is to allow gateway decomposition\ninto a call agent (call control) part (known as Media Gateway Controller, MGC) -\nmaster, and an gateway interface part (known as Media Gateway, MG) - slave. The\nMG has no call control knowledge and only handle making the connections and\nsimple configurations.\n\nSIP and H.323 are peer-to-peer protocols for call control (valid only for some\nof the protocols within H.323), or more generally multi-media session protocols.\nThey both operate at a different level (call control) from Megaco in a\ndecomposed network, and are therefor not aware of whether or not Megaco is being\nused underneath.\n\n![Network architecture](assets/megaco_sys_arch.gif \"Network architecture\")\n\nMegaco and peer protocols are complementary in nature and entirely compatible\nwithin the same system. At a system level, Megaco allows for\n\n- overall network cost and performance optimization\n- protection of investment by isolation of changes at the call control layer\n- freedom to geographically distribute both call function and gateway function\n- adaption of legacy equipment","ref":"megaco_architecture.html#network-view"},{"type":"extras","title":"General - Architecture","doc":"This Erlang/OTP application supplies a framework for building applications that\nneeds to utilize the Megaco/H.248 protocol.\n\nWe have introduced the term \"user\" as a generic term for either an MG or an MGC,\nsince most of the functionality we support, is common for both MG's and MGC's. A\n(local) user may be configured in various ways and it may establish any number\nof connections to its counterpart, the remote user. Once a connection has been\nestablished, the connection is supervised and it may be used for the purpose of\nsending messages. N.B. according to the standard an MG is connected to at most\none MGC, while an MGC may be connected to any number of MG's.\n\nFor the purpose of managing \"virtual MG's\", one Erlang node may host any number\nof MG's. In fact it may host a mix of MG's and MGC's. You may say that an Erlang\nnode may host any number of \"users\".\n\nThe protocol engine uses callback modules to handle various things:\n\n- encoding callback modules - handles the encoding and decoding of messages.\n  Several modules for handling different encodings are included, such as ASN.1\n  BER, pretty well indented text, compact text and some others. Others may be\n  written by you.\n- transport callback modules - handles sending and receiving of messages.\n  Transport modules for TCP/IP and UDP/IP are included and others may be written\n  by you.\n- user callback modules - the actual implementation of an MG or MGC. Most of the\n  functions are intended for handling of a decoded transaction (request, reply,\n  acknowledgement), but there are others that handles connect, disconnect and\n  errors cases.\n\nEach connection may have its own configuration of callback modules, re-send\ntimers, transaction id ranges etc. and they may be re-configured on-the-fly.\n\nIn the API of Megaco, a user may explicitly send action requests, but generation\nof transaction identifiers, the encoding and actual transport of the message to\nthe remote user is handled automatically by the protocol engine according to the\nactual connection configuration. Megaco messages are not exposed in the API.\n\nOn the receiving side the transport module receives the message and forwards it\nto the protocol engine, which decodes it and invokes user callback functions for\neach transaction. When a user has handled its action requests, it simply returns\na list of action replies (or a message error) and the protocol engine uses the\nencoding module and transport module to compose and forward the message to the\noriginating user.\n\nThe protocol stack does also handle things like automatic sending of\nacknowledgements, pending transactions, re-send of messages, supervision of\nconnections etc.\n\nIn order to provide a solution for scalable implementations of MG's and MGC's, a\nuser may be distributed over several Erlang nodes. One of the Erlang nodes is\nconnected to the physical network interface, but messages may be sent from other\nnodes and the replies are automatically forwarded back to the originating node.","ref":"megaco_architecture.html#general"},{"type":"extras","title":"Single node config - Architecture","doc":"Here a system configuration with an MG and MGC residing in one Erlang node each\nis outlined:\n\n![Single node config](assets/single_node_config.gif \"Single node config\")","ref":"megaco_architecture.html#single-node-config"},{"type":"extras","title":"Distributed config - Architecture","doc":"In a larger system with a user (in this case an MGC) distributed over several\nErlang nodes, it looks a little bit different. Here the encoding is performed on\nthe originating Erlang node (1) and the binary is forwarded to the node (2) with\nthe physical network interface. When the potential message reply is received on\nthe interface on node (2), it is decoded there and then different actions will\nbe taken for each transaction in the message. The transaction reply will be\nforwarded in its decoded form to the originating node (1) while the other types\nof transactions will be handled locally on node (2).\n\nTimers and re-send of messages will be handled on locally on one node, that is\nnode(1), in order to avoid unnecessary transfer of data between the Erlang\nnodes.\n\n![Distributes node config](assets/distr_node_config.gif \"Distributes node config\")","ref":"megaco_architecture.html#distributed-config"},{"type":"extras","title":"Message round-trip call flow - Architecture","doc":"The typical round-trip of a message can be viewed as follows. Firstly we view\nthe call flow on the originating side:\n\n![Message Call Flow (originating side)](assets/call_flow.gif \"Message Call Flow (originating side)\")\n\nThen we continue with the call flow on the destination side:\n\n![Message Call Flow (destination side)](assets/call_flow_cont.gif \"Message Call Flow (destination side)\")","ref":"megaco_architecture.html#message-round-trip-call-flow"},{"type":"extras","title":"Running the stack","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Running the stack","ref":"megaco_run.html"},{"type":"extras","title":"Starting - Running the stack","doc":"A user may have a number of \"virtual\" connections to other users. An MG is\nconnected to at most one MGC, while an MGC may be connected to any number of\nMG's. For each connection the user selects a transport service, an encoding\nscheme and a user callback module.\n\nAn MGC must initiate its transport service in order to listen to MG's trying to\nconnect. How the actual transport is initiated is outside the scope of this\napplication. However a send handle (typically a socket id or host and port) must\nbe provided from the transport service in order to enable us to send the message\nto the correct destination. We do however not assume anything about this, from\nour point of view, opaque handle. Hopefully it is rather small since it will\npassed around the system between processes rather frequently.\n\nA user may either be statically configured in a .config file according to the\napplication concept of Erlang/OTP or dynamically started with the configuration\nsettings as arguments to megaco:start_user/2. These configuration settings may\nbe updated later on with megaco:update_conn_info/2.\n\nThe function megaco:connect/4 is used to tell the Megaco application about which\ncontrol process it should supervise, which MID the remote user has, which\ncallback module it should use to send messages etc. When this \"virtual\"\nconnection is established the user may use megaco:call/3 and megaco:cast/3 in\norder to send messages to the other side. Then it is up to the MG to send its\nfirst Service Change Request message after applying some clever algorithm in\norder to fight the problem with startup avalanche (as discussed in the RFC).\n\nThe originating user will wait for a reply or a timeout (defined by the\nrequest_timer). When it receives the reply this will optionally be acknowledged\n(regulated by auto_ack), and forwarded to the user. If an interim pending reply\nis received, the long_request_timer will be used instead of the usual\nrequest_timer, in order to enable avoidance of spurious re-sends of the request.\n\nOn the destination side the transport service waits for messages. Each message\nis forwarded to the Megaco application via the megaco:receive_message/4 callback\nfunction. The transport service may or may not provide means for blocking and\nunblocking the reception of the incoming messages.\n\nIf a message is received before the \"virtual\" connection has been established,\nthe connection will be setup automatically. An MGC may be real open minded and\ndynamically decide which encoding and transport service to use depending on how\nthe transport layer contact is performed. For IP transports two ports are\nstandardized, one for textual encoding and one for binary encoding. If for\nexample an UDP packet was received on the text port it would be possible to\ndecide encoding and transport on the fly.\n\nAfter decoding a message various user callback functions are invoked in order to\nallow the user to act properly. See the megaco_user module for more info about\nthe callback arguments.\n\nWhen the user has processed a transaction request in its callback function, the\nMegaco application assembles a transaction reply, encodes it using the selected\nencoding module and sends the message back by invoking the callback function:\n\n- SendMod:send_message(SendHandle, ErlangBinary)\n\nRe-send of messages, handling pending transactions, acknowledgements etc. is\nhandled automatically by the Megaco application but the user is free to override\nthe default behaviour by the various configuration possibilities. See\nmegaco:update_user_info/2 and megaco:update_conn_info/2 about the possibilities.\n\nWhen connections gets broken (that is explicitly by megaco:disconnect/2 or when\nits controlling process dies) a user callback function is invoked in order to\nallow the user to re-establish the connection. The internal state of kept\nmessages, re-send timers etc. is not affected by this. A few re-sends will of\ncourse fail while the connection is down, but the automatic re-send algorithm\ndoes not bother about this and eventually when the connection is up and running\nthe messages will be delivered if the timeouts are set to be long enough. The\nuser has the option of explicitly invoking megaco:cancel/2 to cancel all\nmessages for a connection.\n\n[](){: #mgc_startup_call_flow }","ref":"megaco_run.html#starting"},{"type":"extras","title":"MGC startup call flow - Running the stack","doc":"In order to prepare the MGC for the reception of the initial message, hopefully\na Service Change Request, the following needs to be done:\n\n- Start the Megaco application.\n- Start the MGC user. This may either be done explicitly with\n  megaco:start_user/2 or implicitly by providing the -megaco users configuration\n  parameter.\n- Initiate the transport service and provide it with a receive handle obtained\n  from megaco:user_info/2.\n\nWhen the initial message arrives the transport service forwards it to the\nprotocol engine which automatically sets up the connection and invokes\nUserMod:handle_connect/2 before it invokes UserMod:handle_trans_request/3 with\nthe Service Change Request like this:\n\n![MGC Startup Call Flow](assets/MGC_startup_call_flow.gif \"MGC Startup Call Flow\")\n\n[](){: #mg_startup_call_flow }","ref":"megaco_run.html#mgc-startup-call-flow"},{"type":"extras","title":"MG startup call flow - Running the stack","doc":"In order to prepare the MG for the sending of the initial message, hopefully a\nService Change Request, the following needs to be done:\n\n- Start the Megaco application.\n- Start the MG user. This may either be done explicitly with megaco:start_user/2\n  or implicitly by providing the -megaco users configuration parameter.\n- Initiate the transport service and provide it with a receive handle obtained\n  from megaco:user_info/2.\n- Setup a connection to the MGC with megaco:connect/4 and provide it with a\n  receive handle obtained from megaco:user_info/2.\n\nIf the MG has been provisioned with the MID of the MGC it can be given as the\nRemoteMid parameter to megaco:connect/4 and the call flow will look like this:\n\n![MG Startup Call Flow](assets/MG_startup_call_flow.gif \"MG Startup Call Flow\")\n\nIf the MG cannot be provisioned with the MID of the MGC, the MG can use the atom\n'preliminary_mid' as the RemoteMid parameter to megaco:connect/4 and the call\nflow will look like this:\n\n![MG Startup Call Flow (no MID)](assets/MG-startup_flow_noMID.gif \"MG Startup Call Flow (no MID)\")\n\n[](){: #config_megaco }","ref":"megaco_run.html#mg-startup-call-flow"},{"type":"extras","title":"Configuring the Megaco stack - Running the stack","doc":"There are three kinds of configuration:\n\n- User info - Information related to megaco users. Read/Write.\n\n  A User is an entity identified by a MID, e.g. a MGC or a MG.\n\n  This information can be retrieved using\n  [megaco:user_info](`m:megaco#user_info`).\n\n- Connection info - Information regarding connections. Read/Write.\n\n  This information can be retrieved using\n  [megaco:conn_info](`m:megaco#conn_info`).\n\n- System info - System wide information. Read only.\n\n  This information can be retrieved using\n  [megaco:system_info](`m:megaco#system_info`).\n\n[](){: #initial_config }","ref":"megaco_run.html#configuring-the-megaco-stack"},{"type":"extras","title":"Initial configuration - Running the stack","doc":"The initial configuration of the Megaco should be defined in the Erlang system\nconfiguration file. The following configured parameters are defined for the\nMegaco application:\n\n- `users = [{Mid, [user_config()]}].`\n\n  Each user is represented by a tuple with the Mid of the user and a list of\n  config parameters (each parameter is in turn a tuple: `{Item, Value}`).\n\n- `scanner = flex | {Module, Function, Arguments, Modules}`\n\n  - `flex` will result in the start of the flex scanner with default options.\n  - The MFA alternative makes it possible for Megaco to start and supervise a\n    scanner written by the user (see `supervisor:start_child` for an explanation\n    of the parameters).\n\nSee also\n[Configuration of text encoding module(s)](megaco_encode.md#text_config) for\nmore info.\n\n[](){: #changing_config }","ref":"megaco_run.html#initial-configuration"},{"type":"extras","title":"Changing the configuration - Running the stack","doc":"The configuration can be changed during runtime. This is done with the functions\n[megaco:update_user_info](`m:megaco#update_user_info`) and\n[megaco:update_conn_info](`m:megaco#update_conn_info`)\n\n[](){: #transaction_sender }","ref":"megaco_run.html#changing-the-configuration"},{"type":"extras","title":"The transaction sender - Running the stack","doc":"The transaction sender is a process (one per connection), which handle all\ntransaction sending, if so configured (see\n[megaco:user_info](`m:megaco#user_info`) and\n[megaco:conn_info](`m:megaco#conn_info`)).\n\nThe purpose of the transaction sender is to accumulate transactions for a more\nefficient message sending. The transactions that are accumulated are transaction\nrequest and transaction ack. For transaction ack's the benefit is quite large,\nsince the transactions are small and it is possible to have ranges (which means\nthat transaction acks for transactions 1, 2, 3 and 4 can be sent as a range 1-4\nin one transaction ack, instead of four separate transactions).\n\nThere are a number of configuration parameter's that control the operation of\nthe transaction sender. In principle, a message with everything stored (ack's\nand request's) is sent from the process when:\n\n- When `trans_timer` expires.\n- When `trans_ack_maxcount` number of ack's has been received.\n- When `trans_req_maxcount` number of requests's has been received.\n- When the size of all received requests exceeds `trans_req_maxsize`.\n- When a reply transaction is sent.\n- When a pending transaction is sent.\n\nWhen something is to be sent, everything is packed into one message, unless the\ntrigger was a reply transaction and the added size of the reply and all the\nrequests is greater then `trans_req_maxsize`, in which case the stored\ntransactions are sent first in a separate message and the reply in another\nmessage.\n\nWhen the transaction sender receives a request which is already \"in storage\"\n(indicated by the transaction id) it is assumed to be a resend and everything\nstored is sent. This could happen if the values of the `trans_timer` and the\n`request_timer` is not properly chosen.\n\n[](){: #segment_reply }","ref":"megaco_run.html#the-transaction-sender"},{"type":"extras","title":"Segmentation of transaction replies - Running the stack","doc":"In version 3 of the megaco standard, the concept of `segmentation package` was\nintroduced. Simply, this package defines a procedure to segment megaco messages\n(transaction replies) when using a transport that does not automatically do this\n(e.g. UDP).\n\nAlthough it would be both pointless and counterproductive to use segmentation on\na transport that already does this (e.g. TCP), the megaco application does not\ncheck this. Instead, it is up to the user to configure this properly.\n\n- Receiving segmented messages:\n\n  This is handled automatically by the megaco application. There is however one\n  thing that need to be configured by the user, the\n  [segment_recv_timer](`m:megaco#user_info`) option.\n\n  Note that the segments are delivered to the user differently depending on\n  which function is used to issue the original request. When issuing the request\n  using the [megaco:cast](`m:megaco#cast`) function, the segments are delivered\n  to the user via the [handle_trans_reply](`m:megaco_user#trans_reply`) callback\n  function one at a time, as they arrive. But this obviously doe not work for\n  the [megaco:call](`m:megaco#call`) function. In this case, the segments are\n  accumulated and then delivered all at once as the function returns.\n\n- Sending segmented messages:\n\n  This is also handled automatically by the megaco application. First of all,\n  segmentation is only attempted if so configured, see the\n  [segment_send](`m:megaco#user_info`) option. Secondly, megaco relies on the\n  ability of the used codec to encode action replies, which is the smallest\n  component the megaco application handles when segmenting. Thirdly, the reply\n  will be segmented only if the sum of the size of the action replies (plus an\n  arbitrary message header size) are greater then the specified max message size\n  (see the [max_pdu_size](`m:megaco#user_info`) option). Finally, if\n  segmentation is decided, then each action reply will make up its own (segment)\n  message.","ref":"megaco_run.html#segmentation-of-transaction-replies"},{"type":"extras","title":"Internal form and its encodings","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Internal form and its encodings\n\nThis version of the stack is compliant with:\n\n- Megaco/H.248 version 1 (RFC3525) updated according to Implementors Guide\n  version 10-13.\n- Megaco/H.248 version 2 as defined by draft-ietf-megaco-h248v2-04 updated\n  according to Implementors Guide version 10-13.\n- Megaco/H.248 version 3 as defined by ITU H.248.1 (09/2005).","ref":"megaco_encode.html"},{"type":"extras","title":"Internal form of messages - Internal form and its encodings","doc":"We use the same internal form for both the binary and text encoding. Our\ninternal form of Megaco/H.248 messages is heavily influenced by the internal\nformat used by ASN.1 encoders/decoders:\n\n- \"SEQUENCE OF\" is represented as a list.\n- \"CHOICE\" is represented as a tagged tuple with size 2.\n- \"SEQUENCE\" is represented as a record, defined in\n  \"megaco/include/megaco_message_v1.hrl\".\n- \"OPTIONAL\" is represented as an ordinary field in a record which defaults to\n  'asn1_NOVALUE', meaning that the field has no value.\n- \"OCTET STRING\" is represented as a list of unsigned integers.\n- \"ENUMERATED\" is represented as a single atom.\n- \"BIT STRING\" is represented as a list of atoms.\n- \"BOOLEAN\" is represented as the atom 'true' or 'false'.\n- \"INTEGER\" is represented as an integer.\n- \"IA5String\" is represented as a list of integers, where each integer is the\n  ASCII value of the corresponding character.\n- \"NULL\" is represented as the atom 'NULL'.\n\nIn order to fully understand the internal form you must get hold on a ASN.1\nspecification for the Megaco/H.248 protocol, and apply the rules above. Please,\nsee the documentation of the ASN.1 compiler in Erlang/OTP for more details of\nthe semantics in mapping between ASN.1 and the corresponding internal form.\n\nObserve that the 'TerminationId' record is not used in the internal form. It has\nbeen replaced with a megaco_term_id record (defined in\n\"megaco/include/megaco.hrl\").","ref":"megaco_encode.html#internal-form-of-messages"},{"type":"extras","title":"The different encodings - Internal form and its encodings","doc":"The Megaco/H.248 standard defines both a plain text encoding and a binary\nencoding (ASN.1 BER) and we have implemented encoders and decoders for both. We\ndo in fact supply five different encoding/decoding modules.\n\nIn the text encoding, implementors have the choice of using a mix of short and\nlong keywords. It is also possible to add white spaces to improve readability.\nWe use the term compact for text messages with the shortest possible keywords\nand no optional white spaces, and the term pretty for a well indented text\nformat using long keywords and an indentation style like the text examples in\nthe Megaco/H.248 specification).\n\nHere follows an example of a text message to give a feeling of the difference\nbetween the pretty and compact versions of text messages. First the pretty, well\nindented version with long keywords:\n\n```c\n   MEGACO/1 [124.124.124.222]\n   Transaction = 9998 {\n           Context = - {\n                   ServiceChange = ROOT {\n                           Services {\n                                   Method = Restart,\n                                   ServiceChangeAddress = 55555,\n                                   Profile = ResGW/1,\n                                   Reason = \"901 Cold Boot\"\n                           }\n                   }\n           }\n   }\n```\n\nThen the compact version without indentation and with short keywords:\n\n```text\n\n   !/1 [124.124.124.222]\n   T=9998{C=-{SC=ROOT{SV{MT=RS,AD=55555,PF=ResGW/1,RE=\"901 Cold Boot\"}}}}\n```\n\nAnd the programmers view of the same message. First a list of ActionRequest\nrecords are constructed and then it is sent with one of the send functions in\nthe API:\n\n```erlang\n  Prof = #'ServiceChangeProfile'{profileName = \"resgw\", version = 1},\n  Parm = #'ServiceChangeParm'{serviceChangeMethod  = restart,\n                              serviceChangeAddress = {portNumber, 55555},\n                              serviceChangeReason  = \"901 Cold Boot\",\n                              serviceChangeProfile = Prof},\n  Req = #'ServiceChangeRequest'{terminationID = [?megaco_root_termination_id],\n                                serviceChangeParms = Parm},\n  Actions = [#'ActionRequest'{contextId = ?megaco_null_context_id,\n                              commandRequests = {serviceChangeReq, Req}}],\n  megaco:call(ConnHandle, Actions, Config).\n```\n\nAnd finally a print-out of the entire internal form:\n\n```erlang\n  {'MegacoMessage',\n   asn1_NOVALUE,\n   {'Message',\n    1,\n    {ip4Address,{'IP4Address', [124,124,124,222], asn1_NOVALUE}},\n    {transactions,\n     [\n      {transactionRequest,\n       {'TransactionRequest',\n         9998,\n         [{'ActionRequest',\n           0,\n           asn1_NOVALUE,\n           asn1_NOVALUE,\n           [\n            {'CommandRequest',\n             {serviceChangeReq,\n              {'ServiceChangeRequest',\n               [\n                {megaco_term_id, false, [\"root\"]}],\n                {'ServiceChangeParm',\n                 restart,\n                 {portNumber, 55555},\n                 asn1_NOVALUE,\n                 {'ServiceChangeProfile', \"resgw\", version = 1},\n                 \"901 MG Cold Boot\",\n                 asn1_NOVALUE,\n                 asn1_NOVALUE,\n                 asn1_NOVALUE\n                }\n              }\n             },\n             asn1_NOVALUE,\n             asn1_NOVALUE\n            }\n           ]\n          }\n         ]\n       }\n      }\n     ]\n    }\n   }\n  }\n```\n\nThe following encoding modules are provided:\n\n- megaco_pretty_text_encoder - encodes messages into pretty text format, decodes\n  both pretty as well as compact text.\n- megaco_compact_text_encoder - encodes messages into compact text format,\n  decodes both pretty as well as compact text.\n- megaco_binary_encoder - encode/decode ASN.1 BER messages. This encoder\n  implements the fastest of the BER encoders/decoders. Recommended binary codec.\n- megaco_ber_encoder - encode/decode ASN.1 BER messages.\n- megaco_per_encoder - encode/decode ASN.1 PER messages. N.B. that this format\n  is not included in the Megaco standard.\n- megaco_erl_dist_encoder - encodes messages into Erlangs distribution format.\n  It is rather verbose but encoding and decoding is blinding fast. N.B. that\n  this format is not included in the Megaco standard.\n\n[](){: #erl_dist_config }","ref":"megaco_encode.html#the-different-encodings"},{"type":"extras","title":"Configuration of Erlang distribution encoding module - Internal form and its encodings","doc":"The encoding_config of the megaco_erl_dist_encoder module may be one of these:\n\n- `[]` \\- Encodes the messages to the standard distribution format. It is rather\n  verbose but encoding and decoding is blinding fast.\n- `[megaco_compressed]` \\- Encodes the messages to the standard distribution\n  format after an internal transformation. It is less verbose, but the total\n  time of the encoding and decoding will on the other hand be somewhat slower\n  (see the [performance](megaco_performance.md) chapter for more info).\n- `[{megaco_compressed, Module}]` \\- Works in the same way as the\n  megaco_compressed config parameter, only here the user provide their own\n  compress module. This module must implement the `m:megaco_edist_compress`\n  behaviour.\n- `[compressed]` \\- Encodes the messages to a compressed form of the standard\n  distribution format. It is less verbose, but the encoding and decoding will on\n  the other hand be slower.\n\n[](){: #text_config }","ref":"megaco_encode.html#configuration-of-erlang-distribution-encoding-module"},{"type":"extras","title":"Configuration of text encoding module(s) - Internal form and its encodings","doc":"When using text encoding(s), there is actually two different configs controlling\nwhat software to use:\n\n- `[]` \\- An empty list indicates that the erlang scanner should be used.\n- `[{flex, port()}]` \\- Use the flex scanner when decoding (not optimized for\n  SMP). See [initial configuration](megaco_run.md#initial_config) for more info.\n- `[{flex, ports()}]` \\- Use the flex scanner when decoding (optimized for SMP).\n  See [initial configuration](megaco_run.md#initial_config) for more info.\n\nThe Flex scanner is a Megaco scanner written as a linked in driver (in C). There\nare two ways to get this working:\n\n- Let the Megaco stack start the flex scanner (load the driver).\n\n  To make this happen the megaco stack has to be configured:\n\n  - Add the `{scanner, flex}` (or similar) directive to an Erlang system config\n    file for the megaco app (see\n    [initial configuration](megaco_run.md#initial_config) chapter for details).\n  - Retrieve the encoding-config using the [system_info](`m:megaco#system_info`)\n    function (with `Item = text_config`).\n  - Update the receive handle with the encoding-config (the `encoding_config`\n    field).\n\n  The benefit of this is that Megaco handles the starting, holding and the\n  supervision of the driver and port.\n\n- The Megaco client (user) starts the flex scanner (load the driver).\n\n  When starting the flex scanner a port to the linked in driver is created. This\n  port has to be owned by a process. This process must not die. If it does the\n  port will also terminate. Therefor:\n\n  - Create a permanent process. Make sure this process is supervised (so that if\n    it does die, this will be noticed).\n  - Let this process start the flex scanner by calling the\n    `megaco_flex_scanner:start/0,1` function.\n  - Retrieve the encoding-config and when initiating the\n    `megaco_receive_handle`, set the field `encoding_config` accordingly.\n  - Pass the `megaco_receive_handle` to the transport module.\n\n[](){: #binary_config }","ref":"megaco_encode.html#configuration-of-text-encoding-module-s"},{"type":"extras","title":"Configuration of binary encoding module(s) - Internal form and its encodings","doc":"When using binary encoding, the structure of the termination id's needs to be\nspecified.\n\n- `[native]` \\- skips the transformation phase, i.e. the decoded message(s) will\n  not be transformed into our internal form.\n- `[integer()]` \\- A list containing the size (the number of bits) of each\n  level. Example: `[3,8,5,8]`.\n- `t:integer/0` \\- Number of one byte (8 bits) levels. N.B. This is currently\n  converted into the previous config. Example: `3` (`[8,8,8]`).\n\n[](){: #handling_versions }","ref":"megaco_encode.html#configuration-of-binary-encoding-module-s"},{"type":"extras","title":"Handling megaco versions - Internal form and its encodings","doc":"There are two ways to handle the different megaco encoding versions. Either\nusing _dynamic version detection_ (only valid for for incoming messages) or by\n_explicit version_ setting in the connection info.\n\nFor incoming messages:\n\n- Dynamic version detection\n\n  Set the protocol version in the megaco_receive_handle to `dynamic` (this is\n  the default).  \n  This works for those codecs that support partial decode of the version,\n  currently _text_, and ber_bin (`megaco_binary_encoder` and\n  `megaco_ber_bin_encoder`).  \n  This way the decoder will detect which version is used and then use the proper\n  decoder.\n\n- Explicit version\n\n  Explicitly set the actual protocol version in the megaco_receive_handle.  \n  Start with version 1. When the initial service change has been performed and\n  version 2 has been negotiated, upgrade the megaco_receive_handle of the\n  transport process (control_pid) to version 2. See\n  [megaco_tcp](`megaco_tcp:upgrade_receive_handle/2`) and\n  [megaco_udp](`megaco_udp:upgrade_receive_handle/2`).  \n  Note that if `udp` is used, the same transport process could be used for\n  several connections. This could make upgrading impossible.  \n  For codecs that does not support partial decode of the version, currently\n  `megaco_ber_encoder` and `megaco_per_encoder`, `dynamic` will revert to\n  version 1.\n\nFor outgoing messages:\n\n- Update the connection info protocol_version.\n- Override protocol version when sending a message by adding the item\n  `{protocol_version, integer()}` to the Options. See [call](`m:megaco#call`) or\n  [cast](`m:megaco#cast`).  \n  Note that this does not effect the messages that are sent autonomously by the\n  stack. They use the protocol_version of the connection info.","ref":"megaco_encode.html#handling-megaco-versions"},{"type":"extras","title":"Encoder callback functions - Internal form and its encodings","doc":"The encoder callback interface is defined by the `megaco_encoder` behaviour, see\n`m:megaco_encoder`.","ref":"megaco_encode.html#encoder-callback-functions"},{"type":"extras","title":"Transport mechanisms","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Transport mechanisms","ref":"megaco_transport_mechanisms.html"},{"type":"extras","title":"Callback interface - Transport mechanisms","doc":"The callback interface of the transport module contains several functions. Some\nof which are mandatory while others are only optional:\n\n- `send_message` \\- Send a message. _Mandatory_\n- `block` \\- Block the transport. _Optional_\n\n  This function is usefull for flow control.\n\n- `unblock` \\- Unblock the transport. _Optional_\n\nFor more detail, see the `m:megaco_transport` behaviour definition.","ref":"megaco_transport_mechanisms.html#callback-interface"},{"type":"extras","title":"Examples - Transport mechanisms","doc":"The Megaco/H.248 application contains implementations for the two protocols\nspecified by the Megaco/H.248 standard; UDP, see `m:megaco_udp`, and TCP/TPKT,\nsee `m:megaco_tcp`.","ref":"megaco_transport_mechanisms.html#examples"},{"type":"extras","title":"Implementation examples","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Implementation examples","ref":"megaco_examples.html"},{"type":"extras","title":"A simple Media Gateway Controller - Implementation examples","doc":"In megaco/examples/simple/megaco_simple_mgc.erl there is an example of a simple\nMGC that listens on both text and binary standard ports and is prepared to\nhandle a Service Change Request message to arrive either via TCP/IP or UDP/IP.\nMessages received on the text port are decoded using a text decoder and messages\nreceived on the binary port are decoded using a binary decoder.\n\nThe Service Change Reply is encoded in the same way as the request and sent back\nto the MG with the same transport mechanism UDP/IP or TCP/IP.\n\nAfter this initial service change message the connection between the MG and MGC\nis fully established and supervised.\n\nThe MGC, with its four listeners, may be started with:\n\n```text\n      cd megaco/examples/simple\n      erl -pa ../../../megaco/ebin -s megaco_filter -s megaco\n      megaco_simple_mgc:start().\n```\n\nor simply 'gmake mgc'.\n\nThe -s megaco_filter option to erl implies, the event tracing mechanism to be\nenabled and an interactive sequence chart tool to be started. This may be quite\nuseful in order to visualize how your MGC interacts with the Megaco/H.248\nprotocol stack.\n\nThe event traces may alternatively be directed to a file for later analyze. By\ndefault the event tracing is disabled, but it may dynamically be enabled without\nany need for re-compilation of the code.","ref":"megaco_examples.html#a-simple-media-gateway-controller"},{"type":"extras","title":"A simple Media Gateway - Implementation examples","doc":"In megaco/examples/simple/megaco_simple_mg.erl there is an example of a simple\nMG that connects to an MGC, sends a Service Change Request and waits\nsynchronously for a reply.\n\nAfter this initial service change message the connection between the MG and MGC\nis fully established and supervised.\n\nAssuming that the MGC is started on the local host, four different MG's, using\ntext over TCP/IP, binary over TCP/IP, text over UDP/IP and binary over UDP/IP\nmay be started on the same Erlang node with:\n\n```text\n      cd megaco/examples/simple\n      erl -pa ../../../megaco/ebin -s megaco_filter -s megaco\n      megaco_simple_mg:start().\n```\n\nor simply 'gmake mg'.\n\nIf you \"only\" want to start a single MG which tries to connect an MG on a host\nnamed \"baidarka\", you may use one of these functions (instead of the\nmegaco_simple_mg:start/0 above):\n\n```erlang\n      megaco_simple_mg:start_tcp_text(\"baidarka\", []).\n      megaco_simple_mg:start_tcp_binary(\"baidarka\", []).\n      megaco_simple_mg:start_udp_text(\"baidarka\", []).\n      megaco_simple_mg:start_udp_binary(\"baidarka\", []).\n```\n\nThe -s megaco_filter option to erl implies, the event tracing mechanism to be\nenabled and an interactive sequence chart tool to be started. This may be quite\nuseful in order to visualize how your MG interacts with the Megaco/H.248\nprotocol stack.\n\nThe event traces may alternatively be directed to a file for later analyze. By\ndefault the event tracing is disabled, but it may dynamically be enabled without\nany need for re-compilation of the code.","ref":"megaco_examples.html#a-simple-media-gateway"},{"type":"extras","title":"Megaco mib","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Megaco mib","ref":"megaco_mib.html"},{"type":"extras","title":"Intro - Megaco mib","doc":"The Megaco mib is as of yet not standardized and our implementation is based on\n_draft-ietf-megaco-mib-04.txt_. Almost all of the mib cannot easily be\nimplemented by the megaco application. Instead these things should be\nimplemented by a user (of the megaco application).\n\nSo what part of the mib is implemented? Basically the relevant statistic\ncounters of the _MedGwyGatewayStatsEntry_.","ref":"megaco_mib.html#intro"},{"type":"extras","title":"Statistics counters - Megaco mib","doc":"The implementation of the statistic counters is lightweight. I.e. the statistic\ncounters are handled separately by different entities of the application. For\ninstance our two transport module(s) (see [megaco_tcp](`megaco_tcp:get_stats/0`) and\n[megaco_udp](`megaco_udp:get_stats/0`)) maintain their own counters and the\napplication engine (see [megaco](`m:megaco#stats`)) maintain its own counters.\n\nThis also means that if a user implement their own transport service then it has\nto maintain its own statistics.","ref":"megaco_mib.html#statistics-counters"},{"type":"extras","title":"Distribution - Megaco mib","doc":"Each megaco application maintains its own set of counters. So in a large\n(distributed) MG/MGC it could be necessary to collect the statistics from\nseveral nodes (each) running the megaco application (only one of them with the\ntransport).","ref":"megaco_mib.html#distribution"},{"type":"extras","title":"Performance comparison","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Performance comparison","ref":"megaco_performance.html"},{"type":"extras","title":"Comparison of encoder/decoders - Performance comparison","doc":"The Megaco/H.248 standard defines both a plain text encoding and a binary\nencoding (ASN.1 BER) and we have implemented encoders and decoders for both. We\ndo supply a bunch of different encoding/decoding modules and the user may in\nfact implement their own (like our erl_dist module). Using a non-standard\nencoding format has its obvious drawbacks, but may be useful in some\nconfigurations.\n\nWe have made four different measurements of our Erlang/OTP implementation of the\nMegaco/H.248 protocol stack, in order to compare our different\nencoders/decoders. The result of each one is summarized in the table below.\n\n| _Codec and config_                       | _Size_ | _Encode_ | _Decode_ | _Total_ |\n| ---------------------------------------- | ------ | -------- | -------- | ------- |\n| pretty                                   | 336    | 5        | 12       | 17      |\n| pretty \\[flex]                           | 336    | 5        | 11       | 16      |\n| compact                                  | 181    | 4        | 10       | 14      |\n| compact \\[flex]                          | 181    | 4        | 9        | 13      |\n| per bin                                  | 91     | 6        | 6        | 12      |\n| per bin \\[native]                        | 91     | 4        | 3        | 7       |\n| ber bin                                  | 165    | 6        | 6        | 12      |\n| ber bin \\[native]                        | 165    | 4        | 3        | 7       |\n| erl_dist                                 | 875    | 2        | 5        | 7       |\n| erl_dist \\[megaco_compressed]            | 405    | 1        | 2        | 3       |\n| erl_dist \\[compressed]                   | 345    | 15       | 9        | 24      |\n| erl_dist \\[megaco_compressed,compressed] | 200    | 11       | 4        | 15      |\n\n_Table: Codec performance_","ref":"megaco_performance.html#comparison-of-encoder-decoders"},{"type":"extras","title":"Description of encoders/decoders - Performance comparison","doc":"In Appendix A of the Megaco/H.248 specification (RFC 3525), there are about 30\nmessages that shows a representative call flow. We have also added a few extra\nversion 1, version 2 and version 3 messages. We have used these messages as\nbasis for our measurements. Our figures have not been weighted in regard to how\nfrequent the different kinds of messages that are sent between the media gateway\nand its controller.\n\nThe test compares the following encoder/decoders:\n\n- _pretty_ \\- pretty printed text. In the text encoding, the protocol stack\n  implementors have the choice of using a mix of short and long keywords. It is\n  also possible to add white spaces to improve readability. The pretty text\n  encoding utilizes long keywords and an indentation style like the text\n  examples in the Megaco/H.248 specification.\n- _compact_ \\- the compact text encoding uses the shortest possible keywords and\n  no optional white spaces.\n- _ber_ \\- ASN.1 BER.\n- _per_ \\- ASN.1 PER. Not standardized as a valid Megaco/H.248 encoding, but\n  included for the matter of completeness as its encoding is extremely compact.\n- _erl_dist_ \\- Erlang's native distribution format. Not standardized as a valid\n  Megaco/H.248 encoding, but included as a reference due to its well known\n  performance characteristics. Erlang is a dynamically typed language and any\n  Erlang data structure may be serialized to the erl_dist format by using\n  built-in functions.\n\nThe actual encoded messages have been collected in one directory per encoding\ntype, containing one file per encoded message.\n\nHere follows an example of a text message to give a feeling of the difference\nbetween the pretty and compact versions of text messages. First the pretty\nprinted, well indented version with long keywords:\n\n```c\nMEGACO/1 [124.124.124.222]\n  Transaction = 9998 {\n    Context = - {\n      ServiceChange = ROOT {\n        Services {\n          Method = Restart,\n          ServiceChangeAddress = 55555,\n          Profile = ResGW/1,\n          Reason = \"901 MG Cold Boot\"\n        }\n      }\n    }\n  }\n```\n\nThen the compact text version without indentation and with short keywords:\n\n```text\n!/1 [124.124.124.222] T=9998{\n  C=-{SC=ROOT{SV{MT=RS,AD=55555,PF=ResGW/1,RE=\"901 MG Cold Boot\"}}}}\n```","ref":"megaco_performance.html#description-of-encoders-decoders"},{"type":"extras","title":"Setup - Performance comparison","doc":"The measurements has been performed on a Dell Precision 5550 Laptop with a\nIntel(R) Core(TM) i7-10875H CPU @ 2.30GHz, with 40 GB memory and running Ubuntu\n20.04 x86_64, kernel 5.4.0-91-generic. Software versions was open source OTP\n24.2 (megaco-4.2).","ref":"megaco_performance.html#setup"},{"type":"extras","title":"Summary - Performance comparison","doc":"In our measurements we have seen that there are no significant differences in\nmessage sizes between ASN.1 BER and the compact text format. Some care should be\ntaken when using the pretty text style (which is used in all the examples\nincluded in the protocol specification and preferred during debugging sessions)\nsince the messages can then be quite large. If the message size really is a\nserious issue, our per encoder should be used, as the ASN.1 PER format is much\nmore compact than all the other alternatives. Its major drawback is that it is\nhas not been approved as a valid Megaco/H.248 message encoding.\n\nWhen it comes to pure encode/decode performance, it turns out that:\n\n- our fastest binary encoder (ber) is about equal to our fastest text encoder\n  (compact).\n- our fastest binary decoder (ber) is about 66% faster than our fastest text\n  decoder (compact).\n\nIf the pure encode/decode performance really is a serious issue, our erl_dist\nencoder could be used, as the encoding/decoding of the erlang distribution\nformat is much faster than all the other alternatives. Its major drawback is\nthat it is has not been approved as a valid Megaco/H.248 message encoding.\n\nThere is no performance advantage of building (and using) a non-reentrant flex\nscanner over a reentrant flex scanner (if flex supports building such a\nscanner).\n\n> #### Note {: .info }\n>\n> Please, observe that these performance figures are related to our\n> implementation in Erlang/OTP. Measurements of other implementations using\n> other tools and techniques may of course result in other figures.","ref":"megaco_performance.html#summary"},{"type":"extras","title":"Testing and tools","doc":"<!--\n%CopyrightBegin%\n\nCopyright Ericsson AB 2023-2024. All Rights Reserved.\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.\n\n%CopyrightEnd%\n-->\n# Testing and tools","ref":"megaco_debug.html"},{"type":"extras","title":"Tracing - Testing and tools","doc":"We have instrumented our code in order to enable tracing. Running the\napplication with tracing deactivated, causes a negligible performance overhead\n(an external call to a function which returns an atom). Activation of tracing\ndoes not require any recompilation of the code, since we rely on Erlang/OTP's\nbuilt in support for dynamic trace activation. In our case tracing of calls to a\ngiven external function.\n\nEvent traces can be viewed in a generic message sequence chart tool, `et`, or as\nstandard output (events are written to stdio).\n\nSee [enable_trace](`m:megaco#enable_trace`),\n[disable_trace](`m:megaco#disable_trace`) and [set_trace](`m:megaco#set_trace`)\nfor more info.","ref":"megaco_debug.html#tracing"},{"type":"extras","title":"Measurement and transformation - Testing and tools","doc":"We have included some simple tool(s) for codec measurement (meas), performance\ntests (mstone1 and mstone2) and message transformation.\n\nThe tool(s) are located in the example/meas directory.","ref":"megaco_debug.html#measurement-and-transformation"},{"type":"extras","title":"Requirement - Testing and tools","doc":"- Erlang/OTP, version 24.2 or later.\n- Version 4.2 or later of _this_ application.\n- Version 5.0.17 or later of the _asn1_ application.\n- The flex libraries. Without it, the flex powered codecs cannot be used.","ref":"megaco_debug.html#requirement"},{"type":"extras","title":"Meas results - Testing and tools","doc":"The results from the measurement run (meas) is four excel-compatible textfiles:\n\n- decode_time.xls -> Decoding result\n- encode_time.xls -> Encoding result\n- total_time.xls -> Total (Decoding+encoding) result\n- message_size.xls -> Message size","ref":"megaco_debug.html#meas-results"},{"type":"extras","title":"Instruction - Testing and tools","doc":"The tool contain four things:\n\n- The transformation module\n- The measurement (meas) module(s)\n- The mstone (mstone1 and mstone2) module(s)\n- The basic message file\n\n#### Message Transformation\n\nThe messages used by the different tools are contained in single message package\nfile (see below for more info). The messages in this file is encoded with just\none codec. During measurement initiation, the messages are read and then\ntransformed to all codec formats used in the measurement.\n\nThe message transformation is done by the transformation module. It is used to\ntransform a set of messages encoded with one codec into the other base codec's.\n\n#### Measurement(s)\n\nThere are two different measurement tools:\n\n- _meas_:\n\n  Used to perform codec measurements. That is, to see what kind of performance\n  can be expected by the different codecs provided by the megaco application.\n\n  The measurement is done by iterating over the decode/encode function for\n  approx 2 seconds per message and counting the number of decodes/encodes.\n\n  Is best run by modifying the meas.sh.skel skeleton script provided by the\n  tool.\n\n  To run it manually do the following:\n\n  ```erlang\n          % erl -pa   -pa  \n          Erlang (BEAM) emulator version 5.6 [source]\n\n          Eshell V12.2  (abort with ^G)\n          1> megaco_codec_meas:start().\n          ...\n          2> halt().\n  ```\n\n  or to make it even easier, assuming a measure shall be done on all the codecs\n  (as above):\n\n  ```text\n          % erl -noshell -pa   \\\\\n                -pa   \\\\\n                -s megaco_codec_meas -s init stop\n  ```\n\n  When run as above (this will take some time), the measurement process is done\n  as follows:\n\n  ```text\n  For each codec:\n      For each message:\n          Read the message from the file\n              Detect message version\n              Measure decode\n                  Measure encode\n            Write results, encode, decode and total, to file\n  ```\n\n- _mstone1 and mstone2_:\n\n  These are two different SMP performance monitoring tool(s).\n\n  _mstone1_ creates a process for each codec config supported by the megaco\n  application and let them run for a specific time (all at the same time),\n  encoding and decoding megaco messages. The number of messages processed in\n  total is the mstone1(1) value.\n\n  There are different ways to run the mstone1 tool, e.g. with or without the use\n  of drivers, with _only_ flex-empowered configs.\n\n  Is best run by modifying the mstone1.sh.skel skeleton script provided by the\n  tool.\n\n  The _mstone2_ is similar to the _mstone1_ tool, but in this case, each created\n  process makes only _one_ run through the messages and then exits. A soon as a\n  process exits, a new process (with the same config and messages) is created to\n  takes its place. The number of messages processed in total is the mstone2(1)\n  value.\n\nBoth these tools use the message package (time_test.msgs) provided with the\ntool(s), although it can run on any message package as long as it has the same\nstructure.\n\n#### Message package file\n\nThis is simply an erlang compatible text-file with the following structure:\n`{codec_name(), messages_list()}`.\n\n```erlang\ncodec_name() = pretty | compact | ber | per | erlang      (how the messages are encoded)\nmessages_list() = [{message_name(), message()}]\nmessage_name() = atom()\nmessage() = binary()\n```\n\nThe codec name is the name of the codec with which all messages in the\n`message_list()` has been encoded.\n\nThis file can be `exported` to a file structure by calling the\n[export_messages](`m:megaco_codec_transform#export_messages`) function. This can\nbe usefull if a measurement shall be done with an external tool. Exporting the\nmessages creates a directory tree with the following structure:\n\n```text\n /pretty/ \n                  compact/\n                  per/\n                  ber/ \n                  erlang/\n```\n\nThe file includes both version 1, 2 and version 3 messages.","ref":"megaco_debug.html#instruction"},{"type":"extras","title":"Notes - Testing and tools","doc":"#### Binary codecs\n\nThere are two basic ways to use the binary encodings: With package related name\nand termination id transformation (the 'native' encoding config) or without.\nThis transformation converts package related names and termination id's to a\nmore convenient internal form (equivalent with the decoded text message).\n\nThe transformation is done \\_after\\_ the actual decode has been done.\n\nTherefor in the tests, binary codecs are tested with two different encoding\nconfigs to determine exactly how the different options effect the performance:\nwith transformation ([]) and without transformation (\\[native]).\n\n#### Included test messages\n\nSome of these messages are ripped from the call flow examples in an old version\nof the RFC and others are created to test a specific feature of megaco.\n\n#### Measurement tool directory name\n\nBe sure _not_ no name the directory containing the measurement binaries starting\nwith 'megaco-', e.g. megaco-meas. This will confuse the erlang application\nloader (erlang applications are named, e.g. megaco-5.2).","ref":"megaco_debug.html#notes"}],"content_type":"text/plain","producer":{"name":"ex_doc","version":[48,46,51,50,46,50]}}