/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.map;

import tim.prune.gui.map.MapSource;
import tim.prune.gui.map.SiteNameUtils;

public class OsmMapSource
extends MapSource {
    private final int _maxZoom;

    public OsmMapSource(String string, String string2) {
        this(string, string2, "png", null, null, 18);
    }

    public OsmMapSource(String string, String string2, String string3, int n) {
        super(string);
        if (string3 != null && string3.length() == 3) {
            this.init(string2, string3, null, null);
        } else {
            this.init(string2, "png", string3, "png");
        }
        this._maxZoom = n;
    }

    public OsmMapSource(String string, String string2, String string3, String string4, String string5, int n) {
        super(string);
        this.init(string2, string3, string4, string5);
        this._maxZoom = n;
    }

    private void init(String string, String string2, String string3, String string4) {
        this.addLayer(OsmMapSource.fixBaseUrl(string), string2);
        this.addLayer(OsmMapSource.fixBaseUrl(string3), string4);
    }

    public static OsmMapSource fromConfig(String string) {
        OsmMapSource osmMapSource = null;
        if (string.startsWith("o:")) {
            String[] stringArray = string.substring(2).split(";");
            try {
                if (stringArray.length == 3) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], null, Integer.parseInt(stringArray[2]));
                } else if (stringArray.length == 4) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], Integer.parseInt(stringArray[3]));
                } else if (stringArray.length == 6) {
                    osmMapSource = new OsmMapSource(stringArray[0], stringArray[1], stringArray[2], stringArray[3], stringArray[4], Integer.parseInt(stringArray[5]));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return osmMapSource;
    }

    @Override
    public String makeURL(int n, int n2, int n3, int n4) {
        String string = SiteNameUtils.pickServerUrl(this.getBaseUrl(n));
        if (string.indexOf(123) < 0) {
            return String.valueOf(string) + n2 + '/' + n3 + '/' + n4 + '.' + this.getFileExtension(n);
        }
        return string.replace("{z}", Integer.toString(n2)).replace("{x}", Integer.toString(n3)).replace("{y}", Integer.toString(n4));
    }

    @Override
    public final int getMaxZoomLevel() {
        return this._maxZoom;
    }

    @Override
    public String getConfigString() {
        return "o:" + this.getName() + ";" + this.getSiteStrings() + this.getMaxZoomLevel();
    }
}

