/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.spark.execution.xcontent;

import java.io.IOException;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializer;
import org.opensearch.sql.spark.execution.xcontent.XContentSerializerUtil;
import org.opensearch.sql.spark.flint.FlintIndexState;
import org.opensearch.sql.spark.flint.FlintIndexStateModel;

public class FlintIndexStateModelXContentSerializer
implements XContentSerializer<FlintIndexStateModel> {
    public static final String FLINT_INDEX_DOC_TYPE = "flintindexstate";
    public static final String LATEST_ID = "latestId";

    @Override
    public XContentBuilder toXContent(FlintIndexStateModel flintIndexStateModel, ToXContent.Params params) throws IOException {
        return XContentFactory.jsonBuilder().startObject().field("version", "1.0").field("type", FLINT_INDEX_DOC_TYPE).field("state", flintIndexStateModel.getIndexState().getState()).field("accountId", flintIndexStateModel.getAccountId()).field("applicationId", flintIndexStateModel.getApplicationId()).field("jobId", flintIndexStateModel.getJobId()).field(LATEST_ID, flintIndexStateModel.getLatestId()).field("dataSourceName", flintIndexStateModel.getDatasourceName()).field("lastUpdateTime", flintIndexStateModel.getLastUpdateTime()).field("error", flintIndexStateModel.getError()).endObject();
    }

    @Override
    public FlintIndexStateModel fromXContent(XContentParser parser, long seqNo, long primaryTerm) {
        FlintIndexStateModel.FlintIndexStateModelBuilder builder = FlintIndexStateModel.builder();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        while (!XContentParser.Token.END_OBJECT.equals((Object)parser.nextToken())) {
            String fieldName = parser.currentName();
            parser.nextToken();
            switch (fieldName) {
                case "state": {
                    builder.indexState(FlintIndexState.fromString((String)parser.text()));
                    break;
                }
                case "accountId": {
                    builder.accountId(parser.textOrNull());
                    break;
                }
                case "applicationId": {
                    builder.applicationId(parser.text());
                    break;
                }
                case "jobId": {
                    builder.jobId(parser.text());
                    break;
                }
                case "latestId": {
                    builder.latestId(parser.text());
                    break;
                }
                case "dataSourceName": {
                    builder.datasourceName(parser.text());
                    break;
                }
                case "lastUpdateTime": {
                    builder.lastUpdateTime(parser.longValue());
                    break;
                }
                case "error": {
                    builder.error(parser.text());
                }
            }
        }
        builder.metadata(XContentSerializerUtil.buildMetadata((long)seqNo, (long)primaryTerm));
        return builder.build();
    }
}

