/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.ws.yahoo.search;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Map;
import org.jdesktop.beans.AbstractBean;
import org.jdesktop.swingx.ws.yahoo.search.ResultsList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class YahooSearch<T>
extends AbstractBean {
    private static final String URL_PREFIX = "http://api.search.yahoo.com";

    protected abstract ResultsList<T> readResults(InputStream var1) throws Exception;

    protected abstract String getServiceName();

    protected abstract String getVersionNumber();

    protected int getDefaultResultCount() {
        return 10;
    }

    protected abstract String getMethod();

    protected abstract Map getParameters();

    protected final URL constructUrl(int firstSearchPosition, int resultCount) throws MalformedURLException {
        firstSearchPosition = firstSearchPosition < 1 ? 1 : firstSearchPosition;
        resultCount = resultCount < 1 ? this.getDefaultResultCount() : resultCount;
        StringBuilder buffer = new StringBuilder(URL_PREFIX);
        buffer.append("/").append(this.getServiceName()).append("/");
        buffer.append(this.getVersionNumber()).append("/").append(this.getMethod()).append("?");
        buffer.append("results=" + resultCount);
        buffer.append("&start=" + firstSearchPosition);
        Map params = this.getParameters();
        for (Object key : params.keySet()) {
            try {
                buffer.append("&");
                buffer.append(URLEncoder.encode(key.toString(), "UTF-8"));
                buffer.append("=");
                buffer.append(URLEncoder.encode(params.get(key).toString(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new MalformedURLException("Failed to construct the url due to bad encoding: " + e.getMessage());
            }
        }
        return new URL(buffer.toString());
    }

    public final ResultsList<T> search() {
        return this.search(-1, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ResultsList<T> search(int firstResultPosition, int resultCount) {
        InputStream in = null;
        try {
            in = this.constructUrl(firstResultPosition, resultCount).openStream();
            ResultsList<T> resultsList = this.readResults(in);
            return resultsList;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            ResultsList<T> resultsList = null;
            return resultsList;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

