/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.rest.handler;

import java.io.IOException;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.timeseries.AnalysisType;
import org.opensearch.timeseries.common.exception.ValidationException;
import org.opensearch.timeseries.constant.CommonMessages;
import org.opensearch.timeseries.feature.SearchFeatureDao;
import org.opensearch.timeseries.model.Config;
import org.opensearch.timeseries.model.Feature;
import org.opensearch.timeseries.model.IntervalTimeConfiguration;
import org.opensearch.timeseries.model.MergeableList;
import org.opensearch.timeseries.model.TimeConfiguration;
import org.opensearch.timeseries.model.ValidationAspect;
import org.opensearch.timeseries.model.ValidationIssueType;
import org.opensearch.timeseries.rest.handler.AggregationPrep;
import org.opensearch.timeseries.rest.handler.IntervalCalculation;
import org.opensearch.timeseries.rest.handler.LatestTimeRetriever;
import org.opensearch.timeseries.transport.ValidateConfigResponse;
import org.opensearch.timeseries.util.MultiResponsesDelegateActionListener;
import org.opensearch.timeseries.util.SecurityClientUtil;

public class ModelValidationActionHandler {
    protected final Config config;
    protected final ClusterService clusterService;
    protected final Logger logger = LogManager.getLogger(ModelValidationActionHandler.class);
    protected final TimeValue requestTimeout;
    protected final Client client;
    protected final SecurityClientUtil clientUtil;
    protected final NamedXContentRegistry xContentRegistry;
    protected final ActionListener<ValidateConfigResponse> listener;
    protected final Clock clock;
    protected final String validationType;
    protected final Settings settings;
    protected final User user;
    protected final AnalysisType context;
    private final SearchFeatureDao searchFeatureDao;
    private LongBounds timeRangeToSearchForConfiguredInterval;
    private final LatestTimeRetriever latestTimeRetriever;
    private final ValidationIssueType intervalIssueType;
    private AggregationPrep aggregationPrep;

    public ModelValidationActionHandler(ClusterService clusterService, Client client, SecurityClientUtil clientUtil, ActionListener<ValidateConfigResponse> listener, Config config, TimeValue requestTimeout, NamedXContentRegistry xContentRegistry, SearchFeatureDao searchFeatureDao, String validationType, Clock clock, Settings settings, User user, AnalysisType context, ValidationIssueType intervalIssueType) {
        this.clusterService = clusterService;
        this.client = client;
        this.clientUtil = clientUtil;
        this.listener = listener;
        this.config = config;
        this.requestTimeout = requestTimeout;
        this.xContentRegistry = xContentRegistry;
        this.searchFeatureDao = searchFeatureDao;
        this.validationType = validationType;
        this.clock = clock;
        this.settings = settings;
        this.user = user;
        this.context = context;
        this.timeRangeToSearchForConfiguredInterval = null;
        this.latestTimeRetriever = new LatestTimeRetriever(config, requestTimeout, clientUtil, client, user, context, searchFeatureDao);
        this.intervalIssueType = intervalIssueType;
        this.aggregationPrep = new AggregationPrep(searchFeatureDao, requestTimeout, config);
    }

    public void start() {
        ActionListener latestTimeListener = ActionListener.wrap(latestEntityAttributes -> this.getSampleRangesForValidationChecks((Optional)latestEntityAttributes.getLeft(), this.config, this.listener, (Map)latestEntityAttributes.getRight()), exception -> {
            this.logger.error("Failed to create search request for last data point", (Throwable)exception);
            this.listener.onFailure(exception);
        });
        this.latestTimeRetriever.checkIfHC((ActionListener<Pair<Optional<Long>, Map<String, Object>>>)latestTimeListener);
    }

    private void getSampleRangesForValidationChecks(Optional<Long> latestTime, Config config, ActionListener<ValidateConfigResponse> listener, Map<String, Object> topEntity) {
        if (!latestTime.isPresent() || latestTime.get() <= 0L) {
            listener.onFailure((Exception)new ValidationException(CommonMessages.TIME_FIELD_NOT_ENOUGH_HISTORICAL_DATA, ValidationIssueType.TIMEFIELD_FIELD, ValidationAspect.MODEL));
            return;
        }
        long timeRangeEnd = Math.min(Instant.now().toEpochMilli(), latestTime.get());
        new IntervalCalculation(config, this.requestTimeout, this.client, this.clientUtil, this.user, this.context, this.clock, this.searchFeatureDao, timeRangeEnd, topEntity).findInterval((ActionListener<IntervalTimeConfiguration>)ActionListener.wrap(interval -> this.processIntervalRecommendation((IntervalTimeConfiguration)interval, (Long)latestTime.get(), topEntity), arg_0 -> listener.onFailure(arg_0)));
    }

    private void processIntervalRecommendation(IntervalTimeConfiguration interval, long latestTime, Map<String, Object> topEntity) throws IOException {
        if (interval == null) {
            this.checkRawDataSparsity(latestTime);
        } else {
            if (((IntervalTimeConfiguration)this.config.getInterval()).gte(interval)) {
                this.logger.info("Using the current interval as there is enough dense data ");
                if (Instant.now().toEpochMilli() - latestTime > this.timeConfigToMilliSec(this.config.getWindowDelay())) {
                    this.sendWindowDelayRec(latestTime);
                    return;
                }
                this.listener.onResponse(null);
                return;
            }
            this.listener.onFailure((Exception)new ValidationException(CommonMessages.INTERVAL_REC + interval.getInterval(), this.intervalIssueType, ValidationAspect.MODEL, interval));
        }
    }

    private AggregationBuilder getBucketAggregation(long latestTime) {
        IntervalTimeConfiguration interval = (IntervalTimeConfiguration)this.config.getInterval();
        long intervalInMinutes = IntervalTimeConfiguration.getIntervalInMinute(interval);
        if (this.timeRangeToSearchForConfiguredInterval == null) {
            this.timeRangeToSearchForConfiguredInterval = this.aggregationPrep.getTimeRangeBounds(interval, latestTime);
        }
        return this.aggregationPrep.getHistogramAggregation((int)intervalInMinutes, this.timeRangeToSearchForConfiguredInterval);
    }

    private void checkRawDataSparsity(long latestTime) {
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().aggregation(aggregation).size(0).timeout(this.requestTimeout);
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processRawDataResults((SearchResponse)response, latestTime), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
    }

    private void processRawDataResults(SearchResponse response, long latestTime) {
        if (this.aggregationPrep.getHistorgramBucketHitRate(response) < 0.75) {
            this.listener.onFailure((Exception)new ValidationException(CommonMessages.RAW_DATA_TOO_SPARSE, ValidationIssueType.INDICES, ValidationAspect.MODEL));
        } else {
            this.checkDataFilterSparsity(latestTime);
        }
    }

    private void checkDataFilterSparsity(long latestTime) {
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime);
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.config.getFilterQuery());
        SearchSourceBuilder searchSourceBuilder = this.aggregationPrep.getSearchSourceBuilder((QueryBuilder)query, aggregation);
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processDataFilterResults((SearchResponse)response, latestTime), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
    }

    private void processDataFilterResults(SearchResponse response, long latestTime) {
        if (this.aggregationPrep.getHistorgramBucketHitRate(response) < 0.25) {
            this.listener.onFailure((Exception)new ValidationException(CommonMessages.FILTER_QUERY_TOO_SPARSE, ValidationIssueType.FILTER_QUERY, ValidationAspect.MODEL));
        } else if (this.config.isHighCardinality()) {
            this.getTopEntityForCategoryField(latestTime);
        } else {
            try {
                this.checkFeatureQueryDelegate(latestTime, new HashMap<String, Object>());
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
                this.listener.onFailure(ex);
            }
        }
    }

    private void getTopEntityForCategoryField(long latestTime) {
        ActionListener getTopEntityListener = ActionListener.wrap(topEntity -> this.checkCategoryFieldSparsity((Map)topEntity.getRight(), latestTime), exception -> {
            this.listener.onFailure(exception);
            this.logger.error("Failed to get top entity for categorical field", (Throwable)exception);
        });
        this.latestTimeRetriever.getTopEntity((ActionListener<Pair<Optional<Long>, Map<String, Object>>>)getTopEntityListener, latestTime);
    }

    private void checkCategoryFieldSparsity(Map<String, Object> topEntity, long latestTime) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(this.config.getFilterQuery());
        for (Map.Entry<String, Object> entry : topEntity.entrySet()) {
            query.filter((QueryBuilder)QueryBuilders.termQuery((String)entry.getKey(), (Object)entry.getValue()));
        }
        AggregationBuilder aggregation = this.getBucketAggregation(latestTime);
        SearchSourceBuilder searchSourceBuilder = this.aggregationPrep.getSearchSourceBuilder((QueryBuilder)query, aggregation);
        SearchRequest searchRequest = new SearchRequest(this.config.getIndices().toArray(new String[0])).source(searchSourceBuilder);
        ActionListener searchResponseListener = ActionListener.wrap(response -> this.processTopEntityResults((SearchResponse)response, latestTime, topEntity), arg_0 -> this.listener.onFailure(arg_0));
        this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
    }

    private void processTopEntityResults(SearchResponse response, long latestTime, Map<String, Object> topEntity) {
        if (this.aggregationPrep.getHistorgramBucketHitRate(response) < 0.25) {
            this.listener.onFailure((Exception)new ValidationException(CommonMessages.CATEGORY_FIELD_TOO_SPARSE, ValidationIssueType.CATEGORY, ValidationAspect.MODEL));
        } else {
            try {
                this.checkFeatureQueryDelegate(latestTime, topEntity);
            }
            catch (Exception ex) {
                this.logger.error((Object)ex);
                this.listener.onFailure(ex);
            }
        }
    }

    private void checkFeatureQueryDelegate(long latestTime, Map<String, Object> topEntity) throws IOException {
        if (this.config.isHighCardinality() && topEntity.isEmpty()) {
            this.listener.onFailure((Exception)new ValidationException(CommonMessages.CATEGORY_FIELD_TOO_SPARSE, ValidationIssueType.CATEGORY, ValidationAspect.MODEL));
            return;
        }
        ActionListener validateFeatureQueriesListener = ActionListener.wrap(response -> this.windowDelayRecommendation(latestTime), exception -> this.listener.onFailure((Exception)new ValidationException(exception.getMessage(), ValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.MODEL)));
        MultiResponsesDelegateActionListener multiFeatureQueriesResponseListener = new MultiResponsesDelegateActionListener(validateFeatureQueriesListener, this.config.getFeatureAttributes().size(), CommonMessages.FEATURE_QUERY_TOO_SPARSE, false);
        for (int i = 0; i < this.config.getFeatureAttributes().size(); ++i) {
            Feature feature = this.config.getFeatureAttributes().get(i);
            IntervalTimeConfiguration interval = (IntervalTimeConfiguration)this.config.getInterval();
            SearchRequest searchRequest = this.aggregationPrep.createSearchRequestForFeature(interval, this.aggregationPrep.getTimeRangeBounds(interval, latestTime), topEntity, i);
            ActionListener searchResponseListener = ActionListener.wrap(response -> {
                try {
                    double fullBucketRate = this.aggregationPrep.getBucketHitRate((SearchResponse)response, interval, latestTime);
                    if (fullBucketRate < 0.25) {
                        multiFeatureQueriesResponseListener.onFailure(new ValidationException(String.format(Locale.ROOT, "%s: %s", CommonMessages.FEATURE_QUERY_TOO_SPARSE, feature.getName()), ValidationIssueType.FEATURE_ATTRIBUTES, ValidationAspect.MODEL));
                    } else {
                        multiFeatureQueriesResponseListener.onResponse(new MergeableList<double[]>(new ArrayList<double[]>(Collections.singletonList(new double[]{fullBucketRate}))));
                    }
                }
                catch (ValidationException e) {
                    this.listener.onFailure((Exception)e);
                }
            }, e -> {
                this.logger.error(e);
                multiFeatureQueriesResponseListener.onFailure((Exception)new OpenSearchStatusException(CommonMessages.FEATURE_QUERY_TOO_SPARSE, RestStatus.BAD_REQUEST, (Throwable)e, new Object[0]));
            });
            this.clientUtil.asyncRequestWithInjectedSecurity(searchRequest, (arg_0, arg_1) -> ((Client)this.client).search(arg_0, arg_1), this.user, this.client, this.context, searchResponseListener);
        }
    }

    private void sendWindowDelayRec(long latestTimeInMillis) {
        long minutesSinceLastStamp = (long)Math.ceil((double)(Instant.now().toEpochMilli() - latestTimeInMillis) / 60000.0);
        this.listener.onFailure((Exception)new ValidationException(String.format(Locale.ROOT, CommonMessages.WINDOW_DELAY_REC, minutesSinceLastStamp, minutesSinceLastStamp), ValidationIssueType.WINDOW_DELAY, ValidationAspect.MODEL, new IntervalTimeConfiguration(minutesSinceLastStamp, ChronoUnit.MINUTES)));
    }

    private void windowDelayRecommendation(long latestTime) {
        if (Instant.now().toEpochMilli() - latestTime > this.timeConfigToMilliSec(this.config.getWindowDelay())) {
            this.sendWindowDelayRec(latestTime);
            return;
        }
        this.listener.onFailure((Exception)new ValidationException(CommonMessages.RAW_DATA_TOO_SPARSE, ValidationIssueType.INDICES, ValidationAspect.MODEL));
    }

    private Long timeConfigToMilliSec(TimeConfiguration timeConfig) {
        return Optional.ofNullable((IntervalTimeConfiguration)timeConfig).map(t -> t.toDuration().toMillis()).orElse(0L);
    }
}

