/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import java.util.ArrayList;
import java.util.List;
import net.osmand.data.QuadRect;

public class QuadTree<T> {
    private float ratio;
    private int maxDepth;
    private Node<T> root;

    public QuadTree(QuadRect r, int depth, float ratio) {
        this.ratio = ratio;
        this.root = new Node(r);
        this.maxDepth = depth;
    }

    public void insert(T data, QuadRect box) {
        int depth = 0;
        this.doInsertData(data, box, this.root, depth);
    }

    public void clear() {
        this.clear(this.root);
    }

    private void clear(Node<T> rt) {
        if (rt != null) {
            if (rt.data != null) {
                rt.data.clear();
            }
            if (rt.children != null) {
                for (Node c : rt.children) {
                    this.clear(c);
                }
            }
        }
    }

    public void insert(T data, float x, float y) {
        this.insert(data, new QuadRect(x, y, x, y));
    }

    public List<T> queryInBox(QuadRect box, List<T> result) {
        result.clear();
        this.queryNode(box, result, this.root);
        return result;
    }

    private void queryNode(QuadRect box, List<T> result, Node<T> node) {
        if (node != null && QuadRect.intersects(box, node.bounds)) {
            if (node.data != null) {
                result.addAll(node.data);
            }
            for (int k = 0; k < 4; ++k) {
                this.queryNode(box, result, node.children[k]);
            }
        }
    }

    private void doInsertData(T data, QuadRect box, Node<T> n, int depth) {
        if (++depth >= this.maxDepth) {
            if (n.data == null) {
                n.data = new ArrayList();
            }
            n.data.add(data);
        } else {
            QuadRect[] ext = new QuadRect[4];
            this.splitBox(n.bounds, ext);
            for (int i = 0; i < 4; ++i) {
                if (!ext[i].contains(box)) continue;
                if (n.children[i] == null) {
                    n.children[i] = new Node(ext[i]);
                }
                this.doInsertData(data, box, n.children[i], depth);
                return;
            }
            if (n.data == null) {
                n.data = new ArrayList();
            }
            n.data.add(data);
        }
    }

    void splitBox(QuadRect node_extent, QuadRect[] n) {
        double width = node_extent.width();
        double height = node_extent.height();
        double lox = node_extent.left;
        double loy = node_extent.top;
        double hix = node_extent.right;
        double hiy = node_extent.bottom;
        n[0] = new QuadRect(lox, loy, lox + width * (double)this.ratio, loy + height * (double)this.ratio);
        n[1] = new QuadRect(hix - width * (double)this.ratio, loy, hix, loy + height * (double)this.ratio);
        n[2] = new QuadRect(lox, hiy - height * (double)this.ratio, lox + width * (double)this.ratio, hiy);
        n[3] = new QuadRect(hix - width * (double)this.ratio, hiy - height * (double)this.ratio, hix, hiy);
    }

    private static class Node<T> {
        List<T> data = null;
        Node<T>[] children = null;
        QuadRect bounds;

        private Node(QuadRect b) {
            this.bounds = new QuadRect(b.left, b.top, b.right, b.bottom);
            this.children = new Node[4];
        }
    }
}

