/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._json;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.core.codecs;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules._json.Scanner$PyExposer;
import org.python.modules._json.ScannerDerived;
import org.python.modules._json._json;

@ExposedType(name="_json.scanner", base=PyObject.class)
public class Scanner
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    public final String __module__ = "_json";
    final String encoding;
    final boolean strict;
    final PyObject object_hook;
    final PyObject pairs_hook;
    final PyObject parse_float;
    final PyObject parse_int;
    final PyObject parse_constant;
    private static final String[] newArgs;

    public Scanner(PyObject context) {
        this(TYPE, context);
    }

    public Scanner(PyType subtype, PyObject context) {
        super(subtype);
        this.encoding = Scanner._castString(context.__getattr__("encoding"), "utf-8");
        this.strict = context.__getattr__("strict").__nonzero__();
        this.object_hook = context.__getattr__("object_hook");
        this.pairs_hook = context.__getattr__("object_pairs_hook");
        this.parse_float = context.__getattr__("parse_float");
        this.parse_int = context.__getattr__("parse_int");
        this.parse_constant = context.__getattr__("parse_constant");
    }

    @Override
    public PyObject __call__(PyObject string, PyObject idx) {
        return this._scan_once((PyString)string, idx.asInt());
    }

    @ExposedNew
    static PyObject Scanner___new__(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("scanner", args, keywords, newArgs, 1);
        PyObject context = ap.getPyObject(0);
        if (subtype == TYPE) {
            return new Scanner(context);
        }
        return new ScannerDerived(subtype, context);
    }

    private static boolean IS_WHITESPACE(int c) {
        return c == 32 || c == 9 || c == 10 || c == 13;
    }

    private static String _castString(PyObject pystr, String defaultValue) {
        if (pystr == Py.None) {
            return defaultValue;
        }
        if (!(pystr instanceof PyString)) {
            throw Py.TypeError("encoding is not a string");
        }
        String s = pystr.toString();
        return codecs.PyUnicode_EncodeASCII(s, s.length(), null);
    }

    static PyTuple valIndex(PyObject obj, int i) {
        return new PyTuple(obj, Py.newInteger(i));
    }

    public PyTuple _parse_object(PyString pystr, int idx) {
        PyString str = pystr;
        int end_idx = pystr.__len__() - 1;
        PyList pairs = new PyList();
        while (idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx))) {
            ++idx;
        }
        if (idx <= end_idx && str.getInt(idx) != 125) {
            while (idx <= end_idx) {
                if (str.getInt(idx) != 34) {
                    _json.raise_errmsg("Expecting property name", pystr, idx);
                }
                PyTuple key_idx = _json.scanstring(pystr, idx + 1, this.encoding, this.strict);
                PyObject key = key_idx.pyget(0);
                for (idx = key_idx.pyget(1).asInt(); idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx)); ++idx) {
                }
                if (idx > end_idx || str.getInt(idx) != 58) {
                    _json.raise_errmsg("Expecting : delimiter", pystr, idx);
                }
                ++idx;
                while (idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx))) {
                    ++idx;
                }
                PyTuple val_idx = this._scan_once(pystr, idx);
                PyObject val = val_idx.pyget(0);
                pairs.append(new PyTuple(key, val));
                for (idx = val_idx.pyget(1).asInt(); idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx)); ++idx) {
                }
                if (idx > end_idx || str.getInt(idx) == 125) break;
                if (str.getInt(idx) != 44) {
                    _json.raise_errmsg("Expecting , delimiter", pystr, idx);
                }
                ++idx;
                while (idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx))) {
                    ++idx;
                }
            }
        }
        if (idx > end_idx || str.getInt(idx) != 125) {
            _json.raise_errmsg("Expecting object", pystr, end_idx);
        }
        if (this.pairs_hook != Py.None) {
            return Scanner.valIndex(this.pairs_hook.__call__(pairs), idx + 1);
        }
        PyObject rval = new PyDictionary();
        rval.update(pairs);
        if (this.object_hook != Py.None) {
            rval = this.object_hook.__call__(rval);
        }
        return Scanner.valIndex(rval, idx + 1);
    }

    public PyTuple _parse_array(PyString pystr, int idx) {
        PyString str = pystr;
        int end_idx = pystr.__len__() - 1;
        PyList rval = new PyList();
        while (idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx))) {
            ++idx;
        }
        if (idx <= end_idx && str.getInt(idx) != 93) {
            while (idx <= end_idx) {
                PyTuple val_idx = this._scan_once(pystr, idx);
                PyObject val = val_idx.pyget(0);
                rval.append(val);
                for (idx = val_idx.pyget(1).asInt(); idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx)); ++idx) {
                }
                if (idx > end_idx || str.getInt(idx) == 93) break;
                if (str.getInt(idx) != 44) {
                    _json.raise_errmsg("Expecting , delimiter", pystr, idx);
                }
                ++idx;
                while (idx <= end_idx && Scanner.IS_WHITESPACE(str.getInt(idx))) {
                    ++idx;
                }
            }
        }
        if (idx > end_idx || str.getInt(idx) != 93) {
            _json.raise_errmsg("Expecting object", pystr, end_idx);
        }
        return Scanner.valIndex(rval, idx + 1);
    }

    public PyTuple _scan_once(PyString pystr, int idx) {
        PyString str = pystr;
        int length = pystr.__len__();
        if (idx >= length) {
            throw Py.StopIteration("");
        }
        switch (str.getInt(idx)) {
            case 34: {
                return _json.scanstring(pystr, idx + 1, this.encoding, this.strict);
            }
            case 123: {
                return this._parse_object(pystr, idx + 1);
            }
            case 91: {
                return this._parse_array(pystr, idx + 1);
            }
            case 110: {
                if (idx + 3 >= length || str.getInt(idx + 1) != 117 || str.getInt(idx + 2) != 108 || str.getInt(idx + 3) != 108) break;
                return Scanner.valIndex(Py.None, idx + 4);
            }
            case 116: {
                if (idx + 3 >= length || str.getInt(idx + 1) != 114 || str.getInt(idx + 2) != 117 || str.getInt(idx + 3) != 101) break;
                return Scanner.valIndex(Py.True, idx + 4);
            }
            case 102: {
                if (idx + 4 >= length || str.getInt(idx + 1) != 97 || str.getInt(idx + 2) != 108 || str.getInt(idx + 3) != 115 || str.getInt(idx + 4) != 101) break;
                return Scanner.valIndex(Py.False, idx + 5);
            }
            case 78: {
                if (idx + 2 >= length || str.getInt(idx + 1) != 97 || str.getInt(idx + 2) != 78) break;
                return this._parse_constant("NaN", idx + 3);
            }
            case 73: {
                if (idx + 7 >= length || str.getInt(idx + 1) != 110 || str.getInt(idx + 2) != 102 || str.getInt(idx + 3) != 105 || str.getInt(idx + 4) != 110 || str.getInt(idx + 5) != 105 || str.getInt(idx + 6) != 116 || str.getInt(idx + 7) != 121) break;
                return this._parse_constant("Infinity", idx + 8);
            }
            case 45: {
                if (idx + 8 >= length || str.getInt(idx + 1) != 73 || str.getInt(idx + 2) != 110 || str.getInt(idx + 3) != 102 || str.getInt(idx + 4) != 105 || str.getInt(idx + 5) != 110 || str.getInt(idx + 6) != 105 || str.getInt(idx + 7) != 116 || str.getInt(idx + 8) != 121) break;
                return this._parse_constant("-Infinity", idx + 9);
            }
        }
        return this._match_number(pystr, idx);
    }

    public PyTuple _parse_constant(String constant, int idx) {
        return Scanner.valIndex(this.parse_constant.__call__(Py.newString(constant)), idx);
    }

    public PyTuple _match_number(PyString pystr, int start) {
        PyString str = pystr;
        int end_idx = pystr.__len__() - 1;
        int idx = start;
        boolean is_float = false;
        if (str.getInt(idx) == 45 && ++idx > end_idx) {
            throw Py.StopIteration("");
        }
        if (str.getInt(idx) >= 49 && str.getInt(idx) <= 57) {
            ++idx;
            while (idx <= end_idx && str.getInt(idx) >= 48 && str.getInt(idx) <= 57) {
                ++idx;
            }
        } else if (str.getInt(idx) == 48) {
            ++idx;
        } else {
            throw Py.StopIteration("");
        }
        if (idx < end_idx && str.getInt(idx) == 46 && str.getInt(idx + 1) >= 48 && str.getInt(idx + 1) <= 57) {
            is_float = true;
            idx += 2;
            while (idx <= end_idx && str.getInt(idx) >= 48 && str.getInt(idx) <= 57) {
                ++idx;
            }
        }
        if (idx < end_idx && (str.getInt(idx) == 101 || str.getInt(idx) == 69)) {
            int e_start = idx++;
            if (idx < end_idx && (str.getInt(idx) == 45 || str.getInt(idx) == 43)) {
                ++idx;
            }
            while (idx <= end_idx && str.getInt(idx) >= 48 && str.getInt(idx) <= 57) {
                ++idx;
            }
            if (str.getInt(idx - 1) >= 48 && str.getInt(idx - 1) <= 57) {
                is_float = true;
            } else {
                idx = e_start;
            }
        }
        PyString numstr = (PyString)str.__getslice__(Py.newInteger(start), Py.newInteger(idx));
        if (is_float) {
            return Scanner.valIndex(this.parse_float.__call__(numstr), idx);
        }
        return Scanner.valIndex(this.parse_int.__call__(numstr), idx);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal;
        if (this.object_hook != null && (retVal = visit.visit(this.object_hook, arg)) != 0) {
            return retVal;
        }
        if (this.pairs_hook != null && (retVal = visit.visit(this.pairs_hook, arg)) != 0) {
            return retVal;
        }
        if (this.parse_float != null && (retVal = visit.visit(this.parse_float, arg)) != 0) {
            return retVal;
        }
        if (this.parse_int != null && (retVal = visit.visit(this.parse_int, arg)) != 0) {
            return retVal;
        }
        return this.parse_constant != null ? visit.visit(this.parse_constant, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.object_hook || ob == this.pairs_hook || ob == this.parse_float || ob == this.parse_int || ob == this.parse_constant);
    }

    static {
        PyType.addBuilder(Scanner.class, new Scanner$PyExposer());
        TYPE = PyType.fromClass(Scanner.class);
        newArgs = new String[]{"context"};
    }
}

