# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from six import with_metaclass
from azure.core import CaseInsensitiveEnumMeta


class AccessRightsDescription(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Rights that this key has.
    """

    SERVICE_CONFIG = "ServiceConfig"
    ENROLLMENT_READ = "EnrollmentRead"
    ENROLLMENT_WRITE = "EnrollmentWrite"
    DEVICE_CONNECT = "DeviceConnect"
    REGISTRATION_STATUS_READ = "RegistrationStatusRead"
    REGISTRATION_STATUS_WRITE = "RegistrationStatusWrite"

class AllocationPolicy(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Allocation policy to be used by this provisioning service.
    """

    HASHED = "Hashed"
    GEO_LATENCY = "GeoLatency"
    STATIC = "Static"

class CertificatePurpose(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):

    CLIENT_AUTHENTICATION = "clientAuthentication"
    SERVER_AUTHENTICATION = "serverAuthentication"

class CreatedByType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The type of identity that created the resource.
    """

    USER = "User"
    APPLICATION = "Application"
    MANAGED_IDENTITY = "ManagedIdentity"
    KEY = "Key"

class IotDpsSku(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Sku name.
    """

    S1 = "S1"

class IpFilterActionType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The desired action for requests captured by this rule.
    """

    ACCEPT = "Accept"
    REJECT = "Reject"

class IpFilterTargetType(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Target for requests captured by this rule.
    """

    ALL = "all"
    SERVICE_API = "serviceApi"
    DEVICE_API = "deviceApi"

class NameUnavailabilityReason(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """specifies the reason a name is unavailable
    """

    INVALID = "Invalid"
    ALREADY_EXISTS = "AlreadyExists"

class PrivateLinkServiceConnectionStatus(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """The status of a private endpoint connection
    """

    PENDING = "Pending"
    APPROVED = "Approved"
    REJECTED = "Rejected"
    DISCONNECTED = "Disconnected"

class PublicNetworkAccess(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Whether requests from Public Network are allowed
    """

    ENABLED = "Enabled"
    DISABLED = "Disabled"

class State(with_metaclass(CaseInsensitiveEnumMeta, str, Enum)):
    """Current state of the provisioning service.
    """

    ACTIVATING = "Activating"
    ACTIVE = "Active"
    DELETING = "Deleting"
    DELETED = "Deleted"
    ACTIVATION_FAILED = "ActivationFailed"
    DELETION_FAILED = "DeletionFailed"
    TRANSITIONING = "Transitioning"
    SUSPENDING = "Suspending"
    SUSPENDED = "Suspended"
    RESUMING = "Resuming"
    FAILING_OVER = "FailingOver"
    FAILOVER_FAILED = "FailoverFailed"
