/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.skin.Context2D;

final class NotesBoxes
extends GraphicalElement
implements InGroupable {
    private final List<NoteBox> notes = new ArrayList<NoteBox>();
    private final List<ParticipantBox> participants1 = new ArrayList<ParticipantBox>();
    private final List<ParticipantBox> participants2 = new ArrayList<ParticipantBox>();

    NotesBoxes(double startingY) {
        super(startingY);
    }

    public void add(NoteBox noteBox, ParticipantBox participantBox1, ParticipantBox participantBox2) {
        this.notes.add(noteBox);
        this.participants1.add(participantBox1);
        if (participantBox2 == null) {
            this.participants2.add(participantBox1);
        } else {
            this.participants2.add(participantBox2);
        }
    }

    public void ensureConstraints(StringBounder stringBounder, ConstraintSet constraintSet) {
        for (int i = 0; i < this.notes.size(); ++i) {
            NoteBox noteBox = this.notes.get(i);
            ParticipantBox participantBox1 = this.participants1.get(i);
            ParticipantBox participantBox2 = this.participants2.get(i);
            double width = noteBox.getPreferredWidth(stringBounder);
            constraintSet.getConstraintBefore(participantBox1).ensureValue(width / 2.0);
            constraintSet.getConstraintAfter(participantBox2).ensureValue(width / 2.0);
            for (int j = i + 1; j < this.notes.size(); ++j) {
                NoteBox noteBox2 = this.notes.get(j);
                ParticipantBox otherParticipantBox1 = this.participants1.get(j);
                double width2 = noteBox2.getPreferredWidth(stringBounder);
                if (participantBox2 == otherParticipantBox1) continue;
                constraintSet.getConstraint(participantBox2, otherParticipantBox1).ensureValue((width + width2) / 2.0);
            }
        }
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        double result = Double.MAX_VALUE;
        for (NoteBox n : this.notes) {
            double m4 = n.getMinX(stringBounder);
            if (!(m4 < result)) continue;
            result = m4;
        }
        return result;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        double result = -1.7976931348623157E308;
        for (NoteBox n : this.notes) {
            double m4 = n.getMaxX(stringBounder);
            if (!(m4 > result)) continue;
            result = m4;
        }
        return result;
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        for (NoteBox n : this.notes) {
            n.drawInternalU(ug, maxX, context);
        }
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        double result = Double.MAX_VALUE;
        for (NoteBox n : this.notes) {
            double m4 = n.getStartingX(stringBounder);
            if (!(m4 < result)) continue;
            result = m4;
        }
        return result;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double result = this.getMaxX(stringBounder) - this.getMinX(stringBounder);
        return result;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        double result = 0.0;
        for (NoteBox n : this.notes) {
            double m4 = n.getPreferredHeight(stringBounder);
            if (!(m4 > result)) continue;
            result = m4;
        }
        return result;
    }
}

