/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.util.EnumMap;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.klimt.UGroupType;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.FontParam;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockInEllipse;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.RotatedEllipse;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.url.Url;

public class EntityImageUseCase
extends AbstractEntityImage {
    private final TextBlock desc;
    private final Url url;

    public EntityImageUseCase(Entity entity, PortionShower portionShower) {
        super(entity);
        Stereotype stereotype = entity.getStereotype();
        Style style = this.getStyle();
        HorizontalAlignment align = style.getHorizontalAlignment();
        TextBlock tmp = BodyFactory.create2(this.getSkinParam().getDefaultTextAlignment(align), entity.getDisplay(), this.getSkinParam(), stereotype, entity, this.getStyle());
        if (stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, entity)) {
            this.desc = tmp;
        } else {
            TextBlock stereo = stereotype.getSprite(this.getSkinParam()) != null ? stereotype.getSprite(this.getSkinParam()) : Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.USECASE_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
            this.desc = TextBlockUtils.mergeTB(stereo, tmp, HorizontalAlignment.CENTER);
        }
        this.url = entity.getUrl99();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new TextBlockInEllipse(this.desc, stringBounder).calculateDimension(stringBounder);
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Style style = this.getStyle();
        double shadow = style.value(PName.Shadowing).asDouble();
        TextBlockInEllipse ellipse = new TextBlockInEllipse(this.desc, stringBounder);
        ellipse.setDeltaShadow(shadow);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        ug = ug.apply(this.getStyle().getStroke(this.getEntity().getColors()));
        HColor linecolor = this.getLineColor();
        ug = ug.apply(linecolor);
        HColor backcolor = this.getBackColor();
        ug = ug.apply(backcolor.bg());
        MyUGraphicEllipse ug2 = new MyUGraphicEllipse(ug, 0.0, 0.0, ellipse.getUEllipse());
        EnumMap<UGroupType, String> typeIDent = new EnumMap<UGroupType, String>(UGroupType.class);
        typeIDent.put(UGroupType.CLASS, "elem " + this.getEntity().getName() + " selected");
        typeIDent.put(UGroupType.ID, "elem_" + this.getEntity().getName());
        ug.startGroup(typeIDent);
        ellipse.drawU(ug2);
        ug2.closeGroup();
        if (this.getEntity().getLeafType() == LeafType.USECASE_BUSINESS) {
            this.specialBusiness(ug, ellipse.getUEllipse());
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private void specialBusiness(UGraphic ug, UEllipse frontier) {
        RotatedEllipse rotatedEllipse = new RotatedEllipse(frontier, 0.7853981633974483);
        double theta1 = 0.3490658503988659;
        double theta2 = rotatedEllipse.getOtherTheta(0.3490658503988659);
        UEllipse frontier2 = frontier.scale(0.99);
        XPoint2D p1 = frontier2.getPointAtAngle(-0.3490658503988659);
        XPoint2D p2 = frontier2.getPointAtAngle(-theta2);
        this.drawLine(ug, p1, p2);
    }

    private void specialBusiness0(UGraphic ug, UEllipse frontier) {
        double c = frontier.getWidth() / frontier.getHeight();
        double ouverture = 1.5707963267948966;
        XPoint2D p1 = frontier.getPointAtAngle(this.getTrueAngle(c, -0.7853981633974483));
        XPoint2D p2 = frontier.getPointAtAngle(this.getTrueAngle(c, 2.356194490192345));
        this.drawLine(ug, p1, p2);
    }

    private void drawLine(UGraphic ug, XPoint2D p1, XPoint2D p2) {
        ug = ug.apply(UTranslate.point(p1));
        ug.draw(new ULine(p2.getX() - p1.getX(), p2.getY() - p1.getY()));
    }

    private double getTrueAngle(double c, double gamma) {
        return Math.atan2(Math.sin(gamma), Math.cos(gamma) / c);
    }

    private HColor getBackColor() {
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            Colors colors = this.getEntity().getColors();
            Style style = this.getStyle();
            style = style.eventuallyOverride(colors);
            backcolor = style.value(PName.BackGroundColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        return backcolor;
    }

    private Style getStyle() {
        return this.getDefaultStyleDefinition().getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    private StyleSignature getDefaultStyleDefinition() {
        LeafType type = this.getEntity().getLeafType();
        if (type == LeafType.USECASE_BUSINESS) {
            return StyleSignatureBasic.of(SName.root, SName.element, SName.componentDiagram, SName.usecase, SName.business).withTOBECHANGED(this.getStereo());
        }
        return StyleSignatureBasic.of(SName.root, SName.element, SName.componentDiagram, SName.usecase).withTOBECHANGED(this.getStereo());
    }

    private HColor getLineColor() {
        HColor linecolor = this.getEntity().getColors().getColor(ColorType.LINE);
        if (linecolor == null) {
            Style style = this.getStyle();
            linecolor = style.value(PName.LineColor).asColor(this.getSkinParam().getIHtmlColorSet());
        }
        return linecolor;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.OVAL;
    }

    static class MyUGraphicEllipse
    extends AbstractUGraphicHorizontalLine {
        private final double startingX;
        private final double yTheoricalPosition;
        private final UEllipse ellipse;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicEllipse(ug, this.startingX, this.yTheoricalPosition, this.ellipse);
        }

        MyUGraphicEllipse(UGraphic ug, double startingX, double yTheoricalPosition, UEllipse ellipse) {
            super(ug);
            this.startingX = startingX;
            this.ellipse = ellipse;
            this.yTheoricalPosition = yTheoricalPosition;
        }

        private double getNormalized(double y) {
            if (y < this.yTheoricalPosition) {
                throw new IllegalArgumentException();
            }
            if ((y -= this.yTheoricalPosition) > this.ellipse.getHeight()) {
                throw new IllegalArgumentException();
            }
            return y;
        }

        private double getStartingXInternal(double y) {
            return this.startingX + this.ellipse.getStartingX(this.getNormalized(y));
        }

        private double getEndingXInternal(double y) {
            return this.startingX + this.ellipse.getEndingX(this.getNormalized(y));
        }

        private Stencil getStencil2(UTranslate translate) {
            final double dy = translate.getDy();
            return new Stencil(){
                final /* synthetic */ MyUGraphicEllipse this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public double getStartingX(StringBounder stringBounder, double y) {
                    return this.this$0.getStartingXInternal(y + dy);
                }

                @Override
                public double getEndingX(StringBounder stringBounder, double y) {
                    return this.this$0.getEndingXInternal(y + dy);
                }
            };
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            UStroke stroke = UStroke.withThickness(1.5);
            line.drawLineInternal(ug.apply(translate), this.getStencil2(translate), 0.0, stroke);
        }
    }
}

