/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.tilesfx.tools;

import java.util.List;

public class Point
implements Comparable<Point> {
    public double x;
    public double y;

    public Point() {
        this(-1.0, -1.0);
    }

    public Point(Point P) {
        this(P.getX(), P.getY());
    }

    public Point(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public double getX() {
        return this.x;
    }

    public void setX(double X) {
        this.x = X;
    }

    public double getY() {
        return this.y;
    }

    public void setY(double Y) {
        this.y = Y;
    }

    public void set(Point P) {
        this.x = P.x;
        this.y = P.y;
    }

    public void set(double X, double Y) {
        this.x = X;
        this.y = Y;
    }

    public double distanceTo(Point P) {
        return Point.distance(P.getX(), P.getY(), this.x, this.y);
    }

    public double distanceTo(double X, double Y) {
        return Point.distance(X, Y, this.x, this.y);
    }

    public double distanceSquareTo(Point P) {
        return Point.distanceSquare(P.getX(), P.getY(), this.x, this.y);
    }

    public Point add(Point P) {
        return this.add(P.getX(), P.getY());
    }

    public Point add(double X, double Y) {
        return new Point(this.getX() + X, this.getY() + Y);
    }

    public Point subtract(Point P) {
        return this.subtract(P.getX(), P.getY());
    }

    public Point subtract(double X, double Y) {
        return new Point(this.getX() - X, this.getY() - Y);
    }

    public Point multiply(double FACTOR) {
        return new Point(this.getX() * FACTOR, this.getY() * FACTOR);
    }

    public Point normalize() {
        double mag = this.magnitude();
        if (mag == 0.0) {
            return new Point(0.0, 0.0);
        }
        return new Point(this.x / mag, this.y / mag);
    }

    public Point midpoint(Point P) {
        return this.midpoint(P.getX(), P.getY());
    }

    public Point midpoint(double X, double Y) {
        return new Point(X + (this.getX() - X) / 2.0, Y + (this.getY() - Y) / 2.0);
    }

    public double angle(Point P) {
        return this.angle(P.getX(), P.getY());
    }

    public double angle(double X, double Y) {
        double ay;
        double ax = this.getX();
        double delta = (ax * X + (ay = this.getY()) * Y) / Math.sqrt((ax * ax + ay * ay) * (X * X + Y * Y));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double angle(Point P1, Point P2) {
        double by;
        double x = this.getX();
        double y = this.getY();
        double ax = P1.getX() - x;
        double ay = P1.getY() - y;
        double bx = P2.getX() - x;
        double delta = (ax * bx + ay * (by = P2.getY() - y)) / Math.sqrt((ax * ax + ay * ay) * (bx * bx + by * by));
        if (delta > 1.0) {
            return 0.0;
        }
        if (delta < -1.0) {
            return 180.0;
        }
        return Math.toDegrees(Math.acos(delta));
    }

    public double magnitude() {
        double x = this.getX();
        double y = this.getY();
        return Math.sqrt(x * x + y * y);
    }

    public double dotProduct(Point VECTOR) {
        return this.dotProduct(VECTOR.getX(), VECTOR.getY());
    }

    public double dotProduct(double X, double Y) {
        return this.getX() * X + this.getY() * Y;
    }

    public static double distance(Point P1, Point P2) {
        return Point.distance(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double distance(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return Math.sqrt(deltaX * deltaX + deltaY * deltaY);
    }

    public static double distanceSquare(Point P1, Point P2) {
        return Point.distanceSquare(P1.getX(), P1.getY(), P2.getX(), P2.getY());
    }

    public static double distanceSquare(double X1, double Y1, double X2, double Y2) {
        double deltaX = X2 - X1;
        double deltaY = Y2 - Y1;
        return deltaX * deltaX + deltaY * deltaY;
    }

    public static Point nearestWithinRadius(Point P, List<Point> POINTS, double RADIUS) {
        double radiusSquare = RADIUS * RADIUS;
        Point p = POINTS.get(0);
        for (int i = 0; i < POINTS.size(); ++i) {
            double distanceSquare = POINTS.get(i).distanceSquareTo(P);
            if (!(distanceSquare < radiusSquare) || !(distanceSquare < p.distanceSquareTo(P))) continue;
            p = POINTS.get(i);
        }
        return p;
    }

    public static Point nearest(Point P, List<Point> POINTS) {
        Point p = POINTS.get(0);
        for (int i = 0; i < POINTS.size(); ++i) {
            if (!(POINTS.get(i).distanceSquareTo(P) < p.distanceSquareTo(P))) continue;
            p = POINTS.get(i);
        }
        return p;
    }

    @Override
    public int compareTo(Point P) {
        return this.x != P.getX() ? Double.compare(this.x, P.x) : Double.compare(this.y, P.y);
    }

    public int hashCode() {
        int tmp = (int)(this.y + (this.x + 1.0) / 2.0);
        return Math.abs((int)(this.x + (double)(tmp * tmp)));
    }

    public boolean equals(Object OBJ) {
        if (OBJ == this) {
            return true;
        }
        if (OBJ instanceof Point) {
            Point p = (Point)OBJ;
            return Double.compare(this.x, p.getX()) == 0 && Double.compare(this.y, p.getY()) == 0;
        }
        return false;
    }

    public String toString() {
        return "{ " + "\"x\": " + this.x + ", " + "\"y\": " + this.y + " }";
    }
}

