# Rootfs

Scan a root filesystem (such as a host machine, a virtual machine image, or an unpacked container image filesystem).

```bash
$ trivy rootfs /path/to/rootfs
```

## From Inside Containers
Scan your container from inside the container.

```bash
$ docker run --rm -it alpine:3.11
/ # curl -sfL https://raw.githubusercontent.com/aquasecurity/trivy/main/contrib/install.sh | sh -s -- -b /usr/local/bin
/ # trivy rootfs /
```

<details>
<summary>Result</summary>

```
2021-03-08T05:22:26.378Z        INFO    Need to update DB
2021-03-08T05:22:26.380Z        INFO    Downloading DB...
20.37 MiB / 20.37 MiB [-------------------------------------------------------------------------------------------------------------------------------------] 100.00% 8.24 MiB p/s 2s
2021-03-08T05:22:30.134Z        INFO    Detecting Alpine vulnerabilities...
2021-03-08T05:22:30.138Z        INFO    Trivy skips scanning programming language libraries because no supported file was detected

313430f09696 (alpine 3.11.7)
============================
Total: 6 (UNKNOWN: 0, LOW: 0, MEDIUM: 0, HIGH: 6, CRITICAL: 0)

+--------------+------------------+----------+-------------------+---------------+---------------------------------------+
|   LIBRARY    | VULNERABILITY ID | SEVERITY | INSTALLED VERSION | FIXED VERSION |                 TITLE                 |
+--------------+------------------+----------+-------------------+---------------+---------------------------------------+
| libcrypto1.1 | CVE-2021-23839   | HIGH     | 1.1.1i-r0         | 1.1.1j-r0     | openssl: incorrect SSLv2              |
|              |                  |          |                   |               | rollback protection                   |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23839 |
+              +------------------+          +                   +               +---------------------------------------+
|              | CVE-2021-23840   |          |                   |               | openssl: integer                      |
|              |                  |          |                   |               | overflow in CipherUpdate              |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23840 |
+              +------------------+          +                   +               +---------------------------------------+
|              | CVE-2021-23841   |          |                   |               | openssl: NULL pointer dereference     |
|              |                  |          |                   |               | in X509_issuer_and_serial_hash()      |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23841 |
+--------------+------------------+          +                   +               +---------------------------------------+
| libssl1.1    | CVE-2021-23839   |          |                   |               | openssl: incorrect SSLv2              |
|              |                  |          |                   |               | rollback protection                   |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23839 |
+              +------------------+          +                   +               +---------------------------------------+
|              | CVE-2021-23840   |          |                   |               | openssl: integer                      |
|              |                  |          |                   |               | overflow in CipherUpdate              |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23840 |
+              +------------------+          +                   +               +---------------------------------------+
|              | CVE-2021-23841   |          |                   |               | openssl: NULL pointer dereference     |
|              |                  |          |                   |               | in X509_issuer_and_serial_hash()      |
|              |                  |          |                   |               | -->avd.aquasec.com/nvd/cve-2021-23841 |
+--------------+------------------+----------+-------------------+---------------+---------------------------------------+
```

</details>

## Other Examples
- [Embed in Dockerfile][embedding]
- [Unpacked container image filesystem][unpacked]

[embedding]: ../../advanced/container/embed-in-dockerfile.md
[unpacked]: ../../advanced/container/unpacked-filesystem.md
