/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import tim.prune.config.Config;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.colour.DiscretePointColourer;

public class DateColourer
extends DiscretePointColourer {
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateInstance();
    private TimeZone _selectedTimezone = null;

    public DateColourer(Color color, Color color2, int n) {
        super(color, color2, n);
    }

    @Override
    public synchronized void calculateColours(TrackInfo trackInfo) {
        String string = Config.getConfigString("prune.timezoneid");
        this._selectedTimezone = string == null || string.equals("") ? TimeZone.getDefault() : TimeZone.getTimeZone(string);
        Track track = trackInfo == null ? null : trackInfo.getTrack();
        int n = track == null ? 0 : track.getNumPoints();
        this.init(n);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(20);
        String string2 = null;
        int n2 = -1;
        int n3 = 0;
        while (n3 < n) {
            DataPoint dataPoint = track.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                int n4 = 0;
                String string3 = this.getDate(dataPoint.getTimestamp());
                if (string3 != null) {
                    if (string3.equals(string2)) {
                        n4 = n2;
                    } else {
                        Integer n5 = (Integer)hashMap.get(string3);
                        if (n5 == null) {
                            n4 = hashMap.size() + 1;
                            hashMap.put(string3, n4);
                        } else {
                            n4 = n5;
                        }
                        string2 = string3;
                        n2 = n4;
                    }
                }
                this.setColour(n3, n4);
            }
            ++n3;
        }
        this.generateDiscreteColours(hashMap.size() + 1);
    }

    private String getDate(Timestamp timestamp) {
        if (timestamp == null || !timestamp.isValid()) {
            return null;
        }
        Calendar calendar = timestamp.getCalendar(null);
        DEFAULT_DATE_FORMAT.setTimeZone(this._selectedTimezone);
        return DEFAULT_DATE_FORMAT.format(calendar.getTime());
    }
}

