"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QueryService = void 0;
require("core-js/modules/es.regexp.flags.js");
require("core-js/modules/es.typed-array.set.js");
var _lodash = _interopRequireDefault(require("lodash"));
function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }
function _defineProperty(obj, key, value) { key = _toPropertyKey(key); if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
function _toPropertyKey(arg) { var key = _toPrimitive(arg, "string"); return typeof key === "symbol" ? key : String(key); }
function _toPrimitive(input, hint) { if (typeof input !== "object" || input === null) return input; var prim = input[Symbol.toPrimitive]; if (prim !== undefined) { var res = prim.call(input, hint || "default"); if (typeof res !== "object") return res; throw new TypeError("@@toPrimitive must return a primitive value."); } return (hint === "string" ? String : Number)(input); } /*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
class QueryService {
  constructor(_client) {
    _defineProperty(this, "client", void 0);
    _defineProperty(this, "describeQueryInternal", async (request, format, responseFormat, context) => {
      try {
        const queryRequest = {
          query: request.body
        };
        const params = {
          body: JSON.stringify(queryRequest)
        };
        let client = this.client;
        let queryResponse;
        const {
          dataSourceMDSId
        } = request.query;
        if (dataSourceMDSId) {
          client = context.dataSource.opensearch.legacy.getClient(dataSourceMDSId);
          queryResponse = await client.callAPI(format, params);
        } else {
          queryResponse = await this.client.asScoped(request).callAsCurrentUser(format, params);
        }
        return {
          data: {
            ok: true,
            resp: _lodash.default.isEqual(responseFormat, 'json') ? JSON.stringify(queryResponse) : queryResponse
          }
        };
      } catch (err) {
        this.logger.info('error describeQueryInternal');
        this.logger.info(err);
        return {
          data: {
            ok: false,
            resp: err.message,
            body: err.body
          }
        };
      }
    });
    _defineProperty(this, "describeSQLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.sqlQuery', 'json', context);
    });
    _defineProperty(this, "describePPLQuery", async (context, request) => {
      return this.describeQueryInternal(request, 'ppl.pplQuery', 'json', context);
    });
    this.client = _client;
  }
}
exports.QueryService = QueryService;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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