/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ValidateActions;
import org.opensearch.action.support.master.AcknowledgedRequest;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.knn.indices.ModelMetadata;

public class UpdateModelMetadataRequest
extends AcknowledgedRequest<UpdateModelMetadataRequest> {
    private String modelId;
    private boolean isRemoveRequest;
    private ModelMetadata modelMetadata;

    public UpdateModelMetadataRequest(StreamInput in) throws IOException {
        super(in);
        this.modelId = in.readString();
        this.isRemoveRequest = in.readBoolean();
        if (!this.isRemoveRequest) {
            this.modelMetadata = new ModelMetadata(in);
        }
    }

    public UpdateModelMetadataRequest(String modelId, boolean isRemoveRequest, ModelMetadata modelMetadata) {
        this.modelId = modelId;
        this.isRemoveRequest = isRemoveRequest;
        this.modelMetadata = modelMetadata;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.modelId.isEmpty()) {
            validationException = ValidateActions.addValidationError((String)"Missing model ID", validationException);
        }
        if (!this.isRemoveRequest && this.modelMetadata == null) {
            validationException = ValidateActions.addValidationError((String)"Model metadata must be passed on add", (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public String getModelId() {
        return this.modelId;
    }

    public boolean isRemoveRequest() {
        return this.isRemoveRequest;
    }

    public ModelMetadata getModelMetadata() {
        return this.modelMetadata;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.modelId);
        out.writeBoolean(this.isRemoveRequest);
        if (!this.isRemoveRequest) {
            this.modelMetadata.writeTo(out);
        }
    }
}

