/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.agents;

import com.google.common.annotations.VisibleForTesting;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.get.GetRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.client.Client;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.index.IndexNotFoundException;
import org.opensearch.ml.common.agent.MLAgent;
import org.opensearch.ml.common.transport.agent.MLAgentGetRequest;
import org.opensearch.ml.common.transport.agent.MLAgentGetResponse;
import org.opensearch.ml.utils.MLNodeUtils;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;

public class GetAgentTransportAction
extends HandledTransportAction<ActionRequest, MLAgentGetResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(GetAgentTransportAction.class);
    private final Client client;
    private final NamedXContentRegistry xContentRegistry;
    private final ClusterService clusterService;

    @Inject
    public GetAgentTransportAction(TransportService transportService, ActionFilters actionFilters, Client client, ClusterService clusterService, NamedXContentRegistry xContentRegistry) {
        super("cluster:admin/opensearch/ml/agents/get", transportService, actionFilters, MLAgentGetRequest::new);
        this.client = client;
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<MLAgentGetResponse> actionListener) {
        MLAgentGetRequest mlAgentGetRequest = MLAgentGetRequest.fromActionRequest((ActionRequest)request);
        String agentId = mlAgentGetRequest.getAgentId();
        GetRequest getRequest = new GetRequest(".plugins-ml-agent").id(agentId);
        boolean isSuperAdmin = this.isSuperAdminUserWrapper(this.clusterService, this.client);
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            this.client.get(getRequest, ActionListener.runBefore((ActionListener)ActionListener.wrap(r -> {
                log.debug("Completed Get Agent Request, id:{}", (Object)agentId);
                if (r != null && r.isExists()) {
                    try (XContentParser parser = MLNodeUtils.createXContentParserFromRegistry(this.xContentRegistry, r.getSourceAsBytesRef());){
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
                        MLAgent mlAgent = MLAgent.parse((XContentParser)parser);
                        if (mlAgent.getIsHidden().booleanValue() && !isSuperAdmin) {
                            actionListener.onFailure((Exception)new OpenSearchStatusException("User doesn't have privilege to perform this operation on this agent", RestStatus.FORBIDDEN, new Object[0]));
                        } else {
                            actionListener.onResponse((Object)MLAgentGetResponse.builder().mlAgent(mlAgent).build());
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to parse ml agent" + r.getId(), (Throwable)e);
                        actionListener.onFailure(e);
                    }
                } else {
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to find agent with the provided agent id: " + agentId, RestStatus.NOT_FOUND, new Object[0]));
                }
            }, e -> {
                if (e instanceof IndexNotFoundException) {
                    log.error("Failed to get agent index", (Throwable)e);
                    actionListener.onFailure((Exception)new OpenSearchStatusException("Failed to get agent index", RestStatus.NOT_FOUND, new Object[0]));
                } else {
                    log.error("Failed to get ML agent " + agentId, (Throwable)e);
                    actionListener.onFailure(e);
                }
            }), () -> ((ThreadContext.StoredContext)context).restore()));
        }
        catch (Exception e2) {
            log.error("Failed to get ML agent " + agentId, (Throwable)e2);
            actionListener.onFailure(e2);
        }
    }

    @VisibleForTesting
    boolean isSuperAdminUserWrapper(ClusterService clusterService, Client client) {
        return RestActionUtils.isSuperAdminUser(clusterService, client);
    }
}

