/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.update;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Optional;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.protege.editor.core.plugin.PluginUtilities;

public class PluginInfo {
    private Bundle b;
    private final String id;
    private final Version availableVersion;
    private final URL downloadURL;
    private Optional<URL> readmeURI = Optional.empty();
    private Optional<String> author = Optional.empty();
    private Optional<String> license = Optional.empty();
    private Optional<String> label = Optional.empty();

    public PluginInfo(String id, Version availableVersion, URL downloadURL) {
        this.id = (String)Preconditions.checkNotNull((Object)id);
        this.availableVersion = (Version)Preconditions.checkNotNull((Object)availableVersion);
        this.downloadURL = (URL)Preconditions.checkNotNull((Object)downloadURL);
    }

    public void setPluginDescriptor(Bundle b) {
        this.b = b;
    }

    public void setReadmeURI(URL readmeURI) {
        this.readmeURI = Optional.ofNullable(readmeURI);
    }

    public void setAuthor(String author) {
        this.author = Optional.ofNullable(author);
    }

    public void setLicense(String license) {
        this.license = Optional.ofNullable(license);
    }

    public Version getAvailableVersion() {
        return this.availableVersion;
    }

    public Optional<Version> getCurrentVersion() {
        if (this.b == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(PluginUtilities.getBundleVersion(this.b));
    }

    public URL getDownloadURL() {
        return this.downloadURL;
    }

    public Bundle getPluginDescriptor() {
        return this.b;
    }

    public Optional<URL> getReadmeURI() {
        return this.readmeURI;
    }

    public Optional<String> getAuthor() {
        return this.author;
    }

    public Optional<String> getLicense() {
        return this.license;
    }

    public String getId() {
        return this.id;
    }

    public void setLabel(String label) {
        this.label = Optional.ofNullable(label);
    }

    public String getLabel() {
        return this.label.orElse(this.id);
    }

    public String toString() {
        return "<PluginInfo: " + this.id + ">";
    }
}

