/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.TooManyListenersException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class FileDrop {
    private transient Border normalBorder;
    private transient DropTargetListener dropListener;
    private static Boolean supportsDnD;
    private static Color defaultBorderColor;
    private static String ZERO_CHAR_STRING;

    public FileDrop(Component c, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), true, listener);
    }

    public FileDrop(Component c, boolean recursive, Listener listener) {
        this(null, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), false, listener);
    }

    public FileDrop(PrintStream out, Component c, boolean recursive, Listener listener) {
        this(out, c, BorderFactory.createMatteBorder(2, 2, 2, 2, defaultBorderColor), recursive, listener);
    }

    public FileDrop(Component c, Border dragBorder, Listener listener) {
        this(null, c, dragBorder, false, listener);
    }

    public FileDrop(Component c, Border dragBorder, boolean recursive, Listener listener) {
        this(null, c, dragBorder, recursive, listener);
    }

    public FileDrop(PrintStream out, Component c, Border dragBorder, Listener listener) {
        this(out, c, dragBorder, false, listener);
    }

    public FileDrop(final PrintStream out, final Component c, final Border dragBorder, boolean recursive, final Listener listener) {
        if (FileDrop.supportsDnD()) {
            this.dropListener = new DropTargetListener(){

                @Override
                public void dragEnter(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dragEnter event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            FileDrop.this.normalBorder = jc.getBorder();
                            FileDrop.log(out, "FileDrop: normal border saved.");
                            jc.setBorder(dragBorder);
                            FileDrop.log(out, "FileDrop: drag border set.");
                        }
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }

                @Override
                public void dragOver(DropTargetDragEvent evt) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void drop(DropTargetDropEvent evt) {
                    FileDrop.log(out, "FileDrop: drop event.");
                    try {
                        Transferable tr = evt.getTransferable();
                        if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                            evt.acceptDrop(1);
                            FileDrop.log(out, "FileDrop: file list accepted.");
                            List fileList = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                            File[] filesTemp = new File[fileList.size()];
                            fileList.toArray(filesTemp);
                            File[] files = filesTemp;
                            if (listener != null) {
                                listener.filesDropped(files);
                            }
                            evt.getDropTargetContext().dropComplete(true);
                            FileDrop.log(out, "FileDrop: drop complete.");
                        } else {
                            DataFlavor[] flavors = tr.getTransferDataFlavors();
                            boolean handled = false;
                            for (int zz = 0; zz < flavors.length; ++zz) {
                                if (!flavors[zz].isRepresentationClassReader()) continue;
                                evt.acceptDrop(1);
                                FileDrop.log(out, "FileDrop: reader accepted.");
                                Reader reader = flavors[zz].getReaderForText(tr);
                                BufferedReader br = new BufferedReader(reader);
                                if (listener != null) {
                                    listener.filesDropped(FileDrop.createFileArray(br, out));
                                }
                                evt.getDropTargetContext().dropComplete(true);
                                FileDrop.log(out, "FileDrop: drop complete.");
                                handled = true;
                                break;
                            }
                            if (!handled) {
                                FileDrop.log(out, "FileDrop: not a file list or reader - abort.");
                                evt.rejectDrop();
                            }
                        }
                    }
                    catch (IOException io) {
                        FileDrop.log(out, "FileDrop: IOException - abort:");
                        io.printStackTrace(out);
                        evt.rejectDrop();
                    }
                    catch (UnsupportedFlavorException ufe) {
                        FileDrop.log(out, "FileDrop: UnsupportedFlavorException - abort:");
                        ufe.printStackTrace(out);
                        evt.rejectDrop();
                    }
                    finally {
                        if (c instanceof JComponent) {
                            JComponent jc = (JComponent)c;
                            jc.setBorder(FileDrop.this.normalBorder);
                            FileDrop.log(out, "FileDrop: normal border restored.");
                        }
                    }
                }

                @Override
                public void dragExit(DropTargetEvent evt) {
                    FileDrop.log(out, "FileDrop: dragExit event.");
                    if (c instanceof JComponent) {
                        JComponent jc = (JComponent)c;
                        jc.setBorder(FileDrop.this.normalBorder);
                        FileDrop.log(out, "FileDrop: normal border restored.");
                    }
                }

                @Override
                public void dropActionChanged(DropTargetDragEvent evt) {
                    FileDrop.log(out, "FileDrop: dropActionChanged event.");
                    if (FileDrop.this.isDragOk(out, evt)) {
                        evt.acceptDrag(1);
                        FileDrop.log(out, "FileDrop: event accepted.");
                    } else {
                        evt.rejectDrag();
                        FileDrop.log(out, "FileDrop: event rejected.");
                    }
                }
            };
            this.makeDropTarget(out, c, recursive);
        } else {
            FileDrop.log(out, "FileDrop: Drag and drop is not supported with this JVM");
        }
    }

    private static boolean supportsDnD() {
        if (supportsDnD == null) {
            boolean support = false;
            try {
                Class.forName("java.awt.dnd.DnDConstants");
                support = true;
            }
            catch (Exception e) {
                support = false;
            }
            supportsDnD = new Boolean(support);
        }
        return supportsDnD;
    }

    private static File[] createFileArray(BufferedReader bReader, PrintStream out) {
        try {
            ArrayList<File> list = new ArrayList<File>();
            String line = null;
            while ((line = bReader.readLine()) != null) {
                try {
                    if (ZERO_CHAR_STRING.equals(line)) continue;
                    File file = new File(new URI(line));
                    list.add(file);
                }
                catch (Exception ex) {
                    FileDrop.log(out, "Error with " + line + ": " + ex.getMessage());
                }
            }
            return list.toArray(new File[list.size()]);
        }
        catch (IOException ex) {
            FileDrop.log(out, "FileDrop: IOException");
            return new File[0];
        }
    }

    private void makeDropTarget(final PrintStream out, final Component c, boolean recursive) {
        DropTarget dt = new DropTarget();
        try {
            dt.addDropTargetListener(this.dropListener);
        }
        catch (TooManyListenersException e) {
            e.printStackTrace();
            FileDrop.log(out, "FileDrop: Drop will not work due to previous error. Do you have another listener attached?");
        }
        c.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent evt) {
                FileDrop.log(out, "FileDrop: Hierarchy changed.");
                Container parent = c.getParent();
                if (parent == null) {
                    c.setDropTarget(null);
                    FileDrop.log(out, "FileDrop: Drop target cleared from component.");
                } else {
                    new DropTarget(c, FileDrop.this.dropListener);
                    FileDrop.log(out, "FileDrop: Drop target added to component.");
                }
            }
        });
        if (c.getParent() != null) {
            new DropTarget(c, this.dropListener);
        }
        if (recursive && c instanceof Container) {
            Container cont = (Container)c;
            Component[] comps = cont.getComponents();
            for (int i = 0; i < comps.length; ++i) {
                this.makeDropTarget(out, comps[i], recursive);
            }
        }
    }

    private boolean isDragOk(PrintStream out, DropTargetDragEvent evt) {
        int i;
        boolean ok = false;
        DataFlavor[] flavors = evt.getCurrentDataFlavors();
        for (i = 0; !ok && i < flavors.length; ++i) {
            DataFlavor curFlavor = flavors[i];
            if (!curFlavor.equals(DataFlavor.javaFileListFlavor) && !curFlavor.isRepresentationClassReader()) continue;
            ok = true;
        }
        if (out != null) {
            if (flavors.length == 0) {
                FileDrop.log(out, "FileDrop: no data flavors.");
            }
            for (i = 0; i < flavors.length; ++i) {
                FileDrop.log(out, flavors[i].toString());
            }
        }
        return ok;
    }

    private static void log(PrintStream out, String message) {
        if (out != null) {
            out.println(message);
        }
    }

    public static boolean remove(Component c) {
        return FileDrop.remove(null, c, true);
    }

    public static boolean remove(PrintStream out, Component c, boolean recursive) {
        if (FileDrop.supportsDnD()) {
            FileDrop.log(out, "FileDrop: Removing drag-and-drop hooks.");
            c.setDropTarget(null);
            if (recursive && c instanceof Container) {
                Component[] comps = ((Container)c).getComponents();
                for (int i = 0; i < comps.length; ++i) {
                    FileDrop.remove(out, comps[i], recursive);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    static {
        defaultBorderColor = new Color(0.0f, 0.0f, 1.0f, 0.25f);
        ZERO_CHAR_STRING = "\u0000";
    }

    public static class TransferableObject
    implements Transferable {
        public static final String MIME_TYPE = "application/x-net.iharder.dnd.TransferableObject";
        public static final DataFlavor DATA_FLAVOR = new DataFlavor(TransferableObject.class, "application/x-net.iharder.dnd.TransferableObject");
        private Fetcher fetcher;
        private Object data;
        private DataFlavor customFlavor;

        public TransferableObject(Object data) {
            this.data = data;
            this.customFlavor = new DataFlavor(data.getClass(), MIME_TYPE);
        }

        public TransferableObject(Fetcher fetcher) {
            this.fetcher = fetcher;
        }

        public TransferableObject(Class<?> dataClass, Fetcher fetcher) {
            this.fetcher = fetcher;
            this.customFlavor = new DataFlavor(dataClass, MIME_TYPE);
        }

        public DataFlavor getCustomDataFlavor() {
            return this.customFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (this.customFlavor != null) {
                return new DataFlavor[]{this.customFlavor, DATA_FLAVOR, DataFlavor.stringFlavor};
            }
            return new DataFlavor[]{DATA_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(DATA_FLAVOR)) {
                return this.fetcher == null ? this.data : this.fetcher.getObject();
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.fetcher == null ? this.data.toString() : this.fetcher.getObject().toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            if (flavor.equals(DATA_FLAVOR)) {
                return true;
            }
            return flavor.equals(DataFlavor.stringFlavor);
        }

        public static interface Fetcher {
            public Object getObject();
        }
    }

    public static class Event
    extends EventObject {
        private static final long serialVersionUID = 1L;
        private File[] files;

        public Event(File[] files, Object source) {
            super(source);
            this.files = files;
        }

        public File[] getFiles() {
            return this.files;
        }
    }

    public static interface Listener {
        public void filesDropped(File[] var1);
    }
}

