/*
 * Decompiled with CFR 0.152.
 */
package net.atmp;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.abel.Bag;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.abel.EntityFactory;
import net.sourceforge.plantuml.abel.EntityGender;
import net.sourceforge.plantuml.abel.EntityPortion;
import net.sourceforge.plantuml.abel.GroupType;
import net.sourceforge.plantuml.abel.LeafType;
import net.sourceforge.plantuml.abel.Link;
import net.sourceforge.plantuml.abel.Together;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodierJSon;
import net.sourceforge.plantuml.cucadiagram.BodierMap;
import net.sourceforge.plantuml.cucadiagram.BodyFactory;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.HideOrShow;
import net.sourceforge.plantuml.cucadiagram.LinkConstraint;
import net.sourceforge.plantuml.cucadiagram.Magma;
import net.sourceforge.plantuml.cucadiagram.MagmaList;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.dot.CucaDiagramTxtMaker;
import net.sourceforge.plantuml.elk.CucaDiagramFileMakerElk;
import net.sourceforge.plantuml.graphml.CucaDiagramGraphmlMaker;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.plasma.Plasma;
import net.sourceforge.plantuml.plasma.Quark;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.sdot.CucaDiagramFileMakerSmetana;
import net.sourceforge.plantuml.security.SecurityUtils;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.skin.VisibilityModifier;
import net.sourceforge.plantuml.statediagram.StateDiagram;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;
import net.sourceforge.plantuml.svek.CucaDiagramFileMaker;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek;
import net.sourceforge.plantuml.text.Guillemet;
import net.sourceforge.plantuml.xmi.CucaDiagramXmiMaker;
import net.sourceforge.plantuml.xmlsc.StateDiagramScxmlMaker;

public abstract class CucaDiagram
extends UmlDiagram
implements GroupHierarchy,
PortionShower,
EntityFactory {
    private final List<EntityHideOrShow> hideOrShows = new ArrayList<EntityHideOrShow>();
    private final Set<VisibilityModifier> hideVisibilityModifier = new HashSet<VisibilityModifier>();
    private final List<HideOrShow> hides2 = new ArrayList<HideOrShow>();
    private final List<HideOrShow> removed = new ArrayList<HideOrShow>();
    private final AtomicInteger cpt1 = new AtomicInteger(1);
    private final AtomicInteger cpt2 = new AtomicInteger(1);
    private List<Bag> stacks = new ArrayList<Bag>();
    private boolean visibilityModifierPresent;
    private final List<Link> links = new ArrayList<Link>();
    private final Plasma<Entity> namespace = new Plasma();
    private final Quark<Entity> root = this.namespace.root();
    private int rawLayout;
    private Entity lastEntity = null;
    private String warningOrError;

    @Override
    public final void setNamespaceSeparator(String namespaceSeparator) {
        super.setNamespaceSeparator(namespaceSeparator);
        this.setSeparator(namespaceSeparator);
    }

    public CucaDiagram(UmlSource source, UmlDiagramType type, Map<String, String> orig) {
        super(source, type, orig);
        new Entity(this.root, this, null, GroupType.ROOT, 0);
        this.stacks.add(this.root.getData());
    }

    @Override
    public void startingPass(ParserPass pass) {
        this.setLastEntity(null);
        this.cpt1.set(1);
        this.cpt2.set(1);
        if (this.stacks.size() > 1) {
            this.stacks.subList(1, this.stacks.size()).clear();
        }
    }

    public String getPortFor(String entString, Quark<Entity> ident) {
        int x = entString.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        if (entString.startsWith(ident.getName())) {
            return entString.substring(x + 2);
        }
        return null;
    }

    public final Entity getCurrentGroup() {
        for (int pos = this.stacks.size() - 1; pos >= 0; --pos) {
            Bag tmp = this.stacks.get(pos);
            if (!(tmp instanceof Entity)) continue;
            return (Entity)tmp;
        }
        throw new IllegalStateException();
    }

    public final Together currentTogether() {
        int pos = this.stacks.size() - 1;
        Bag tmp = this.stacks.get(pos);
        if (tmp instanceof Together) {
            return (Together)tmp;
        }
        return null;
    }

    public String cleanId(String id) {
        if (id == null) {
            return null;
        }
        return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(id);
    }

    @Override
    public boolean hasUrl() {
        for (Quark<Entity> quark : this.quarks()) {
            Entity ent = quark.getData();
            if (ent == null || !ent.hasUrl()) continue;
            return true;
        }
        return false;
    }

    public final void setLastEntity(Entity last) {
        this.lastEntity = last;
    }

    protected void updateLasts(Entity result) {
    }

    public final Entity reallyCreateLeaf(Quark<Entity> ident, Display display, LeafType type, USymbol symbol) {
        Objects.requireNonNull(type);
        if (ident.getData() != null) {
            throw new IllegalStateException();
        }
        if (Display.isNull(display)) {
            throw new IllegalArgumentException();
        }
        Entity result = this.createLeaf(ident, this, type, this.getHidesVisibilityModifier());
        result.setUSymbol(symbol);
        this.lastEntity = result;
        result.setTogether(this.currentTogether());
        this.updateLasts(result);
        result.setDisplay(display);
        if (type.isLikeClass()) {
            this.eventuallyBuildPhantomGroups();
        }
        return result;
    }

    public final Quark<Entity> quarkInContext(boolean reuseExistingChild, String full) {
        return this.quarkInContextSafe(reuseExistingChild, full).get();
    }

    public final Failable<Quark<Entity>> quarkInContextSafe(boolean reuseExistingChild, String full) {
        boolean firstPackageDoesExist;
        String sep = this.getNamespaceSeparator();
        if (sep == null) {
            Quark<Entity> result = this.firstWithName(full);
            if (result != null) {
                return Failable.ok(result);
            }
            return Failable.ok(this.getCurrentGroup().getQuark().child(full));
        }
        Quark<Entity> currentQuark = this.getCurrentGroup().getQuark();
        if (full.startsWith(sep)) {
            return Failable.ok(this.root.child(full.substring(sep.length())));
        }
        int x = full.indexOf(sep);
        if (x == -1) {
            if (reuseExistingChild && this.countByName(full) == 1) {
                Quark<Entity> byName = this.firstWithName(full);
                assert (byName != null);
                if (byName != currentQuark) {
                    return Failable.ok(byName);
                }
            }
            return Failable.ok(currentQuark.child(full));
        }
        Quark<Entity> first = this.root.childIfExists(full.substring(0, x));
        boolean bl = firstPackageDoesExist = first != null;
        if (firstPackageDoesExist && first.getData() != null && !first.getData().isGroup()) {
            return Failable.error("Not a package: " + full.substring(0, x));
        }
        if (firstPackageDoesExist) {
            return Failable.ok(this.root.child(full));
        }
        return Failable.ok(currentQuark.child(full));
    }

    public String removePortId(String id) {
        if ("::".equals(this.getNamespaceSeparator())) {
            return id;
        }
        int x = id.lastIndexOf("::");
        if (x == -1) {
            return id;
        }
        return id.substring(0, x);
    }

    public String getPortId(String id) {
        if ("::".equals(this.getNamespaceSeparator())) {
            return null;
        }
        int x = id.lastIndexOf("::");
        if (x == -1) {
            return null;
        }
        return id.substring(x + 2);
    }

    @Override
    public final Collection<Entity> getChildrenGroups(Entity entity) {
        return entity.groups();
    }

    private void eventuallyBuildPhantomGroups() {
        for (Quark<Entity> quark : this.quarks()) {
            int countChildren;
            if (quark.getData() != null || (countChildren = quark.countChildren()) <= 0) continue;
            Display display = Display.getWithNewlines(quark.getName());
            Entity result = this.createGroup(quark, GroupType.PACKAGE);
            result.setDisplay(display);
        }
    }

    public final CommandExecutionResult gotoTogether() {
        this.stacks.add(new Together(this.currentTogether()));
        return CommandExecutionResult.ok();
    }

    public final CommandExecutionResult gotoGroup(Quark<Entity> quark, Display display, GroupType type) {
        return this.gotoGroup(quark, display, type, null);
    }

    public final CommandExecutionResult gotoGroup(Quark<Entity> quark, Display display, GroupType type, USymbol usymbol) {
        if (quark.getData() == null) {
            Entity result = this.createGroup(quark, type);
            result.setTogether(this.currentTogether());
            result.setDisplay(display);
        }
        Entity ent = quark.getData();
        ent.muteToGroupType(type);
        if (usymbol != null) {
            ent.setUSymbol(usymbol);
        }
        this.stacks.add(quark.getData());
        return CommandExecutionResult.ok();
    }

    public boolean endGroup() {
        if (this.stacks.size() > 0) {
            this.stacks.remove(this.stacks.size() - 1);
            return true;
        }
        return false;
    }

    public final Entity getGroup(String code) {
        Quark<Entity> quark = this.firstWithName(code);
        if (quark == null) {
            return null;
        }
        return quark.getData();
    }

    public final boolean isGroup(String code) {
        Quark<Entity> quark = this.firstWithName(code);
        if (quark == null) {
            return false;
        }
        return this.isGroup(quark);
    }

    public final boolean isGroup(Quark<Entity> quark) {
        Entity ent = quark.getData();
        if (ent == null) {
            return false;
        }
        return ent.isGroup();
    }

    protected abstract List<String> getDotStrings();

    public final String[] getDotStringSkek() {
        String ratio;
        ArrayList<String> result = new ArrayList<String>();
        for (String s2 : this.getDotStrings()) {
            if (!s2.startsWith("nodesep") && !s2.startsWith("ranksep") && !s2.startsWith("layout")) continue;
            result.add(s2);
        }
        String aspect = this.getPragma().getValue("aspect");
        if (aspect != null) {
            aspect = aspect.replace(',', '.');
            result.add("aspect=" + aspect + ";");
        }
        if ((ratio = this.getPragma().getValue("ratio")) != null) {
            result.add("ratio=" + ratio + ";");
        }
        return result.toArray(new String[result.size()]);
    }

    private void createFilesGraphml(OutputStream suggestedFile) throws IOException {
        CucaDiagramGraphmlMaker maker = new CucaDiagramGraphmlMaker(this);
        maker.createFiles(suggestedFile);
    }

    private void createFilesXmi(OutputStream suggestedFile, FileFormat fileFormat) throws IOException {
        CucaDiagramXmiMaker maker = new CucaDiagramXmiMaker(this, fileFormat);
        maker.createFiles(suggestedFile);
    }

    private void createFilesScxml(OutputStream suggestedFile) throws IOException {
        StateDiagramScxmlMaker maker = new StateDiagramScxmlMaker((StateDiagram)this);
        maker.createFiles(suggestedFile);
    }

    private void createFilesTxt(OutputStream os, int index, FileFormat fileFormat) throws IOException {
        CucaDiagramTxtMaker maker = new CucaDiagramTxtMaker(this, fileFormat);
        maker.createFiles(os, index);
    }

    @Override
    public final void exportDiagramGraphic(UGraphic ug, FileFormatOption fileFormatOption) {
        CucaDiagramFileMakerSmetana maker = new CucaDiagramFileMakerSmetana(this);
        ((CucaDiagramFileMaker)maker).createOneGraphic(ug);
    }

    @Override
    protected final TextBlock getTextMainBlock(FileFormatOption fileFormatOption) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ImageData exportDiagramInternal(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        FileFormat fileFormat = fileFormatOption.getFileFormat();
        if (fileFormat == FileFormat.ATXT || fileFormat == FileFormat.UTXT) {
            try {
                this.createFilesTxt(os, index, fileFormat);
            }
            catch (Throwable t2) {
                t2.printStackTrace(SecurityUtils.createPrintStream(os));
            }
            return ImageDataSimple.ok();
        }
        if (fileFormat == FileFormat.GRAPHML) {
            this.createFilesGraphml(os);
            return ImageDataSimple.ok();
        }
        if (fileFormat.name().startsWith("XMI")) {
            this.createFilesXmi(os, fileFormat);
            return ImageDataSimple.ok();
        }
        if (fileFormat == FileFormat.SCXML) {
            this.createFilesScxml(os);
            return ImageDataSimple.ok();
        }
        if (this.getUmlDiagramType() == UmlDiagramType.COMPOSITE) {
            throw new UnsupportedOperationException();
        }
        this.eventuallyBuildPhantomGroups();
        CucaDiagramFileMaker maker = this.isUseElk() ? new CucaDiagramFileMakerElk(this) : (this.isUseSmetana() ? new CucaDiagramFileMakerSmetana(this) : new CucaDiagramFileMakerSvek(this));
        ImageData result = ((CucaDiagramFileMaker)maker).createFile(os, this.getDotStrings(), fileFormatOption);
        if (result == null) {
            return ImageDataSimple.error();
        }
        this.warningOrError = result.getWarningOrError();
        return result;
    }

    @Override
    public String getWarningOrError() {
        String generalWarningOrError = super.getWarningOrError();
        if (this.warningOrError == null) {
            return generalWarningOrError;
        }
        if (generalWarningOrError == null) {
            return this.warningOrError;
        }
        return generalWarningOrError + "\n" + this.warningOrError;
    }

    private static boolean isNumber(String s2) {
        return s2.matches("[+-]?(\\.?\\d+|\\d+\\.\\d*)");
    }

    public void resetPragmaLabel() {
        this.getPragma().undefine("labeldistance");
        this.getPragma().undefine("labelangle");
    }

    public String getLabeldistance() {
        String s2;
        if (this.getPragma().isDefine("labeldistance") && CucaDiagram.isNumber(s2 = this.getPragma().getValue("labeldistance"))) {
            return s2;
        }
        if (this.getPragma().isDefine("defaultlabeldistance") && CucaDiagram.isNumber(s2 = this.getPragma().getValue("defaultlabeldistance"))) {
            return s2;
        }
        return "1.7";
    }

    public String getLabelangle() {
        String s2;
        if (this.getPragma().isDefine("labelangle") && CucaDiagram.isNumber(s2 = this.getPragma().getValue("labelangle"))) {
            return s2;
        }
        if (this.getPragma().isDefine("defaultlabelangle") && CucaDiagram.isNumber(s2 = this.getPragma().getValue("defaultlabelangle"))) {
            return s2;
        }
        return "25";
    }

    @Override
    public final boolean isEmpty(Entity entity) {
        return entity.isEmpty();
    }

    public final boolean isVisibilityModifierPresent() {
        return this.visibilityModifierPresent;
    }

    public final void setVisibilityModifierPresent(boolean visibilityModifierPresent) {
        this.visibilityModifierPresent = visibilityModifierPresent;
    }

    @Override
    public final boolean showPortion(EntityPortion portion, Entity entity) {
        if (this.getSkinParam().strictUmlStyle() && portion == EntityPortion.CIRCLED_CHARACTER) {
            return false;
        }
        boolean result = true;
        for (EntityHideOrShow cmd : this.hideOrShows) {
            if (cmd.portion != portion || !cmd.gender.contains(entity)) continue;
            result = cmd.show;
        }
        return result;
    }

    public void hideOrShowVisibilityModifier(Set<VisibilityModifier> visibilities, boolean show) {
        if (show) {
            this.hideVisibilityModifier.removeAll(visibilities);
        } else {
            this.hideVisibilityModifier.addAll(visibilities);
        }
    }

    @Override
    public List<String> getVisibleStereotypeLabels(Entity entity) {
        Stereotype stereotype = entity.getStereotype();
        if (stereotype == null) {
            return null;
        }
        ArrayList<EntityHideOrShow> commands = new ArrayList<EntityHideOrShow>();
        for (EntityHideOrShow hideOrShowEntry : this.hideOrShows) {
            if (hideOrShowEntry.portion != EntityPortion.STEREOTYPE) continue;
            commands.add(hideOrShowEntry);
        }
        ArrayList<String> visibleStereotypeLabels = new ArrayList<String>();
        for (String stereoTypeLabel : entity.getStereotype().getLabels(Guillemet.DOUBLE_COMPARATOR)) {
            if (this.isHiddenStereotypeLabel(stereoTypeLabel, commands)) continue;
            visibleStereotypeLabels.add(stereoTypeLabel);
        }
        return visibleStereotypeLabels;
    }

    private boolean isHiddenStereotypeLabel(String stereoTypeLabel, List<EntityHideOrShow> commands) {
        for (EntityHideOrShow cmd : commands) {
            String gender = cmd.gender.getGender();
            if (gender != null && gender.equals(stereoTypeLabel)) {
                return !cmd.show;
            }
            if (gender != null) continue;
            return !cmd.show;
        }
        return false;
    }

    public final void hideOrShow(EntityGender gender, EntityPortion portions, boolean show) {
        for (EntityPortion portion : portions.asSet()) {
            this.hideOrShows.add(new EntityHideOrShow(gender, portion, show));
        }
    }

    public void hideOrShow2(String what, boolean show) {
        what = this.fixWhat(what);
        this.hides2.add(new HideOrShow(what, show));
    }

    public void removeOrRestore(String what, boolean show) {
        what = this.fixWhat(what);
        this.removed.add(new HideOrShow(what, show));
    }

    private String fixWhat(String what) {
        Quark<Entity> currentQuark;
        String sep = this.getNamespaceSeparator();
        if (sep != null && (currentQuark = this.getCurrentGroup().getQuark()).getQualifiedName().length() > 0) {
            what = currentQuark.getQualifiedName() + sep + what;
        }
        return what;
    }

    public final Set<VisibilityModifier> getHidesVisibilityModifier() {
        return Collections.unmodifiableSet(this.hideVisibilityModifier);
    }

    public final boolean isStandalone(Entity ent) {
        for (Link link : this.getLinks()) {
            if (link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final boolean isStandaloneForArgo(Entity ent) {
        for (Link link : this.getLinks()) {
            if (link.isHidden() || link.isInvis() || link.getEntity1() != ent && link.getEntity2() != ent) continue;
            return false;
        }
        return true;
    }

    public final Link getLastLink() {
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            return link;
        }
        return null;
    }

    public final List<Link> getTwoLastLinks() {
        ArrayList<Link> result = new ArrayList<Link>();
        List<Link> links = this.getLinks();
        for (int i = links.size() - 1; i >= 0; --i) {
            Link link = links.get(i);
            if (link.getEntity1().getLeafType() == LeafType.NOTE || link.getEntity2().getLeafType() == LeafType.NOTE) continue;
            result.add(link);
            if (result.size() != 2) continue;
            return Collections.unmodifiableList(result);
        }
        return null;
    }

    public final Entity getLastEntity() {
        return this.lastEntity;
    }

    public void applySingleStrategy() {
        MagmaList magmaList = new MagmaList();
        Collection<Entity> groups = this.groupsAndRoot();
        for (Entity g2 : groups) {
            ArrayList<Entity> standalones = new ArrayList<Entity>();
            for (Entity ent : g2.leafs()) {
                if (!this.isStandalone(ent)) continue;
                standalones.add(ent);
            }
            if (standalones.size() < 3) continue;
            Magma magma = new Magma(this, standalones);
            magma.putInSquare();
            magmaList.add(magma);
        }
        for (Entity g2 : groups) {
            MagmaList magmas = magmaList.getMagmas(g2);
            if (magmas.size() < 3) continue;
            magmas.putInSquare();
        }
    }

    @Override
    public boolean isHideEmptyDescriptionForState() {
        return false;
    }

    public CommandExecutionResult constraintOnLinks(Link link1, Link link2, Display display) {
        LinkConstraint linkConstraint = new LinkConstraint(link1, link2, display);
        link1.setLinkConstraint(linkConstraint);
        link2.setLinkConstraint(linkConstraint);
        return CommandExecutionResult.ok();
    }

    @Override
    public ClockwiseTopRightBottomLeft getDefaultMargins() {
        return ClockwiseTopRightBottomLeft.topRightBottomLeft(0.0, 5.0, 5.0, 0.0);
    }

    public int getUniqueSequenceValue() {
        return this.cpt1.addAndGet(1);
    }

    public String getUniqueSequence(String prefix) {
        return prefix + this.cpt1.addAndGet(1);
    }

    public String getUniqueSequence2(String prefix) {
        return prefix + this.cpt2.addAndGet(1);
    }

    public boolean isStereotypeRemoved(Stereotype stereotype) {
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            result = hide.apply(result, stereotype);
        }
        return result;
    }

    public boolean isHidden(Entity leaf) {
        if (leaf.isRoot()) {
            return false;
        }
        Entity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other != null && other != leaf) {
            return this.isHidden(other);
        }
        boolean hidden = false;
        for (HideOrShow hide : this.hides2) {
            hidden = hide.apply(hidden, leaf);
        }
        return hidden;
    }

    public boolean isRemoved(Entity leaf) {
        if (leaf.isRoot()) {
            return false;
        }
        Entity other = this.isNoteWithSingleLinkAttachedTo(leaf);
        if (other != null) {
            return this.isRemoved(other);
        }
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            result = hide.apply(result, leaf);
        }
        return result;
    }

    private Entity isNoteWithSingleLinkAttachedTo(Entity note) {
        if (note.getLeafType() != LeafType.NOTE) {
            return null;
        }
        assert (note.getLeafType() == LeafType.NOTE);
        Entity other = null;
        for (Link link : this.getLinks()) {
            if (link.getType().isInvisible() || !link.contains(note)) continue;
            if (other != null) {
                return null;
            }
            other = link.getOther(note);
            if (other.getLeafType() != LeafType.NOTE) continue;
            return null;
        }
        return other;
    }

    public boolean isRemovedIgnoreUnlinked(Entity leaf) {
        boolean result = false;
        for (HideOrShow hide : this.removed) {
            if (hide.isAboutUnlinked()) continue;
            result = hide.apply(result, leaf);
        }
        return result;
    }

    public final Entity createLeaf(Quark<Entity> quark, CucaDiagram diagram, LeafType entityType, Set<VisibilityModifier> hideVisibilityModifier) {
        Bodier bodier = Objects.requireNonNull(entityType) == LeafType.MAP ? new BodierMap() : (Objects.requireNonNull(entityType) == LeafType.JSON ? new BodierJSon() : BodyFactory.createLeaf(entityType, hideVisibilityModifier));
        Entity result = new Entity(quark, this, bodier, entityType, diagram.rawLayout);
        bodier.setLeaf(result);
        return result;
    }

    public Entity createGroup(Quark<Entity> quark, GroupType groupType) {
        Objects.requireNonNull(groupType);
        if (quark.getData() != null) {
            return quark.getData();
        }
        Bodier bodier = BodyFactory.createGroup();
        Entity result = new Entity(quark, this, bodier, groupType, this.rawLayout);
        return result;
    }

    public final Collection<Entity> leafs() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data;
            if (quark.isRoot() || (data = quark.getData()) == null || data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public final Collection<Entity> groups() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data;
            if (quark.isRoot() || (data = quark.getData()) == null || !data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public final Collection<Entity> groupsAndRoot() {
        ArrayList<Entity> result = new ArrayList<Entity>();
        for (Quark<Entity> quark : this.quarks()) {
            Entity data = quark.getData();
            if (data == null || !data.isGroup()) continue;
            result.add(data);
        }
        return Collections.unmodifiableCollection(result);
    }

    public void incRawLayout() {
        ++this.rawLayout;
    }

    public final List<Link> getLinks() {
        return Collections.unmodifiableList(this.links);
    }

    public void addLink(Link link) {
        if (link.isSingle() && this.containsSimilarLink(link)) {
            return;
        }
        this.links.add(link);
    }

    private boolean containsSimilarLink(Link other) {
        for (Link link : this.links) {
            if (!other.sameConnections(link)) continue;
            return true;
        }
        return false;
    }

    public void removeLink(Link link) {
        boolean ok = this.links.remove(link);
        if (!ok) {
            throw new IllegalArgumentException();
        }
    }

    public Collection<Quark<Entity>> quarks() {
        ArrayList<Quark<Entity>> result = new ArrayList<Quark<Entity>>();
        for (Quark<Entity> quark : this.namespace.quarks()) {
            result.add(quark);
        }
        return result;
    }

    @Override
    public Entity getRootGroup() {
        return this.root.getData();
    }

    public void setSeparator(String namespaceSeparator) {
        this.namespace.setSeparator(namespaceSeparator);
    }

    public Quark<Entity> firstWithName(String full) {
        return this.namespace.firstWithName(full);
    }

    public int countByName(String full) {
        return this.namespace.countByName(full);
    }

    static class EntityHideOrShow {
        private final EntityGender gender;
        private final EntityPortion portion;
        private final boolean show;

        EntityHideOrShow(EntityGender gender, EntityPortion portion, boolean show) {
            this.gender = gender;
            this.portion = portion;
            this.show = show;
        }
    }
}

