/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.drawing.svg;

import net.sourceforge.plantuml.klimt.color.ColorMapper;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.svg.LengthAdjust;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;

public class SvgOption {
    private boolean interactive = false;
    private LengthAdjust lengthAdjust = LengthAdjust.defaultValue();
    private String preserveAspectRatio = "none";
    private String hover;
    private boolean svgDimensionStyle = true;
    private XDimension2D minDim = new XDimension2D(0.0, 0.0);
    private HColor backcolor;
    private double scale = 1.0;
    private ColorMapper colorMapper = ColorMapper.IDENTITY;
    private String linkTarget;
    private String font;
    private String title;

    public static SvgOption basic() {
        return new SvgOption();
    }

    private SvgOption() {
    }

    public SvgOption withTitle(Display titleDisplay) {
        if (titleDisplay.size() > 0) {
            this.title = titleDisplay.get(0).toString();
        }
        return this;
    }

    public SvgOption withInteractive() {
        this.interactive = true;
        return this;
    }

    public SvgOption withLengthAdjust(LengthAdjust lengthAdjust) {
        this.lengthAdjust = lengthAdjust;
        return this;
    }

    public SvgOption withPreserveAspectRatio(String preserveAspectRatio) {
        this.preserveAspectRatio = preserveAspectRatio;
        return this;
    }

    public SvgOption withHoverPathColorRGB(String hover) {
        this.hover = hover;
        return this;
    }

    public SvgOption withSvgDimensionStyle(boolean svgDimensionStyle) {
        this.svgDimensionStyle = svgDimensionStyle;
        return this;
    }

    public SvgOption withMinDim(XDimension2D minDim) {
        this.minDim = minDim;
        return this;
    }

    public SvgOption withBackcolor(HColor backcolor) {
        this.backcolor = backcolor;
        return this;
    }

    public SvgOption withScale(double scale) {
        this.scale = scale;
        return this;
    }

    public SvgOption withColorMapper(ColorMapper colorMapper) {
        this.colorMapper = colorMapper;
        return this;
    }

    public SvgOption withLinkTarget(String linkTarget) {
        this.linkTarget = linkTarget;
        return this;
    }

    public SvgOption withFont(String font) {
        this.font = font;
        return this;
    }

    public String getPreserveAspectRatio() {
        return this.preserveAspectRatio;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public LengthAdjust getLengthAdjust() {
        return this.lengthAdjust;
    }

    public String getHover() {
        return this.hover;
    }

    public boolean getSvgDimensionStyle() {
        return this.svgDimensionStyle;
    }

    public XDimension2D getMinDim() {
        return this.minDim;
    }

    public HColor getBackcolor() {
        return this.backcolor;
    }

    public double getScale() {
        return this.scale;
    }

    public ColorMapper getColorMapper() {
        return this.colorMapper;
    }

    public String getLinkTarget() {
        return this.linkTarget;
    }

    public String getFont() {
        return this.font;
    }

    public String getTitle() {
        return this.title;
    }
}

