/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.elk.core.util.ElkUtil;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.LoggedGraph;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class BasicProgressMonitor
implements IElkProgressMonitor {
    public static final String ROOT_DEBUG_FOLDER_NAME = "logs";
    private static final int INFINITE_HIERARCHY_LEVELS = -1;
    private BasicProgressMonitor parentMonitor;
    private final List<IElkProgressMonitor> children = new LinkedList<IElkProgressMonitor>();
    private int maxLevels = -1;
    private String taskName;
    private boolean closed = false;
    private float totalWork;
    private float completedWork = 0.0f;
    private float currentChildWork = -1.0f;
    private boolean recordLogs = false;
    private boolean persistLogs = false;
    private List<String> logMessages = null;
    private List<LoggedGraph> logGraphs = null;
    private Path debugFolder = null;
    private Path logFile = null;
    private boolean recordExecutionTime = false;
    private long startTime;
    private double totalTime;
    private static final double NANO_FACT = 1.0E-9;

    public BasicProgressMonitor() {
    }

    public BasicProgressMonitor(int themaxLevels) {
        this.withMaxHierarchyLevels(themaxLevels);
    }

    public BasicProgressMonitor withMaxHierarchyLevels(int levels) {
        this.maxLevels = levels < 0 ? -1 : levels;
        return this;
    }

    public BasicProgressMonitor withLogging(boolean enabled) {
        this.recordLogs = enabled;
        if (this.recordLogs) {
            this.logMessages = new ArrayList<String>();
            this.logGraphs = new ArrayList<LoggedGraph>();
        } else {
            this.logMessages = null;
            this.logGraphs = null;
        }
        return this;
    }

    public BasicProgressMonitor withLogPersistence(boolean enabled) {
        this.persistLogs = enabled;
        return this;
    }

    public BasicProgressMonitor withExecutionTimeMeasurement(boolean enabled) {
        this.recordExecutionTime = enabled;
        return this;
    }

    @Override
    public final boolean begin(String name, float thetotalWork) {
        if (this.closed) {
            throw new IllegalStateException("The task is already done.");
        }
        if (this.taskName != null) {
            return false;
        }
        if (name == null) {
            throw new NullPointerException();
        }
        this.taskName = name;
        this.totalWork = thetotalWork;
        this.doBegin(name, thetotalWork, this.parentMonitor == null, this.maxLevels);
        if (this.recordExecutionTime) {
            this.startTime = System.nanoTime();
        }
        return true;
    }

    protected void doBegin(String name, float newTotalWork, boolean topInstance, int maxHierarchyLevels) {
    }

    @Override
    public final void worked(float work) {
        if (work > 0.0f && !this.closed) {
            this.internalWorked(work);
        }
    }

    private void internalWorked(float work) {
        if (this.totalWork > 0.0f && this.completedWork < this.totalWork) {
            this.completedWork += work;
            this.doWorked(this.completedWork, this.totalWork, this.parentMonitor == null);
            if (this.parentMonitor != null && this.parentMonitor.currentChildWork > 0.0f && this.maxLevels != 0) {
                this.parentMonitor.internalWorked(work / this.totalWork * this.parentMonitor.currentChildWork);
            }
        }
    }

    protected void doWorked(float thecompletedWork, float thetotalWork, boolean topInstance) {
    }

    @Override
    public final void done() {
        if (this.taskName == null) {
            throw new IllegalStateException("The task has not begun yet.");
        }
        if (!this.closed) {
            if (this.recordExecutionTime) {
                long endTime = System.nanoTime();
                this.totalTime = (double)(endTime - this.startTime) * 1.0E-9;
            }
            if (this.completedWork < this.totalWork) {
                this.internalWorked(this.totalWork - this.completedWork);
            }
            this.doDone(this.parentMonitor == null, this.maxLevels);
            this.closed = true;
        }
    }

    protected void doDone(boolean topInstance, int maxHierarchyLevels) {
    }

    @Override
    public boolean isRunning() {
        return this.taskName != null && !this.closed;
    }

    @Override
    public boolean isCanceled() {
        return false;
    }

    @Override
    public String getTaskName() {
        return this.taskName;
    }

    @Override
    public final IElkProgressMonitor subTask(float work) {
        if (!this.closed) {
            BasicProgressMonitor subMonitor = this.doSubTask(work, this.maxLevels);
            this.children.add(subMonitor);
            subMonitor.parentMonitor = this;
            this.currentChildWork = work;
            return subMonitor;
        }
        return null;
    }

    protected BasicProgressMonitor doSubTask(float work, int maxHierarchyLevels) {
        int newMaxHierarchyLevels = maxHierarchyLevels > 0 ? maxHierarchyLevels - 1 : maxHierarchyLevels;
        return new BasicProgressMonitor().withMaxHierarchyLevels(newMaxHierarchyLevels).withLogging(this.recordLogs).withLogPersistence(this.persistLogs).withExecutionTimeMeasurement(this.recordExecutionTime);
    }

    @Override
    public final List<IElkProgressMonitor> getSubMonitors() {
        assert (this.children != null);
        return Collections.unmodifiableList(this.children);
    }

    @Override
    public final IElkProgressMonitor getParentMonitor() {
        return this.parentMonitor;
    }

    @Override
    public boolean isLoggingEnabled() {
        return this.recordLogs;
    }

    @Override
    public boolean isLogPersistenceEnabled() {
        return this.persistLogs;
    }

    @Override
    public void log(Object object) {
        if (this.recordLogs && object != null) {
            Path outputFile;
            String logMessage = object.toString();
            this.logMessages.add(logMessage);
            if (this.persistLogs && (outputFile = this.retrieveLogFilePath()) != null) {
                try {
                    Files.write(outputFile, Lists.newArrayList(logMessage), StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List<String> getLogs() {
        return this.logMessages == null ? null : Collections.unmodifiableList(this.logMessages);
    }

    @Override
    public void logGraph(ElkNode graph, String tag) {
        if (this.recordLogs && graph != null) {
            this.logGraph(EcoreUtil.copy(graph), tag, LoggedGraph.Type.ELK);
        }
    }

    @Override
    public void logGraph(Object object, String tag, LoggedGraph.Type graphType) {
        if (this.recordLogs && object != null && graphType != null) {
            String actualTag;
            Path filePath;
            LoggedGraph loggedGraph = new LoggedGraph(object, tag, graphType);
            this.logGraphs.add(loggedGraph);
            if (this.persistLogs && (filePath = this.retrieveFilePath(actualTag = Strings.isNullOrEmpty(tag) ? "Unnamed" : tag, graphType.getFileExtension())) != null) {
                try {
                    Files.write(filePath, Lists.newArrayList(loggedGraph.serialize()), StandardOpenOption.WRITE, StandardOpenOption.CREATE);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public List<LoggedGraph> getLoggedGraphs() {
        return this.logGraphs == null ? null : Collections.unmodifiableList(this.logGraphs);
    }

    @Override
    public Path getDebugFolder() {
        this.initDebugFolder(false);
        return this.debugFolder;
    }

    @Override
    public boolean isExecutionTimeMeasured() {
        return this.recordExecutionTime;
    }

    @Override
    public final double getExecutionTime() {
        return this.totalTime;
    }

    private void initDebugFolder(boolean ensureExistence) {
        if (this.recordLogs && this.persistLogs && this.debugFolder == null) {
            if (this.getParentMonitor() == null) {
                this.initRootMonitorDebugFolder();
            } else {
                this.initChildMonitorDebugFolder();
            }
            if (ensureExistence) {
                if (Files.isRegularFile(this.debugFolder, new LinkOption[0])) {
                    this.recordLogs = false;
                    this.log("Debug folder '" + this.debugFolder.toString() + "' refers to a file! Not persisting logs.");
                    this.debugFolder = null;
                } else if (!Files.exists(this.debugFolder, new LinkOption[0])) {
                    this.debugFolder.toFile().mkdirs();
                }
                if (!Files.isDirectory(this.debugFolder, new LinkOption[0])) {
                    this.recordLogs = false;
                    this.log("Unable to create debug folder '" + this.debugFolder.toString() + "'! Not persisting logs.");
                    this.debugFolder = null;
                }
            }
        }
    }

    private void initRootMonitorDebugFolder() {
        long timestamp = System.currentTimeMillis();
        int validCharacterRange = 26;
        char randChar1 = (char)(97 + (int)(Math.random() * (double)validCharacterRange));
        char randChar2 = (char)(97 + (int)(Math.random() * (double)validCharacterRange));
        String name = this.getTaskName();
        if (Strings.isNullOrEmpty(name)) {
            name = "Unnamed";
        }
        name = ElkUtil.toSafePathName(name);
        String monitorFolder = String.format("%d%c%c-%s", timestamp, Character.valueOf(randChar1), Character.valueOf(randChar2), name);
        this.debugFolder = Paths.get(ElkUtil.debugFolderPath(ROOT_DEBUG_FOLDER_NAME, monitorFolder), new String[0]);
    }

    private void initChildMonitorDebugFolder() {
        int index = this.getParentMonitor().getSubMonitors().indexOf(this);
        String name = this.getTaskName();
        if (Strings.isNullOrEmpty(name)) {
            name = "Unnamed";
        }
        name = ElkUtil.toSafePathName(name);
        String monitorFolder = String.format("%02d-%s", index, name);
        this.debugFolder = this.getParentMonitor().getDebugFolder().resolve(monitorFolder);
    }

    private Path retrieveLogFilePath() {
        if (this.logFile == null) {
            this.logFile = this.retrieveFilePath("log", "txt");
        }
        return this.logFile;
    }

    private Path retrieveFilePath(String name, String extension) {
        this.initDebugFolder(true);
        if (this.debugFolder == null) {
            return null;
        }
        Path filePath = this.debugFolder.resolve(String.valueOf(name) + "." + extension);
        int number = 0;
        while (Files.exists(filePath, new LinkOption[0])) {
            filePath = this.debugFolder.resolve(String.valueOf(name) + "-" + ++number + "." + extension);
        }
        return filePath;
    }
}

