/*
 * Decompiled with CFR 0.152.
 */
package de.tuberlin.polymake.common.io;

import de.tuberlin.polymake.common.PolymakeControl;
import de.tuberlin.polymake.common.PolymakeFrame;
import de.tuberlin.polymake.common.SelectorThread;
import java.io.BufferedReader;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.InetSocketAddress;
import java.nio.channels.Channels;
import java.nio.channels.Pipe;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;

public class PolymakeServerParser {
    SelectorThread parent;

    public PolymakeServerParser(SelectorThread selectorThread) {
        this.parent = selectorThread;
    }

    public void parseLine(BufferedReader bufferedReader) throws PolymakeServerReadException, IOException {
        while (true) {
            String string;
            if ((string = bufferedReader.readLine()) == null) {
                throw new PolymakeServerReadException("Could not read from polymake server channel");
            }
            if (System.getProperty("polymake.debug") != null && System.getProperty("polymake.debug").equalsIgnoreCase("max")) {
                SelectorThread.newErr.println(string);
            }
            if (string.length() == 0) {
                return;
            }
            string.trim();
            switch (string.charAt(0)) {
                case 'n': {
                    String[] stringArray = string.substring(2).split("\\s+");
                    int n = Integer.parseInt(stringArray[1]);
                    try {
                        this.createAndRegisterControl(stringArray[0], n, bufferedReader);
                        return;
                    }
                    catch (ControlCreationException controlCreationException) {
                        controlCreationException.printStackTrace(SelectorThread.newErr);
                        break;
                    }
                }
                case 'e': {
                    String[] stringArray = string.substring(2).split("\\s+", 2);
                    int n = Integer.parseInt(stringArray[0]);
                    PolymakeFrame polymakeFrame = PolymakeFrame.getById(n);
                    if (polymakeFrame != null) {
                        polymakeFrame.setStatus(stringArray[1]);
                    }
                    return;
                }
            }
        }
    }

    private void createAndRegisterControl(String string, int n, BufferedReader bufferedReader) throws ControlCreationException {
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            Class<?> clazz = classLoader.loadClass("java.io.BufferedReader");
            Class<?> clazz2 = classLoader.loadClass("java.nio.channels.Pipe$SinkChannel");
            Class<?> clazz3 = Class.forName(string);
            Constructor<?> constructor = clazz3.getConstructor(clazz, clazz, clazz2);
            if (n != -1) {
                Pipe pipe = Pipe.open();
                pipe.source().configureBlocking(false);
                InetSocketAddress inetSocketAddress = new InetSocketAddress("localhost", n);
                SocketChannel socketChannel = SocketChannel.open();
                socketChannel.connect(inetSocketAddress);
                socketChannel.configureBlocking(false);
                PolymakeControl polymakeControl = (PolymakeControl)constructor.newInstance(bufferedReader, new BufferedReader(Channels.newReader((ReadableByteChannel)socketChannel, SelectorThread.CHARSET.name())), pipe.sink());
                this.parent.registerControl(polymakeControl, socketChannel, pipe);
            } else {
                Pipe pipe = Pipe.open();
                pipe.source().configureBlocking(false);
                PolymakeControl polymakeControl = (PolymakeControl)constructor.newInstance(bufferedReader, bufferedReader, pipe.sink());
                this.parent.registerControl(polymakeControl, pipe);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(SelectorThread.newErr);
            throw new ControlCreationException("Could not create " + string + " connected to port " + n);
        }
    }

    public class PolymakeServerReadException
    extends Exception {
        private static final long serialVersionUID = -2748406480628591233L;

        public PolymakeServerReadException(String string) {
            super(string);
        }
    }

    public class ControlCreationException
    extends Exception {
        private static final long serialVersionUID = 7056767773781646634L;

        public ControlCreationException(String string) {
            super(string);
        }
    }
}

