/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis;

import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.AbstractAnalysisFactory;
import org.apache.lucene.analysis.AnalysisSPILoader;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.util.AttributeFactory;

public abstract class TokenizerFactory
extends AbstractAnalysisFactory {
    public static TokenizerFactory forName(String name, Map<String, String> args2) {
        return Holder.getLoader().newInstance(name, args2);
    }

    public static Class<? extends TokenizerFactory> lookupClass(String name) {
        return Holder.getLoader().lookupClass(name);
    }

    public static Set<String> availableTokenizers() {
        return Holder.getLoader().availableServices();
    }

    public static String findSPIName(Class<? extends TokenizerFactory> serviceClass) {
        try {
            return AnalysisSPILoader.lookupSPIName(serviceClass);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void reloadTokenizers(ClassLoader classloader) {
        Holder.getLoader().reload(classloader);
    }

    protected TokenizerFactory() {
    }

    protected TokenizerFactory(Map<String, String> args2) {
        super(args2);
    }

    public final Tokenizer create() {
        return this.create(TokenStream.DEFAULT_TOKEN_ATTRIBUTE_FACTORY);
    }

    public abstract Tokenizer create(AttributeFactory var1);

    private static final class Holder {
        private static final AnalysisSPILoader<TokenizerFactory> LOADER = new AnalysisSPILoader<TokenizerFactory>(TokenizerFactory.class);

        private Holder() {
        }

        static AnalysisSPILoader<TokenizerFactory> getLoader() {
            if (LOADER == null) {
                throw new IllegalStateException("You tried to lookup a TokenizerFactory by name before all factories could be initialized. This likely happens if you call TokenizerFactory#forName from a TokenizerFactory ctor.");
            }
            return LOADER;
        }
    }
}

