/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.triggercondition.resolvers;

import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\f\r\u000eB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004J*\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J*\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J*\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002\u0082\u0001\u0003\u000f\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression;", "", "()V", "resolve", "", "", "resolveAnd", "documentSet1", "documentSet2", "resolveNot", "allDocs", "resolveOr", "And", "Not", "Or", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$And;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$Not;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$Or;", "opensearch-alerting"})
public abstract class TriggerExpression {
    private TriggerExpression() {
    }

    @NotNull
    public final Set<String> resolve() {
        Set<String> set;
        TriggerExpression triggerExpression = this;
        if (triggerExpression instanceof And) {
            set = this.resolveAnd(((And)this).getDocSet1(), ((And)this).getDocSet2());
        } else if (triggerExpression instanceof Or) {
            set = this.resolveOr(((Or)this).getDocSet1(), ((Or)this).getDocSet2());
        } else if (triggerExpression instanceof Not) {
            set = this.resolveNot(((Not)this).getAllDocs(), ((Not)this).getDocSet2());
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return set;
    }

    private final Set<String> resolveAnd(Set<String> documentSet1, Set<String> documentSet2) {
        return CollectionsKt.intersect((Iterable)documentSet1, (Iterable)documentSet2);
    }

    private final Set<String> resolveOr(Set<String> documentSet1, Set<String> documentSet2) {
        return CollectionsKt.union((Iterable)documentSet1, (Iterable)documentSet2);
    }

    private final Set<String> resolveNot(Set<String> allDocs, Set<String> documentSet2) {
        return CollectionsKt.subtract((Iterable)allDocs, (Iterable)documentSet2);
    }

    public /* synthetic */ TriggerExpression(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$And;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression;", "docSet1", "", "", "docSet2", "(Ljava/util/Set;Ljava/util/Set;)V", "getDocSet1", "()Ljava/util/Set;", "getDocSet2", "opensearch-alerting"})
    public static final class And
    extends TriggerExpression {
        @NotNull
        private final Set<String> docSet1;
        @NotNull
        private final Set<String> docSet2;

        public And(@NotNull Set<String> docSet1, @NotNull Set<String> docSet2) {
            Intrinsics.checkNotNullParameter(docSet1, (String)"docSet1");
            Intrinsics.checkNotNullParameter(docSet2, (String)"docSet2");
            super(null);
            this.docSet1 = docSet1;
            this.docSet2 = docSet2;
        }

        @NotNull
        public final Set<String> getDocSet1() {
            return this.docSet1;
        }

        @NotNull
        public final Set<String> getDocSet2() {
            return this.docSet2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$Not;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression;", "allDocs", "", "", "docSet2", "(Ljava/util/Set;Ljava/util/Set;)V", "getAllDocs", "()Ljava/util/Set;", "getDocSet2", "opensearch-alerting"})
    public static final class Not
    extends TriggerExpression {
        @NotNull
        private final Set<String> allDocs;
        @NotNull
        private final Set<String> docSet2;

        public Not(@NotNull Set<String> allDocs, @NotNull Set<String> docSet2) {
            Intrinsics.checkNotNullParameter(allDocs, (String)"allDocs");
            Intrinsics.checkNotNullParameter(docSet2, (String)"docSet2");
            super(null);
            this.allDocs = allDocs;
            this.docSet2 = docSet2;
        }

        @NotNull
        public final Set<String> getAllDocs() {
            return this.allDocs;
        }

        @NotNull
        public final Set<String> getDocSet2() {
            return this.docSet2;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0006R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression$Or;", "Lorg/opensearch/alerting/triggercondition/resolvers/TriggerExpression;", "docSet1", "", "", "docSet2", "(Ljava/util/Set;Ljava/util/Set;)V", "getDocSet1", "()Ljava/util/Set;", "getDocSet2", "opensearch-alerting"})
    public static final class Or
    extends TriggerExpression {
        @NotNull
        private final Set<String> docSet1;
        @NotNull
        private final Set<String> docSet2;

        public Or(@NotNull Set<String> docSet1, @NotNull Set<String> docSet2) {
            Intrinsics.checkNotNullParameter(docSet1, (String)"docSet1");
            Intrinsics.checkNotNullParameter(docSet2, (String)"docSet2");
            super(null);
            this.docSet1 = docSet1;
            this.docSet2 = docSet2;
        }

        @NotNull
        public final Set<String> getDocSet1() {
            return this.docSet1;
        }

        @NotNull
        public final Set<String> getDocSet2() {
            return this.docSet2;
        }
    }
}

