/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.mapper;

import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.index.VectorEncoding;
import org.opensearch.common.Explicit;
import org.opensearch.common.xcontent.XContentFactory;
import org.opensearch.index.mapper.FieldMapper;
import org.opensearch.knn.index.SpaceType;
import org.opensearch.knn.index.VectorDataType;
import org.opensearch.knn.index.engine.KNNEngine;
import org.opensearch.knn.index.engine.KNNLibraryIndexingContext;
import org.opensearch.knn.index.engine.KNNMethodConfigContext;
import org.opensearch.knn.index.engine.KNNMethodContext;
import org.opensearch.knn.index.engine.qframe.QuantizationConfig;
import org.opensearch.knn.index.engine.qframe.QuantizationConfigParser;
import org.opensearch.knn.index.mapper.CompressionLevel;
import org.opensearch.knn.index.mapper.KNNMappingConfig;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapper;
import org.opensearch.knn.index.mapper.KNNVectorFieldMapperUtil;
import org.opensearch.knn.index.mapper.KNNVectorFieldType;
import org.opensearch.knn.index.mapper.Mode;
import org.opensearch.knn.index.mapper.OriginalMappingParameters;
import org.opensearch.knn.index.mapper.PerDimensionProcessor;
import org.opensearch.knn.index.mapper.PerDimensionValidator;
import org.opensearch.knn.index.mapper.VectorValidator;

public class MethodFieldMapper
extends KNNVectorFieldMapper {
    private final PerDimensionProcessor perDimensionProcessor;
    private final PerDimensionValidator perDimensionValidator;
    private final VectorValidator vectorValidator;

    public static MethodFieldMapper createFieldMapper(String fullname, String simpleName, Map<String, String> metaValue, final KNNMethodConfigContext knnMethodConfigContext, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, final OriginalMappingParameters originalMappingParameters) {
        KNNMethodContext knnMethodContext = originalMappingParameters.getResolvedKnnMethodContext();
        final QuantizationConfig quantizationConfig = knnMethodContext.getKnnEngine().getKNNLibraryIndexingContext(knnMethodContext, knnMethodConfigContext).getQuantizationConfig();
        KNNVectorFieldType mappedFieldType = new KNNVectorFieldType(fullname, metaValue, knnMethodConfigContext.getVectorDataType(), new KNNMappingConfig(){

            @Override
            public Optional<KNNMethodContext> getKnnMethodContext() {
                return Optional.of(originalMappingParameters.getResolvedKnnMethodContext());
            }

            @Override
            public int getDimension() {
                return knnMethodConfigContext.getDimension();
            }

            @Override
            public Mode getMode() {
                return Mode.fromName(originalMappingParameters.getMode());
            }

            @Override
            public CompressionLevel getCompressionLevel() {
                return knnMethodConfigContext.getCompressionLevel();
            }

            @Override
            public QuantizationConfig getQuantizationConfig() {
                return quantizationConfig;
            }
        });
        return new MethodFieldMapper(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, knnMethodConfigContext, originalMappingParameters);
    }

    private MethodFieldMapper(String simpleName, KNNVectorFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, Explicit<Boolean> ignoreMalformed, boolean stored, boolean hasDocValues, KNNMethodConfigContext knnMethodConfigContext, OriginalMappingParameters originalMappingParameters) {
        super(simpleName, mappedFieldType, multiFields, copyTo, ignoreMalformed, stored, hasDocValues, knnMethodConfigContext.getVersionCreated(), originalMappingParameters);
        this.useLuceneBasedVectorField = KNNVectorFieldMapperUtil.useLuceneKNNVectorsFormat(this.indexCreatedVersion);
        KNNMappingConfig knnMappingConfig = mappedFieldType.getKnnMappingConfig();
        KNNMethodContext resolvedKnnMethodContext = originalMappingParameters.getResolvedKnnMethodContext();
        KNNEngine knnEngine = resolvedKnnMethodContext.getKnnEngine();
        KNNLibraryIndexingContext knnLibraryIndexingContext = knnEngine.getKNNLibraryIndexingContext(resolvedKnnMethodContext, knnMethodConfigContext);
        QuantizationConfig quantizationConfig = knnLibraryIndexingContext.getQuantizationConfig();
        this.fieldType = new FieldType((IndexableFieldType)KNNVectorFieldMapper.Defaults.FIELD_TYPE);
        this.fieldType.putAttribute("dimension", String.valueOf(knnMappingConfig.getDimension()));
        this.fieldType.putAttribute("spaceType", resolvedKnnMethodContext.getSpaceType().getValue());
        if (quantizationConfig != null && quantizationConfig != QuantizationConfig.EMPTY) {
            this.fieldType.putAttribute("qframe_config", QuantizationConfigParser.toCsv(quantizationConfig));
        }
        this.fieldType.putAttribute("data_type", this.vectorDataType.getValue());
        this.fieldType.putAttribute("engine", knnEngine.getName());
        try {
            this.fieldType.putAttribute("parameters", XContentFactory.jsonBuilder().map(knnLibraryIndexingContext.getLibraryParameters()).toString());
        }
        catch (IOException ioe) {
            throw new RuntimeException(String.format("Unable to create KNNVectorFieldMapper: %s", ioe));
        }
        if (this.useLuceneBasedVectorField) {
            int adjustedDimension = mappedFieldType.vectorDataType == VectorDataType.BINARY ? knnMappingConfig.getDimension() / 8 : knnMappingConfig.getDimension();
            VectorEncoding encoding = mappedFieldType.vectorDataType == VectorDataType.FLOAT ? VectorEncoding.FLOAT32 : VectorEncoding.BYTE;
            this.fieldType.setVectorAttributes(adjustedDimension, encoding, SpaceType.DEFAULT.getKnnVectorSimilarityFunction().getVectorSimilarityFunction());
        } else {
            this.fieldType.setDocValuesType(DocValuesType.BINARY);
        }
        this.fieldType.freeze();
        this.perDimensionProcessor = knnLibraryIndexingContext.getPerDimensionProcessor();
        this.perDimensionValidator = knnLibraryIndexingContext.getPerDimensionValidator();
        this.vectorValidator = knnLibraryIndexingContext.getVectorValidator();
    }

    @Override
    protected VectorValidator getVectorValidator() {
        return this.vectorValidator;
    }

    @Override
    protected PerDimensionValidator getPerDimensionValidator() {
        return this.perDimensionValidator;
    }

    @Override
    protected PerDimensionProcessor getPerDimensionProcessor() {
        return this.perDimensionProcessor;
    }
}

