/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javafx.scene.paint.Color;
import org.apache.commons.lang3.SystemUtils;

public class DarkModeDetector {
    public static final Map<Integer, Color[]> MACOS_ACCENT_COLOR_MAP = Map.of(-1, new Color[]{MacOSSystemColor.GRAY.colorAqua, MacOSSystemColor.GRAY.colorDark}, 0, new Color[]{MacOSSystemColor.RED.colorAqua, MacOSSystemColor.RED.colorDark}, 1, new Color[]{MacOSSystemColor.ORANGE.colorAqua, MacOSSystemColor.ORANGE.colorDark}, 2, new Color[]{MacOSSystemColor.YELLOW.colorAqua, MacOSSystemColor.YELLOW.colorDark}, 3, new Color[]{MacOSSystemColor.GREEN.colorAqua, MacOSSystemColor.GREEN.colorDark}, 4, new Color[]{MacOSSystemColor.BLUE.colorAqua, MacOSSystemColor.BLUE.colorDark}, 5, new Color[]{MacOSSystemColor.PURPLE.colorAqua, MacOSSystemColor.PURPLE.colorDark}, 6, new Color[]{MacOSSystemColor.PINK.colorAqua, MacOSSystemColor.PINK.colorDark});
    private static final String REGQUERY_UTIL = "reg query ";
    private static final String REGDWORD_TOKEN = "REG_DWORD";
    private static final String DARK_THEME_CMD = "reg query \"HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Themes\\Personalize\" /v AppsUseLightTheme";

    public static boolean isDarkMode() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return DarkModeDetector.isMacOsDarkMode();
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return DarkModeDetector.isWindowsDarkMode();
        }
        return false;
    }

    public static boolean hasDarkModeDetectionSupport() {
        return SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC_OSX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isMacOsDarkMode() {
        BufferedReader rdr = null;
        InputStreamReader isr = null;
        try {
            String line;
            boolean isDarkMode = false;
            Process process = Runtime.getRuntime().exec("defaults read -g AppleInterfaceStyle");
            isr = new InputStreamReader(process.getInputStream());
            rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                if (!line.equals("Dark")) continue;
                isDarkMode = true;
            }
            int rc = process.waitFor();
            boolean bl = 0 == rc && isDarkMode;
            return bl;
        }
        catch (IOException | InterruptedException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rdr != null) {
                    rdr.close();
                }
                if (isr != null) {
                    isr.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static boolean isWindowsDarkMode() {
        try {
            Process process = Runtime.getRuntime().exec(DARK_THEME_CMD);
            StreamReader reader = new StreamReader(process.getInputStream());
            reader.start();
            process.waitFor();
            reader.join();
            String result = reader.getResult();
            int p = result.indexOf(REGDWORD_TOKEN);
            if (p == -1) {
                return false;
            }
            String temp = result.substring(p + REGDWORD_TOKEN.length()).trim();
            return Integer.parseInt(temp.substring("0x".length()), 16) == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Color getMacOSAccentColor() {
        if (SystemUtils.IS_OS_MAC_OSX) {
            return MacOSAccentColor.MULTI_COLOR.getColorAqua();
        }
        boolean isDarkMode = DarkModeDetector.isMacOsDarkMode();
        try {
            String line;
            Integer colorKey = null;
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("defaults read -g AppleAccentColor");
            InputStreamReader isr = new InputStreamReader(process.getInputStream());
            BufferedReader rdr = new BufferedReader(isr);
            while ((line = rdr.readLine()) != null) {
                colorKey = Integer.valueOf(line);
            }
            int rc = process.waitFor();
            if (0 == rc) {
                return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(colorKey)[1] : MACOS_ACCENT_COLOR_MAP.get(colorKey)[0];
            }
            return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(4)[1] : MACOS_ACCENT_COLOR_MAP.get(4)[0];
        }
        catch (IOException | InterruptedException e) {
            return isDarkMode ? MACOS_ACCENT_COLOR_MAP.get(4)[1] : MACOS_ACCENT_COLOR_MAP.get(4)[0];
        }
    }

    static class StreamReader
    extends Thread {
        private final InputStream is;
        private final StringWriter sw;

        StreamReader(InputStream is) {
            this.is = is;
            this.sw = new StringWriter();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.is.read()) != -1) {
                    this.sw.write(c);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        String getResult() {
            return this.sw.toString();
        }
    }

    public static enum MacOSAccentColor {
        MULTI_COLOR(null, MacOSSystemColor.BLUE.colorAqua, MacOSSystemColor.BLUE.colorDark),
        GRAPHITE(-1, MacOSSystemColor.GRAY.colorAqua, MacOSSystemColor.GRAY.colorDark),
        RED(0, MacOSSystemColor.RED.colorAqua, MacOSSystemColor.RED.colorDark),
        ORANGE(1, MacOSSystemColor.ORANGE.colorAqua, MacOSSystemColor.ORANGE.colorDark),
        YELLOW(2, MacOSSystemColor.YELLOW.colorAqua, MacOSSystemColor.YELLOW.colorDark),
        GREEN(3, MacOSSystemColor.GREEN.colorAqua, MacOSSystemColor.GREEN.colorDark),
        BLUE(4, MacOSSystemColor.BLUE.colorAqua, MacOSSystemColor.BLUE.colorDark),
        PURPLE(5, MacOSSystemColor.PURPLE.colorAqua, MacOSSystemColor.PURPLE.colorDark),
        PINK(6, MacOSSystemColor.PINK.colorAqua, MacOSSystemColor.PINK.colorDark);

        final Integer key;
        final Color colorAqua;
        final Color colorDark;

        private MacOSAccentColor(Integer key, Color colorAqua, Color colorDark) {
            this.key = key;
            this.colorAqua = colorAqua;
            this.colorDark = colorDark;
        }

        public static List<MacOSAccentColor> getAsList() {
            return Arrays.asList(MacOSAccentColor.values());
        }

        public Integer getKey() {
            return this.key;
        }

        public Color getColorAqua() {
            return this.colorAqua;
        }

        public Color getColorDark() {
            return this.colorDark;
        }

        public boolean isGivenColor(Color color) {
            return this.colorAqua.equals(color) || this.colorDark.equals(color);
        }
    }

    public static enum MacOSSystemColor {
        BLUE(Color.rgb(0, 122, 255), Color.rgb(10, 132, 255)),
        BROWN(Color.rgb(162, 132, 94), Color.rgb(172, 142, 104)),
        GRAY(Color.rgb(142, 142, 147), Color.rgb(152, 152, 157)),
        GREEN(Color.rgb(40, 205, 65), Color.rgb(50, 215, 75)),
        INIDIGO(Color.rgb(88, 86, 214), Color.rgb(94, 92, 230)),
        ORANGE(Color.rgb(255, 149, 0), Color.rgb(255, 159, 0)),
        PINK(Color.rgb(255, 45, 85), Color.rgb(255, 55, 95)),
        PURPLE(Color.rgb(175, 82, 222), Color.rgb(191, 90, 242)),
        RED(Color.rgb(255, 59, 48), Color.rgb(255, 69, 58)),
        TEAL(Color.rgb(85, 190, 240), Color.rgb(90, 200, 245)),
        YELLOW(Color.rgb(255, 204, 0), Color.rgb(255, 214, 10));

        final Color colorAqua;
        final Color colorDark;

        private MacOSSystemColor(Color colorAqua, Color colorDark) {
            this.colorAqua = colorAqua;
            this.colorDark = colorDark;
        }

        public static List<MacOSSystemColor> getAsList() {
            return Arrays.asList(MacOSSystemColor.values());
        }

        public Color getColorAqua() {
            return this.colorAqua;
        }

        public Color getColorDark() {
            return this.colorDark;
        }

        public boolean isGivenColor(Color color) {
            return this.colorAqua.equals(color) || this.colorDark.equals(color);
        }
    }
}

