/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.WriteRequest;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.resthandler.RestIndexMonitorActionKt;
import org.opensearch.client.node.NodeClient;
import org.opensearch.commons.alerting.action.AlertingActions;
import org.opensearch.commons.alerting.action.IndexMonitorRequest;
import org.opensearch.commons.alerting.action.IndexMonitorResponse;
import org.opensearch.commons.alerting.model.BucketLevelTrigger;
import org.opensearch.commons.alerting.model.DocLevelMonitorInput;
import org.opensearch.commons.alerting.model.DocLevelQuery;
import org.opensearch.commons.alerting.model.DocumentLevelTrigger;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.model.QueryLevelTrigger;
import org.opensearch.commons.alerting.model.Trigger;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.commons.alerting.util.IndexUtilsKt;
import org.opensearch.commons.utils.ValidationHelpersKt;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestResponseListener;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u001e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0012\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u0004H\u0002\u00a8\u0006\u001f"}, d2={"Lorg/opensearch/alerting/resthandler/RestIndexMonitorAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "indexMonitorResponse", "Lorg/opensearch/rest/action/RestResponseListener;", "Lorg/opensearch/commons/alerting/action/IndexMonitorResponse;", "channel", "Lorg/opensearch/rest/RestChannel;", "restMethod", "Lorg/opensearch/rest/RestRequest$Method;", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "validateDataSources", "", "monitor", "Lorg/opensearch/commons/alerting/model/Monitor;", "validateDocLevelQueryName", "validateOwner", "owner", "opensearch-alerting"})
@SourceDebugExtension(value={"SMAP\nRestIndexMonitorAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RestIndexMonitorAction.kt\norg/opensearch/alerting/resthandler/RestIndexMonitorAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,211:1\n1855#2,2:212\n1855#2,2:214\n1855#2,2:216\n1855#2,2:218\n800#2,11:220\n1855#2:231\n1855#2,2:232\n1856#2:234\n*S KotlinDebug\n*F\n+ 1 RestIndexMonitorAction.kt\norg/opensearch/alerting/resthandler/RestIndexMonitorAction\n*L\n109#1:212,2\n117#1:214,2\n125#1:216,2\n134#1:218,2\n161#1:220,11\n161#1:231\n162#1:232,2\n161#1:234\n*E\n"})
public final class RestIndexMonitorAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "index_monitor_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI, RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI), new RestHandler.ReplacedRoute(RestRequest.Method.PUT, AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}", RestRequest.Method.PUT, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/{monitorID}")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) throws IOException {
        List rbacRoles;
        Monitor monitor;
        String id;
        block13: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)client, (String)"client");
            RestIndexMonitorActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_BASE_URI);
            id = request.param("monitorID", "");
            if (request.method() == RestRequest.Method.PUT && Intrinsics.areEqual((Object)"", (Object)id)) {
                throw AlertingException.Companion.wrap((Exception)new IllegalArgumentException("Missing monitor ID"));
            }
            XContentParser xcp = request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            monitor = null;
            rbacRoles = null;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)xcp, (String)"xcp");
                Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                Monitor monitor2 = Monitor.Companion.parse$default((Monitor.Companion)Monitor.Companion, (XContentParser)xcp, (String)id, (long)0L, (int)4, null);
                Instant instant = Instant.now();
                Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now()");
                monitor = Monitor.copy$default((Monitor)monitor2, null, (long)0L, null, (boolean)false, null, (Instant)instant, null, null, null, (int)0, null, null, null, null, null, (int)32735, null);
                rbacRoles = (List)request.contentParser().map().get("rbac_roles");
                this.validateDataSources(monitor);
                this.validateOwner(monitor.getOwner());
                String monitorType = monitor.getMonitorType();
                List triggers = monitor.getTriggers();
                if (!IndexUtilsKt.isMonitorOfStandardType((Monitor)monitor)) break block13;
                String string = monitor.getMonitorType();
                Locale locale = Locale.ROOT;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
                String string2 = string.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                switch (WhenMappings.$EnumSwitchMapping$0[Monitor.MonitorType.valueOf((String)string2).ordinal()]) {
                    case 1: {
                        Iterable $this$forEach$iv = triggers;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Trigger it = (Trigger)element$iv;
                            boolean bl = false;
                            if (it instanceof QueryLevelTrigger) continue;
                            throw new IllegalArgumentException("Illegal trigger type, " + it.getClass().getName() + ", for query level monitor");
                        }
                        break;
                    }
                    case 2: {
                        Iterable $this$forEach$iv = triggers;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Trigger it = (Trigger)element$iv;
                            boolean bl = false;
                            if (it instanceof BucketLevelTrigger) continue;
                            throw new IllegalArgumentException("Illegal trigger type, " + it.getClass().getName() + ", for bucket level monitor");
                        }
                        break;
                    }
                    case 3: {
                        Iterable $this$forEach$iv = triggers;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Trigger it = (Trigger)element$iv;
                            boolean bl = false;
                            if (it instanceof QueryLevelTrigger) continue;
                            throw new IllegalArgumentException("Illegal trigger type, " + it.getClass().getName() + ", for cluster metrics monitor");
                        }
                        break;
                    }
                    case 4: {
                        this.validateDocLevelQueryName(monitor);
                        Iterable $this$forEach$iv = triggers;
                        boolean $i$f$forEach = false;
                        for (Object element$iv : $this$forEach$iv) {
                            Trigger it = (Trigger)element$iv;
                            boolean bl = false;
                            if (it instanceof DocumentLevelTrigger) continue;
                            throw new IllegalArgumentException("Illegal trigger type, " + it.getClass().getName() + ", for document level monitor");
                        }
                    }
                    default: {
                        break;
                    }
                }
            }
            catch (Exception e) {
                throw AlertingException.Companion.wrap(e);
            }
        }
        long seqNo = request.paramAsLong("if_seq_no", -2L);
        long primaryTerm = request.paramAsLong("if_primary_term", 0L);
        WriteRequest.RefreshPolicy refreshPolicy = request.hasParam("refresh") ? WriteRequest.RefreshPolicy.parse((String)request.param("refresh")) : WriteRequest.RefreshPolicy.IMMEDIATE;
        Intrinsics.checkNotNullExpressionValue((Object)refreshPolicy, (String)"refreshPolicy");
        RestRequest.Method method = request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        IndexMonitorRequest indexMonitorRequest = new IndexMonitorRequest(id, seqNo, primaryTerm, refreshPolicy, method, monitor, rbacRoles);
        return arg_0 -> RestIndexMonitorAction.prepareRequest$lambda$4(client, indexMonitorRequest, this, request, arg_0);
    }

    /*
     * WARNING - void declaration
     */
    private final void validateDocLevelQueryName(Monitor monitor) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = monitor.getInputs();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof DocLevelMonitorInput)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DocLevelMonitorInput docLevelMonitorInput = (DocLevelMonitorInput)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = docLevelMonitorInput.getQueries();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                DocLevelQuery dlq = (DocLevelQuery)element$iv2;
                boolean bl2 = false;
                if (ValidationHelpersKt.isValidName((String)dlq.getName())) continue;
                throw new IllegalArgumentException("Doc level query name may not start with [_, +, -], contain '..', or contain: " + StringsKt.replace$default((String)ValidationHelpersKt.getInvalidNameChars(), (String)"\\", (String)"", (boolean)false, (int)4, null));
            }
        }
    }

    private final void validateDataSources(Monitor monitor) {
        if (!(monitor.getDataSources() == null || Intrinsics.areEqual((Object)monitor.getDataSources().getQueryIndex(), (Object)".opensearch-alerting-queries") && Intrinsics.areEqual((Object)monitor.getDataSources().getFindingsIndex(), (Object)".opensearch-alerting-finding-history-write") && Intrinsics.areEqual((Object)monitor.getDataSources().getAlertsIndex(), (Object)".opendistro-alerting-alerts"))) {
            throw new IllegalArgumentException("Custom Data Sources are not allowed.");
        }
    }

    private final void validateOwner(String owner) {
        if (!Intrinsics.areEqual((Object)owner, (Object)"alerting")) {
            throw new IllegalArgumentException("Invalid owner field");
        }
    }

    private final RestResponseListener<IndexMonitorResponse> indexMonitorResponse(RestChannel channel, RestRequest.Method restMethod) {
        return (RestResponseListener)new RestResponseListener<IndexMonitorResponse>(channel, restMethod){
            final /* synthetic */ RestChannel $channel;
            final /* synthetic */ RestRequest.Method $restMethod;
            {
                this.$channel = $channel;
                this.$restMethod = $restMethod;
                super($channel);
            }

            @NotNull
            public RestResponse buildResponse(@NotNull IndexMonitorResponse response2) throws Exception {
                Intrinsics.checkNotNullParameter((Object)response2, (String)"response");
                RestStatus returnStatus = RestStatus.CREATED;
                if (this.$restMethod == RestRequest.Method.PUT) {
                    returnStatus = RestStatus.OK;
                }
                XContentBuilder xContentBuilder = this.$channel.newBuilder();
                Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"channel.newBuilder()");
                ToXContent.Params params = ToXContent.EMPTY_PARAMS;
                Intrinsics.checkNotNullExpressionValue((Object)params, (String)"EMPTY_PARAMS");
                BytesRestResponse restResponse = new BytesRestResponse(returnStatus, response2.toXContent(xContentBuilder, params));
                if (returnStatus == RestStatus.CREATED) {
                    String location = AlertingPlugin.MONITOR_BASE_URI + "/" + response2.getId();
                    restResponse.addHeader("Location", location);
                }
                return (RestResponse)restResponse;
            }
        };
    }

    private static final void prepareRequest$lambda$4(NodeClient $client, IndexMonitorRequest $indexMonitorRequest, RestIndexMonitorAction this$0, RestRequest $request, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        Intrinsics.checkNotNullParameter((Object)$indexMonitorRequest, (String)"$indexMonitorRequest");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        ActionRequest actionRequest = (ActionRequest)$indexMonitorRequest;
        Intrinsics.checkNotNullExpressionValue((Object)channel, (String)"channel");
        RestRequest.Method method = $request.method();
        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"request.method()");
        $client.execute(AlertingActions.INDEX_MONITOR_ACTION_TYPE, actionRequest, (ActionListener)this$0.indexMonitorResponse(channel, method));
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Monitor.MonitorType.values().length];
            try {
                nArray[Monitor.MonitorType.QUERY_LEVEL_MONITOR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Monitor.MonitorType.BUCKET_LEVEL_MONITOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Monitor.MonitorType.CLUSTER_METRICS_MONITOR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Monitor.MonitorType.DOC_LEVEL_MONITOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

