// Copyright (c) Lawrence Livermore National Security, LLC and other Conduit
// Project developers. See top-level LICENSE AND COPYRIGHT files for dates and
// other details. No copyright assignment is required to contribute to Conduit.

//-----------------------------------------------------------------------------
///
/// file: conduit_config.h
///
//-----------------------------------------------------------------------------

#ifndef CONDUIT_CONFIG_H
#define CONDUIT_CONFIG_H

//-----------------------------------------------------------------------------
//
// #define platform check helpers
//
//-----------------------------------------------------------------------------

#if defined(WIN32) || defined(_WIN32) || defined(__WIN32) && !defined(__CYGWIN__)
#define CONDUIT_PLATFORM_WINDOWS
#elif  defined(__APPLE__)
#define CONDUIT_PLATFORM_APPLE
#else
#define CONDUIT_PLATFORM_UNIX
#endif

/* #undef CONDUIT_INSTALL_PREFIX */

// version info
#define CONDUIT_VERSION "0.8.3"
#define CONDUIT_VERSION_MAJOR 0
#define CONDUIT_VERSION_MINOR 8
#define CONDUIT_VERSION_PATCH 3

#define CONDUIT_GIT_SHA1 "d8000c2d46b8ea968c2b7551cd0ce2af5b75b6da"
/* #undef CONDUIT_GIT_SHA1_ABBREV */
/* #undef CONDUIT_GIT_TAG */

#define CONDUIT_SYSTEM_TYPE "Linux-5.1.16-1-ARCH"

#define CONDUIT_CPP_COMPILER "/usr/lib/distcc/bin/c++"

/* #undef CONDUIT_FORTRAN_COMPILER */

/* #undef CONDUIT_USE_FMT */

#define CONDUIT_USE_CXX11

/* #undef CONDUIT_USE_CALIPER */

#endif



