/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.saber;

import org.bouncycastle.pqc.crypto.saber.SABEREngine;

class Utils {
    private final int SABER_N;
    private final int SABER_L;
    private final int SABER_ET;
    private final int SABER_POLYBYTES;
    private final int SABER_EP;
    private final int SABER_KEYBYTES;
    private final boolean usingEffectiveMasking;

    public Utils(SABEREngine engine) {
        this.SABER_N = engine.getSABER_N();
        this.SABER_L = engine.getSABER_L();
        this.SABER_ET = engine.getSABER_ET();
        this.SABER_POLYBYTES = engine.getSABER_POLYBYTES();
        this.SABER_EP = engine.getSABER_EP();
        this.SABER_KEYBYTES = engine.getSABER_KEYBYTES();
        this.usingEffectiveMasking = engine.usingEffectiveMasking;
    }

    public void POLT2BS(byte[] bytes, int byteIndex, short[] data) {
        block4: {
            block5: {
                block3: {
                    if (this.SABER_ET != 3) break block3;
                    for (int j = 0; j < this.SABER_N / 8; j = (int)((short)(j + 1))) {
                        short offset_byte = (short)(3 * j);
                        short offset_data = (short)(8 * j);
                        bytes[byteIndex + offset_byte + 0] = (byte)(data[offset_data + 0] & 7 | (data[offset_data + 1] & 7) << 3 | (data[offset_data + 2] & 3) << 6);
                        bytes[byteIndex + offset_byte + 1] = (byte)(data[offset_data + 2] >> 2 & 1 | (data[offset_data + 3] & 7) << 1 | (data[offset_data + 4] & 7) << 4 | (data[offset_data + 5] & 1) << 7);
                        bytes[byteIndex + offset_byte + 2] = (byte)(data[offset_data + 5] >> 1 & 3 | (data[offset_data + 6] & 7) << 2 | (data[offset_data + 7] & 7) << 5);
                    }
                    break block4;
                }
                if (this.SABER_ET != 4) break block5;
                for (int j = 0; j < this.SABER_N / 2; j = (int)((short)(j + 1))) {
                    int offset_byte = j;
                    short offset_data = (short)(2 * j);
                    bytes[byteIndex + offset_byte] = (byte)(data[offset_data] & 0xF | (data[offset_data + 1] & 0xF) << 4);
                }
                break block4;
            }
            if (this.SABER_ET != 6) break block4;
            for (int j = 0; j < this.SABER_N / 4; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(3 * j);
                short offset_data = (short)(4 * j);
                bytes[byteIndex + offset_byte + 0] = (byte)(data[offset_data + 0] & 0x3F | (data[offset_data + 1] & 3) << 6);
                bytes[byteIndex + offset_byte + 1] = (byte)(data[offset_data + 1] >> 2 & 0xF | (data[offset_data + 2] & 0xF) << 4);
                bytes[byteIndex + offset_byte + 2] = (byte)(data[offset_data + 2] >> 4 & 3 | (data[offset_data + 3] & 0x3F) << 2);
            }
        }
    }

    public void BS2POLT(byte[] bytes, int byteIndex, short[] data) {
        block4: {
            block5: {
                block3: {
                    if (this.SABER_ET != 3) break block3;
                    for (int j = 0; j < this.SABER_N / 8; j = (int)((short)(j + 1))) {
                        short offset_byte = (short)(3 * j);
                        short offset_data = (short)(8 * j);
                        data[offset_data + 0] = (short)(bytes[byteIndex + offset_byte + 0] & 7);
                        data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte + 0] >> 3 & 7);
                        data[offset_data + 2] = (short)(bytes[byteIndex + offset_byte + 0] >> 6 & 3 | (bytes[byteIndex + offset_byte + 1] & 1) << 2);
                        data[offset_data + 3] = (short)(bytes[byteIndex + offset_byte + 1] >> 1 & 7);
                        data[offset_data + 4] = (short)(bytes[byteIndex + offset_byte + 1] >> 4 & 7);
                        data[offset_data + 5] = (short)(bytes[byteIndex + offset_byte + 1] >> 7 & 1 | (bytes[byteIndex + offset_byte + 2] & 3) << 1);
                        data[offset_data + 6] = (short)(bytes[byteIndex + offset_byte + 2] >> 2 & 7);
                        data[offset_data + 7] = (short)(bytes[byteIndex + offset_byte + 2] >> 5 & 7);
                    }
                    break block4;
                }
                if (this.SABER_ET != 4) break block5;
                for (int j = 0; j < this.SABER_N / 2; j = (int)((short)(j + 1))) {
                    int offset_byte = j;
                    short offset_data = (short)(2 * j);
                    data[offset_data] = (short)(bytes[byteIndex + offset_byte] & 0xF);
                    data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte] >> 4 & 0xF);
                }
                break block4;
            }
            if (this.SABER_ET != 6) break block4;
            for (int j = 0; j < this.SABER_N / 4; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(3 * j);
                short offset_data = (short)(4 * j);
                data[offset_data + 0] = (short)(bytes[byteIndex + offset_byte + 0] & 0x3F);
                data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte + 0] >> 6 & 3 | (bytes[byteIndex + offset_byte + 1] & 0xF) << 2);
                data[offset_data + 2] = (short)((bytes[byteIndex + offset_byte + 1] & 0xFF) >> 4 | (bytes[byteIndex + offset_byte + 2] & 3) << 4);
                data[offset_data + 3] = (short)((bytes[byteIndex + offset_byte + 2] & 0xFF) >> 2);
            }
        }
    }

    private void POLq2BS(byte[] bytes, int byteIndex, short[] data) {
        if (!this.usingEffectiveMasking) {
            for (int j = 0; j < this.SABER_N / 8; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(13 * j);
                short offset_data = (short)(8 * j);
                bytes[byteIndex + offset_byte + 0] = (byte)(data[offset_data + 0] & 0xFF);
                bytes[byteIndex + offset_byte + 1] = (byte)(data[offset_data + 0] >> 8 & 0x1F | (data[offset_data + 1] & 7) << 5);
                bytes[byteIndex + offset_byte + 2] = (byte)(data[offset_data + 1] >> 3 & 0xFF);
                bytes[byteIndex + offset_byte + 3] = (byte)(data[offset_data + 1] >> 11 & 3 | (data[offset_data + 2] & 0x3F) << 2);
                bytes[byteIndex + offset_byte + 4] = (byte)(data[offset_data + 2] >> 6 & 0x7F | (data[offset_data + 3] & 1) << 7);
                bytes[byteIndex + offset_byte + 5] = (byte)(data[offset_data + 3] >> 1 & 0xFF);
                bytes[byteIndex + offset_byte + 6] = (byte)(data[offset_data + 3] >> 9 & 0xF | (data[offset_data + 4] & 0xF) << 4);
                bytes[byteIndex + offset_byte + 7] = (byte)(data[offset_data + 4] >> 4 & 0xFF);
                bytes[byteIndex + offset_byte + 8] = (byte)(data[offset_data + 4] >> 12 & 1 | (data[offset_data + 5] & 0x7F) << 1);
                bytes[byteIndex + offset_byte + 9] = (byte)(data[offset_data + 5] >> 7 & 0x3F | (data[offset_data + 6] & 3) << 6);
                bytes[byteIndex + offset_byte + 10] = (byte)(data[offset_data + 6] >> 2 & 0xFF);
                bytes[byteIndex + offset_byte + 11] = (byte)(data[offset_data + 6] >> 10 & 7 | (data[offset_data + 7] & 0x1F) << 3);
                bytes[byteIndex + offset_byte + 12] = (byte)(data[offset_data + 7] >> 5 & 0xFF);
            }
        } else {
            for (int j = 0; j < this.SABER_N / 2; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(3 * j);
                short offset_data = (short)(2 * j);
                bytes[byteIndex + offset_byte + 0] = (byte)(data[offset_data + 0] & 0xFF);
                bytes[byteIndex + offset_byte + 1] = (byte)(data[offset_data + 0] >> 8 & 0xF | (data[offset_data + 1] & 0xF) << 4);
                bytes[byteIndex + offset_byte + 2] = (byte)(data[offset_data + 1] >> 4 & 0xFF);
            }
        }
    }

    private void BS2POLq(byte[] bytes, int byteIndex, short[] data) {
        if (!this.usingEffectiveMasking) {
            for (int j = 0; j < this.SABER_N / 8; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(13 * j);
                short offset_data = (short)(8 * j);
                data[offset_data + 0] = (short)(bytes[byteIndex + offset_byte + 0] & 0xFF | (bytes[byteIndex + offset_byte + 1] & 0x1F) << 8);
                data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte + 1] >> 5 & 7 | (bytes[byteIndex + offset_byte + 2] & 0xFF) << 3 | (bytes[byteIndex + offset_byte + 3] & 3) << 11);
                data[offset_data + 2] = (short)(bytes[byteIndex + offset_byte + 3] >> 2 & 0x3F | (bytes[byteIndex + offset_byte + 4] & 0x7F) << 6);
                data[offset_data + 3] = (short)(bytes[byteIndex + offset_byte + 4] >> 7 & 1 | (bytes[byteIndex + offset_byte + 5] & 0xFF) << 1 | (bytes[byteIndex + offset_byte + 6] & 0xF) << 9);
                data[offset_data + 4] = (short)(bytes[byteIndex + offset_byte + 6] >> 4 & 0xF | (bytes[byteIndex + offset_byte + 7] & 0xFF) << 4 | (bytes[byteIndex + offset_byte + 8] & 1) << 12);
                data[offset_data + 5] = (short)(bytes[byteIndex + offset_byte + 8] >> 1 & 0x7F | (bytes[byteIndex + offset_byte + 9] & 0x3F) << 7);
                data[offset_data + 6] = (short)(bytes[byteIndex + offset_byte + 9] >> 6 & 3 | (bytes[byteIndex + offset_byte + 10] & 0xFF) << 2 | (bytes[byteIndex + offset_byte + 11] & 7) << 10);
                data[offset_data + 7] = (short)(bytes[byteIndex + offset_byte + 11] >> 3 & 0x1F | (bytes[byteIndex + offset_byte + 12] & 0xFF) << 5);
            }
        } else {
            for (int j = 0; j < this.SABER_N / 2; j = (int)((short)(j + 1))) {
                short offset_byte = (short)(3 * j);
                short offset_data = (short)(2 * j);
                data[offset_data + 0] = (short)(bytes[byteIndex + offset_byte + 0] & 0xFF | (bytes[byteIndex + offset_byte + 1] & 0xF) << 8);
                data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte + 1] >> 4 & 0xF | (bytes[byteIndex + offset_byte + 2] & 0xFF) << 4);
            }
        }
    }

    private void POLp2BS(byte[] bytes, int byteIndex, short[] data) {
        for (int j = 0; j < this.SABER_N / 4; j = (int)((short)(j + 1))) {
            short offset_byte = (short)(5 * j);
            short offset_data = (short)(4 * j);
            bytes[byteIndex + offset_byte + 0] = (byte)(data[offset_data + 0] & 0xFF);
            bytes[byteIndex + offset_byte + 1] = (byte)(data[offset_data + 0] >> 8 & 3 | (data[offset_data + 1] & 0x3F) << 2);
            bytes[byteIndex + offset_byte + 2] = (byte)(data[offset_data + 1] >> 6 & 0xF | (data[offset_data + 2] & 0xF) << 4);
            bytes[byteIndex + offset_byte + 3] = (byte)(data[offset_data + 2] >> 4 & 0x3F | (data[offset_data + 3] & 3) << 6);
            bytes[byteIndex + offset_byte + 4] = (byte)(data[offset_data + 3] >> 2 & 0xFF);
        }
    }

    public void BS2POLp(byte[] bytes, int byteIndex, short[] data) {
        for (int j = 0; j < this.SABER_N / 4; j = (int)((short)(j + 1))) {
            short offset_byte = (short)(5 * j);
            short offset_data = (short)(4 * j);
            data[offset_data + 0] = (short)(bytes[byteIndex + offset_byte + 0] & 0xFF | (bytes[byteIndex + offset_byte + 1] & 3) << 8);
            data[offset_data + 1] = (short)(bytes[byteIndex + offset_byte + 1] >> 2 & 0x3F | (bytes[byteIndex + offset_byte + 2] & 0xF) << 6);
            data[offset_data + 2] = (short)(bytes[byteIndex + offset_byte + 2] >> 4 & 0xF | (bytes[byteIndex + offset_byte + 3] & 0x3F) << 4);
            data[offset_data + 3] = (short)(bytes[byteIndex + offset_byte + 3] >> 6 & 3 | (bytes[byteIndex + offset_byte + 4] & 0xFF) << 2);
        }
    }

    public void POLVECq2BS(byte[] bytes, short[][] data) {
        for (int i = 0; i < this.SABER_L; i = (int)((byte)(i + 1))) {
            this.POLq2BS(bytes, i * this.SABER_POLYBYTES, data[i]);
        }
    }

    public void BS2POLVECq(byte[] bytes, int byteIndex, short[][] data) {
        for (int i = 0; i < this.SABER_L; i = (int)((byte)(i + 1))) {
            this.BS2POLq(bytes, byteIndex + i * this.SABER_POLYBYTES, data[i]);
        }
    }

    public void POLVECp2BS(byte[] bytes, short[][] data) {
        for (int i = 0; i < this.SABER_L; i = (int)((byte)(i + 1))) {
            this.POLp2BS(bytes, i * (this.SABER_EP * this.SABER_N / 8), data[i]);
        }
    }

    public void BS2POLVECp(byte[] bytes, short[][] data) {
        for (int i = 0; i < this.SABER_L; i = (int)((byte)(i + 1))) {
            this.BS2POLp(bytes, i * (this.SABER_EP * this.SABER_N / 8), data[i]);
        }
    }

    public void BS2POLmsg(byte[] bytes, short[] data) {
        for (int j = 0; j < this.SABER_KEYBYTES; j = (int)((byte)(j + 1))) {
            for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                data[j * 8 + i] = (short)(bytes[j] >> i & 1);
            }
        }
    }

    public void POLmsg2BS(byte[] bytes, short[] data) {
        for (int j = 0; j < this.SABER_KEYBYTES; j = (int)((byte)(j + 1))) {
            for (int i = 0; i < 8; i = (int)((byte)(i + 1))) {
                bytes[j] = (byte)(bytes[j] | (data[j * 8 + i] & 1) << i);
            }
        }
    }
}

