/************************************************************************
 * This program is free software; you can redistribute it and/or modify *
 * it under the terms of the GNU General Public License as published by *
 * the Free Software Foundation; either version 2 of the License, or    *
 * (at your option) any later version.                                  *
 *                                                                      *
 * This program is distributed in the hope that it will be useful,      *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of       *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the        *
 * GNU General Public License for more details.                         *
 *                                                                      *
 * You should have received a copy of the GNU General Public License    *
 * along with this program; if not, write to the                        *
 * Free Software Foundation, Inc.,                                      *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.             *
 ************************************************************************/

#ifndef __FCITX_MODULE_FCITX_CHTTRANS_API_H
#define __FCITX_MODULE_FCITX_CHTTRANS_API_H

#include <stdint.h>
#include <stdarg.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>
#include "chttrans.h"

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-chttrans", Chttrans)

DEFINE_GET_AND_INVOKE_FUNC(Chttrans, S2T, 0)
static inline char*
FcitxChttransS2T(FcitxInstance *instance, const char* _arg0)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    result = FcitxChttransInvokeS2T(instance, args);
    FCITX_RETURN_FROM_PTR(char*, result);
}

DEFINE_GET_AND_INVOKE_FUNC(Chttrans, T2S, 1)
static inline char*
FcitxChttransT2S(FcitxInstance *instance, const char* _arg0)
{
    void *result = NULL;
    FCITX_DEF_CAST_TO_PTR(arg0, const char*, _arg0);
    FCITX_DEF_MODULE_ARGS(args, arg0);
    result = FcitxChttransInvokeT2S(instance, args);
    FCITX_RETURN_FROM_PTR(char*, result);
}


#ifdef __cplusplus
}
#endif

#endif
