/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.java17;

import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.OpsBuilder;
import com.google.googlejavaformat.java.JavaInputAstVisitor;
import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.util.List;
import java.util.Optional;
import javax.lang.model.element.Name;

public class Java17InputAstVisitor
extends JavaInputAstVisitor {
    public Java17InputAstVisitor(OpsBuilder builder, int indentMultiplier) {
        super(builder, indentMultiplier);
    }

    @Override
    protected void handleModule(boolean afterFirstToken, CompilationUnitTree node) {
        ModuleTree module = node.getModule();
        if (module != null) {
            if (afterFirstToken) {
                this.builder.blankLineWanted(OpsBuilder.BlankLineWanted.YES);
            }
            this.markForPartialFormat();
            this.visitModule(module, null);
            this.builder.forcedBreak();
        }
    }

    @Override
    protected List<? extends Tree> getPermitsClause(ClassTree node) {
        return node.getPermitsClause();
    }

    @Override
    public Void visitBindingPattern(BindingPatternTree node, Void unused) {
        this.sync(node);
        VariableTree variableTree = node.getVariable();
        this.visitBindingPattern(variableTree.getModifiers(), variableTree.getType(), variableTree.getName());
        return null;
    }

    private void visitBindingPattern(ModifiersTree modifiers, Tree type, Name name) {
        this.builder.open(this.plusFour);
        this.declareOne(JavaInputAstVisitor.DeclarationKind.PARAMETER, JavaInputAstVisitor.Direction.HORIZONTAL, Optional.of(modifiers), type, name, "", "", Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        this.builder.close();
    }

    @Override
    public Void visitYield(YieldTree node, Void aVoid) {
        this.sync(node);
        this.token("yield");
        this.builder.space();
        this.scan((Tree)node.getValue(), null);
        this.token(";");
        return null;
    }

    @Override
    public Void visitSwitchExpression(SwitchExpressionTree node, Void aVoid) {
        this.sync(node);
        this.visitSwitch(node.getExpression(), node.getCases());
        return null;
    }

    @Override
    public Void visitClass(ClassTree tree, Void unused) {
        switch (tree.getKind()) {
            case ANNOTATION_TYPE: {
                this.visitAnnotationType(tree);
                break;
            }
            case CLASS: 
            case INTERFACE: {
                this.visitClassDeclaration(tree);
                break;
            }
            case ENUM: {
                this.visitEnumDeclaration(tree);
                break;
            }
            case RECORD: {
                this.visitRecordDeclaration(tree);
                break;
            }
            default: {
                throw new AssertionError((Object)tree.getKind());
            }
        }
        return null;
    }

    public void visitRecordDeclaration(ClassTree node) {
        this.sync(node);
        this.typeDeclarationModifiers(node.getModifiers());
        Verify.verify((node.getExtendsClause() == null ? 1 : 0) != 0);
        boolean hasSuperInterfaceTypes = !node.getImplementsClause().isEmpty();
        this.token("record");
        this.builder.space();
        this.visit(node.getSimpleName());
        if (!node.getTypeParameters().isEmpty()) {
            this.token("<");
        }
        this.builder.open(this.plusFour);
        if (!node.getTypeParameters().isEmpty()) {
            this.typeParametersRest(node.getTypeParameters(), hasSuperInterfaceTypes ? this.plusFour : ZERO);
        }
        ImmutableList<JCTree.JCVariableDecl> parameters = Java17InputAstVisitor.recordVariables(node);
        this.token("(");
        if (!parameters.isEmpty()) {
            this.builder.breakToFill("");
        }
        this.visitFormals(Optional.empty(), (List<? extends VariableTree>)parameters);
        this.token(")");
        if (hasSuperInterfaceTypes) {
            this.builder.breakToFill(" ");
            this.builder.open(node.getImplementsClause().size() > 1 ? this.plusFour : ZERO);
            this.token("implements");
            this.builder.space();
            boolean afterFirstToken = false;
            for (Tree tree : node.getImplementsClause()) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        this.builder.close();
        if (node.getMembers() == null) {
            this.token(";");
        } else {
            List members = (List)node.getMembers().stream().filter(t -> (TreeInfo.flags((JCTree)t) & 0x1000000L) == 0L).collect(ImmutableList.toImmutableList());
            this.addBodyDeclarations(members, JavaInputAstVisitor.BracesOrNot.YES, JavaInputAstVisitor.FirstDeclarationsOrNot.YES);
        }
        this.dropEmptyDeclarations();
    }

    private static ImmutableList<JCTree.JCVariableDecl> recordVariables(ClassTree node) {
        return (ImmutableList)node.getMembers().stream().filter(JCTree.JCVariableDecl.class::isInstance).map(JCTree.JCVariableDecl.class::cast).filter(m -> (m.mods.flags & 0x2000000000000000L) == 0x2000000000000000L).collect(ImmutableList.toImmutableList());
    }

    @Override
    public Void visitInstanceOf(InstanceOfTree node, Void unused) {
        this.sync(node);
        this.builder.open(this.plusFour);
        this.scan((Tree)node.getExpression(), null);
        this.builder.breakOp(" ");
        this.builder.open(ZERO);
        this.token("instanceof");
        this.builder.breakOp(" ");
        if (node.getPattern() != null) {
            this.scan((Tree)node.getPattern(), null);
        } else {
            this.scan(node.getType(), null);
        }
        this.builder.close();
        this.builder.close();
        return null;
    }

    @Override
    public Void visitCase(CaseTree node, Void unused) {
        this.sync(node);
        this.markForPartialFormat();
        this.builder.forcedBreak();
        List<? extends CaseLabelTree> labels = node.getLabels();
        boolean isDefault = labels.size() == 1 && ((CaseLabelTree)Iterables.getOnlyElement(labels)).getKind().name().equals("DEFAULT_CASE_LABEL");
        this.builder.open(node.getCaseKind().equals((Object)CaseTree.CaseKind.RULE) && !node.getBody().getKind().equals((Object)Tree.Kind.BLOCK) ? this.plusFour : ZERO);
        if (isDefault) {
            this.token("default", ZERO);
        } else {
            this.token("case", ZERO);
            this.builder.open(labels.size() > 1 ? this.plusFour : ZERO);
            this.builder.space();
            boolean afterFirstToken = false;
            for (Tree tree : labels) {
                if (afterFirstToken) {
                    this.token(",");
                    this.builder.breakOp(" ");
                }
                this.scan(tree, null);
                afterFirstToken = true;
            }
            this.builder.close();
        }
        ExpressionTree guard = this.getGuard(node);
        if (guard != null) {
            this.builder.space();
            this.token("when");
            this.builder.space();
            this.scan((Tree)guard, null);
        }
        switch (node.getCaseKind()) {
            case STATEMENT: {
                this.token(":");
                this.builder.open(this.plusTwo);
                this.visitStatements(node.getStatements());
                this.builder.close();
                break;
            }
            case RULE: {
                this.builder.space();
                this.token("-");
                this.token(">");
                if (node.getBody().getKind() == Tree.Kind.BLOCK) {
                    this.builder.space();
                    this.visitBlock((BlockTree)node.getBody(), JavaInputAstVisitor.CollapseEmptyOrNot.YES, JavaInputAstVisitor.AllowLeadingBlankLine.NO, JavaInputAstVisitor.AllowTrailingBlankLine.NO);
                } else {
                    this.builder.breakOp(" ");
                    this.scan(node.getBody(), null);
                }
                this.builder.guessToken(";");
                break;
            }
            default: {
                throw new AssertionError((Object)node.getCaseKind());
            }
        }
        this.builder.close();
        return null;
    }

    protected ExpressionTree getGuard(CaseTree node) {
        return null;
    }
}

