/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.legacy.executor.format;

import com.google.common.annotations.VisibleForTesting;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.opensearch.sql.legacy.executor.format.DataRows;
import org.opensearch.sql.legacy.executor.format.DateFormat;
import org.opensearch.sql.legacy.executor.format.ResultSet;
import org.opensearch.sql.legacy.executor.format.Schema;
import org.opensearch.sql.legacy.expression.domain.BindingTuple;
import org.opensearch.sql.legacy.expression.model.ExprValue;
import org.opensearch.sql.legacy.query.planner.core.ColumnNode;

public class BindingTupleResultSet
extends ResultSet {
    public BindingTupleResultSet(List<ColumnNode> columnNodes, List<BindingTuple> bindingTuples) {
        this.schema = BindingTupleResultSet.buildSchema(columnNodes);
        this.dataRows = BindingTupleResultSet.buildDataRows(columnNodes, bindingTuples);
    }

    @VisibleForTesting
    public static Schema buildSchema(List<ColumnNode> columnNodes) {
        List<Schema.Column> columnList = columnNodes.stream().map(node -> new Schema.Column(node.getName(), node.getAlias(), node.getType())).collect(Collectors.toList());
        return new Schema(columnList);
    }

    @VisibleForTesting
    public static DataRows buildDataRows(List<ColumnNode> columnNodes, List<BindingTuple> bindingTuples) {
        List<DataRows.Row> rowList = bindingTuples.stream().map(tuple -> {
            Map<String, ExprValue> bindingMap = tuple.getBindingMap();
            HashMap<String, Object> rowMap = new HashMap<String, Object>();
            for (ColumnNode column : columnNodes) {
                String columnName = column.columnName();
                Object value = bindingMap.get(columnName).value();
                if (column.getType() == Schema.Type.DATE) {
                    value = DateFormat.getFormattedDate(new Date((Long)value), "yyyy-MM-dd HH:mm:ss.SSS");
                }
                rowMap.put(columnName, value);
            }
            return new DataRows.Row(rowMap);
        }).collect(Collectors.toList());
        return new DataRows(bindingTuples.size(), bindingTuples.size(), rowList);
    }
}

