/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner;

import org.opensearch.sql.executor.pagination.PlanSerializer;
import org.opensearch.sql.planner.logical.LogicalAggregation;
import org.opensearch.sql.planner.logical.LogicalCloseCursor;
import org.opensearch.sql.planner.logical.LogicalDedupe;
import org.opensearch.sql.planner.logical.LogicalEval;
import org.opensearch.sql.planner.logical.LogicalFetchCursor;
import org.opensearch.sql.planner.logical.LogicalFilter;
import org.opensearch.sql.planner.logical.LogicalLimit;
import org.opensearch.sql.planner.logical.LogicalNested;
import org.opensearch.sql.planner.logical.LogicalPaginate;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalProject;
import org.opensearch.sql.planner.logical.LogicalRareTopN;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.logical.LogicalRemove;
import org.opensearch.sql.planner.logical.LogicalRename;
import org.opensearch.sql.planner.logical.LogicalSort;
import org.opensearch.sql.planner.logical.LogicalValues;
import org.opensearch.sql.planner.logical.LogicalWindow;
import org.opensearch.sql.planner.physical.AggregationOperator;
import org.opensearch.sql.planner.physical.CursorCloseOperator;
import org.opensearch.sql.planner.physical.DedupeOperator;
import org.opensearch.sql.planner.physical.EvalOperator;
import org.opensearch.sql.planner.physical.FilterOperator;
import org.opensearch.sql.planner.physical.LimitOperator;
import org.opensearch.sql.planner.physical.NestedOperator;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.ProjectOperator;
import org.opensearch.sql.planner.physical.RareTopNOperator;
import org.opensearch.sql.planner.physical.RemoveOperator;
import org.opensearch.sql.planner.physical.RenameOperator;
import org.opensearch.sql.planner.physical.SortOperator;
import org.opensearch.sql.planner.physical.TakeOrderedOperator;
import org.opensearch.sql.planner.physical.ValuesOperator;
import org.opensearch.sql.planner.physical.WindowOperator;
import org.opensearch.sql.storage.read.TableScanBuilder;
import org.opensearch.sql.storage.write.TableWriteBuilder;

public class DefaultImplementor<C>
extends LogicalPlanNodeVisitor<PhysicalPlan, C> {
    @Override
    public PhysicalPlan visitRareTopN(LogicalRareTopN node, C context) {
        return new RareTopNOperator(this.visitChild(node, context), node.getCommandType(), node.getNoOfResults(), node.getFieldList(), node.getGroupByList());
    }

    @Override
    public PhysicalPlan visitDedupe(LogicalDedupe node, C context) {
        return new DedupeOperator(this.visitChild(node, context), node.getDedupeList(), node.getAllowedDuplication(), node.getKeepEmpty(), node.getConsecutive());
    }

    @Override
    public PhysicalPlan visitProject(LogicalProject node, C context) {
        return new ProjectOperator(this.visitChild(node, context), node.getProjectList(), node.getNamedParseExpressions());
    }

    @Override
    public PhysicalPlan visitWindow(LogicalWindow node, C context) {
        return new WindowOperator(this.visitChild(node, context), node.getWindowFunction(), node.getWindowDefinition());
    }

    @Override
    public PhysicalPlan visitRemove(LogicalRemove node, C context) {
        return new RemoveOperator(this.visitChild(node, context), node.getRemoveList());
    }

    @Override
    public PhysicalPlan visitEval(LogicalEval node, C context) {
        return new EvalOperator(this.visitChild(node, context), node.getExpressions());
    }

    @Override
    public PhysicalPlan visitNested(LogicalNested node, C context) {
        return new NestedOperator(this.visitChild(node, context), node.getFields());
    }

    @Override
    public PhysicalPlan visitSort(LogicalSort node, C context) {
        return new SortOperator(this.visitChild(node, context), node.getSortList());
    }

    @Override
    public PhysicalPlan visitRename(LogicalRename node, C context) {
        return new RenameOperator(this.visitChild(node, context), node.getRenameMap());
    }

    @Override
    public PhysicalPlan visitAggregation(LogicalAggregation node, C context) {
        return new AggregationOperator(this.visitChild(node, context), node.getAggregatorList(), node.getGroupByList());
    }

    @Override
    public PhysicalPlan visitFilter(LogicalFilter node, C context) {
        return new FilterOperator(this.visitChild(node, context), node.getCondition());
    }

    @Override
    public PhysicalPlan visitValues(LogicalValues node, C context) {
        return new ValuesOperator(node.getValues());
    }

    @Override
    public PhysicalPlan visitLimit(LogicalLimit node, C context) {
        PhysicalPlan child = this.visitChild(node, context);
        if (child instanceof SortOperator) {
            SortOperator sortChild = (SortOperator)child;
            return new TakeOrderedOperator(sortChild.getInput(), node.getLimit(), node.getOffset(), sortChild.getSortList());
        }
        return new LimitOperator(child, node.getLimit(), node.getOffset());
    }

    @Override
    public PhysicalPlan visitTableScanBuilder(TableScanBuilder plan, C context) {
        return plan.build();
    }

    @Override
    public PhysicalPlan visitTableWriteBuilder(TableWriteBuilder plan, C context) {
        return plan.build(this.visitChild(plan, context));
    }

    @Override
    public PhysicalPlan visitRelation(LogicalRelation node, C context) {
        throw new UnsupportedOperationException("Storage engine is responsible for implementing and optimizing logical plan with relation involved");
    }

    @Override
    public PhysicalPlan visitFetchCursor(LogicalFetchCursor plan, C context) {
        return new PlanSerializer(plan.getEngine()).convertToPlan(plan.getCursor());
    }

    @Override
    public PhysicalPlan visitCloseCursor(LogicalCloseCursor node, C context) {
        return new CursorCloseOperator(this.visitChild(node, context));
    }

    @Override
    public PhysicalPlan visitPaginate(LogicalPaginate plan, C context) {
        return this.visitChild(plan, context);
    }

    protected PhysicalPlan visitChild(LogicalPlan node, C context) {
        return (PhysicalPlan)node.getChild().get(0).accept(this, context);
    }
}

