connect-inject
==================
connect middleware for adding any script to the response, this is a forked version of connect-livereload.

This is a slightly modified version of [connect-livereload](https://github.com/intesso/connect-livereload) all the credits go to  the author.

For further documentation refer to the author's repo [connect-livereload](https://github.com/intesso/connect-livereload).

install
=======
```bash
npm install connect-inject --save-dev
```
```git
git clone https://github.com/danielhq/connect-inject.git
```
use
===

this middleware can be used to inject any sort of content into the webpage e.g. [Livereload, Weinre etc]
```
  snippet: string | Array
```
snippet now accepts either string or an array.
## connect/express example
```javascript
  app.use(require('connect-inject')({
    snippet: "<script>alert('hello world');</script>"
  }));
```


## options
Options are not mandatory: `app.use(require('connect-inject')());`
The Options have to be provided when the middleware is loaded:

e.g.:
```
  app.use(require('connect-inject')({
    snippet: "<script>alert('hello world');</script>",
    ignore: ['.js', '.svg']
  }));

```

These are the available options with the following defaults:

```javascript
  // these files will be ignored
  ignore: ['.js', '.css', '.svg', '.ico', '.woff', '.png', '.jpg', '.jpeg'],

  // this function is used to determine if the content of `res.write` or `res.end` is html.
  html: function (str) {
    return /<[:_-\w\s\!\/\=\"\']+>/i.test(str);
  },

  // rules are provided to find the place where the snippet should be inserted.
  // the main problem is that on the server side it can be tricky to determine if a string will be valid html on the client.
  // the function `fn` of the first `match` is executed like this `body.replace(rule.match, rule.fn);`
  // the function `fn` has got the arguments `fn(w, s)` where `w` is the matches string and `s` is the snippet.
  rules: [{
    match: /<\/body>/,
    fn: prepend
  }, {
    match: /<\/html>/,
    fn: prepend
  }, {
    match: /<\!DOCTYPE.+>/,
    fn: append
  }],


  // snippet taks a string argument which can be anything you want, and will be appended (by default) before </body> tag
  snippet: "<script>alert('hello world');</script>"
```


## grunt example

The following example is from an actual Gruntfile that uses [grunt-contrib-connect](https://github.com/gruntjs/grunt-contrib-connect)

```javascript
connect: {
  options: {
    port: 3000,
    hostname: 'localhost'
  },
  dev: {
    options: {
      middleware: function (connect) {
        return [
          require('connect-inject')({ snippet: "<script>alert('hello world');</script>"}),
          mountFolder(connect, '.tmp'),
          mountFolder(connect, 'app')
        ];
      }
    }
  }
}
```
For use as middleware in grunt simply add the following to the **top** of your array of middleware.

```javascript
  require('connect-inject')(),
```
You can pass in options to this call if you do not want the defaults.

`dev` is simply the name of the server being used with the task `grunt connect:dev`. The other items in the `middleware` array are all functions that either are of the form `function (req, res, next)` like `checkForDownload` or return that like `mountFolder(connect, 'something')`.


#### multiple injections
You can also do multiple injections by defining a snippet inside of a rule and setting the `runAll` option to true

```javascript
{
    runAll: true,
    rules: [
        {
            match: /<head>/ig,
            snippet: '<script src="/top_file.js"></script>',
            fn: function(w, s) {
                return w + s;
            }
        },
        {
            match: /<script .* src=".*\.test\.js"><\/script>/ig,
            snippet: [
              '<script src="/bottomFile1.js"></script>',
              '<script src="/bottomFile2.js"></script>',
              '<script src="/src-test/testUtils.js"></script>'
            ]
            fn: function(w, s) {
                return s + w;
            }
        }
    ]
}
```

credits
=======
This is a slightly modified version of [connect-livereload](https://github.com/intesso/connect-livereload) all the credits go to the author.


license
=======
[MIT License](https://github.com/intesso/connect-livereload/blob/master/LICENSE)


[![Bitdeli Badge](https://d2weczhvl823v0.cloudfront.net/danielhq/connect-inject/trend.png)](https://bitdeli.com/free "Bitdeli Badge")

