/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.websocket.server;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerEndpointConfig;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.security.ConcurrentMessageDigest;
import org.apache.tomcat.websocket.Constants;
import org.apache.tomcat.websocket.Transformation;
import org.apache.tomcat.websocket.TransformationFactory;
import org.apache.tomcat.websocket.Util;
import org.apache.tomcat.websocket.WsHandshakeResponse;
import org.apache.tomcat.websocket.pojo.PojoMethodMapping;
import org.apache.tomcat.websocket.server.WsHandshakeRequest;
import org.apache.tomcat.websocket.server.WsHttpUpgradeHandler;
import org.apache.tomcat.websocket.server.WsPerSessionServerEndpointConfig;
import org.apache.tomcat.websocket.server.WsServerContainer;

public class UpgradeUtil {
    private static final StringManager sm = StringManager.getManager((String)UpgradeUtil.class.getPackage().getName());
    private static final byte[] WS_ACCEPT = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes(StandardCharsets.ISO_8859_1);

    private UpgradeUtil() {
    }

    public static boolean isWebSocketUpgradeRequest(ServletRequest servletRequest, ServletResponse servletResponse) {
        return servletRequest instanceof HttpServletRequest && servletResponse instanceof HttpServletResponse && UpgradeUtil.headerContainsToken((HttpServletRequest)servletRequest, "Upgrade", "websocket") && "GET".equals(((HttpServletRequest)servletRequest).getMethod());
    }

    public static void doUpgrade(WsServerContainer wsServerContainer, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, ServerEndpointConfig serverEndpointConfig, Map<String, String> map) throws ServletException, IOException {
        Object deploymentException;
        List<Extension> list;
        String string = null;
        if (!UpgradeUtil.headerContainsToken(httpServletRequest, "Connection", "upgrade")) {
            httpServletResponse.sendError(400);
            return;
        }
        if (!UpgradeUtil.headerContainsToken(httpServletRequest, "Sec-WebSocket-Version", "13")) {
            httpServletResponse.setStatus(426);
            httpServletResponse.setHeader("Sec-WebSocket-Version", "13");
            return;
        }
        String string2 = httpServletRequest.getHeader("Sec-WebSocket-Key");
        if (!UpgradeUtil.validateKey(string2)) {
            httpServletResponse.sendError(400);
            return;
        }
        String string3 = httpServletRequest.getHeader("Origin");
        if (!serverEndpointConfig.getConfigurator().checkOrigin(string3)) {
            httpServletResponse.sendError(403);
            return;
        }
        List<String> list2 = UpgradeUtil.getTokensFromHeader(httpServletRequest, "Sec-WebSocket-Protocol");
        string = serverEndpointConfig.getConfigurator().getNegotiatedSubprotocol(serverEndpointConfig.getSubprotocols(), list2);
        ArrayList<Extension> arrayList = new ArrayList<Extension>();
        Enumeration enumeration = httpServletRequest.getHeaders("Sec-WebSocket-Extensions");
        while (enumeration.hasMoreElements()) {
            Util.parseExtensionHeader(arrayList, (String)enumeration.nextElement());
        }
        List<Extension> list3 = null;
        if (serverEndpointConfig.getExtensions().size() == 0) {
            list3 = Constants.INSTALLED_EXTENSIONS;
        } else {
            list3 = new ArrayList<Extension>();
            list3.addAll(serverEndpointConfig.getExtensions());
            list3.addAll(Constants.INSTALLED_EXTENSIONS);
        }
        List list4 = serverEndpointConfig.getConfigurator().getNegotiatedExtensions(list3, arrayList);
        List<Transformation> list5 = UpgradeUtil.createTransformations(list4);
        if (list5.isEmpty()) {
            list = Collections.emptyList();
        } else {
            list = new ArrayList(list5.size());
            for (Transformation object32 : list5) {
                list.add(object32.getExtensionResponse());
            }
        }
        Object object4 = null;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (Transformation transformation : list5) {
            if (bl) {
                bl = false;
            } else {
                stringBuilder.append(',');
            }
            UpgradeUtil.append(stringBuilder, transformation.getExtensionResponse());
            if (object4 == null) {
                object4 = transformation;
                continue;
            }
            object4.setNext(transformation);
        }
        if (object4 != null && !object4.validateRsvBits(0)) {
            throw new ServletException(sm.getString("upgradeUtil.incompatibleRsv"));
        }
        httpServletResponse.setHeader("Upgrade", "websocket");
        httpServletResponse.setHeader("Connection", "upgrade");
        httpServletResponse.setHeader("Sec-WebSocket-Accept", UpgradeUtil.getWebSocketAccept(string2));
        if (string != null && string.length() > 0) {
            httpServletResponse.setHeader("Sec-WebSocket-Protocol", string);
        }
        if (!list5.isEmpty()) {
            httpServletResponse.setHeader("Sec-WebSocket-Extensions", stringBuilder.toString());
        }
        if (!Endpoint.class.isAssignableFrom(serverEndpointConfig.getEndpointClass()) && serverEndpointConfig.getUserProperties().get("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping") == null) {
            try {
                deploymentException = new PojoMethodMapping(serverEndpointConfig.getEndpointClass(), serverEndpointConfig.getDecoders(), serverEndpointConfig.getPath(), wsServerContainer.getInstanceManager(Thread.currentThread().getContextClassLoader()));
                if (((PojoMethodMapping)deploymentException).getOnClose() != null || ((PojoMethodMapping)deploymentException).getOnOpen() != null || ((PojoMethodMapping)deploymentException).getOnError() != null || ((PojoMethodMapping)deploymentException).hasMessageHandlers()) {
                    serverEndpointConfig.getUserProperties().put("org.apache.tomcat.websocket.pojo.PojoEndpoint.methodMapping", deploymentException);
                }
            }
            catch (DeploymentException deploymentException2) {
                throw new ServletException(sm.getString("upgradeUtil.pojoMapFail", new Object[]{serverEndpointConfig.getEndpointClass().getName()}), (Throwable)deploymentException2);
            }
        }
        deploymentException = new WsPerSessionServerEndpointConfig(serverEndpointConfig);
        WsHandshakeRequest wsHandshakeRequest = new WsHandshakeRequest(httpServletRequest, map);
        WsHandshakeResponse wsHandshakeResponse = new WsHandshakeResponse();
        serverEndpointConfig.getConfigurator().modifyHandshake((ServerEndpointConfig)deploymentException, (HandshakeRequest)wsHandshakeRequest, (HandshakeResponse)wsHandshakeResponse);
        wsHandshakeRequest.finished();
        for (Map.Entry<String, List<String>> entry : wsHandshakeResponse.getHeaders().entrySet()) {
            for (String string4 : entry.getValue()) {
                httpServletResponse.addHeader(entry.getKey(), string4);
            }
        }
        WsHttpUpgradeHandler wsHttpUpgradeHandler = (WsHttpUpgradeHandler)httpServletRequest.upgrade(WsHttpUpgradeHandler.class);
        wsHttpUpgradeHandler.preInit((ServerEndpointConfig)deploymentException, wsServerContainer, wsHandshakeRequest, list, string, (Transformation)object4, map, httpServletRequest.isSecure());
    }

    private static boolean validateKey(String string) {
        if (string == null) {
            return false;
        }
        if (string.length() != 24) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (cArray[22] != '=' || cArray[23] != '=') {
            return false;
        }
        for (int i = 0; i < 22; ++i) {
            if (Base64.isInAlphabet((char)cArray[i])) continue;
            return false;
        }
        return true;
    }

    private static List<Transformation> createTransformations(List<Extension> list) {
        Object object;
        TransformationFactory transformationFactory = TransformationFactory.getInstance();
        LinkedHashMap<String, ArrayList<List>> linkedHashMap = new LinkedHashMap<String, ArrayList<List>>();
        ArrayList<Transformation> arrayList = new ArrayList<Transformation>(list.size());
        for (Extension object2 : list) {
            object = (ArrayList<List>)linkedHashMap.get(object2.getName());
            if (object == null) {
                object = new ArrayList<List>();
                linkedHashMap.put(object2.getName(), (ArrayList<List>)object);
            }
            object.add(object2.getParameters());
        }
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            object = transformationFactory.create((String)entry.getKey(), (List)entry.getValue(), true);
            if (object == null) continue;
            arrayList.add((Transformation)object);
        }
        return arrayList;
    }

    private static void append(StringBuilder stringBuilder, Extension extension) {
        if (extension == null || extension.getName() == null || extension.getName().length() == 0) {
            return;
        }
        stringBuilder.append(extension.getName());
        for (Extension.Parameter parameter : extension.getParameters()) {
            stringBuilder.append(';');
            stringBuilder.append(parameter.getName());
            if (parameter.getValue() == null) continue;
            stringBuilder.append('=');
            stringBuilder.append(parameter.getValue());
        }
    }

    private static boolean headerContainsToken(HttpServletRequest httpServletRequest, String string, String string2) {
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string3 = (String)enumeration.nextElement();
            for (String string4 : stringArray = string3.split(",")) {
                if (!string2.equalsIgnoreCase(string4.trim())) continue;
                return true;
            }
        }
        return false;
    }

    private static List<String> getTokensFromHeader(HttpServletRequest httpServletRequest, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration enumeration = httpServletRequest.getHeaders(string);
        while (enumeration.hasMoreElements()) {
            String[] stringArray;
            String string2 = (String)enumeration.nextElement();
            for (String string3 : stringArray = string2.split(",")) {
                arrayList.add(string3.trim());
            }
        }
        return arrayList;
    }

    private static String getWebSocketAccept(String string) {
        byte[] byArray = ConcurrentMessageDigest.digestSHA1((byte[][])new byte[][]{string.getBytes(StandardCharsets.ISO_8859_1), WS_ACCEPT});
        return Base64.encodeBase64String((byte[])byArray);
    }
}

