"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || (function () {
    var ownKeys = function(o) {
        ownKeys = Object.getOwnPropertyNames || function (o) {
            var ar = [];
            for (var k in o) if (Object.prototype.hasOwnProperty.call(o, k)) ar[ar.length] = k;
            return ar;
        };
        return ownKeys(o);
    };
    return function (mod) {
        if (mod && mod.__esModule) return mod;
        var result = {};
        if (mod != null) for (var k = ownKeys(mod), i = 0; i < k.length; i++) if (k[i] !== "default") __createBinding(result, mod, k[i]);
        __setModuleDefault(result, mod);
        return result;
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const fromZigbee_1 = __importDefault(require("../converters/fromZigbee"));
const exposes = __importStar(require("../lib/exposes"));
const modernExtend_1 = require("../lib/modernExtend");
const tuya = __importStar(require("../lib/tuya"));
const e = exposes.presets;
const ea = exposes.access;
const definitions = [
    {
        fingerprint: [{ modelID: 'TS0001', manufacturerName: '_TZ3000_wrhhi5h2' }],
        model: '1GNNTS',
        vendor: 'WETEN',
        description: '1 gang no neutral touch wall switch',
        extend: [(0, modernExtend_1.onOff)()],
        fromZigbee: [fromZigbee_1.default.ignore_basic_report, fromZigbee_1.default.ignore_time_read],
    },
    {
        fingerprint: tuya.fingerprint('TS0601', ['_TZE204_6fk3gewc']),
        model: 'PCI E',
        vendor: 'WETEN',
        description: 'Remote Control PCI E Card for PC',
        whiteLabel: [{ vendor: 'Weten', model: 'Tuya PRO' }],
        fromZigbee: [tuya.fz.datapoints],
        toZigbee: [tuya.tz.datapoints],
        exposes: [
            e.switch().setAccess('state', ea.STATE_SET),
            e.enum('restart_mode', ea.STATE_SET, ['restart', 'force restart', '–']).withDescription('Restart Mode'),
            e.binary('rf_pairing', ea.STATE_SET, 'ON', 'OFF').withDescription('Enables/disables RF 433 remote pairing mode').withCategory('config'),
            e.binary('rf_remote_control', ea.STATE_SET, 'ON', 'OFF').withDescription('Enables/disables RF 433 remote control').withCategory('config'),
            e.binary('buzzer_feedback', ea.STATE_SET, 'ON', 'OFF').withDescription('Enable buzzer feedback.').withCategory('config'),
            e.enum('power_on_behavior', ea.STATE_SET, ['on', 'off']).withDescription('Power On Behavior').withCategory('config'),
            e
                .binary('child_lock', ea.STATE_SET, 'LOCK', 'UNLOCK')
                .withDescription('Enables/disables physical input on the device')
                .withCategory('config'),
        ],
        meta: {
            tuyaDatapoints: [
                [1, 'state', tuya.valueConverter.onOff],
                [101, 'restart_mode', tuya.valueConverterBasic.lookup({ restart: tuya.enum(0), 'force restart': tuya.enum(1), '–': tuya.enum(2) })],
                [102, 'rf_remote_control', tuya.valueConverterBasic.lookup({ ON: tuya.enum(0), OFF: tuya.enum(1) })],
                [103, 'rf_pairing', tuya.valueConverter.onOff],
                [104, 'buzzer_feedback', tuya.valueConverter.onOff],
                [105, 'power_on_behavior', tuya.valueConverterBasic.lookup({ off: tuya.enum(0), on: tuya.enum(1) })],
                [106, 'child_lock', tuya.valueConverter.lockUnlock],
            ],
        },
    },
];
exports.default = definitions;
module.exports = definitions;
//# sourceMappingURL=weten.js.map