"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeHeaders = void 0;
function mergeHeaders() {
    var headerPayloads = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        headerPayloads[_i] = arguments[_i];
    }
    if (headerPayloads.length === 0)
        return {};
    var headerKeys = {};
    return headerPayloads.reduce(function (output, headers) {
        Object.keys(headers).forEach(function (header) {
            var lowerHeader = header.toLowerCase();
            if (headerKeys.hasOwnProperty(lowerHeader)) {
                output[headerKeys[lowerHeader]] = headers[header];
            }
            else {
                headerKeys[lowerHeader] = header;
                output[header] = headers[header];
            }
        });
        return output;
    }, {});
}
exports.mergeHeaders = mergeHeaders;
