/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.freeplane.core.resources.ResourceController;

public class PersistentEditableComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private ActionListener actionListener = null;
    private final String pStorageKey;
    private boolean sendExternalEvents = true;

    public PersistentEditableComboBox(String storageKey, int maximumRowCount) {
        this.pStorageKey = storageKey;
        this.setEditable(true);
        this.setMaximumRowCount(maximumRowCount);
        String storedUrls = ResourceController.getResourceController().getProperty(this.pStorageKey);
        if (storedUrls != null) {
            String[] array = storedUrls.split("\t");
            for (int i = 0; i < array.length && i != maximumRowCount; ++i) {
                String string = array[i];
                this.addUrl(string);
            }
        }
        this.setSelectedItem("");
        super.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                String text = PersistentEditableComboBox.this.getText();
                if (text == null) {
                    return;
                }
                PersistentEditableComboBox.this.addUrl(text);
                if (PersistentEditableComboBox.this.sendExternalEvents && PersistentEditableComboBox.this.actionListener != null) {
                    PersistentEditableComboBox.this.actionListener.actionPerformed(arg0);
                }
            }
        });
    }

    @Override
    public void addActionListener(ActionListener arg0) {
        this.actionListener = arg0;
    }

    private void addUrl(String selectedItem) {
        DefaultComboBoxModel model = (DefaultComboBoxModel)this.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            String element = (String)model.getElementAt(i);
            if (!element.equals(selectedItem)) continue;
            model.removeElementAt(i);
            break;
        }
        model.insertElementAt(selectedItem, 0);
        this.setSelectedIndex(0);
        StringBuilder resultBuffer = new StringBuilder();
        for (int i = 0; i < model.getSize(); ++i) {
            String element = (String)model.getElementAt(i);
            resultBuffer.append(element);
            resultBuffer.append("\t");
        }
        ResourceController.getResourceController().setProperty(this.pStorageKey, resultBuffer.toString());
    }

    public String getText() {
        Object selectedItem = this.getSelectedItem();
        return selectedItem == null ? null : selectedItem.toString();
    }

    public void setText(String text) {
        this.sendExternalEvents = false;
        this.addUrl(text);
        this.sendExternalEvents = true;
    }
}

