/**
 * @template {object & {filePath: string|undefined}} Value
 */
export class FindUp<
  Value extends object & {
    filePath: string | undefined
  }
> {
  /**
   * @callback Create
   * @param {Buffer} buf
   * @param {string} filePath
   * @returns {Promise<Value|undefined>|Value|undefined}
   */
  /**
   * @callback Callback
   * @param {Error|null} error
   * @param {Value} [result]
   * @returns {void}
   */
  /**
   * @typedef Options
   * @property {string} cwd
   * @property {string|undefined} filePath
   * @property {boolean|undefined} [detect]
   * @property {Array<string>} names
   * @property {Create} create
   */
  /**
   * @param {Options} options
   */
  constructor(options: {
    cwd: string
    filePath: string | undefined
    detect?: boolean | undefined
    names: Array<string>
    create: (
      buf: Buffer,
      filePath: string
    ) => Promise<Value | undefined> | Value | undefined
  })
  /** @type {Record<string, Array<Callback>|undefined|Error|Value>} */
  cache: Record<
    string,
    | Value
    | ((error: Error | null, result?: Value | undefined) => void)[]
    | Error
    | undefined
  >
  /** @type {string} */
  cwd: string
  /** @type {boolean|undefined} */
  detect: boolean | undefined
  /** @type {Array<string>} */
  names: Array<string>
  /** @type {Create} */
  create: (
    buf: Buffer,
    filePath: string
  ) => Promise<Value | undefined> | Value | undefined
  /** @type {string|undefined} */
  givenFilePath: string | undefined
  /** @type {Error|Value|Array<Callback>|undefined} */
  givenFile:
    | Value
    | ((error: Error | null, result?: Value | undefined) => void)[]
    | Error
    | undefined
  /**
   * @param {string} filePath
   * @param {Callback} callback
   */
  load(
    filePath: string,
    callback: (error: Error | null, result?: Value | undefined) => void
  ): void
}
