/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.generator.qdox.model;

import org.hamcrest.generator.qdox.model.AbstractJavaEntity;
import org.hamcrest.generator.qdox.model.IndentBuffer;
import org.hamcrest.generator.qdox.model.Member;
import org.hamcrest.generator.qdox.model.Type;

public class JavaField
extends AbstractJavaEntity
implements Member {
    private Type type;
    private String initializationExpression;

    public JavaField() {
    }

    public JavaField(String name) {
        this.setName(name);
    }

    public JavaField(Type type, String name) {
        this.setType(type);
        this.setName(name);
    }

    public Type getType() {
        return this.type;
    }

    protected void writeBody(IndentBuffer result) {
        this.writeAllModifiers(result);
        result.write(this.type.toString());
        result.write(' ');
        result.write(this.name);
        if (this.initializationExpression != null && this.initializationExpression.length() > 0) {
            result.write(" = ");
            result.write(this.initializationExpression);
        }
        result.write(';');
        result.newline();
    }

    public void setType(Type type) {
        this.type = type;
    }

    public int compareTo(Object o) {
        return this.getName().compareTo(((JavaField)o).getName());
    }

    public String getDeclarationSignature(boolean withModifiers) {
        IndentBuffer result = new IndentBuffer();
        if (withModifiers) {
            this.writeAllModifiers(result);
        }
        result.write(this.type.toString());
        result.write(' ');
        result.write(this.name);
        return result.toString();
    }

    public String getCallSignature() {
        return this.getName();
    }

    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String initializationExpression) {
        this.initializationExpression = initializationExpression;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        if (this.isPrivate()) {
            result.append("private ");
        } else if (this.isProtected()) {
            result.append("protected ");
        } else if (this.isPublic()) {
            result.append("public ");
        }
        if (this.isStatic()) {
            result.append("static ");
        }
        if (this.isFinal()) {
            result.append("final ");
        }
        if (this.isTransient()) {
            result.append("transient ");
        }
        if (this.isVolatile()) {
            result.append("volatile ");
        }
        result.append(this.getType().getValue() + " ");
        result.append(this.getParentClass().getFullyQualifiedName() + "." + this.getName());
        return result.toString();
    }
}

